/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.consultation.client;

import com.ebaiyihui.consultation.common.dto.HosManageOrderDto;
import com.ebaiyihui.consultation.common.dto.OrderUserPayMnetDto;
import com.ebaiyihui.consultation.common.dto.PatientInfoDto;
import com.ebaiyihui.consultation.common.vo.ConsultationVO;
import com.ebaiyihui.framework.common.ResultInfo;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

@FeignClient(value="service-consultation-server")
public interface ConsultationServiceClient {
    @PostMapping(value={"/api/v1/consultation/save_consultation"})
    public ResultInfo saveConsultation(@RequestBody ConsultationVO var1);

    @GetMapping(value={"/api/v1/consultation/query_consultation_by_id"})
    public ResultInfo queryConsultationById(@RequestParam(value="id") Long var1);

    @PostMapping(value={"/api/v1/consultation/update_consultation_status"})
    public ResultInfo updateConsultationStatus(@RequestParam(value="id") Long var1, @RequestParam(value="status") Integer var2);

    @PostMapping(value={"/api/v1/consultation/delete_consultation"})
    public ResultInfo<List<HosManageOrderDto>> deleteConsultation(@RequestParam(value="id") Long var1);

    @GetMapping(value={"/api/v1/consultation/query_consultation_list_by_doctor_id"})
    public ResultInfo queryConsultationListByDoctorId(@RequestParam(value="pageIndex") Integer var1, @RequestParam(value="pageSize") Integer var2, @RequestParam(value="doctorId") Long var3, @RequestParam(value="beginTime") String var4, @RequestParam(value="endTime") String var5, @RequestParam(value="type") Integer var6, @RequestParam(value="status") Integer var7, @RequestParam(value="isSponsor") Integer var8);

    @PostMapping(value={"/api/v1/consultation/query_hospitalManage_order_byHospitalId"})
    public ResultInfo<List<HosManageOrderDto>> queryHospitalManageOrderByHospitalId(@RequestParam(value="hospitalId", defaultValue="0") Long var1);

    @GetMapping(value={"/api/v1/consultation/query_patientInfo_list"})
    public ResultInfo<List<PatientInfoDto>> queryPatientInfoList(@RequestParam(value="doctorId", defaultValue="0") Long var1, @RequestParam(value="pageIndex", required=false, defaultValue="1") Integer var2, @RequestParam(value="pageSize", required=false, defaultValue="10") Integer var3);

    @PostMapping(value={"/api/v1/consultation/update_patient_signature"})
    public ResultInfo updatePatientSignature(@RequestParam(value="orderId", defaultValue="0") Long var1, @RequestParam(value="patientSignature", defaultValue="") String var2);

    @PostMapping(value={"/api/v1/consultation/update_patient_signature_relationship"})
    public ResultInfo updatePatientSignatureRelationship(@RequestParam(value="orderId", defaultValue="0") Long var1, @RequestParam(value="patientSignature", defaultValue="") String var2, @RequestParam(value="patientSignerRelationship", defaultValue="1") Integer var3);

    @PostMapping(value={"/api/v1/consultation/order_expert_accept"})
    public ResultInfo orderExpertAccept(@RequestParam(value="orderId", defaultValue="0") Long var1);

    @PostMapping(value={"/api/v1/consultation/hospitalManage_order_distribution"})
    public ResultInfo hospitalManageOrderDistribution(@RequestParam(value="orderIds", defaultValue="") String var1, @RequestParam(value="orderType", defaultValue="0") Integer var2, @RequestParam(value="expertId", defaultValue="0") Long var3, @RequestParam(value="expertName", defaultValue="") String var4, @RequestParam(value="expertDepId", defaultValue="0") Long var5, @RequestParam(value="expertDepName", defaultValue="") String var6, @RequestParam(value="consultationDate", defaultValue="") String var7);

    @GetMapping(value={"/api/v1/consultation/user/payment/{userId}/{hospitalId}"})
    public ResultInfo<List<OrderUserPayMnetDto>> getUserPayment(@PathVariable(value="userId") String var1, @PathVariable(value="hospitalId") String var2);

    @GetMapping(value={"/api/v1/consultation/findAllConsultationByExpIdOrDocId"})
    public ResultInfo<Object> findAllConsultationByExpIdOrDocId(@RequestParam(value="expOrDocId") Long var1);
}

