/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.doctor.client;

import com.ebaiyihui.doctor.client.error.DoctorError;
import com.ebaiyihui.doctor.common.DoctorServiceInfoEntity;
import com.ebaiyihui.doctor.common.DoctorServiceVo;
import com.ebaiyihui.doctor.common.vo.DoctorServiceInfoVo;
import com.ebaiyihui.doctor.common.vo.DoctorServiceResVo;
import com.ebaiyihui.framework.common.ResultInfo;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

@FeignClient(name="service-doctor", fallback=DoctorError.class)
public interface DoctorServiceInfoClient {
    @PostMapping(value={"/api/v1/doctorserviceinfo/save"})
    public ResultInfo saveDoctorServiceInfo(DoctorServiceInfoEntity var1);

    @GetMapping(value={"/api/v1/doctorserviceinfo/{id}"})
    public ResultInfo<DoctorServiceInfoEntity> getDoctorServiceInfo(@PathVariable Long var1);

    @PostMapping(value={"/api/v1/doctorserviceinfo/update"})
    public ResultInfo updateDoctorServiceInfo(@RequestBody DoctorServiceInfoEntity var1);

    @PostMapping(value={"/api/v1/doctorserviceinfo/delete"})
    public ResultInfo deleteDoctorServiceInfo(@RequestParam(value="id", required=true) Long var1);

    @PostMapping(value={"/api/v1/doctorserviceinfo/get_doctorservice_list"})
    public ResultInfo<List<DoctorServiceVo>> getDoctorServiceList(@RequestParam(value="hospitalId", required=false) Long var1, @RequestParam(value="doctorId", required=false) Long var2);

    @PostMapping(value={"/api/v1/doctorserviceinfo/get_doctorservice"})
    public ResultInfo<List<DoctorServiceInfoVo>> getDoctorService(@RequestParam(value="doctorId", required=true) Long var1, @RequestParam(value="serviceId", required=false) Long var2);

    @PostMapping(value={"/api/v1/doctorserviceinfo/selectby_doctorid"})
    public ResultInfo<DoctorServiceInfoEntity> selectByDoctorId(@RequestParam(value="doctorId", required=true) Long var1);

    @PostMapping(value={"/api/v1/doctorserviceinfo/selectall_bydoctorid"})
    public ResultInfo<DoctorServiceResVo> selectAllByDoctorId(@RequestParam(value="loginUserId", required=false) Long var1, @RequestParam(value="doctorId", required=true) Long var2);

    @PostMapping(value={"/api/v1/doctorserviceinfo/update_status"})
    public ResultInfo<Integer> updateStatus(@RequestParam(value="doctorId") Long var1, @RequestParam(value="serviceInfoId") Long var2, @RequestParam(value="status") Integer var3);

    @PostMapping(value={"/api/v1/doctorserviceinfo/getbyservicecode"})
    public ResultInfo<DoctorServiceInfoEntity> getByDoctorServiceCode(@RequestParam(value="doctorId") Long var1, @RequestParam(value="serviceCode") String var2);

    @PostMapping(value={"/api/v1/doctorserviceinfo/getserviceprice"})
    public ResultInfo<Map<Long, BigDecimal>> getServicePrice(@RequestParam(value="doctorIdFrom") Long var1, @RequestParam(value="doctorIdTo") Long var2, @RequestParam(value="serviceCodeFrom") String var3, @RequestParam(value="serviceCodeTo") String var4);
}

