/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.his.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ebaiyihui.his.mapper.OutpatientPaymentMapper;
import com.ebaiyihui.his.model.ResponseBaseResult;
import com.ebaiyihui.his.model.base.FrontRequest;
import com.ebaiyihui.his.model.base.FrontResponse;
import com.ebaiyihui.his.model.bill.RefundCallBackReq;
import com.ebaiyihui.his.model.bill.RefundCallBackRes;
import com.ebaiyihui.his.model.outpatient.ComfirmPayNewReq;
import com.ebaiyihui.his.model.outpatient.ComfirmPayNewRes;
import com.ebaiyihui.his.model.outpatient.GetAdmissionReq;
import com.ebaiyihui.his.model.outpatient.GetAdmissionRes;
import com.ebaiyihui.his.model.outpatient.PayItemReq;
import com.ebaiyihui.his.model.outpatient.PayItemRes;
import com.ebaiyihui.his.model.outpatient.datas.PayItemResDatas;
import com.ebaiyihui.his.model.outpatient.items.GetAdmissionItems;
import com.ebaiyihui.his.model.outpatient.items.PayItemResItems;
import com.ebaiyihui.his.model.request.BaseHisResquest;
import com.ebaiyihui.his.model.request.RefundTradeReq;
import com.ebaiyihui.his.service.OutpatientPaymentService;
import com.ebaiyihui.his.utils.NumberUtils;
import com.ebaiyihui.his.utils.StringUtils;
import java.math.BigDecimal;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Locale;
import java.util.Objects;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class OutpatientPaymentServiceImpl
implements OutpatientPaymentService {
    private static final Logger log = LoggerFactory.getLogger(OutpatientPaymentServiceImpl.class);
    @Autowired
    private OutpatientPaymentMapper outpatientPaymentMapper;

    public String seqInvoiceGzh() {
        return this.outpatientPaymentMapper.seqInvoiceGzh();
    }

    public FrontResponse<ComfirmPayNewRes> paymentConfirmation(FrontRequest<ComfirmPayNewReq> param) {
        String[] results;
        ComfirmPayNewReq comfirmPayNewReq = (ComfirmPayNewReq)param.getBody();
        log.info("\u7f34\u8d39\u7ed3\u7b97\u5165\u53c2\uff1a" + JSON.toJSONString((Object)comfirmPayNewReq));
        String invoice = this.outpatientPaymentMapper.seqInvoiceGzh();
        String inputStr = comfirmPayNewReq.getPatientId() + "#" + comfirmPayNewReq.getId() + "#" + invoice + "#" + comfirmPayNewReq.getRespmsg().getOrderid() + "##" + NumberUtils.formatAmtY2F((String)comfirmPayNewReq.getAmount()) + "###" + NumberUtils.formatAmtY2F((String)comfirmPayNewReq.getAmount()) + "##";
        BaseHisResquest baseHisResquest = new BaseHisResquest();
        baseHisResquest.setInputStr(inputStr);
        baseHisResquest.setCode("HIS_ATM_05140");
        log.info("\u7f34\u8d39\u7ed3\u7b97His\u5165\u53c2\uff1a" + inputStr);
        this.outpatientPaymentMapper.paymentConfirmation(baseHisResquest);
        log.info("\u7f34\u8d39\u7ed3\u7b97His\u51fa\u53c2\uff1a" + baseHisResquest.getOutputData());
        if (StringUtils.isEmpty((String)baseHisResquest.getOutputData())) {
            FrontResponse.error((String)param.getTransactionId(), (String)"0", (String)baseHisResquest.getOutputData());
        }
        if (!(results = baseHisResquest.getOutputData().split("#"))[0].equals("0")) {
            return FrontResponse.error((String)param.getTransactionId(), (String)"0", (String)baseHisResquest.getOutputData());
        }
        ComfirmPayNewRes comfirmPayNewRes = new ComfirmPayNewRes();
        comfirmPayNewRes.setReceiptId(results[1]);
        log.info("\u7f34\u8d39\u7ed3\u7b97\u51fa\u53c2\uff1a" + JSON.toJSONString((Object)comfirmPayNewRes));
        return FrontResponse.success((String)param.getTransactionId(), (Object)comfirmPayNewRes);
    }

    public FrontResponse<RefundCallBackRes> advRefund(FrontRequest<RefundCallBackReq> param) {
        RefundCallBackReq refundCallBackReq = (RefundCallBackReq)param.getBody();
        log.info("\u5165\u53c2\uff1a" + JSON.toJSONString((Object)refundCallBackReq));
        ResponseBaseResult responseBaseResult = new ResponseBaseResult();
        JSONObject jsonObject = new JSONObject();
        String inputStr = refundCallBackReq.getPatientId() + "#" + refundCallBackReq.getAdmId() + "#" + refundCallBackReq.getRefundTrandNo() + "#" + refundCallBackReq.getMoney() + "#";
        System.out.println("\u5165\u53c2\uff1a" + inputStr);
        BaseHisResquest baseHisResquest = new BaseHisResquest();
        baseHisResquest.setInputStr(inputStr);
        baseHisResquest.setCode("HIS_ATM_05150");
        this.outpatientPaymentMapper.advRefund(baseHisResquest);
        log.info("\u51fa\u53c2\uff1a" + baseHisResquest.getOutputData());
        return FrontResponse.success((String)param.getTransactionId(), null);
    }

    public FrontResponse<JSONObject> refund(RefundTradeReq refundTradeReq) {
        log.info("\u5165\u53c2\uff1a" + JSON.toJSONString((Object)refundTradeReq));
        ResponseBaseResult responseBaseResult = new ResponseBaseResult();
        JSONObject jsonObject = new JSONObject();
        String inputStr = refundTradeReq.getPATIENTID() + "#" + refundTradeReq.getREGISTERID() + "#" + refundTradeReq.getInvoice() + "#" + refundTradeReq.getAmount() + "#";
        System.out.println("\u5165\u53c2\uff1a" + inputStr);
        BaseHisResquest baseHisResquest = new BaseHisResquest();
        baseHisResquest.setInputStr(inputStr);
        baseHisResquest.setCode("HIS_ATM_05160");
        this.outpatientPaymentMapper.advRefund(baseHisResquest);
        log.info("\u51fa\u53c2\uff1a" + baseHisResquest.getOutputData());
        return FrontResponse.success((String)refundTradeReq.getTransactionId(), null);
    }

    public FrontResponse<GetAdmissionRes> queryPaymentReceipt(FrontRequest<GetAdmissionReq> param) {
        GetAdmissionReq getAdmissionReq = (GetAdmissionReq)param.getBody();
        log.info("\u67e5\u8be2\u5f85\u7f34\u8d39\u4fe1\u606f\u5165\u53c2\uff1a" + JSON.toJSONString((Object)getAdmissionReq));
        ArrayList items = this.outpatientPaymentMapper.queryPaymentReceipt(getAdmissionReq);
        log.info("\u83b7\u53d6\u95e8\u8bca\u5f85\u7f34\u8d39\u9879\u76eeHis\u6570\u636e\u4e3a:{}", (Object)JSON.toJSONString((Object)items));
        if (Objects.isNull(items)) {
            return FrontResponse.error((String)param.getTransactionId(), (String)"0", (String)"\u672a\u67e5\u8be2\u5230\u5f85\u7f34\u8d39\u4fe1\u606f");
        }
        items = items.stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<GetAdmissionItems>(Comparator.comparing(GetAdmissionItems::getAdmId))), ArrayList::new));
        GetAdmissionRes getAdmissionRes = new GetAdmissionRes();
        getAdmissionRes.setItems(items);
        log.info("\u67e5\u8be2\u5f85\u7f34\u8d39\u4fe1\u606f\u51fa\u53c2:{}", (Object)getAdmissionRes);
        return FrontResponse.success((String)param.getTransactionId(), (Object)getAdmissionRes);
    }

    public FrontResponse<PayItemRes> queryChargeDetails(FrontRequest<PayItemReq> param) {
        PayItemReq payItemReq = (PayItemReq)param.getBody();
        log.info("\u5904\u65b9\u8be6\u60c5\u5165\u53c2\uff1a" + JSON.toJSONString((Object)payItemReq));
        ArrayList payItemVos = this.outpatientPaymentMapper.queryChargeDetails(payItemReq);
        log.info("\u67e5\u5904\u65b9\u8be6\u60c5His\u51fa\u53c2\uff1a" + JSON.toJSONString((Object)payItemVos));
        if (Objects.isNull(payItemVos) && payItemVos.size() <= 0) {
            return FrontResponse.error((String)param.getTransactionId(), (String)"0", (String)"\u672a\u67e5\u8be2\u5230\u5f85\u7f34\u8d39\u4fe1\u606f\u8be6\u60c5");
        }
        PayItemRes payItemRes = new PayItemRes();
        ArrayList datas = new ArrayList();
        payItemVos.stream().forEach(p -> {
            ArrayList<PayItemResItems> payItemResItemsArray = new ArrayList<PayItemResItems>();
            PayItemResDatas payItemResDatas = new PayItemResDatas();
            payItemResDatas.setAdmId(p.getB1());
            String sum = String.valueOf(p.getB9() * (double)((int)Math.round(Double.parseDouble(p.getB10()))));
            payItemResDatas.setAmount(sum);
            payItemResDatas.setItemType("");
            payItemResDatas.setFeeId(p.getTRANSNO());
            PayItemResItems payItemResItems = new PayItemResItems();
            payItemResItems.setId(p.getB7());
            payItemResItems.setItemType("");
            payItemResItems.setDesc(p.getB8());
            payItemResItems.setInsuCode("");
            payItemResItems.setPrice(String.valueOf(p.getB9()));
            payItemResItems.setPrescriptionNo(p.getB4());
            payItemResItems.setQty(String.valueOf((int)Math.round(Double.parseDouble(p.getB10()))));
            payItemResItems.setSum(sum);
            payItemResItems.setUnit(p.getB18());
            payItemResItemsArray.add(payItemResItems);
            payItemResDatas.setItems(payItemResItemsArray);
            datas.add(payItemResDatas);
        });
        payItemRes.setDatas(datas);
        log.info("\u5904\u65b9\u8be6\u60c5\u51fa\u53c2\uff1a" + JSON.toJSONString((Object)payItemRes));
        return FrontResponse.success((String)param.getTransactionId(), (Object)payItemRes);
    }

    public static String fen2yuan(int price) {
        NumberFormat numberFormat = NumberFormat.getCurrencyInstance(Locale.CHINA);
        numberFormat.setMaximumFractionDigits(2);
        numberFormat.setMinimumFractionDigits(2);
        String format = numberFormat.format(BigDecimal.valueOf(price).divide(BigDecimal.valueOf(100L)));
        return format.replace("\uffe5", "");
    }
}

