/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.maven;

import com.intellij.openapi.util.text.StringUtil;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cli.common.CLICompiler;
import org.jetbrains.kotlin.cli.common.ExitCode;
import org.jetbrains.kotlin.cli.common.arguments.K2JVMCompilerArguments;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;
import org.jetbrains.kotlin.cli.jvm.K2JVMCompiler;
import org.jetbrains.kotlin.incremental.ICReporter;
import org.jetbrains.kotlin.incremental.IncrementalJvmCompilerRunnerKt;
import org.jetbrains.kotlin.maven.KotlinCompileMojoBase;
import org.jetbrains.kotlin.maven.Util;
import org.jetbrains.kotlin.maven.incremental.FileCopier;
import org.jetbrains.kotlin.maven.incremental.MavenICReporter;
import org.jetbrains.kotlin.maven.kapt.AnnotationProcessingManager;

@Mojo(name="compile", defaultPhase=LifecyclePhase.COMPILE, requiresDependencyResolution=ResolutionScope.COMPILE, threadSafe=true)
public class K2JVMCompileMojo
extends KotlinCompileMojoBase<K2JVMCompilerArguments> {
    @Parameter(defaultValue="${project.compileClasspathElements}", required=true, readonly=true)
    public List<String> classpath;
    @Parameter(defaultValue="${project.testClasspathElements}", required=true, readonly=true)
    protected List<String> testClasspath;
    @Parameter(defaultValue="${project.artifactId}", required=true, readonly=true)
    protected String moduleName;
    @Parameter(defaultValue="${project.artifactId}-test", required=true, readonly=true)
    protected String testModuleName;
    @Parameter(property="kotlin.compiler.jvmTarget")
    protected String jvmTarget;
    @Parameter(property="kotlin.compiler.jdkHome")
    protected String jdkHome;
    @Parameter(property="kotlin.compiler.scriptTemplates")
    protected List<String> scriptTemplates;
    @Parameter(property="kotlin.compiler.incremental", defaultValue="false")
    private boolean myIncremental;
    @Parameter(property="kotlin.compiler.incremental.cache.root", defaultValue="${project.build.directory}/kotlin-ic")
    public String incrementalCachesRoot;
    @Parameter(property="kotlin.compiler.javaParameters")
    protected boolean javaParameters;

    @NotNull
    private File getCachesDir() {
        return new File(this.incrementalCachesRoot, this.getSourceSetName());
    }

    protected boolean isIncremental() {
        return this.myIncremental;
    }

    private boolean isIncrementalSystemProperty() {
        String value = System.getProperty("kotlin.incremental");
        return value != null && value.equals("true");
    }

    @Override
    protected List<String> getRelatedSourceRoots(MavenProject project) {
        return project.getCompileSourceRoots();
    }

    @NotNull
    protected K2JVMCompiler createCompiler() {
        return new K2JVMCompiler();
    }

    @Override
    @NotNull
    protected K2JVMCompilerArguments createCompilerArguments() {
        return new K2JVMCompilerArguments();
    }

    @Override
    protected List<String> getSourceFilePaths() {
        List<String> paths = super.getSourceFilePaths();
        File sourcesDir = AnnotationProcessingManager.getGeneratedSourcesDirectory(this.project, this.getSourceSetName());
        if (sourcesDir.isDirectory()) {
            paths = new ArrayList<String>(paths);
            paths.add(sourcesDir.getAbsolutePath());
        }
        return paths;
    }

    protected List<String> getClasspath() {
        return Util.filterClassPath(this.project.getBasedir(), this.classpath);
    }

    @NotNull
    protected String getSourceSetName() {
        return "compile";
    }

    @Override
    protected void configureSpecificCompilerArguments(@NotNull K2JVMCompilerArguments arguments, @NotNull List<File> sourceRoots) throws MojoExecutionException {
        List<String> classpathList;
        arguments.setDestination(this.output);
        arguments.setNoStdlib(true);
        arguments.setJavaParameters(this.javaParameters);
        if (this.module != null || this.testModule != null) {
            this.getLog().warn((CharSequence)"Parameters module and testModule are deprecated and ignored, they will be removed in further release.");
        }
        if (!(classpathList = this.getClasspath()).isEmpty()) {
            String classPathString = StringUtil.join(classpathList, (String)File.pathSeparator);
            if (this.isJava9Module(sourceRoots)) {
                this.getLog().debug((CharSequence)("Module path: " + classPathString));
                arguments.setJavaModulePath(classPathString);
            } else {
                this.getLog().debug((CharSequence)("Classpath: " + classPathString));
                arguments.setClasspath(classPathString);
            }
        }
        this.getLog().debug((CharSequence)("Classes directory is " + this.output));
        arguments.setDestination(this.output);
        arguments.setModuleName(this.moduleName);
        this.getLog().debug((CharSequence)("Module name is " + this.moduleName));
        if (arguments.getNoOptimize()) {
            this.getLog().info((CharSequence)"Optimization is turned off");
        }
        if (this.jvmTarget != null) {
            arguments.setJvmTarget(this.jvmTarget);
        }
        if (this.jdkHome != null) {
            this.getLog().info((CharSequence)("Overriding JDK home path with: " + this.jdkHome));
            arguments.setJdkHome(this.jdkHome);
        }
        if (this.scriptTemplates != null && !this.scriptTemplates.isEmpty()) {
            arguments.setScriptTemplates(this.scriptTemplates.toArray(new String[0]));
        }
    }

    private boolean isJava9Module(@NotNull List<File> sourceRoots) {
        return sourceRoots.stream().anyMatch(file -> file.getName().equals("module-info.java") || file.isDirectory() && Arrays.stream(file.listFiles()).anyMatch(child -> child.getName().equals("module-info.java")));
    }

    @Override
    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.args != null && this.args.contains("-Xuse-javac")) {
            try {
                URL toolsJar = this.getJdkToolsJarURL();
                if (toolsJar != null) {
                    this.project.getClassRealm().addURL(toolsJar);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        super.execute();
    }

    @Override
    @NotNull
    protected ExitCode execCompiler(CLICompiler<K2JVMCompilerArguments> compiler, MessageCollector messageCollector, K2JVMCompilerArguments arguments, List<File> sourceRoots) throws MojoExecutionException {
        if (this.isIncremental()) {
            return this.runIncrementalCompiler(messageCollector, arguments, sourceRoots);
        }
        return super.execCompiler(compiler, messageCollector, arguments, sourceRoots);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private ExitCode runIncrementalCompiler(MessageCollector messageCollector, K2JVMCompilerArguments arguments, List<File> sourceRoots) throws MojoExecutionException {
        this.getLog().warn((CharSequence)"Using experimental Kotlin incremental compilation");
        File cachesDir = this.getCachesDir();
        cachesDir.mkdirs();
        String destination = arguments.getDestination();
        assert (destination != null) : "output is not specified!";
        File classesDir = new File(destination);
        File kotlinClassesDir = new File(cachesDir, "classes");
        File snapshotsFile = new File(cachesDir, "snapshots.bin");
        String classpath = arguments.getClasspath();
        MavenICReporter icReporter = MavenICReporter.get(this.getLog());
        try {
            arguments.setDestination(kotlinClassesDir.getAbsolutePath());
            if (classpath != null) {
                ArrayList<String> filteredClasspath = new ArrayList<String>();
                for (String path : classpath.split(File.pathSeparator)) {
                    if (classesDir.equals(new File(path))) continue;
                    filteredClasspath.add(path);
                }
                arguments.setClasspath(StringUtil.join(filteredClasspath, (String)File.pathSeparator));
            }
            IncrementalJvmCompilerRunnerKt.makeIncrementally((File)cachesDir, sourceRoots, (K2JVMCompilerArguments)arguments, (MessageCollector)messageCollector, (ICReporter)icReporter);
            int compiledKtFilesCount = icReporter.getCompiledKotlinFiles().size();
            this.getLog().info((CharSequence)("Compiled " + icReporter.getCompiledKotlinFiles().size() + " Kotlin files using incremental compiler"));
            if (!messageCollector.hasErrors()) {
                new FileCopier(this.getLog()).syncDirs(kotlinClassesDir, classesDir, snapshotsFile);
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
            ExitCode exitCode = ExitCode.INTERNAL_ERROR;
            return exitCode;
        }
        finally {
            arguments.setDestination(destination);
            arguments.setClasspath(classpath);
        }
        if (messageCollector.hasErrors()) {
            return ExitCode.COMPILATION_ERROR;
        }
        return ExitCode.OK;
    }

    @Nullable
    private URL getJdkToolsJarURL() throws IOException {
        String javaHomePath = System.getProperty("java.home");
        if (javaHomePath == null || javaHomePath.isEmpty()) {
            return null;
        }
        File javaHome = new File(javaHomePath);
        File toolsJar = new File(javaHome, "lib/tools.jar");
        if (toolsJar.exists()) {
            return toolsJar.getCanonicalFile().toURI().toURL();
        }
        if (javaHome.getName().equals("jre") && (toolsJar = new File(javaHome.getParent(), "lib/tools.jar")).exists()) {
            return toolsJar.getCanonicalFile().toURI().toURL();
        }
        return null;
    }
}

