/*
 * Decompiled with CFR 0.152.
 */
package com.byh.module.verlogin;

import android.content.Context;
import android.content.Intent;
import android.content.res.Resources;
import android.text.Editable;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.view.View;
import android.widget.EditText;
import android.widget.TextView;
import androidx.annotation.RequiresApi;
import androidx.core.content.res.ResourcesCompat;
import com.alibaba.android.arouter.facade.annotation.Route;
import com.blankj.utilcode.util.ToastUtils;
import com.byh.module.verlogin.R;
import com.byh.module.verlogin.ResetPasswordActivity;
import com.byh.module.verlogin.present.ForgetSendVerifyCodePersent;
import com.byh.module.verlogin.present.ValidatePhoneAndCodePresent;
import com.byh.module.verlogin.present.inter.IValidatePhoneCodePresent;
import com.byh.module.verlogin.view.IForgetSendVercodeView;
import com.byh.module.verlogin.view.IValidatePhoneAndCodeView;
import com.kangxin.common.base.ResponseBody;
import com.kangxin.common.base.kt.BaseActivity;
import com.kangxin.common.byh.entity.response.LoginSuccess;
import com.kangxin.common.byh.util.CountDownUtil;
import com.kangxin.common.util.EditTextPlusUtil;
import com.kangxin.common.util.VerifyUtil;

@Route(path="/auth/modify/ForgetPassWordActivity")
public class ForgetPassWordActivity
extends BaseActivity
implements IForgetSendVercodeView,
IValidatePhoneAndCodeView {
    private static final String TAG = "ForgetPassWordActivity";
    private EditText mRealNameEdit;
    private TextView mVercodeTv;
    private EditText mVercodeEdit;
    private TextView mErrNoticeTv;
    private CountDownUtil mCountDownUtil;
    private ForgetSendVerifyCodePersent mForgetSendVerifyCodePersent;
    private String mPhoneNum;
    private String mPhoneNumEdit;
    private IValidatePhoneCodePresent mValidatePhoneCodePresent;
    private String mAuthKey;

    public void start() {
        this.mForgetSendVerifyCodePersent = new ForgetSendVerifyCodePersent(this);
        this.mValidatePhoneCodePresent = new ValidatePhoneAndCodePresent(this);
        this.mPhoneNum = this.getIntent().getStringExtra("phoneNum");
        this.initViews();
    }

    private void initViews() {
        this.mRealNameEdit = (EditText)this.findViewById(R.id.et_real_name);
        this.mVercodeTv = (TextView)this.findViewById(R.id.tv_vercode);
        this.mVercodeEdit = (EditText)this.findViewById(R.id.edt_vercode);
        this.mErrNoticeTv = (TextView)this.findViewById(R.id.err_notice);
        this.mCountDownUtil = new CountDownUtil(this.mVercodeTv).setCountDownMillis(60000L).setCountDownColor(R.color.white, 0x1060000);
        this.isVercodeUsable(false);
        String maskNumber = this.mPhoneNum.substring(0, 3) + "****" + this.mPhoneNum.substring(7, this.mPhoneNum.length());
        this.mRealNameEdit.setText((CharSequence)maskNumber);
        if (VerifyUtil.isMobilePhoneNumber((String)this.mPhoneNum)) {
            this.isVercodeUsable(true);
        } else {
            this.isVercodeUsable(false);
        }
        this.mCountDownUtil.setOnDownEndListener(() -> {
            String phoneNum = TextUtils.isEmpty((CharSequence)this.mPhoneNum) ? this.mRealNameEdit.getText().toString().trim() : this.mPhoneNum;
            if (!TextUtils.isEmpty((CharSequence)phoneNum)) {
                this.isVercodeUsable(true);
            } else {
                this.isVercodeUsable(false);
            }
        });
        this.mVercodeTv.setOnClickListener(view -> {
            String phoneNum = TextUtils.isEmpty((CharSequence)this.mPhoneNum) ? this.mRealNameEdit.getText().toString().trim() : this.mPhoneNum;
            if (!TextUtils.isEmpty((CharSequence)phoneNum)) {
                this.isVercodeUsable(true);
            } else {
                this.isVercodeUsable(false);
            }
            this.mForgetSendVerifyCodePersent.receiveByVercode(phoneNum);
            this.mCountDownUtil.start();
            this.isVercodeUsable(false);
        });
        this.addEdtChangeListener();
    }

    public int getContentLayoutId() {
        return R.layout.activity_forget_pass_word;
    }

    public void onButterKnifeBtnClick(View view) {
        this.mPhoneNumEdit = TextUtils.isEmpty((CharSequence)this.mPhoneNum) ? this.mRealNameEdit.getText().toString().trim() : this.mPhoneNum;
        String verCode = this.mVercodeEdit.getText().toString().trim();
        if (TextUtils.isEmpty((CharSequence)this.mAuthKey)) {
            ToastUtils.showLong((CharSequence)"\u8bf7\u5148\u53d1\u9001\u9a8c\u8bc1\u7801");
            return;
        }
        if (TextUtils.isEmpty((CharSequence)this.mPhoneNumEdit)) {
            this.mErrNoticeTv.setVisibility(0);
            this.mErrNoticeTv.setText((CharSequence)"\u624b\u673a\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
            return;
        }
        if (!VerifyUtil.isMobilePhoneNumber((String)this.mPhoneNumEdit)) {
            this.mErrNoticeTv.setVisibility(0);
            this.mErrNoticeTv.setText((CharSequence)this.getResources().getString(R.string.forget_phone_error_tips));
            return;
        }
        if (TextUtils.isEmpty((CharSequence)verCode)) {
            this.mErrNoticeTv.setVisibility(0);
            this.mErrNoticeTv.setText((CharSequence)"\u9a8c\u8bc1\u7801\u4e0d\u80fd\u4e3a\u7a7a");
            return;
        }
        this.mValidatePhoneCodePresent.getValidatePhoneCodePresenter(verCode, this.mAuthKey, true);
    }

    public void onBackImageOnClick(View view) {
        this.finish();
    }

    private void addEdtChangeListener() {
        EditTextPlusUtil.rightAlign((EditText)this.mRealNameEdit, (TextWatcher)new TextWatcher(){

            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
            }

            public void onTextChanged(CharSequence s, int start, int before, int count) {
            }

            public void afterTextChanged(Editable s) {
                ForgetPassWordActivity.this.mErrNoticeTv.setVisibility(8);
                if (VerifyUtil.isMobilePhoneNumber((String)ForgetPassWordActivity.this.mPhoneNum)) {
                    ForgetPassWordActivity.this.isVercodeUsable(true);
                } else {
                    ForgetPassWordActivity.this.isVercodeUsable(false);
                }
            }
        });
        this.mVercodeEdit.addTextChangedListener(new TextWatcher(){

            public void beforeTextChanged(CharSequence charSequence, int i, int i1, int i2) {
            }

            public void onTextChanged(CharSequence charSequence, int i, int i1, int i2) {
            }

            @RequiresApi(api=16)
            public void afterTextChanged(Editable editable) {
                ForgetPassWordActivity.this.mErrNoticeTv.setVisibility(8);
            }
        });
    }

    private void isVercodeUsable(boolean isUse) {
        if (isUse) {
            this.mCountDownUtil.setUsable(true);
            this.mVercodeTv.setBackground(ResourcesCompat.getDrawable((Resources)this.getResources(), (int)R.drawable.vercode_order_bg, null));
            this.mVercodeTv.setTextColor(this.getResources().getColor(17170443));
            this.mVercodeTv.setClickable(true);
            this.mVercodeTv.setFocusable(true);
            this.mVercodeTv.setText(R.string.forget_send_getvercode);
        } else {
            this.mCountDownUtil.setUsable(false);
            this.mVercodeTv.setBackground(ResourcesCompat.getDrawable((Resources)this.getResources(), (int)R.drawable.edt_order_bg, null));
            this.mVercodeTv.setTextColor(this.getResources().getColor(0x1060000));
            this.mVercodeTv.setText(R.string.forget_send_getvercode);
            this.mVercodeTv.setClickable(false);
            this.mVercodeTv.setFocusable(false);
        }
    }

    @Override
    public void receiveResult(LoginSuccess responseBody) {
        if (responseBody == null) {
            return;
        }
        this.mAuthKey = responseBody.getAuthKey();
    }

    @Override
    public void getValidatePhoneAndCodeOk(ResponseBody responseBody) {
        this.showShortToast(responseBody.getMsg());
        Intent intent = new Intent((Context)this, ResetPasswordActivity.class);
        intent.putExtra("phoneNum", this.mPhoneNumEdit);
        this.startActivity(intent);
    }
}

