/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.wisdommedical.controller.medical;

import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.hkdhisfront.appoint.InHospitalNumByIdCardVo;
import com.ebaiyihui.hkdhisfront.inhosp.GetInpAdmissionResItems;
import com.ebaiyihui.hkdhisfront.inhosp.GetOrdItemsReq;
import com.ebaiyihui.hkdhisfront.outpatient.FeeDetail;
import com.ebaiyihui.wisdommedical.exception.InHospitalException;
import com.ebaiyihui.wisdommedical.pojo.vo.repsvo.GetIhHospitalOrderItemsResVo;
import com.ebaiyihui.wisdommedical.pojo.vo.repsvo.InHospDepositCreateOrderResVO;
import com.ebaiyihui.wisdommedical.pojo.vo.repsvo.InHospitalRechargeDetailResVO;
import com.ebaiyihui.wisdommedical.pojo.vo.reqvo.GetIhHospitalOrderItemsReqVo;
import com.ebaiyihui.wisdommedical.pojo.vo.reqvo.GetInpAdmissionReqVO;
import com.ebaiyihui.wisdommedical.pojo.vo.reqvo.InHospDepositCreateOrderReqVO;
import com.ebaiyihui.wisdommedical.pojo.vo.reqvo.InHospDepositPayReqVO;
import com.ebaiyihui.wisdommedical.pojo.vo.reqvo.InHospitalRechargeDetailReqVO;
import com.ebaiyihui.wisdommedical.service.InHospitalService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.validation.Valid;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u4f4f\u9662\u4e1a\u52a1api"})
@RequestMapping(value={"/api/v1/inHospital"})
public class InHospitalController {
    private static final Logger log = LoggerFactory.getLogger(InHospitalController.class);
    @Autowired
    private InHospitalService inHospitalService;

    @ApiOperation(value="\u4f4f\u9662\u9884\u4ea4\u91d1\u53ef\u9009\u91d1\u989d\u5217\u8868", notes="\u4f4f\u9662\u9884\u4ea4\u91d1\u53ef\u9009\u91d1\u989d\u5217\u8868")
    @GetMapping(value={"/getMoneysList"})
    public BaseResponse<List<String>> getMoneysList(@RequestParam(value="hospitalCode") String hospitalCode) {
        if (StringUtils.isBlank((CharSequence)hospitalCode)) {
            BaseResponse.error((String)"\u8bf7\u4f20\u5165\u6b63\u786e\u7684\u533b\u9662\u7f16\u7801\uff01");
        }
        return BaseResponse.success((Object)this.inHospitalService.getMoneyList(hospitalCode));
    }

    @ApiOperation(value="\u83b7\u53d6\u4f4f\u9662\u8bb0\u5f55\uff08\u5305\u542b\u5f53\u524d\u4f4f\u9662\uff09", notes="\u83b7\u53d6\u4f4f\u9662\u8bb0\u5f55\uff08\u5305\u542b\u5f53\u524d\u4f4f\u9662\uff09")
    @GetMapping(value={"/getInHospRecordList"})
    public BaseResponse<List<InHospitalNumByIdCardVo>> getInHospRecordList(@RequestParam(value="cardId") String cardId) {
        if (StringUtils.isBlank((CharSequence)cardId)) {
            BaseResponse.error((String)"\u8bf7\u5148\u9009\u62e9\u5c31\u8bca\u5361\uff01");
        }
        return BaseResponse.success((Object)this.inHospitalService.getInHospRecordList(cardId));
    }

    @ApiOperation(value="\u83b7\u53d6\u4f4f\u9662\u5c31\u8bca\u8bb0\u5f55", notes="\u83b7\u53d6\u4f4f\u9662\u5c31\u8bca\u8bb0\u5f55")
    @PostMapping(value={"getInpAdmissionList"})
    public BaseResponse<GetInpAdmissionResItems> getInpAdmissionList(@Valid @RequestBody GetInpAdmissionReqVO getInpAdmissionReqVO, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return BaseResponse.error((String)bindingResult.getFieldError().getDefaultMessage());
        }
        GetInpAdmissionResItems InpAdmissionList = null;
        try {
            InpAdmissionList = this.inHospitalService.getInpAdmissionItems(getInpAdmissionReqVO);
        }
        catch (InHospitalException e) {
            return BaseResponse.error((String)e.getMessage());
        }
        return BaseResponse.success((Object)InpAdmissionList);
    }

    @ApiOperation(value="\u83b7\u53d6\u4f4f\u9662\u9884\u4ea4\u91d1\u660e\u7ec6", notes="\u83b7\u53d6\u4f4f\u9662\u9884\u4ea4\u91d1\u660e\u7ec6")
    @PostMapping(value={"getInHospRechargeDetail"})
    public BaseResponse<InHospitalRechargeDetailResVO> getInHospRechargeDetail(@Valid @RequestBody InHospitalRechargeDetailReqVO inHospitalRechargeDetailReqVO, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return BaseResponse.error((String)bindingResult.getFieldError().getDefaultMessage());
        }
        InHospitalRechargeDetailResVO rechargeDetailResVO = null;
        try {
            rechargeDetailResVO = this.inHospitalService.getRechargeDetail(inHospitalRechargeDetailReqVO);
        }
        catch (InHospitalException e) {
            return BaseResponse.error((String)e.getMessage());
        }
        return BaseResponse.success((Object)rechargeDetailResVO);
    }

    @ApiOperation(value="\u4f4f\u9662\u9884\u4ea4\u91d1\u521b\u5efa\u8ba2\u5355", notes="\u4f4f\u9662\u9884\u4ea4\u91d1\u521b\u5efa\u8ba2\u5355")
    @PostMapping(value={"inHospDepositCreateOrder"})
    public BaseResponse<InHospDepositCreateOrderResVO> inHospDepositCreateOrder(@Valid @RequestBody InHospDepositCreateOrderReqVO inHospDepositCreateOrderReqVO, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return BaseResponse.error((String)bindingResult.getFieldError().getDefaultMessage());
        }
        InHospDepositCreateOrderResVO inHospDepositCreateOrderResVO = null;
        try {
            inHospDepositCreateOrderResVO = this.inHospitalService.inHospDepositCreateOrder(inHospDepositCreateOrderReqVO);
        }
        catch (InHospitalException e) {
            return BaseResponse.error((String)e.getMessage());
        }
        return BaseResponse.success((Object)inHospDepositCreateOrderResVO);
    }

    @ApiOperation(value="\u4f4f\u9662\u9884\u4ea4\u91d1\u652f\u4ed8", notes="\u4f4f\u9662\u9884\u4ea4\u91d1\u652f\u4ed8")
    @PostMapping(value={"inHospDepositPay"})
    public BaseResponse<String> inHospDepositPay(@Valid @RequestBody InHospDepositPayReqVO inHospDepositPayReqVO, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return BaseResponse.error((String)bindingResult.getFieldError().getDefaultMessage());
        }
        log.info("InHospitalController.inHospDepositPay\u8bf7\u6c42\u5165\u53c2inHospDepositPayReqVO\u4e3a:{}", (Object)inHospDepositPayReqVO);
        BaseResponse baseResponse = this.inHospitalService.InHospDepositPay(inHospDepositPayReqVO);
        return baseResponse;
    }

    @ApiOperation(value="\u83b7\u53d6\u4f4f\u9662\u8d39\u7528\u6e05\u5355", notes="\u83b7\u53d6\u4f4f\u9662\u8d39\u7528\u6e05\u5355")
    @PostMapping(value={"getHospitalOrderItems"})
    public BaseResponse<GetIhHospitalOrderItemsResVo> getHospitalOrderItems(@Valid @RequestBody GetIhHospitalOrderItemsReqVo getHospitalOrderItemsReqVo, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return BaseResponse.error((String)bindingResult.getFieldError().getDefaultMessage());
        }
        GetIhHospitalOrderItemsResVo getIhHospitalOrderItemsResVo = null;
        try {
            getIhHospitalOrderItemsResVo = this.inHospitalService.getIhHospitalOrderItems(getHospitalOrderItemsReqVo);
        }
        catch (InHospitalException e) {
            BaseResponse.error((String)e.getMessage());
        }
        return BaseResponse.success((Object)getIhHospitalOrderItemsResVo);
    }

    @ApiOperation(value="\u83b7\u53d6\u8ba2\u5355\u4fe1\u606f", notes="\u83b7\u53d6\u8ba2\u5355\u4fe1\u606f")
    @GetMapping(value={"/getOrderDetail"})
    public BaseResponse<InHospDepositCreateOrderResVO> getOrderDetail(@RequestParam(value="orderSeq") String orderSeq) {
        InHospDepositCreateOrderResVO inHospDepositCreateOrderResVO = null;
        try {
            inHospDepositCreateOrderResVO = this.inHospitalService.getInHospDepositCreateOrderRes(orderSeq);
        }
        catch (Exception e) {
            BaseResponse.error((String)e.getMessage());
        }
        return BaseResponse.success((Object)inHospDepositCreateOrderResVO);
    }

    @ApiOperation(value="\u83b7\u53d6\u4f4f\u9662\u8d39\u7528\u4fe1\u606f\uff08\u652f\u6301\u65f6\u95f4\u6bb5\u5e05\u9009\uff09", notes="\u83b7\u53d6\u4f4f\u9662\u8d39\u7528\u4fe1\u606f\uff08\u652f\u6301\u65f6\u95f4\u6bb5\u5e05\u9009\uff09")
    @PostMapping(value={"/getInHospitalFeeList"})
    public BaseResponse<List<FeeDetail>> getInHospitalFeeList(@RequestBody GetOrdItemsReq req) {
        return BaseResponse.success((Object)this.inHospitalService.getInHospitalFeeList(req));
    }
}

