/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.wisdommedical.service.impl;

import com.ebaiyihui.api.WaitingQueueClient;
import com.ebaiyihui.card.common.vo.CardDetailsInfoReqVO;
import com.ebaiyihui.card.common.vo.CardDetailsInfoRespVO;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.hkdhisfront.base.FrontRequest;
import com.ebaiyihui.hkdhisfront.base.FrontResponse;
import com.ebaiyihui.hkdhisfront.waitingqueue.PatientQueueInfo;
import com.ebaiyihui.hkdhisfront.waitingqueue.PatientQueueReq;
import com.ebaiyihui.wisdommedical.service.WaitingQueueService;
import com.ebaiyihui.wisdommedical.util.GetCardInfoUtil;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Service;

@Service
public class WaitingQueueServiceImpl
implements WaitingQueueService {
    private static final Logger log = LoggerFactory.getLogger(WaitingQueueServiceImpl.class);
    private static final String WAITING_QUEUE_TOKEN_KEY = "his_waiting_queue_token";
    @Autowired
    private GetCardInfoUtil getCardInfoUtil;
    @Autowired
    private WaitingQueueClient waitingQueueClient;
    @Autowired
    private StringRedisTemplate redisTemplate;

    public BaseResponse<List<PatientQueueInfo>> getPatientQueue(String cardId) {
        CardDetailsInfoRespVO cardDetail = this.getCardDetail(cardId);
        log.info("\u5c31\u8bca\u5361\u4fe1\u606f\uff1a{}", (Object)cardDetail);
        if (Objects.isNull(cardDetail)) {
            return BaseResponse.error((String)"\u672a\u67e5\u8be2\u5230\u8be5\u5c31\u8bca\u5361\u4fe1\u606f\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u5c31\u8bca\u5361\uff01");
        }
        String token = (String)this.redisTemplate.opsForValue().get((Object)WAITING_QUEUE_TOKEN_KEY);
        if (StringUtils.isEmpty((CharSequence)token)) {
            FrontResponse frontResponse = this.waitingQueueClient.getToken();
            if (Objects.isNull(frontResponse)) {
                log.error("WaitingQueueServiceImpl.getPatientQueue->\u672a\u83b7\u53d6\u63a5\u53e3\u8bf7\u6c42token");
                return BaseResponse.error((String)"\u672a\u83b7\u53d6\u63a5\u53e3\u8bf7\u6c42token");
            }
            if (!"1".equals(frontResponse.getCode())) {
                log.error("WaitingQueueServiceImpl.getPatientQueue->\u672a\u83b7\u53d6\u63a5\u53e3\u8bf7\u6c42token");
                return BaseResponse.error((String)"\u672a\u83b7\u53d6\u63a5\u53e3\u8bf7\u6c42token");
            }
            token = (String)frontResponse.getBody();
            this.redisTemplate.opsForValue().set((Object)WAITING_QUEUE_TOKEN_KEY, (Object)token, 11L, TimeUnit.HOURS);
        }
        FrontRequest param = new FrontRequest();
        PatientQueueReq patientQueueReq = new PatientQueueReq();
        patientQueueReq.setPatientId(cardDetail.getCardNo());
        patientQueueReq.setToken(token);
        param.setBody((Object)patientQueueReq);
        param.setTransactionId(UUID.randomUUID().toString());
        FrontResponse queueFrontResponse = this.waitingQueueClient.getPatientQueueInfo(param);
        if (Objects.isNull(queueFrontResponse)) {
            log.error("WaitingQueueServiceImpl.getPatientQueue->\u672a\u83b7\u53d6\u5019\u8bca\u961f\u5217\u4fe1\u606f");
            return BaseResponse.error((String)"\u672a\u83b7\u53d6\u5019\u8bca\u961f\u5217\u4fe1\u606f");
        }
        if (!"1".equals(queueFrontResponse.getCode())) {
            log.error("WaitingQueueServiceImpl.getPatientQueue->\u672a\u83b7\u53d6\u5019\u8bca\u961f\u5217\u4fe1\u606f");
            return BaseResponse.error((String)queueFrontResponse.getMessage());
        }
        return BaseResponse.success((Object)queueFrontResponse.getBody());
    }

    private CardDetailsInfoRespVO getCardDetail(String cardId) {
        CardDetailsInfoReqVO cardDetailsInfoReqVO = new CardDetailsInfoReqVO();
        cardDetailsInfoReqVO.setCardId(cardId);
        cardDetailsInfoReqVO.setChannelCode("app");
        CardDetailsInfoRespVO respVO = this.getCardInfoUtil.getCardDetail(cardDetailsInfoReqVO);
        return respVO;
    }
}

