/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.controller.mobile;

import com.ebaiyihui.dto.HospitalManagementDTO;
import com.ebaiyihui.dto.ServiceQualityDTO;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.service.HospitalService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"mobile/hospital"}, produces={"application/json;charset=UTF-8"})
@Api(tags={"\u533b\u9662\u6570\u636e"})
@CrossOrigin(origins={"*"})
public class HospitalController {
    private static final Logger log = LoggerFactory.getLogger(HospitalController.class);
    @Autowired
    private HospitalService hospitalService;

    @GetMapping(value={"/getHospitalManagement"})
    @ApiOperation(value="\u533b\u9662\u7ba1\u7406")
    public BaseResponse<HospitalManagementDTO> getHospitalManagement(@RequestHeader(value="appCode") String appCode) {
        return BaseResponse.success((Object)this.hospitalService.getHospitalManagement(appCode));
    }

    @GetMapping(value={"/getServiceQuality"})
    @ApiOperation(value="\u670d\u52a1\u8d28\u91cf")
    public BaseResponse<ServiceQualityDTO> getServiceQuality() {
        return BaseResponse.success((Object)this.hospitalService.getServiceQuality());
    }

    @GetMapping(value={"/exportExcel"}, produces={"application/vnd.ms-excel"})
    @ApiOperation(value="\u5bfc\u51fa")
    public void exportExcel(HttpServletResponse response) {
        this.hospitalService.exportExcel(response);
    }
}

