/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.controller.web;

import com.ebaiyihui.dto.TrafficViewDTO;
import com.ebaiyihui.dto.TrafficViewRatioDTO;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.service.TrafficViewService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.text.DecimalFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"data/traffic"}, produces={"application/json;charset=UTF-8"})
@Api(tags={"\u6d41\u91cf\u770b\u7248"})
@CrossOrigin(origins={"*"})
public class TrafficViewController {
    private static final Logger log = LoggerFactory.getLogger(TrafficViewController.class);
    @Autowired
    private TrafficViewService trafficViewService;

    @GetMapping(value={"/getTrafficView"})
    @ApiOperation(value="\u6d41\u91cf\u770b\u7248")
    public BaseResponse<TrafficViewDTO> getTrafficView(@RequestHeader(value="appCode") String appCode) {
        TrafficViewDTO trafficView = this.trafficViewService.getTrafficView(appCode);
        return BaseResponse.success((Object)trafficView);
    }

    @GetMapping(value={"/getTrafficViewRatio"})
    @ApiOperation(value="\u6d41\u91cf\u770b\u7248\u767e\u5206\u7387")
    public BaseResponse<TrafficViewRatioDTO> getTrafficViewRatio(@RequestHeader(value="appCode") String appCode) {
        TrafficViewRatioDTO trafficViewRatio = this.trafficViewService.getTrafficViewRatio(appCode);
        return BaseResponse.success((Object)trafficViewRatio);
    }

    public static void main(String[] args) {
        double v = 50.0;
        System.out.println(new DecimalFormat("#").format(Math.abs(v)).toString());
        double v4 = Double.NaN;
        System.out.println((long)v4);
        System.out.println(String.format("%.1f", 0.0));
    }
}

