/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.service.impl;

import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUnit;
import cn.hutool.core.date.DateUtil;
import com.ebaiyihui.dto.ComTimeDTO;
import com.ebaiyihui.dto.FollowUpPrescriptionDTO;
import com.ebaiyihui.dto.ReceivingDepartmentsDTO;
import com.ebaiyihui.mapper.db2.OnlineOutpatientMapper;
import com.ebaiyihui.service.BusinessService;
import com.ebaiyihui.service.HospitalService;
import com.ebaiyihui.vo.DocDeptDateRankingResVO;
import com.ebaiyihui.vo.DocDeptDateRankingVO;
import com.ebaiyihui.vo.OrderListForCountReqVo;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;

@Service
@Transactional(rollbackFor={Exception.class})
public class BusinessServiceImpl
implements BusinessService {
    private static final Logger log = LoggerFactory.getLogger(BusinessServiceImpl.class);
    @Autowired
    private HospitalService hospitalService;
    @Autowired
    private OnlineOutpatientMapper onlineOutpatientMapper;
    @Value(value="${hospital.id}")
    private String hospitalId;
    @Value(value="${hospital.code}")
    private String code;
    @Value(value="${hospital.appCode}")
    private String appCode;

    public FollowUpPrescriptionDTO getFollowUpPrescription() {
        FollowUpPrescriptionDTO entity = new FollowUpPrescriptionDTO();
        DateTime dateTime = DateUtil.offsetDay((Date)new Date(), (int)-30);
        String startTime = DateUtil.format((Date)dateTime, (String)"yyyy-MM-dd");
        dateTime = DateUtil.offsetDay((Date)new Date(), (int)0);
        String endTime = DateUtil.format((Date)dateTime, (String)"yyyy-MM-dd");
        log.info("startTime: {}, endTime: {}", (Object)startTime, (Object)endTime);
        long payCount = this.onlineOutpatientMapper.getFollowAllCount(startTime, endTime);
        entity.setBookOrderCount(Long.valueOf(payCount));
        long comCount = this.onlineOutpatientMapper.getFollowAllCommitCount(startTime, endTime);
        entity.setReceiveOrderCount(Long.valueOf(comCount));
        long per = (long)((double)comCount / (double)payCount * 100.0);
        entity.setReceiveRate(per + "%");
        List dtos = this.onlineOutpatientMapper.getComTime(startTime, endTime);
        log.info("dtos: {}", (Object)dtos.size());
        Long timeMins = 0L;
        long count = 0L;
        for (ComTimeDTO dto : dtos) {
            if (StringUtils.isEmpty((Object)dto.getEndTime())) continue;
            String dateStr1 = dto.getStartTime();
            DateTime date1 = DateUtil.parse((String)dateStr1);
            String dateStr2 = dto.getEndTime();
            DateTime date2 = DateUtil.parse((String)dateStr2);
            long betweenMinute = DateUtil.between((Date)date1, (Date)date2, (DateUnit)DateUnit.MINUTE);
            timeMins = timeMins + betweenMinute;
            ++count;
        }
        log.info("timeMins: {}", (Object)timeMins);
        Long avgMins = timeMins / count;
        log.info("count: {}", (Object)count);
        log.info("avgMins: {}", (Object)avgMins.toString());
        entity.setAverageReceiveTime(this.formatTime(avgMins.longValue()));
        return entity;
    }

    private String formatTime(long minuteStr) {
        String resultStr = "";
        resultStr = minuteStr != 0L ? (minuteStr / 60L == 0L ? minuteStr % 60L + "\u5206" : (minuteStr % 60L == 0L ? minuteStr / 60L + "\u5c0f\u65f6" : minuteStr / 60L + "\u5c0f\u65f6" + minuteStr % 60L + "\u5206")) : "0\u65f60\u5206";
        return resultStr;
    }

    public List<ReceivingDepartmentsDTO> getReceivingDepartments() {
        ArrayList<ReceivingDepartmentsDTO> entity = new ArrayList<ReceivingDepartmentsDTO>();
        DateTime dateTime = DateUtil.offsetDay((Date)new Date(), (int)-30);
        String startTime = DateUtil.format((Date)dateTime, (String)"yyyy-MM-dd");
        dateTime = DateUtil.offsetDay((Date)new Date(), (int)-1);
        String endTime = DateUtil.format((Date)dateTime, (String)"yyyy-MM-dd");
        OrderListForCountReqVo vo = new OrderListForCountReqVo();
        vo.setAppCode(this.appCode);
        vo.setDateType("1");
        vo.setEndTime(endTime);
        vo.setNewOrderCount("1");
        vo.setHospitalId(this.code);
        vo.setServType(Integer.valueOf(3));
        vo.setSortType("1");
        vo.setStartTime(startTime);
        log.info("startTime: {}, endTime: {}", (Object)startTime, (Object)endTime);
        int sumCount = 0;
        DocDeptDateRankingResVO vo1 = this.hospitalService.deptReceiveRanking(vo);
        List voList = vo1.getDocDeptDateRankingVOList();
        for (DocDeptDateRankingVO docDeptDateRankingVO : voList) {
            ReceivingDepartmentsDTO dto = new ReceivingDepartmentsDTO();
            dto.setName(docDeptDateRankingVO.getDeptName());
            dto.setValue(docDeptDateRankingVO.getOrdersReceived());
            log.info("\u63a5\u8bca\u79d1\u5ba4: {} ,\u63a5\u8bca\u91cf: {},", (Object)docDeptDateRankingVO.getDeptName(), (Object)docDeptDateRankingVO.getOrdersReceived());
            if (5 <= docDeptDateRankingVO.getOrdersReceived()) {
                entity.add(dto);
            }
            sumCount += docDeptDateRankingVO.getOrdersReceived().intValue();
        }
        log.info("\u79d1\u5ba4\u603b\u63a5\u5355\u91cf\uff1a{}", (Object)sumCount);
        return entity;
    }
}

