/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.service.impl;

import cn.afterturn.easypoi.excel.entity.ExportParams;
import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.CharsetUtil;
import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ebaiyihui.dto.DataDTO;
import com.ebaiyihui.dto.DepartmentDTO;
import com.ebaiyihui.dto.DoctorDTO;
import com.ebaiyihui.dto.ExportDepartDto;
import com.ebaiyihui.dto.ExportDotorDto;
import com.ebaiyihui.dto.HospitalManagementDTO;
import com.ebaiyihui.dto.ServiceQualityDTO;
import com.ebaiyihui.mapper.db2.OnlineOutpatientMapper;
import com.ebaiyihui.mapper.db3.PrescriptionCirculationMapper;
import com.ebaiyihui.mapper.db5.MedicalcloudServiceMapper;
import com.ebaiyihui.service.HospitalService;
import com.ebaiyihui.utils.ExcelUtils;
import com.ebaiyihui.vo.AccountConAndLoginTimeVO;
import com.ebaiyihui.vo.DepartmentVO;
import com.ebaiyihui.vo.DocDeptDateRankingResVO;
import com.ebaiyihui.vo.DocDeptDateRankingVO;
import com.ebaiyihui.vo.OrderCountForMangVo;
import com.ebaiyihui.vo.OrderListForCountReqVo;
import com.ebaiyihui.vo.OrganIdReq;
import java.io.IOException;
import java.nio.charset.Charset;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.TreeSet;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@Service
@Transactional(rollbackFor={Exception.class})
public class HospitalServiceImpl
implements HospitalService {
    private static final Logger log = LoggerFactory.getLogger(HospitalServiceImpl.class);
    public static final String ASC = "1";
    public static final String DESC = "2";
    @Autowired
    private OnlineOutpatientMapper onlineOutpatientMapper;
    @Autowired
    private PrescriptionCirculationMapper prescriptionCirculationMapper;
    @Autowired
    private MedicalcloudServiceMapper medicalcloudServiceMapper;
    @Value(value="${doctor-basedata.ip}")
    private String doctorBasedataIP;
    @Value(value="${doctor-usercenter.ip}")
    private String doctorUsercenterIP;
    @Value(value="${hospital.id}")
    private String hospitalId;
    @Value(value="${hospital.code}")
    private String code;
    @Value(value="${hospital.appCode}")
    private String appCode;

    public HospitalManagementDTO getHospitalManagement(String appCode) {
        HospitalManagementDTO entity = new HospitalManagementDTO();
        OrganIdReq organIdReq = new OrganIdReq();
        organIdReq.setOrganId(this.code);
        organIdReq.setOrganCode(this.code);
        String json = JSON.toJSONString((Object)organIdReq);
        String result2 = ((HttpRequest)HttpRequest.post((String)(this.doctorBasedataIP + "/department/listAllOrganDept")).contentType("application/json").header("Accept", "application/json")).body(json).execute().body();
        log.info("result2: {}", (Object)result2);
        JSONObject jsonObject2 = JSON.parseObject((String)result2);
        String data2 = jsonObject2.get((Object)"data").toString();
        List departmentVOS = JSON.parseArray((String)data2, DepartmentVO.class);
        Long count = this.medicalcloudServiceMapper.getCountDrug(appCode);
        log.info("code: {}", (Object)this.code);
        String url = this.doctorUsercenterIP + "/cloudaccount/getAccountConAndLoginTime?hospitalCode=" + this.code;
        String result = HttpUtil.get((String)url, (Charset)CharsetUtil.CHARSET_UTF_8);
        log.info("result: {}", (Object)result);
        JSONObject jsonObject = JSON.parseObject((String)result);
        String data = jsonObject.get((Object)"data").toString();
        List accountConAndLoginTimeVOS = JSON.parseArray((String)data, AccountConAndLoginTimeVO.class);
        DateTime dateTime = DateUtil.offsetDay((Date)new Date(), (int)-30);
        String startTime = DateUtil.format((Date)dateTime, (String)"yyyy-MM-dd");
        log.info("startTime: {}", (Object)startTime);
        DateTime dateTime1 = DateUtil.offsetDay((Date)new Date(), (int)0);
        String endTime = DateUtil.format((Date)dateTime1, (String)"yyyy-MM-dd");
        log.info("endTime: {}", (Object)endTime);
        double live = 0.0;
        for (AccountConAndLoginTimeVO vo : accountConAndLoginTimeVOS) {
            if (StringUtils.isEmpty((Object)vo.getCreateTime()) || !"APP".equals(vo.getDeviceType()) || 0 != vo.getLoginType()) continue;
            String dateStr1 = vo.getCreateTime();
            DateTime date1 = DateUtil.parse((String)dateStr1);
            DateTime date2 = DateUtil.parse((String)(startTime + " 00:00:00"));
            DateTime date3 = DateUtil.parse((String)(endTime + " 00:00:00"));
            if (date1.getTime() <= date2.getTime() || date1.getTime() >= date3.getTime()) continue;
            live += 1.0;
        }
        log.info("accountConAndLoginTimeVOS.size() : {}", (Object)accountConAndLoginTimeVOS.size());
        log.info("live : {}", (Object)live);
        double per = live / (double)accountConAndLoginTimeVOS.size() * 100.0;
        entity.setDepartmentCount(Long.valueOf(departmentVOS.size()));
        entity.setDrugCount(String.valueOf(count));
        entity.setDoctorCount(String.valueOf(accountConAndLoginTimeVOS.size()));
        entity.setActiveRate((long)per + "%");
        return entity;
    }

    public ServiceQualityDTO getServiceQuality() {
        ServiceQualityDTO entity = new ServiceQualityDTO();
        DateTime dateTime = DateUtil.offsetDay((Date)new Date(), (int)-30);
        String startTime = DateUtil.format((Date)dateTime, (String)"yyyy-MM-dd");
        dateTime = DateUtil.offsetDay((Date)new Date(), (int)-1);
        String endTime = DateUtil.format((Date)dateTime, (String)"yyyy-MM-dd");
        dateTime = DateUtil.offsetDay((Date)new Date(), (int)-31);
        String startTime1 = DateUtil.format((Date)dateTime, (String)"yyyy-MM-dd");
        dateTime = DateUtil.offsetDay((Date)new Date(), (int)-60);
        String endTime1 = DateUtil.format((Date)dateTime, (String)"yyyy-MM-dd");
        log.info("startTime: {}, endTime: {}", (Object)startTime, (Object)endTime);
        log.info("startTime1: {}, endTime1: {}", (Object)startTime1, (Object)endTime1);
        OrderListForCountReqVo vo = new OrderListForCountReqVo();
        vo.setAppCode(this.appCode);
        vo.setDateType(ASC);
        vo.setOrdersReceived(ASC);
        log.info("code {},", (Object)this.code);
        vo.setHospitalId(this.code);
        vo.setServType(Integer.valueOf(3));
        vo.setSortType(ASC);
        vo.setStartTime(startTime);
        vo.setEndTime(endTime);
        DocDeptDateRankingResVO vo1 = this.deptReceiveRanking(vo);
        List voList = vo1.getDocDeptDateRankingVOList();
        DepartmentDTO department = new DepartmentDTO();
        DepartmentDTO departmentAll = new DepartmentDTO();
        DepartmentDTO departmentNotAccepted = new DepartmentDTO();
        ArrayList<DataDTO> data = new ArrayList<DataDTO>();
        ArrayList<DataDTO> notAccpted = new ArrayList<DataDTO>();
        int count = 0;
        for (DocDeptDateRankingVO docDeptDateRankingVO : voList) {
            DataDTO dataDTO = new DataDTO();
            dataDTO.setName(docDeptDateRankingVO.getDeptName());
            dataDTO.setValue(docDeptDateRankingVO.getOrdersReceivedRate() + "%");
            dataDTO.setReceiving(Long.valueOf(docDeptDateRankingVO.getOrdersReceived().longValue()));
            dataDTO.setPlace(Long.valueOf(docDeptDateRankingVO.getNewOrderCount().longValue()));
            if (5 > docDeptDateRankingVO.getNewOrderCount()) {
                ++count;
            }
            log.info("\u63a5\u8bca\u79d1\u5ba4: {} ,\u4e0b\u5355\u91cf: {}, \u63a5\u8bca\u91cf: {},", new Object[]{docDeptDateRankingVO.getDeptName(), docDeptDateRankingVO.getNewOrderCount(), docDeptDateRankingVO.getOrdersReceived()});
            data.add(dataDTO);
            DataDTO dataDTO1 = new DataDTO();
            dataDTO1.setName(docDeptDateRankingVO.getDeptName());
            dataDTO1.setValue(docDeptDateRankingVO.getOrdersReceivedRate() + "%");
            dataDTO1.setReceiving(Long.valueOf(docDeptDateRankingVO.getOrdersReceived().longValue()));
            dataDTO1.setPlace(Long.valueOf(docDeptDateRankingVO.getNewOrderCount().longValue()));
            notAccpted.add(dataDTO1);
        }
        departmentAll.setData(data);
        if (data.size() >= 10) {
            department.setData(data.subList(0, 10));
        } else {
            department.setData(data);
        }
        for (DataDTO datum : notAccpted) {
            double v = (double)(datum.getPlace() - datum.getReceiving()) / (double)datum.getPlace().longValue() * 100.0;
            datum.setValue(String.format("%.1f", v) + "%");
            datum.setReceiving(Long.valueOf(datum.getPlace() - datum.getReceiving()));
        }
        departmentNotAccepted.setData(this.sort3(notAccpted));
        DoctorDTO doctor = new DoctorDTO();
        DoctorDTO doctorAll = new DoctorDTO();
        DoctorDTO doctorNotAccepted = new DoctorDTO();
        vo.setNewOrderCount(null);
        vo.setOrdersReceived(ASC);
        vo.setOrdersReceivedRate(null);
        DocDeptDateRankingResVO vo3 = this.docDataRanking(vo);
        List voList3 = vo3.getDocDeptDateRankingVOList();
        ArrayList<DataDTO> data1 = new ArrayList<DataDTO>();
        ArrayList<DataDTO> notAccptedDoc = new ArrayList<DataDTO>();
        double count1 = 0.0;
        for (DocDeptDateRankingVO docDeptDateRankingVO : voList3) {
            DataDTO dataDTO = new DataDTO();
            dataDTO.setName(docDeptDateRankingVO.getDocName());
            dataDTO.setValue(docDeptDateRankingVO.getOrdersReceivedRate() + "%");
            dataDTO.setReceiving(Long.valueOf(docDeptDateRankingVO.getOrdersReceived().longValue()));
            dataDTO.setPlace(Long.valueOf(docDeptDateRankingVO.getNewOrderCount().longValue()));
            if (5 < docDeptDateRankingVO.getNewOrderCount()) {
                count1 += 1.0;
            }
            log.info("\u533b\u751f\u59d3\u540d: {} ,\u4e0b\u5355\u91cf: {}, \u63a5\u8bca\u91cf: {},", new Object[]{docDeptDateRankingVO.getDocName(), docDeptDateRankingVO.getNewOrderCount(), docDeptDateRankingVO.getOrdersReceived()});
            data1.add(dataDTO);
            DataDTO dataDTO1 = new DataDTO();
            dataDTO1.setName(docDeptDateRankingVO.getDocName());
            dataDTO1.setValue(docDeptDateRankingVO.getOrdersReceivedRate() + "%");
            dataDTO1.setReceiving(Long.valueOf(docDeptDateRankingVO.getOrdersReceived().longValue()));
            dataDTO1.setPlace(Long.valueOf(docDeptDateRankingVO.getNewOrderCount().longValue()));
            notAccptedDoc.add(dataDTO1);
        }
        doctorAll.setData(data1);
        if (data1.size() >= 10) {
            doctor.setData(data1.subList(0, 10));
        } else {
            doctor.setData(data1);
        }
        for (DataDTO datum : notAccptedDoc) {
            double v = (double)(datum.getPlace() - datum.getReceiving()) / (double)datum.getPlace().longValue() * 100.0;
            datum.setValue(String.format("%.1f", v) + "%");
            datum.setReceiving(Long.valueOf(datum.getPlace() - datum.getReceiving()));
        }
        doctorNotAccepted.setData(this.sort3(notAccptedDoc));
        entity.setDepartment(department);
        entity.setDoctor(doctor);
        entity.setDepartmentAll(departmentAll);
        entity.setDoctorAll(doctorAll);
        entity.setDepartmentNotAccepted(departmentNotAccepted);
        entity.setDoctorNotAccepted(doctorNotAccepted);
        return entity;
    }

    public List<DocDeptDateRankingVO> sort(List<DocDeptDateRankingVO> voList) {
        LinkedHashMap map = new LinkedHashMap();
        for (DocDeptDateRankingVO vo : voList) {
            List docDeptDateRankingVOS = (List)map.get(vo.getNewOrderCount());
            if (CollectionUtils.isEmpty((Collection)docDeptDateRankingVOS)) {
                ArrayList<DocDeptDateRankingVO> list = new ArrayList<DocDeptDateRankingVO>();
                list.add(vo);
                map.put(vo.getNewOrderCount(), list);
                continue;
            }
            docDeptDateRankingVOS.add(vo);
        }
        ArrayList<DocDeptDateRankingVO> voList1 = new ArrayList<DocDeptDateRankingVO>();
        for (Integer integer : map.keySet()) {
            List docDeptDateRankingVOS = (List)map.get(integer);
            if (docDeptDateRankingVOS.size() > 1) {
                docDeptDateRankingVOS = docDeptDateRankingVOS.stream().sorted(Comparator.comparing(DocDeptDateRankingVO::getOrdersReceived).reversed()).collect(Collectors.toList());
                for (DocDeptDateRankingVO docDeptDateRankingVO : docDeptDateRankingVOS) {
                    voList1.add(docDeptDateRankingVO);
                }
                continue;
            }
            voList1.add((DocDeptDateRankingVO)docDeptDateRankingVOS.get(0));
        }
        return voList1;
    }

    public List<DocDeptDateRankingVO> sort2(List<DocDeptDateRankingVO> voList) {
        LinkedHashMap map = new LinkedHashMap();
        for (DocDeptDateRankingVO vo : voList) {
            List docDeptDateRankingVOS = (List)map.get(vo.getOrdersReceived());
            if (CollectionUtils.isEmpty((Collection)docDeptDateRankingVOS)) {
                ArrayList<DocDeptDateRankingVO> list = new ArrayList<DocDeptDateRankingVO>();
                list.add(vo);
                map.put(vo.getOrdersReceived(), list);
                continue;
            }
            docDeptDateRankingVOS.add(vo);
        }
        ArrayList<DocDeptDateRankingVO> voList1 = new ArrayList<DocDeptDateRankingVO>();
        for (Integer integer : map.keySet()) {
            List docDeptDateRankingVOS = (List)map.get(integer);
            if (docDeptDateRankingVOS.size() > 1) {
                docDeptDateRankingVOS = docDeptDateRankingVOS.stream().sorted((x, y) -> {
                    Collator instance = Collator.getInstance(Locale.CHINA);
                    return instance.compare(x.getDeptName(), y.getDeptName());
                }).collect(Collectors.toList());
                for (DocDeptDateRankingVO docDeptDateRankingVO : docDeptDateRankingVOS) {
                    voList1.add(docDeptDateRankingVO);
                }
                continue;
            }
            voList1.add((DocDeptDateRankingVO)docDeptDateRankingVOS.get(0));
        }
        return voList1;
    }

    public List<DataDTO> sort3(List<DataDTO> voList) {
        return voList.stream().sorted((x, y) -> y.getReceiving().compareTo(x.getReceiving())).collect(Collectors.toList());
    }

    public DocDeptDateRankingResVO docDataRanking(OrderListForCountReqVo orderListForCountReqVo) {
        orderListForCountReqVo.setStartTime(orderListForCountReqVo.getStartTime() + " 00:00:00");
        orderListForCountReqVo.setEndTime(orderListForCountReqVo.getEndTime() + " 24:00:00");
        DocDeptDateRankingResVO docDeptDateRankingResVO = new DocDeptDateRankingResVO();
        ArrayList<DocDeptDateRankingVO> docDeptDateRankingVOList = new ArrayList<DocDeptDateRankingVO>();
        List<Object> docDeptDateRankingVOLists = new ArrayList();
        List orderListForCountList = this.onlineOutpatientMapper.selectOrderDocCount(orderListForCountReqVo);
        if (!CollectionUtils.isEmpty((Collection)orderListForCountList)) {
            log.info("deptReceiveRanking.orderCount: {}", (Object)orderListForCountList.size());
        }
        List data = orderListForCountList.stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<OrderCountForMangVo>(Comparator.comparing(o -> o.getDeptId() + o.getDoctorName()))), ArrayList::new)).stream().filter(x -> x.getDeptName() != null).collect(Collectors.toList());
        for (OrderCountForMangVo doctor : data) {
            DocDeptDateRankingVO docDeptDateRankingVO = new DocDeptDateRankingVO();
            List newOrderCount = orderListForCountList.stream().filter(x -> x.getStartTime() != null && x.getDoctorName().equals(doctor.getDoctorName()) && x.getDeptId().equals(doctor.getDeptId())).collect(Collectors.toList());
            List orderCountForMang = orderListForCountList.stream().filter(x -> x.getStatus() != 65 && x.getDoctorName() != null && x.getDoctorName().equals(doctor.getDoctorName()) && x.getDeptId().equals(doctor.getDeptId())).collect(Collectors.toList());
            List completeNewOrdersList = orderListForCountList.stream().filter(x -> x.getStartTime() != null && x.getDoctorName() != null && x.getStatus() != 65 && x.getDoctorName().equals(doctor.getDoctorName()) && x.getDeptId().equals(doctor.getDeptId()) && x.getSecondsCount() != null).collect(Collectors.toList());
            List completeOrdersList = orderListForCountList.stream().filter(x -> (x.getStatus() == 7 || x.getStatus() == 8 || x.getStatus() == 9) && x.getStartTime() != null && x.getEndTime() != null && x.getDoctorName().equals(doctor.getDoctorName()) && x.getDeptId().equals(doctor.getDeptId())).collect(Collectors.toList());
            docDeptDateRankingVO.setDeptName(doctor.getDeptName()).setDocName(doctor.getDoctorName()).setOrdersReceived(Integer.valueOf(orderListForCountList.stream().filter(x -> (x.getStatus() == 2 || x.getStatus() == 7 || x.getStatus() == 8 || x.getStatus() == 9) && x.getStartTime() != null && x.getDoctorName().equals(doctor.getDoctorName()) && x.getDeptId().equals(doctor.getDeptId())).collect(Collectors.toList()).size())).setHospitalId(orderListForCountReqVo.getHospitalId()).setNewOrderCount(Integer.valueOf(orderCountForMang.size()));
            if (newOrderCount.size() == 0) {
                docDeptDateRankingVO.setAvgReceiveTime(Integer.valueOf(0));
            } else {
                docDeptDateRankingVO.setAvgReceiveTime(Integer.valueOf(completeNewOrdersList.stream().mapToInt(OrderCountForMangVo::getSecondsCount).sum() / newOrderCount.size() / 60));
            }
            if (orderCountForMang.size() == 0) {
                docDeptDateRankingVO.setOrdersReceivedRate(Double.valueOf(0.0));
            } else {
                docDeptDateRankingVO.setOrdersReceivedRate(Double.valueOf((double)orderListForCountList.stream().filter(x -> (x.getStatus() == 2 || x.getStatus() == 7 || x.getStatus() == 8 || x.getStatus() == 9) && x.getStartTime() != null && x.getEndTime() != null && x.getDoctorName().equals(doctor.getDoctorName()) && x.getDeptId().equals(doctor.getDeptId())).collect(Collectors.toList()).size() / (double)orderCountForMang.size()));
            }
            if (orderCountForMang.size() == 0) {
                docDeptDateRankingVO.setCompletionRate(Double.valueOf(0.0));
            } else {
                docDeptDateRankingVO.setCompletionRate(Double.valueOf((double)orderListForCountList.stream().filter(x -> (x.getStatus() == 2 || x.getStatus() == 7 || x.getStatus() == 8 || x.getStatus() == 9) && x.getStartTime() != null && x.getEndTime() != null && x.getDoctorName().equals(doctor.getDoctorName()) && x.getDeptId().equals(doctor.getDeptId())).collect(Collectors.toList()).size() / (double)orderCountForMang.size()));
            }
            docDeptDateRankingVOList.add(docDeptDateRankingVO);
        }
        if (!Objects.isNull(orderListForCountReqVo.getSortType())) {
            if (ASC.equals(orderListForCountReqVo.getSortType())) {
                if (orderListForCountReqVo.getAvgReceiveTime() != null && !"".equals(orderListForCountReqVo.getAvgReceiveTime())) {
                    docDeptDateRankingVOLists = docDeptDateRankingVOList.stream().sorted(Comparator.comparing(DocDeptDateRankingVO::getAvgReceiveTime).reversed()).collect(Collectors.toList());
                }
                if (orderListForCountReqVo.getOrdersReceived() != null && !"".equals(orderListForCountReqVo.getOrdersReceived())) {
                    docDeptDateRankingVOLists = docDeptDateRankingVOList.stream().sorted(Comparator.comparing(DocDeptDateRankingVO::getOrdersReceived).reversed()).collect(Collectors.toList());
                }
                if (orderListForCountReqVo.getCompletionRate() != null && !"".equals(orderListForCountReqVo.getCompletionRate())) {
                    docDeptDateRankingVOLists = docDeptDateRankingVOList.stream().sorted(Comparator.comparing(DocDeptDateRankingVO::getCompletionRate).reversed()).collect(Collectors.toList());
                }
                if (orderListForCountReqVo.getNewOrderCount() != null && !"".equals(orderListForCountReqVo.getNewOrderCount())) {
                    docDeptDateRankingVOLists = docDeptDateRankingVOList.stream().sorted(Comparator.comparing(DocDeptDateRankingVO::getNewOrderCount).reversed()).collect(Collectors.toList());
                }
                if (orderListForCountReqVo.getOrdersReceivedRate() != null && !"".equals(orderListForCountReqVo.getOrdersReceivedRate())) {
                    docDeptDateRankingVOLists = docDeptDateRankingVOList.stream().sorted(Comparator.comparing(DocDeptDateRankingVO::getOrdersReceivedRate).reversed()).collect(Collectors.toList());
                }
            } else if (DESC.equals(orderListForCountReqVo.getSortType())) {
                if (orderListForCountReqVo.getAvgReceiveTime() != null && !"".equals(orderListForCountReqVo.getAvgReceiveTime())) {
                    docDeptDateRankingVOLists = docDeptDateRankingVOList.stream().sorted(Comparator.comparing(DocDeptDateRankingVO::getAvgReceiveTime)).collect(Collectors.toList());
                }
                if (orderListForCountReqVo.getOrdersReceived() != null && !"".equals(orderListForCountReqVo.getOrdersReceived())) {
                    docDeptDateRankingVOLists = docDeptDateRankingVOList.stream().sorted(Comparator.comparing(DocDeptDateRankingVO::getOrdersReceived)).collect(Collectors.toList());
                }
                if (orderListForCountReqVo.getCompletionRate() != null && !"".equals(orderListForCountReqVo.getCompletionRate())) {
                    docDeptDateRankingVOLists = docDeptDateRankingVOList.stream().sorted(Comparator.comparing(DocDeptDateRankingVO::getCompletionRate)).collect(Collectors.toList());
                }
                if (orderListForCountReqVo.getNewOrderCount() != null && !"".equals(orderListForCountReqVo.getNewOrderCount())) {
                    docDeptDateRankingVOLists = docDeptDateRankingVOList.stream().sorted(Comparator.comparing(DocDeptDateRankingVO::getNewOrderCount)).collect(Collectors.toList());
                }
                if (orderListForCountReqVo.getOrdersReceivedRate() != null && !"".equals(orderListForCountReqVo.getOrdersReceivedRate())) {
                    docDeptDateRankingVOLists = docDeptDateRankingVOList.stream().sorted(Comparator.comparing(DocDeptDateRankingVO::getOrdersReceivedRate)).collect(Collectors.toList());
                }
            }
        } else {
            docDeptDateRankingVOLists = docDeptDateRankingVOList.stream().sorted(Comparator.comparing(DocDeptDateRankingVO::getOrdersReceived)).collect(Collectors.toList());
        }
        if (Objects.nonNull(orderListForCountReqVo.getHospitalId())) {
            docDeptDateRankingVOLists.forEach(x -> x.setCompletionRate(Double.valueOf(Double.parseDouble(String.format("%.1f", x.getCompletionRate() * 100.0)))));
            docDeptDateRankingVOLists.forEach(x -> x.setOrdersReceivedRate(Double.valueOf(Double.parseDouble(String.format("%.1f", x.getOrdersReceivedRate() * 100.0)))));
            docDeptDateRankingResVO.setDataType(Integer.valueOf(1)).setDocDeptDateRankingVOList(docDeptDateRankingVOLists.stream().filter(x -> x.getHospitalId().equals(orderListForCountReqVo.getHospitalId())).collect(Collectors.toList()));
            return docDeptDateRankingResVO;
        }
        if (Objects.nonNull(orderListForCountReqVo.getDeptId())) {
            docDeptDateRankingVOLists.forEach(x -> x.setCompletionRate(Double.valueOf(Double.parseDouble(String.format("%.1f", x.getCompletionRate() * 100.0)))));
            docDeptDateRankingResVO.setDataType(Integer.valueOf(1)).setDocDeptDateRankingVOList(docDeptDateRankingVOLists.stream().filter(x -> x.getDeptId().equals(orderListForCountReqVo.getDeptId())).collect(Collectors.toList()));
            return docDeptDateRankingResVO;
        }
        if (Objects.nonNull(orderListForCountReqVo.getHospitalId()) && Objects.nonNull(orderListForCountReqVo.getDeptId())) {
            docDeptDateRankingVOLists.forEach(x -> x.setCompletionRate(Double.valueOf(Double.parseDouble(String.format("%.1f", x.getCompletionRate() * 100.0)))));
            docDeptDateRankingResVO.setDataType(Integer.valueOf(1)).setDocDeptDateRankingVOList(docDeptDateRankingVOLists.stream().filter(x -> x.getDeptId().equals(orderListForCountReqVo.getDeptId()) && x.getHospitalId().equals(orderListForCountReqVo.getHospitalId())).collect(Collectors.toList()));
            return docDeptDateRankingResVO;
        }
        docDeptDateRankingResVO.setDataType(Integer.valueOf(1)).setDocDeptDateRankingVOList(docDeptDateRankingVOLists);
        return docDeptDateRankingResVO;
    }

    public DocDeptDateRankingResVO deptReceiveRanking(OrderListForCountReqVo orderListForCountReqVo) {
        orderListForCountReqVo.setDeptId(null);
        orderListForCountReqVo.setStartTime(orderListForCountReqVo.getStartTime() + " 00:00:00");
        orderListForCountReqVo.setEndTime(orderListForCountReqVo.getEndTime() + " 23:59:59");
        DocDeptDateRankingResVO docDeptDateRankingResVO = new DocDeptDateRankingResVO();
        ArrayList<DocDeptDateRankingVO> docDeptDateRankingVOList = new ArrayList<DocDeptDateRankingVO>();
        ArrayList<DocDeptDateRankingVO> docDeptDateRankingVOLists = new ArrayList<DocDeptDateRankingVO>();
        List<Object> docDeptDateRankingVOListsort = new ArrayList();
        List orderCount = this.onlineOutpatientMapper.selectOrderDocCount(orderListForCountReqVo);
        if (!CollectionUtils.isEmpty((Collection)orderCount)) {
            log.info("deptReceiveRanking.orderCount: {}", (Object)orderCount.size());
        }
        ArrayList orderCountForMangVos = orderCount.stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<OrderCountForMangVo>(Comparator.comparing(o -> o.getHospitalId() + o.getDeptId()))), ArrayList::new));
        for (OrderCountForMangVo doctor : orderCountForMangVos) {
            List newOrderCount = orderCount.stream().filter(x -> x.getDeptId().equals(doctor.getDeptId())).collect(Collectors.toList());
            List newOrderDateCount = orderCount.stream().filter(x -> x.getDeptId().equals(doctor.getDeptId()) && x.getStartTime() != null).collect(Collectors.toList());
            List orderCountForMang = orderCount.stream().filter(x -> x.getDoctorName() != null && x.getStatus() != 65 && x.getDeptId().equals(doctor.getDeptId())).collect(Collectors.toList());
            List completeNewOrdersList = orderCount.stream().filter(x -> x.getStartTime() != null && x.getDeptId().equals(doctor.getDeptId()) && x.getSecondsCount() != null).collect(Collectors.toList());
            List completeOrdersList = orderCount.stream().filter(x -> (x.getStatus() == 7 || x.getStatus() == 8 || x.getStatus() == 9) && x.getStartTime() != null && x.getEndTime() != null && x.getDeptId().equals(doctor.getDeptId()) && x.getTestOrder() == null && x.getTestPatient() == null).collect(Collectors.toList());
            DocDeptDateRankingVO docDeptDateRankingVO = new DocDeptDateRankingVO();
            docDeptDateRankingVO.setDeptName(doctor.getDeptName()).setDeptId(doctor.getDeptId()).setDocName(doctor.getDoctorName()).setOrdersReceived(Integer.valueOf(newOrderCount.stream().filter(x -> (x.getStatus() == 2 || x.getStatus() == 7 || x.getStatus() == 8 || x.getStatus() == 9) && x.getStartTime() != null && x.getDeptId().equals(doctor.getDeptId())).collect(Collectors.toList()).size())).setNewOrderCount(Integer.valueOf(newOrderCount.size()));
            if (newOrderDateCount.size() == 0) {
                docDeptDateRankingVO.setAvgReceiveTime(Integer.valueOf(0));
            } else {
                docDeptDateRankingVO.setAvgReceiveTime(Integer.valueOf(completeNewOrdersList.stream().mapToInt(OrderCountForMangVo::getSecondsCount).sum() / 60 / newOrderDateCount.size()));
            }
            if (orderCountForMang.size() == 0) {
                docDeptDateRankingVO.setOrdersReceivedRate(Double.valueOf(0.0));
            } else {
                docDeptDateRankingVO.setOrdersReceivedRate(Double.valueOf((double)newOrderCount.stream().filter(x -> (x.getStatus() == 2 || x.getStatus() == 7 || x.getStatus() == 8 || x.getStatus() == 9) && x.getDeptId().equals(doctor.getDeptId())).collect(Collectors.toList()).size() / (double)newOrderCount.size()));
            }
            if (completeNewOrdersList.size() == 0) {
                docDeptDateRankingVO.setCompletionRate(Double.valueOf(0.0));
            } else {
                docDeptDateRankingVO.setCompletionRate(Double.valueOf((double)completeOrdersList.size() / (double)completeNewOrdersList.size()));
            }
            docDeptDateRankingVOList.add(docDeptDateRankingVO);
        }
        Map<String, List<DocDeptDateRankingVO>> collect = docDeptDateRankingVOList.stream().collect(Collectors.groupingBy(DocDeptDateRankingVO::getDeptId));
        for (String s : collect.keySet()) {
            DocDeptDateRankingVO docDeptDateRankingVO = new DocDeptDateRankingVO();
            docDeptDateRankingVO.setDeptName(((DocDeptDateRankingVO)collect.get(s).stream().filter(x -> x.getDeptName() != null).collect(Collectors.toList()).get(0)).getDeptName());
            if (collect.get(s).size() != 0) {
                docDeptDateRankingVO.setAvgReceiveTime(Integer.valueOf(collect.get(s).stream().mapToInt(DocDeptDateRankingVO::getAvgReceiveTime).sum() / collect.get(s).size())).setOrdersReceived(Integer.valueOf(collect.get(s).stream().mapToInt(DocDeptDateRankingVO::getOrdersReceived).sum() / collect.get(s).size())).setCompletionRate(Double.valueOf(collect.get(s).stream().mapToDouble(DocDeptDateRankingVO::getCompletionRate).sum() / (double)collect.get(s).size())).setOrdersReceivedRate(Double.valueOf(collect.get(s).stream().mapToDouble(DocDeptDateRankingVO::getOrdersReceivedRate).sum() / (double)collect.get(s).size())).setNewOrderCount(Integer.valueOf(collect.get(s).stream().mapToInt(DocDeptDateRankingVO::getNewOrderCount).sum() / collect.get(s).size()));
            } else {
                docDeptDateRankingVO.setAvgReceiveTime(Integer.valueOf(0)).setOrdersReceived(Integer.valueOf(0)).setCompletionRate(Double.valueOf(0.0)).setOrdersReceivedRate(Double.valueOf(0.0)).setNewOrderCount(Integer.valueOf(0));
            }
            docDeptDateRankingVOLists.add(docDeptDateRankingVO);
        }
        if (!Objects.isNull(orderListForCountReqVo.getSortType())) {
            if (ASC.equals(orderListForCountReqVo.getSortType())) {
                if (orderListForCountReqVo.getAvgReceiveTime() != null && !"".equals(orderListForCountReqVo.getAvgReceiveTime())) {
                    docDeptDateRankingVOListsort = docDeptDateRankingVOLists.stream().sorted(Comparator.comparing(DocDeptDateRankingVO::getAvgReceiveTime).reversed()).collect(Collectors.toList());
                }
                if (orderListForCountReqVo.getOrdersReceived() != null && !"".equals(orderListForCountReqVo.getOrdersReceived())) {
                    docDeptDateRankingVOListsort = docDeptDateRankingVOLists.stream().sorted(Comparator.comparing(DocDeptDateRankingVO::getOrdersReceived).reversed()).collect(Collectors.toList());
                }
                if (orderListForCountReqVo.getCompletionRate() != null && !"".equals(orderListForCountReqVo.getCompletionRate())) {
                    docDeptDateRankingVOListsort = docDeptDateRankingVOLists.stream().sorted(Comparator.comparing(DocDeptDateRankingVO::getCompletionRate).reversed()).collect(Collectors.toList());
                }
                if (orderListForCountReqVo.getNewOrderCount() != null && !"".equals(orderListForCountReqVo.getNewOrderCount())) {
                    docDeptDateRankingVOListsort = docDeptDateRankingVOLists.stream().sorted(Comparator.comparing(DocDeptDateRankingVO::getNewOrderCount).reversed()).collect(Collectors.toList());
                }
                if (orderListForCountReqVo.getOrdersReceivedRate() != null && !"".equals(orderListForCountReqVo.getOrdersReceivedRate())) {
                    docDeptDateRankingVOListsort = docDeptDateRankingVOLists.stream().sorted(Comparator.comparing(DocDeptDateRankingVO::getOrdersReceivedRate).reversed()).collect(Collectors.toList());
                }
            } else if (DESC.equals(orderListForCountReqVo.getSortType())) {
                if (orderListForCountReqVo.getAvgReceiveTime() != null && !"".equals(orderListForCountReqVo.getAvgReceiveTime())) {
                    docDeptDateRankingVOListsort = docDeptDateRankingVOLists.stream().sorted(Comparator.comparing(DocDeptDateRankingVO::getAvgReceiveTime)).collect(Collectors.toList());
                }
                if (orderListForCountReqVo.getOrdersReceived() != null && !"".equals(orderListForCountReqVo.getOrdersReceived())) {
                    docDeptDateRankingVOListsort = docDeptDateRankingVOLists.stream().sorted(Comparator.comparing(DocDeptDateRankingVO::getOrdersReceived)).collect(Collectors.toList());
                }
                if (orderListForCountReqVo.getCompletionRate() != null && !"".equals(orderListForCountReqVo.getCompletionRate())) {
                    docDeptDateRankingVOListsort = docDeptDateRankingVOLists.stream().sorted(Comparator.comparing(DocDeptDateRankingVO::getCompletionRate)).collect(Collectors.toList());
                }
                if (orderListForCountReqVo.getNewOrderCount() != null && !"".equals(orderListForCountReqVo.getNewOrderCount())) {
                    docDeptDateRankingVOListsort = docDeptDateRankingVOLists.stream().sorted(Comparator.comparing(DocDeptDateRankingVO::getNewOrderCount)).collect(Collectors.toList());
                }
                if (orderListForCountReqVo.getOrdersReceivedRate() != null && !"".equals(orderListForCountReqVo.getOrdersReceivedRate())) {
                    docDeptDateRankingVOListsort = docDeptDateRankingVOLists.stream().sorted(Comparator.comparing(DocDeptDateRankingVO::getOrdersReceivedRate)).collect(Collectors.toList());
                }
            }
        } else {
            docDeptDateRankingVOListsort = docDeptDateRankingVOLists.stream().sorted(Comparator.comparing(DocDeptDateRankingVO::getAvgReceiveTime).reversed()).collect(Collectors.toList());
        }
        docDeptDateRankingVOLists.forEach(x -> x.setCompletionRate(Double.valueOf(Double.parseDouble(String.format("%.1f", x.getCompletionRate() * 100.0)))));
        docDeptDateRankingVOLists.forEach(x -> x.setOrdersReceivedRate(Double.valueOf(Double.parseDouble(String.format("%.1f", x.getOrdersReceivedRate() * 100.0)))));
        docDeptDateRankingResVO.setDataType(Integer.valueOf(2)).setDocDeptDateRankingVOList(docDeptDateRankingVOListsort);
        return docDeptDateRankingResVO;
    }

    public void setNotReceive(DataDTO datum) {
        double v = (double)(datum.getPlace() - datum.getReceiving()) / (double)datum.getPlace().longValue() * 100.0;
        datum.setValue(String.format("%.1f", v) + "%");
        datum.setReceiving(Long.valueOf(datum.getPlace() - datum.getReceiving()));
    }

    public void exportExcel(HttpServletResponse response) {
        ServiceQualityDTO serviceQuality = this.getServiceQuality();
        if (ObjectUtils.isEmpty((Object)serviceQuality)) {
            log.info("\u5bfc\u51fa\u6570\u636e\u4e3a\u7a7a\uff0c\u9000\u51fa");
            return;
        }
        List deptData = serviceQuality.getDepartmentAll().getData();
        ArrayList exportDepartDtos = new ArrayList();
        deptData.forEach(dataDTO -> {
            ExportDepartDto exportDepartDto = new ExportDepartDto();
            exportDepartDto.setDeptName(dataDTO.getName());
            exportDepartDto.setReceiving(dataDTO.getReceiving().toString());
            exportDepartDto.setPlace(dataDTO.getPlace().toString());
            exportDepartDto.setValue(dataDTO.getValue());
            exportDepartDto.setNotReceiving(String.valueOf(dataDTO.getPlace() - dataDTO.getReceiving()));
            this.setNotReceive(dataDTO);
            exportDepartDto.setNotReceiving(dataDTO.getReceiving().toString());
            exportDepartDto.setNotPlace(dataDTO.getPlace().toString());
            exportDepartDto.setNotValue(dataDTO.getValue());
            exportDepartDtos.add(exportDepartDto);
        });
        List docData = serviceQuality.getDoctorAll().getData();
        ArrayList exportDotorDtos = new ArrayList();
        docData.forEach(doc -> {
            ExportDotorDto exportDotorDto = new ExportDotorDto();
            exportDotorDto.setDocName(doc.getName());
            exportDotorDto.setReceiving(doc.getReceiving().toString());
            exportDotorDto.setPlace(doc.getPlace().toString());
            exportDotorDto.setValue(doc.getValue());
            this.setNotReceive(doc);
            exportDotorDto.setNotReceiving(doc.getReceiving().toString());
            exportDotorDto.setNotPlace(doc.getPlace().toString());
            exportDotorDto.setNotValue(doc.getValue());
            exportDotorDtos.add(exportDotorDto);
        });
        ArrayList sheetsList = new ArrayList();
        this.addToSheetList(exportDepartDtos, ExportDepartDto.class, sheetsList, "\u79d1\u5ba4\u63a5\u8bca\u6570\u636e\u62a5\u8868");
        this.addToSheetList(exportDotorDtos, ExportDotorDto.class, sheetsList, "\u533b\u751f\u63a5\u8bca\u6570\u636e\u62a5\u8868");
        try {
            ExcelUtils.exportExcel(sheetsList, (String)"\u79d1\u5ba4\u533b\u751f\u63a5\u8bca\u6570\u636e\u62a5\u8868", (HttpServletResponse)response);
        }
        catch (IOException e) {
            log.error("\u5bfc\u51fa\u62a5\u9519", (Throwable)e);
        }
    }

    private void addToSheetList(List<?> list, Class<?> pojoClass, List<Map<String, Object>> sheetsList, String sheetName) {
        ExportParams deptParams = new ExportParams();
        deptParams.setSheetName(sheetName);
        HashMap<String, Object> deptMap = new HashMap<String, Object>();
        deptMap.put("title", deptParams);
        deptMap.put("entity", pojoClass);
        deptMap.put("data", list);
        sheetsList.add(deptMap);
    }
}

