/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.service.impl;

import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.CharsetUtil;
import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ebaiyihui.dto.CoreIndicatorsDTO;
import com.ebaiyihui.dto.PatientCardBindingDTO;
import com.ebaiyihui.dto.PatientComplaintDTO;
import com.ebaiyihui.dto.PatientEvaluationDTO;
import com.ebaiyihui.dto.PatientOrderDTO;
import com.ebaiyihui.dto.RegisterDTO;
import com.ebaiyihui.dto.UserVisitDTO;
import com.ebaiyihui.mapper.db2.OnlineOutpatientMapper;
import com.ebaiyihui.mapper.db4.UserCenterMapper;
import com.ebaiyihui.service.PatientService;
import java.nio.charset.Charset;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(rollbackFor={Exception.class})
public class PatientServiceImpl
implements PatientService {
    private static final Logger log = LoggerFactory.getLogger(PatientServiceImpl.class);
    @Value(value="${statistics.ip}")
    private String dev;
    @Value(value="${hospital.appCode}")
    private String appCode;
    @Value(value="${doctor-basedata.ip}")
    private String doctorBasedataIP;
    @Value(value="${doctor-usercenter.ip}")
    private String doctorUsercenterIP;
    @Autowired
    private UserCenterMapper userCenterMapper;
    @Autowired
    private OnlineOutpatientMapper onlineOutpatientMapper;

    public CoreIndicatorsDTO getCoreIndicators() {
        CoreIndicatorsDTO entity = new CoreIndicatorsDTO();
        DateTime dateTime = DateUtil.offsetDay((Date)new Date(), (int)0);
        DateTime dateTime1 = DateUtil.offsetDay((Date)new Date(), (int)-1);
        String lastDayStr = DateUtil.format((Date)dateTime, (String)"yyyy-MM-dd") + " 00:00:00";
        String lastDayStrURL = DateUtil.format((Date)dateTime1, (String)"yyyy-MM-dd");
        String lastDayStrURL1 = DateUtil.format((Date)dateTime, (String)"yyyy-MM-dd");
        dateTime = DateUtil.offsetDay((Date)new Date(), (int)-7);
        String lastWeekStr = DateUtil.format((Date)dateTime, (String)"yyyy-MM-dd") + " 00:00:00";
        String lastWeekStrURL = DateUtil.format((Date)dateTime, (String)"yyyy-MM-dd");
        dateTime = DateUtil.offsetDay((Date)new Date(), (int)-8);
        String lastWeekStrURL1 = DateUtil.format((Date)dateTime, (String)"yyyy-MM-dd");
        dateTime = DateUtil.offsetDay((Date)new Date(), (int)-30);
        String lastTwoWeekStr = DateUtil.format((Date)dateTime, (String)"yyyy-MM-dd") + " 00:00:00";
        String lastTwoWeekStrURL = DateUtil.format((Date)dateTime, (String)"yyyy-MM-dd");
        log.info("lastDayStr: {}", (Object)lastDayStr);
        log.info("lastTwoWeekStr: {}", (Object)lastTwoWeekStr);
        log.info("lastDayStrURL: {}", (Object)lastDayStrURL);
        log.info("lastDayStrURL1: {}", (Object)lastDayStrURL1);
        log.info("lastWeekStrURL: {}", (Object)lastWeekStrURL);
        log.info("lastWeekStrURL1: {}", (Object)lastWeekStrURL1);
        log.info("lastTwoWeekStrURL: {}", (Object)lastTwoWeekStrURL);
        ArrayList<String> weekNum = new ArrayList<String>();
        ArrayList<String> twoWeekNum = new ArrayList<String>();
        PatientEvaluationDTO dto = new PatientEvaluationDTO();
        dto.setAppCode(this.appCode);
        dto.setPageNum(Integer.valueOf(1));
        dto.setPageSize(Integer.valueOf(1));
        dto.setServCode("53110");
        dto.setStartTime(lastWeekStrURL);
        dto.setEndTime(lastDayStrURL);
        String json = JSON.toJSONString((Object)dto);
        String result2 = ((HttpRequest)HttpRequest.post((String)(this.doctorBasedataIP + "/patient/evaluation/listEvaluation")).contentType("application/json").header("Accept", "application/json")).body(json).execute().body();
        log.info("result2: {}", (Object)result2);
        JSONObject jsonObject2 = JSON.parseObject((String)result2);
        JSONObject dataObj = jsonObject2.getJSONObject("data");
        Long followAll = dataObj.getLong("totalNum");
        Long followStar = dataObj.getLong("goodNum");
        dto.setServCode("zxmz");
        String json2 = JSON.toJSONString((Object)dto);
        String result3 = ((HttpRequest)HttpRequest.post((String)(this.doctorBasedataIP + "/patient/evaluation/listEvaluation")).contentType("application/json").header("Accept", "application/json")).body(json2).execute().body();
        log.info("result3: {}", (Object)result3);
        JSONObject jsonObject3 = JSON.parseObject((String)result3);
        JSONObject dataObj1 = jsonObject3.getJSONObject("data");
        Long conAll = dataObj1.getLong("totalNum");
        Long conStar = dataObj1.getLong("goodNum");
        log.info("conStar: {}", (Object)conStar);
        log.info("followStar: {}", (Object)followStar);
        log.info("conAll: {}", (Object)conAll);
        log.info("followAll: {}", (Object)followAll);
        double v = (double)(conStar + followStar) / (double)(conAll + followAll) * 100.0;
        weekNum.add(String.valueOf((long)v));
        PatientEvaluationDTO dto1 = new PatientEvaluationDTO();
        dto1.setAppCode(this.appCode);
        dto1.setPageNum(Integer.valueOf(1));
        dto1.setPageSize(Integer.valueOf(1));
        dto1.setServCode("53110");
        dto1.setStartTime(lastTwoWeekStrURL);
        dto1.setEndTime(lastDayStrURL);
        String json3 = JSON.toJSONString((Object)dto1);
        String result4 = ((HttpRequest)HttpRequest.post((String)(this.doctorBasedataIP + "/patient/evaluation/listEvaluation")).contentType("application/json").header("Accept", "application/json")).body(json3).execute().body();
        log.info("result4: {}", (Object)result4);
        JSONObject jsonObject4 = JSON.parseObject((String)result4);
        JSONObject dataObj4 = jsonObject4.getJSONObject("data");
        Long followTwoAll = dataObj4.getLong("totalNum");
        Long followStarTwo = dataObj4.getLong("goodNum");
        dto1.setServCode("zxmz");
        String json4 = JSON.toJSONString((Object)dto1);
        String result5 = ((HttpRequest)HttpRequest.post((String)(this.doctorBasedataIP + "/patient/evaluation/listEvaluation")).contentType("application/json").header("Accept", "application/json")).body(json4).execute().body();
        log.info("result5: {}", (Object)result5);
        JSONObject jsonObject5 = JSON.parseObject((String)result5);
        JSONObject dataObj5 = jsonObject5.getJSONObject("data");
        Long conTwoAll = dataObj5.getLong("totalNum");
        Long conStarTwo = dataObj5.getLong("goodNum");
        log.info("conStarTwo: {}", (Object)conStarTwo);
        log.info("followStarTwo: {}", (Object)followStarTwo);
        log.info("conTwoAll: {}", (Object)conTwoAll);
        log.info("followTwoAll: {}", (Object)followTwoAll);
        double v1 = (double)(conStarTwo + followStarTwo) / (double)(conTwoAll + followTwoAll) * 100.0;
        twoWeekNum.add(new DecimalFormat("#").format(Math.abs(v1)).toString());
        String visitorsUrl = this.dev + "app/operation/log/getappuv?appCode=" + this.appCode + "&endTime=" + lastDayStrURL + "&startTime=" + lastWeekStrURL;
        String visitorsResult = HttpUtil.get((String)visitorsUrl, (Charset)CharsetUtil.CHARSET_UTF_8);
        JSONObject visitorsJsonObject = JSON.parseObject((String)visitorsResult);
        String visitorsData = visitorsJsonObject.get((Object)"data").toString();
        String visitorsCount = JSON.parseObject((String)visitorsData).get((Object)"data").toString();
        log.info("visitorsCount: {}", (Object)visitorsCount);
        long lastUserCount = this.userCenterMapper.selectCountUser(lastDayStr, lastWeekStr);
        log.info("lastUserCount: {}", (Object)lastUserCount);
        double v2 = (double)lastUserCount / (double)Long.parseLong(visitorsCount) * 100.0;
        String visitorsUrl1 = this.dev + "app/operation/log/getappuv?appCode=" + this.appCode + "&endTime=" + lastDayStrURL + "&startTime=" + lastTwoWeekStrURL;
        String visitorsResult1 = HttpUtil.get((String)visitorsUrl1, (Charset)CharsetUtil.CHARSET_UTF_8);
        JSONObject visitorsJsonObject1 = JSON.parseObject((String)visitorsResult1);
        String visitorsData1 = visitorsJsonObject1.get((Object)"data").toString();
        String visitorsCount1 = JSON.parseObject((String)visitorsData1).get((Object)"data").toString();
        log.info("visitorsCount1: {}", (Object)visitorsCount1);
        long lastUserCount1 = this.userCenterMapper.selectCountUser(lastDayStr, lastTwoWeekStr);
        log.info("lastUserCount1: {}", (Object)lastUserCount1);
        double v3 = (double)lastUserCount1 / (double)Long.parseLong(visitorsCount1) * 100.0;
        long lastCarCount = this.userCenterMapper.selectCountUserCar(lastDayStr, lastWeekStr);
        log.info("lastCarCount: {}", (Object)lastCarCount);
        double v4 = (double)lastCarCount / (double)lastUserCount * 100.0;
        weekNum.add(String.valueOf((long)v4));
        long lastCarTwoCount = this.userCenterMapper.selectCountUserCar(lastDayStr, lastTwoWeekStr);
        log.info("lastCarTwoCount: {}", (Object)lastCarTwoCount);
        double v5 = (double)lastCarTwoCount / (double)lastUserCount1 * 100.0;
        twoWeekNum.add(new DecimalFormat("#").format(Math.abs(v5)).toString());
        weekNum.add("0");
        twoWeekNum.add("0");
        String followUrl = this.dev + "api/v1/data/operation/log/getFollowUp?startTime=" + lastWeekStrURL + "&endTime=" + lastDayStrURL1 + "&appCode=" + this.appCode;
        String followResult = HttpUtil.get((String)followUrl, (Charset)CharsetUtil.CHARSET_UTF_8);
        JSONObject followJsonObject = JSON.parseObject((String)followResult);
        String followData = followJsonObject.get((Object)"data").toString();
        String followCount = JSON.parseObject((String)followData).get((Object)"count").toString();
        log.info("followCount: {}", (Object)followCount);
        long count = this.onlineOutpatientMapper.getFollowUserCount(lastWeekStr, lastDayStr);
        log.info("count: {}", (Object)count);
        double v6 = (double)count / (double)Long.parseLong(followCount) * 100.0;
        weekNum.add(new DecimalFormat("#").format(Math.abs(v6)).toString());
        String followUrl1 = this.dev + "api/v1/data/operation/log/getFollowUp?startTime=" + lastTwoWeekStrURL + "&endTime=" + lastDayStrURL1 + "&appCode=" + this.appCode;
        String followResult1 = HttpUtil.get((String)followUrl1, (Charset)CharsetUtil.CHARSET_UTF_8);
        JSONObject followJsonObject1 = JSON.parseObject((String)followResult1);
        String followData1 = followJsonObject1.get((Object)"data").toString();
        String followCount1 = JSON.parseObject((String)followData1).get((Object)"count").toString();
        log.info("followCount1: {}", (Object)followCount1);
        long count1 = this.onlineOutpatientMapper.getFollowUserCount(lastTwoWeekStr, lastDayStr);
        log.info("count1: {}", (Object)count1);
        double v7 = (double)count1 / (double)Long.parseLong(followCount1) * 100.0;
        twoWeekNum.add(new DecimalFormat("#").format(Math.abs(v7)).toString());
        weekNum.add(String.valueOf((long)v2));
        twoWeekNum.add(new DecimalFormat("#").format(Math.abs(v3)).toString());
        ArrayList<ArrayList<String>> chartData = new ArrayList<ArrayList<String>>();
        chartData.add(weekNum);
        chartData.add(twoWeekNum);
        entity.setChartData(chartData);
        RegisterDTO register = new RegisterDTO();
        dateTime = DateUtil.offsetDay((Date)new Date(), (int)-14);
        String weekStr = DateUtil.format((Date)dateTime, (String)"yyyy-MM-dd");
        log.info("weekCount: {}", (Object)weekStr);
        long weekCount = this.userCenterMapper.selectCountUser(lastWeekStrURL, weekStr);
        log.info("weekCount: {}", (Object)weekCount);
        register.setCount(Long.valueOf(lastUserCount));
        double huanbi = (double)(lastUserCount - weekCount) / (double)weekCount * 100.0;
        if (huanbi < 0.0) {
            register.setTrend("DOWN");
            register.setTrendRate(Math.abs((long)huanbi) + "%");
        } else if (huanbi > 0.0) {
            register.setTrend("UP");
            register.setTrendRate((long)huanbi + "%");
        } else {
            register.setTrend("FLAT");
            register.setTrendRate("0%");
        }
        entity.setRegister(register);
        entity.setCardBindRate((long)((double)lastCarCount / (double)lastUserCount * 100.0) + "%");
        entity.setOrderRate(Objects.equals(followCount, "0") ? "0%" : (long)((double)count / (double)Long.parseLong(followCount) * 100.0) + "%");
        PatientEvaluationDTO dto2 = new PatientEvaluationDTO();
        dto2.setAppCode(this.appCode);
        dto2.setPageNum(Integer.valueOf(1));
        dto2.setPageSize(Integer.valueOf(1));
        dto2.setServCode("53110");
        String json5 = JSON.toJSONString((Object)dto2);
        String result6 = ((HttpRequest)HttpRequest.post((String)(this.doctorBasedataIP + "/patient/evaluation/listEvaluation")).contentType("application/json").header("Accept", "application/json")).body(json5).execute().body();
        log.info("result6: {}", (Object)result6);
        JSONObject jsonObject6 = JSON.parseObject((String)result6);
        JSONObject dataObj6 = jsonObject6.getJSONObject("data");
        Long totalNum = dataObj6.getLong("totalNum");
        Long goodNum = dataObj6.getLong("goodNum");
        dto2.setServCode("zxmz");
        String json6 = JSON.toJSONString((Object)dto2);
        String result7 = ((HttpRequest)HttpRequest.post((String)(this.doctorBasedataIP + "/patient/evaluation/listEvaluation")).contentType("application/json").header("Accept", "application/json")).body(json6).execute().body();
        log.info("result7: {}", (Object)result7);
        JSONObject jsonObject7 = JSON.parseObject((String)result7);
        JSONObject dataObj7 = jsonObject7.getJSONObject("data");
        Long totalNum1 = dataObj7.getLong("totalNum");
        Long goodNum1 = dataObj7.getLong("goodNum");
        log.info("totalNum: {}", (Object)totalNum);
        log.info("goodNum: {}", (Object)goodNum);
        log.info("totalNum1: {}", (Object)totalNum1);
        log.info("goodNum1: {}", (Object)goodNum1);
        double v8 = (double)(goodNum + goodNum1) / (double)(totalNum + totalNum1) * 100.0;
        entity.setFavorableRate(Math.round(v8) + "%");
        entity.setComplaintRate("0%");
        return entity;
    }

    public UserVisitDTO getUserVisit() {
        UserVisitDTO entity = new UserVisitDTO();
        DateTime dateTime = DateUtil.offsetDay((Date)new Date(), (int)-1);
        String lastDayStr = DateUtil.format((Date)dateTime, (String)"yyyy-MM-dd");
        dateTime = DateUtil.offsetDay((Date)new Date(), (int)-7);
        String lastWeekStr = DateUtil.format((Date)dateTime, (String)"yyyy-MM-dd");
        dateTime = DateUtil.offsetDay((Date)new Date(), (int)-8);
        String lastWeekStr1 = DateUtil.format((Date)dateTime, (String)"yyyy-MM-dd");
        dateTime = DateUtil.offsetDay((Date)new Date(), (int)-14);
        String lastTwoWeekStr = DateUtil.format((Date)dateTime, (String)"yyyy-MM-dd");
        String visitorsUrl = this.dev + "app/operation/log/getappuv?appCode=" + this.appCode + "&endTime=" + lastDayStr + "&startTime=" + lastWeekStr;
        String visitorsResult = HttpUtil.get((String)visitorsUrl, (Charset)CharsetUtil.CHARSET_UTF_8);
        JSONObject visitorsJsonObject = JSON.parseObject((String)visitorsResult);
        String visitorsData = visitorsJsonObject.get((Object)"data").toString();
        String visitorsCount = JSON.parseObject((String)visitorsData).get((Object)"data").toString();
        log.info("visitorsCount: {}", (Object)visitorsCount);
        String visitorsUrl1 = this.dev + "app/operation/log/getappuv?appCode=" + this.appCode + "&endTime=" + lastWeekStr1 + "&startTime=" + lastTwoWeekStr;
        String visitorsResult1 = HttpUtil.get((String)visitorsUrl1, (Charset)CharsetUtil.CHARSET_UTF_8);
        JSONObject visitorsJsonObject1 = JSON.parseObject((String)visitorsResult1);
        String visitorsData1 = visitorsJsonObject1.get((Object)"data").toString();
        String visitorsCount1 = JSON.parseObject((String)visitorsData1).get((Object)"data").toString();
        log.info("visitorsCount1: {}", (Object)visitorsCount1);
        entity.setCount(Long.valueOf(Long.parseLong(visitorsCount)));
        double huanbi = (Double.parseDouble(visitorsCount) - Double.parseDouble(visitorsCount1)) / Double.parseDouble(visitorsCount1) * 100.0;
        log.info("huanbi: {}", (Object)huanbi);
        if (huanbi < 0.0) {
            entity.setRate(Math.round(huanbi) + "%");
            entity.setAnalysisText("\u6570\u636e\u8868\u793a\u8fd17\u65e5\u589e\u957f\u4e0d\u7406\u60f3\uff0c\u5efa\u8bae\u52a0\u5927\u5ba3\u4f20\u529b\u5ea6\u3002");
        } else if (huanbi > 0.0) {
            entity.setRate(Math.round(huanbi) + "%");
            entity.setAnalysisText("\u6570\u636e\u8868\u793a\u8fd17\u65e5\u589e\u957f\u7406\u60f3\uff0c\u5efa\u8bae\u7ee7\u7eed\u4fdd\u6301\u3002");
        } else {
            entity.setRate(Math.round(huanbi) + "%");
            if (0L == Long.parseLong(visitorsCount)) {
                entity.setAnalysisText("\u6570\u636e\u8868\u793a\u7ed3\u679c\u975e\u5e38\u4e0d\u7406\u60f3\uff0c\u5efa\u8bae\u4ece\u5ba3\u4f20\u63a8\u5e7f\u3001\u5f00\u653e\u79d1\u5ba4/\u836f\u54c1\u3001\u7279\u8272\u670d\u52a1\u7b49\u591a\u65b9\u9762\u8fdb\u884c\u4f18\u5316\u3002");
            } else {
                entity.setAnalysisText("\u6570\u636e\u8868\u793a\u8fd17\u65e5\u6ce2\u52a8\u4e0d\u5927\uff0c\u7a33\u5b9a\u589e\u52a0\u3002");
            }
        }
        return entity;
    }

    public PatientCardBindingDTO getPatientCardBinding() {
        PatientCardBindingDTO entity = new PatientCardBindingDTO();
        DateTime dateTime = DateUtil.offsetDay((Date)new Date(), (int)0);
        String lastDayStr = DateUtil.format((Date)dateTime, (String)"yyyy-MM-dd") + " 00:00:00";
        dateTime = DateUtil.offsetDay((Date)new Date(), (int)-7);
        String lastWeekStr = DateUtil.format((Date)dateTime, (String)"yyyy-MM-dd") + " 00:00:00";
        dateTime = DateUtil.offsetDay((Date)new Date(), (int)-14);
        String lastTwoWeekStr = DateUtil.format((Date)dateTime, (String)"yyyy-MM-dd") + " 00:00:00";
        long lastCarCount = this.userCenterMapper.selectCountCar(lastDayStr, lastWeekStr);
        log.info("lastCarCount: {}", (Object)lastCarCount);
        long lastCarTwoCount = this.userCenterMapper.selectCountCar(lastWeekStr, lastTwoWeekStr);
        log.info("lastCarTwoCount: {}", (Object)lastCarTwoCount);
        entity.setCount(Long.valueOf(lastCarCount));
        double huanbi = ((double)lastCarCount - (double)lastCarTwoCount) / (double)lastCarTwoCount * 100.0;
        if (huanbi < 0.0) {
            entity.setRate(Math.round(huanbi) + "%");
            entity.setAnalysisText("\u6570\u636e\u8868\u793a\u8fd17\u65e5\u589e\u957f\u4e0d\u7406\u60f3\uff0c\u5efa\u8bae\u591a\u63a8\u5e7f\u7279\u8272\u670d\u52a1\u3002");
        } else if (huanbi > 0.0) {
            entity.setRate(Math.round(huanbi) + "%");
            entity.setAnalysisText("\u6570\u636e\u8868\u793a\u8fd17\u65e5\u589e\u957f\u7406\u60f3\uff0c\u5efa\u8bae\u7ee7\u7eed\u4fdd\u6301\u3002");
        } else {
            entity.setRate(Math.round(huanbi) + "%");
            if (0L == lastCarCount) {
                entity.setAnalysisText("\u6570\u636e\u8868\u793a\u7ed3\u679c\u975e\u5e38\u4e0d\u7406\u60f3\uff0c\u5efa\u8bae\u4ece\u5ba3\u4f20\u63a8\u5e7f\u3001\u5f00\u653e\u7279\u8272\u670d\u52a1\u7b49\u591a\u65b9\u9762\u8fdb\u884c\u4f18\u5316\u3002");
            } else {
                entity.setAnalysisText("\u6570\u636e\u8868\u793a\u8fd17\u65e5\u6ce2\u52a8\u4e0d\u5927\uff0c\u7a33\u5b9a\u589e\u52a0\u3002");
            }
        }
        return entity;
    }

    public PatientOrderDTO getPatientOrder() {
        PatientOrderDTO entity = new PatientOrderDTO();
        DateTime dateTime = DateUtil.offsetDay((Date)new Date(), (int)0);
        String lastDayStr = DateUtil.format((Date)dateTime, (String)"yyyy-MM-dd") + " 00:00:00";
        dateTime = DateUtil.offsetDay((Date)new Date(), (int)-7);
        String lastWeekStr = DateUtil.format((Date)dateTime, (String)"yyyy-MM-dd") + " 00:00:00";
        dateTime = DateUtil.offsetDay((Date)new Date(), (int)-14);
        String lastTwoWeekStr = DateUtil.format((Date)dateTime, (String)"yyyy-MM-dd") + " 00:00:00";
        long count = this.onlineOutpatientMapper.getFollowUserCount(lastWeekStr, lastDayStr);
        log.info("count: {}", (Object)count);
        long count1 = this.onlineOutpatientMapper.getFollowUserCount(lastTwoWeekStr, lastWeekStr);
        log.info("count1: {}", (Object)count1);
        long count2 = this.onlineOutpatientMapper.getZxUserCount(lastWeekStr, lastDayStr);
        log.info("count2: {}", (Object)count2);
        long count3 = this.onlineOutpatientMapper.getZxUserCount(lastTwoWeekStr, lastWeekStr);
        log.info("count3: {}", (Object)count3);
        entity.setCount(Long.valueOf(count + count2));
        double huanbi = ((double)(count + count2) - (double)(count1 + count3)) / (double)(count1 + count3) * 100.0;
        if (huanbi < 0.0) {
            entity.setRate(Math.round(huanbi) + "%");
            entity.setAnalysisText("\u6570\u636e\u8868\u793a\u8fd17\u65e5\u589e\u957f\u4e0d\u7406\u60f3\uff0c\u5efa\u8bae\u5f00\u653e\u66f4\u591a\u79d1\u5ba4\u4e0e\u533b\u751f\uff0c\u4e3a\u60a3\u8005\u63d0\u4f9b\u66f4\u591a\u9009\u62e9\u3002");
        } else if (huanbi > 0.0) {
            entity.setRate(Math.round(huanbi) + "%");
            entity.setAnalysisText("\u6570\u636e\u8868\u793a\u8fd17\u65e5\u589e\u957f\u7406\u60f3\uff0c\u5efa\u8bae\u7ee7\u7eed\u4fdd\u6301\u3002");
        } else {
            entity.setRate(Math.round(huanbi) + "%");
            if (0L == count + count2) {
                entity.setAnalysisText("\u6570\u636e\u8868\u793a\u7ed3\u679c\u975e\u5e38\u4e0d\u7406\u60f3\uff0c\u5efa\u8bae\u4ece\u5ba3\u4f20\u63a8\u5e7f\u3001\u5f00\u653e\u79d1\u5ba4/\u836f\u54c1\u7b49\u591a\u65b9\u9762\u8fdb\u884c\u4f18\u5316\u3002");
            } else {
                entity.setAnalysisText("\u6570\u636e\u8868\u793a\u8fd17\u65e5\u6ce2\u52a8\u4e0d\u5927\uff0c\u7a33\u5b9a\u589e\u52a0\u3002");
            }
        }
        return entity;
    }

    public PatientComplaintDTO getPatientComplaint() {
        PatientComplaintDTO entity = new PatientComplaintDTO();
        entity.setCount(Long.valueOf(0L));
        entity.setRate("0%");
        entity.setAnalysisText("");
        return entity;
    }
}

