/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.service.impl;

import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.CharsetUtil;
import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ebaiyihui.dto.RatioDTO;
import com.ebaiyihui.dto.TrafficViewDTO;
import com.ebaiyihui.dto.TrafficViewRatioDTO;
import com.ebaiyihui.mapper.db1.WisdomMedicalMapper;
import com.ebaiyihui.mapper.db2.OnlineOutpatientMapper;
import com.ebaiyihui.mapper.db3.PrescriptionCirculationMapper;
import com.ebaiyihui.mapper.db4.UserCenterMapper;
import com.ebaiyihui.service.TrafficViewService;
import java.nio.charset.Charset;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(rollbackFor={Exception.class})
public class TrafficViewServiceImpl
implements TrafficViewService {
    private static final Logger log = LoggerFactory.getLogger(TrafficViewServiceImpl.class);
    private static final String YYYY_MM_DD = "yyyy-MM-dd";
    private static final String UP = "UP";
    private static final String DOWN = "DOWN";
    private static final String FLAT = "FLAT";
    @Value(value="${statistics.ip}")
    private String dev;
    @Autowired
    private WisdomMedicalMapper wisdomMedicalMapper;
    @Autowired
    private OnlineOutpatientMapper onlineOutpatientMapper;
    @Autowired
    private PrescriptionCirculationMapper prescriptionCirculationMapper;
    @Autowired
    private UserCenterMapper userCenterMapper;

    public TrafficViewDTO getTrafficView(String appCode) {
        TrafficViewDTO trafficViewDTO = new TrafficViewDTO();
        DateTime nowDateTime = DateUtil.offsetDay((Date)new Date(), (int)1);
        String nowMonStr = DateUtil.format((Date)nowDateTime, (String)YYYY_MM_DD);
        DateTime lastDateTime = DateUtil.offsetMonth((Date)new Date(), (int)-1);
        String lastMonStr = DateUtil.format((Date)lastDateTime, (String)YYYY_MM_DD);
        DateTime lastTwoDateTime = DateUtil.offsetMonth((Date)new Date(), (int)-2);
        String lastTwoMonStr = DateUtil.format((Date)lastTwoDateTime, (String)YYYY_MM_DD);
        log.info("TrafficViewServiceImpl 0: {}", (Object)DateUtil.now());
        String lastUrl = this.dev + "api/v1/data/operation/log/getHomePageMonth?appCode=" + appCode;
        log.info("lastUrl:, {}", (Object)lastUrl);
        String lastResult = HttpUtil.get((String)lastUrl, (Charset)CharsetUtil.CHARSET_UTF_8);
        JSONObject lastJsonObject = JSON.parseObject((String)lastResult);
        String lastData = lastJsonObject.get((Object)"data").toString();
        String lastVisCount = JSON.parseObject((String)lastData).get((Object)"count").toString();
        String lastTwoUrl = this.dev + "api/v1/data/operation/log/getHomePageTwoMonth?appCode=" + appCode;
        String lastTwoResult = HttpUtil.get((String)lastTwoUrl, (Charset)CharsetUtil.CHARSET_UTF_8);
        JSONObject lastTwoJsonObject = JSON.parseObject((String)lastTwoResult);
        String lastTwoData = lastTwoJsonObject.get((Object)"data").toString();
        String lastTwoVisCount = JSON.parseObject((String)lastTwoData).get((Object)"count").toString();
        log.info("TrafficViewServiceImpl 1: {}", (Object)DateUtil.now());
        long lastUserCount = this.userCenterMapper.selectCountUser(nowMonStr, lastMonStr);
        long lastTwoUserCount = this.userCenterMapper.selectCountUser(lastMonStr, lastTwoMonStr);
        log.info("TrafficViewServiceImpl 2: {}", (Object)DateUtil.now());
        long lastCarCount = this.userCenterMapper.selectCountCar(nowMonStr, lastMonStr);
        long lastTwoCarCount = this.userCenterMapper.selectCountCar(lastMonStr, lastTwoMonStr);
        log.info("TrafficViewServiceImpl 3: {}", (Object)DateUtil.now());
        long lastOrderCount = this.onlineOutpatientMapper.getLastTotalOrderCountTra(appCode, nowMonStr, lastMonStr);
        long lastTwoOrderCount = this.onlineOutpatientMapper.getLastTotalOrderCountTra(appCode, lastMonStr, lastTwoMonStr);
        log.info("TrafficViewServiceImpl 4: {}", (Object)DateUtil.now());
        long lastCirculationCount = this.prescriptionCirculationMapper.getCirculationTra(nowMonStr, lastMonStr);
        long lastTwoCirculationCount = this.prescriptionCirculationMapper.getCirculationTra(lastMonStr, lastTwoMonStr);
        log.info("TrafficViewServiceImpl 5: {}", (Object)DateUtil.now());
        ArrayList<Long> currentMonthData = new ArrayList<Long>();
        currentMonthData.add(Long.parseLong(lastVisCount));
        currentMonthData.add(lastUserCount);
        currentMonthData.add(lastCarCount);
        currentMonthData.add(lastOrderCount);
        currentMonthData.add(lastCirculationCount);
        trafficViewDTO.setCurrentMonthData(currentMonthData);
        ArrayList<Long> lastMonthData = new ArrayList<Long>();
        lastMonthData.add(Long.parseLong(lastTwoVisCount));
        lastMonthData.add(lastTwoUserCount);
        lastMonthData.add(lastTwoCarCount);
        lastMonthData.add(lastTwoOrderCount);
        lastMonthData.add(lastTwoCirculationCount);
        trafficViewDTO.setLastMonthData(lastMonthData);
        NumberFormat numberformat = NumberFormat.getInstance();
        numberformat.setMaximumFractionDigits(1);
        ArrayList<RatioDTO> ratio = new ArrayList<RatioDTO>();
        RatioDTO visRatioDTO = new RatioDTO();
        String visPer = numberformat.format(this.getPer(Long.parseLong(lastVisCount), Long.parseLong(lastTwoVisCount)) * 100.0f);
        visRatioDTO.setPercent(visPer + "%");
        visRatioDTO.setType(this.getType(Long.parseLong(lastVisCount), Long.parseLong(lastTwoVisCount)));
        ratio.add(visRatioDTO);
        RatioDTO userRatioDTO = new RatioDTO();
        String userPer = numberformat.format(this.getPer(lastUserCount, lastTwoUserCount) * 100.0f);
        userRatioDTO.setPercent(userPer + "%");
        userRatioDTO.setType(this.getType(lastUserCount, lastTwoUserCount));
        ratio.add(userRatioDTO);
        RatioDTO carRatioDTO = new RatioDTO();
        String carPer = numberformat.format(this.getPer(lastCarCount, lastTwoCarCount) * 100.0f);
        carRatioDTO.setPercent(carPer + "%");
        carRatioDTO.setType(this.getType(lastCarCount, lastTwoCarCount));
        ratio.add(carRatioDTO);
        RatioDTO orderRatioDTO = new RatioDTO();
        String orderPer = numberformat.format(this.getPer(lastOrderCount, lastTwoOrderCount) * 100.0f);
        orderRatioDTO.setPercent(orderPer + "%");
        orderRatioDTO.setType(this.getType(lastOrderCount, lastTwoOrderCount));
        ratio.add(orderRatioDTO);
        RatioDTO circulationRatioDTO = new RatioDTO();
        String circulationPer = numberformat.format(this.getPer(lastCirculationCount, lastTwoCirculationCount) * 100.0f);
        log.info("getTrafficViewCirculationPer={}", (Object)circulationPer);
        circulationRatioDTO.setPercent(circulationPer + "%");
        circulationRatioDTO.setType(this.getType(lastCirculationCount, lastTwoCirculationCount));
        ratio.add(circulationRatioDTO);
        trafficViewDTO.setRatio(ratio);
        return trafficViewDTO;
    }

    public TrafficViewRatioDTO getTrafficViewRatio(String appCode) {
        TrafficViewRatioDTO trafficViewDTO = new TrafficViewRatioDTO();
        DateTime nowDateTime = DateUtil.offsetDay((Date)new Date(), (int)1);
        String nowMonStr = DateUtil.format((Date)nowDateTime, (String)YYYY_MM_DD);
        DateTime lastDateTime = DateUtil.offsetMonth((Date)new Date(), (int)-1);
        String lastMonStr = DateUtil.format((Date)lastDateTime, (String)YYYY_MM_DD);
        DateTime lastTwoDateTime = DateUtil.offsetMonth((Date)new Date(), (int)-2);
        String lastTwoMonStr = DateUtil.format((Date)lastTwoDateTime, (String)YYYY_MM_DD);
        log.info("TrafficViewServiceImpl 0: {}", (Object)DateUtil.now());
        long addUserCount = this.userCenterMapper.getAddUserCount(appCode);
        long allCarCount = this.userCenterMapper.getAllCarCount();
        log.info("TrafficViewServiceImpl 6: {}", (Object)DateUtil.now());
        long receiveCount = this.onlineOutpatientMapper.getReceiveCount(appCode, nowMonStr, lastMonStr);
        log.info("TrafficViewServiceImpl 7: {}", (Object)DateUtil.now());
        long paymentCount = this.prescriptionCirculationMapper.getPaymentCount(nowMonStr, lastMonStr);
        log.info("TrafficViewServiceImpl 8: {}", (Object)DateUtil.now());
        NumberFormat numberformat = NumberFormat.getInstance();
        numberformat.setMaximumFractionDigits(1);
        String bindPer = numberformat.format(addUserCount == 0L ? 0.0 : (double)((float)allCarCount / (float)addUserCount * 100.0f));
        trafficViewDTO.setBindCardPercent(bindPer + "%");
        long lastOrderCount = this.onlineOutpatientMapper.getLastTotalOrderCountTra(appCode, nowMonStr, lastMonStr);
        String followupPer = numberformat.format(lastOrderCount == 0L ? 0.0 : (double)((float)receiveCount / (float)lastOrderCount * 100.0f));
        trafficViewDTO.setFollowupCompletePercent(followupPer + "%");
        long lastCirculationCount = this.prescriptionCirculationMapper.getCirculationTra(nowMonStr, lastMonStr);
        String lastCirculationPer = numberformat.format(lastCirculationCount == 0L ? 0.0 : (double)((float)paymentCount / (float)lastCirculationCount * 100.0f));
        trafficViewDTO.setPrescribePayPercent(lastCirculationPer + "%");
        return trafficViewDTO;
    }

    private float getPer(long num1, long num2) {
        float v = num2 == 0L ? 0.0f : (float)(num1 - num2) / (float)num2;
        return Math.abs(v);
    }

    private String getType(long num1, long num2) {
        if (num1 == num2) {
            return FLAT;
        }
        if (num1 > num2) {
            return UP;
        }
        return DOWN;
    }
}

