/*
 * Decompiled with CFR 0.152.
 */
package com.byh.hs.api.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.byh.hs.api.util.CommonUtil;
import com.byh.hs.api.util.encryption.FuncRetCode;
import com.byh.hs.api.util.encryption.SM2Util;
import com.byh.hs.api.util.encryption.SM4Util;
import com.byh.hs.api.util.encryption.ServerException;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import java.util.Map;
import java.util.Objects;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.bouncycastle.pqc.math.linearalgebra.ByteUtils;
import sun.misc.BASE64Decoder;

public class DataHandler {
    private static volatile DataHandler INSTANCE;
    private final byte[] encryptKeys;
    private final String publicKeys;
    private final String privateKeys;
    private final String appID;
    private final String secret;
    private String version = "2.0.0";
    private boolean skipVerify = false;
    BASE64Decoder decoder = new BASE64Decoder();
    SM2Util sm2 = new SM2Util();
    private static final Log LOG;

    private DataHandler(String appID, String secret, String publicKey, String privateKey) throws IOException {
        this.appID = appID;
        this.secret = secret;
        this.encryptKeys = SM4Util.encryptEcb(CommonUtil.stringToHexString(appID.substring(0, 16)), secret).substring(0, 16).toUpperCase().getBytes();
        this.publicKeys = CommonUtil.byteArrayToHex(this.decoder.decodeBuffer(publicKey));
        this.privateKeys = CommonUtil.byteArrayToHex(this.decoder.decodeBuffer(privateKey));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static DataHandler newInstance(String appID, String secret, String publicKey, String privateKey) throws IOException {
        if (INSTANCE != null) return INSTANCE;
        Class<DataHandler> var4 = DataHandler.class;
        Class<DataHandler> clazz = DataHandler.class;
        synchronized (DataHandler.class) {
            if (INSTANCE != null) return INSTANCE;
            INSTANCE = new DataHandler(appID, secret, publicKey, privateKey);
            // ** MonitorExit[var5_5] (shouldn't be in output)
            return INSTANCE;
        }
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public void setSkipVerify(boolean skipVerify) {
        this.skipVerify = skipVerify;
    }

    public String buildReqData(JSONObject objData) throws Exception {
        TreeMap<String, Object> map = new TreeMap<String, Object>();
        for (Map.Entry entry : objData.entrySet()) {
            map.put((String)entry.getKey(), entry.getValue());
        }
        String reqData = this.buildReqData(map);
        return reqData;
    }

    public String buildReqData(Object objData) throws Exception {
        SortedMap<String, Object> map = CommonUtil.objectToMap(objData);
        LOG.debug((Object)("buildReqData\u53c2\u6570\u8f6c\u6362map\u7ed3\u679c\uff1a" + map));
        String reqData = this.buildReqData(map);
        return reqData;
    }

    public String buildReqData(Map<String, Object> mapData) throws Exception {
        String str = JSON.toJSONString(mapData);
        org.json.JSONObject jsonObject = new org.json.JSONObject(str);
        String jsonStr = CommonUtil.valueToString(jsonObject);
        JSONObject dataMap = JSON.parseObject((String)jsonStr);
        TreeMap<String, Object> treeMap = new TreeMap<String, Object>();
        treeMap.put("version", this.version);
        treeMap.put("encType", "SM4");
        treeMap.put("signType", "SM2");
        treeMap.put("appId", this.appID);
        treeMap.put("timestamp", new Date().getTime());
        treeMap.put("extra", null);
        treeMap.put("data", JSON.toJSON((Object)dataMap));
        String signStr = CommonUtil.getSignStr(this.secret, treeMap);
        LOG.info((Object)("signStr:" + signStr));
        String signData = this.sm2.sign(signStr, this.privateKeys);
        LOG.info((Object)("\u7b7e\u540d\u7ed3\u679c\uff1a" + signData));
        byte[] dataBytes = treeMap.get("data").toString().getBytes(StandardCharsets.UTF_8);
        byte[] encDataBytes = SM4Util.encrypt_Ecb_Padding(this.encryptKeys, dataBytes);
        String encData = ByteUtils.toHexString((byte[])encDataBytes);
        treeMap.put("encData", encData);
        LOG.info((Object)("\u52a0\u5bc6\u7ed3\u679c\uff1a" + encData));
        treeMap.keySet().removeIf(key -> Objects.equals(key, "data"));
        treeMap.put("signData", signData);
        return JSON.toJSONString(treeMap);
    }

    public String processRspData(String rspData) throws Exception {
        Map treeMap = (Map)JSON.parseObject((String)rspData, (TypeReference)new TypeReference<Map<String, Object>>(){}, (Feature[])new Feature[0]);
        Integer codeObj = (Integer)treeMap.get("code");
        if (codeObj != null && codeObj == 0) {
            String encData = treeMap.get("encData").toString();
            String jsonStr = null;
            try {
                byte[] cipherData = ByteUtils.fromHexString((String)encData);
                byte[] cipherByte = SM4Util.decrypt_Ecb_Padding(this.encryptKeys, cipherData);
                String dEncData = new String(cipherByte, StandardCharsets.UTF_8);
                org.json.JSONObject jsonObject = new org.json.JSONObject(dEncData);
                jsonStr = JSON.parseObject((String)jsonObject.toString()).toJSONString();
            }
            catch (Exception var10) {
                throw new ServerException(FuncRetCode.ERROR_CODE_ENCRYPT_ERROR);
            }
            Map dataMap = (Map)JSON.parseObject((String)jsonStr, (TypeReference)new TypeReference<Map<String, Object>>(){}, (Feature[])new Feature[0]);
            treeMap.put("data", dataMap);
            treeMap.keySet().removeIf(key -> Objects.equals(key, "encData") || Objects.equals(key, "signData"));
        }
        return JSON.toJSONString((Object)treeMap);
    }

    static {
        LOG = LogFactory.getLog(DataHandler.class);
    }
}

