/*
 * Decompiled with CFR 0.152.
 */
package com.byh.outpatient.web.mvc.controller;

import com.byh.outpatient.api.dto.netHospital.ReservationDTO;
import com.byh.outpatient.api.dto.reservation.InsertResevationDto;
import com.byh.outpatient.api.dto.reservation.QueryReservationDto;
import com.byh.outpatient.api.model.reservation.ReservationEntity;
import com.byh.outpatient.api.util.EasyExcelUtil;
import com.byh.outpatient.api.util.PageResult;
import com.byh.outpatient.api.util.ResponseData;
import com.byh.outpatient.api.vo.order.ExcelReservation;
import com.byh.outpatient.api.vo.reservation.ReservationDetailVo;
import com.byh.outpatient.web.aspect.UserOptLogger;
import com.byh.outpatient.web.mvc.utils.CommonRequest;
import com.byh.outpatient.web.service.ReservationService;
import io.swagger.annotations.ApiOperation;
import java.text.ParseException;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.BindingResult;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Validated
@RequestMapping(value={"/reservation"})
public class ReservationController {
    @Autowired
    private ReservationService reservationService;
    @Autowired
    private CommonRequest commonRequest;

    @PostMapping(value={"/insert"})
    @UserOptLogger(operation="\u65b0\u589e\u9884\u7ea6\u8bb0\u5f55")
    @ApiOperation(value="\u65b0\u589e\u9884\u7ea6\u8bb0\u5f55", httpMethod="POST", notes="\u65b0\u589e\u9884\u7ea6\u8bb0\u5f55")
    public ResponseData insert(@RequestBody InsertResevationDto insertResevationDto) {
        Integer tenantId = this.commonRequest.getTenant();
        insertResevationDto.setTenantId(tenantId);
        return this.reservationService.insert(insertResevationDto);
    }

    @UserOptLogger(operation="\u5220\u9664\u9884\u7ea6\u8bb0\u5f55")
    @GetMapping(value={"/deleteById"})
    @ApiOperation(value="\u5220\u9664\u9884\u7ea6\u8bb0\u5f55", httpMethod="GET", notes="\u5220\u9664\u9884\u7ea6\u8bb0\u5f55")
    public ResponseData deleteById(@RequestParam(value="id", required=true) Integer id) {
        return this.reservationService.deleteById(id);
    }

    @UserOptLogger(operation="\u66f4\u65b0\u9884\u7ea6\u8bb0\u5f55")
    @PostMapping(value={"/updateById"})
    @ApiOperation(value="\u66f4\u65b0\u9884\u7ea6\u8bb0\u5f55", httpMethod="POST", notes="\u66f4\u65b0\u9884\u7ea6\u8bb0\u5f55")
    public ResponseData updateById(@RequestBody ReservationEntity reservation) {
        return this.reservationService.updateById(reservation);
    }

    @GetMapping(value={"/queryById"})
    @ApiOperation(value="\u67e5\u8be2\u9884\u7ea6\u8bb0\u5f55", httpMethod="GET", notes="\u67e5\u8be2\u9884\u7ea6\u8bb0\u5f55")
    public ResponseData<ReservationDetailVo> queryById(@RequestParam(value="id", required=true) Integer id) {
        return this.reservationService.queryById(id);
    }

    @PostMapping(value={"/queryReservation"})
    @ApiOperation(value="\u67e5\u8be2\u9884\u7ea6\u8bb0\u5f55", httpMethod="POST", notes="\u67e5\u8be2\u9884\u7ea6\u8bb0\u5f55")
    public ResponseData<PageResult<ReservationEntity>> queryReservation(@RequestBody @Valid QueryReservationDto queryReservationDto, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return ResponseData.error((String)bindingResult.getFieldError().getDefaultMessage());
        }
        Integer tenantId = this.commonRequest.getTenant();
        queryReservationDto.setTenantId(tenantId);
        return this.reservationService.queryReservation(queryReservationDto);
    }

    @PostMapping(value={"/queryReservationCount"})
    @ApiOperation(value="\u7edf\u8ba1\u9884\u7ea6\u4eba\u6570\uff0c\u5c31\u8bca\u4eba\u6570", httpMethod="POST", notes="\u7edf\u8ba1\u9884\u7ea6\u4eba\u6570\uff0c\u5c31\u8bca\u4eba\u6570")
    public ResponseData<Map<String, Object>> queryReservationCount(@RequestBody @Valid QueryReservationDto queryReservationDto, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return ResponseData.error((String)bindingResult.getFieldError().getDefaultMessage());
        }
        Integer tenantId = this.commonRequest.getTenant();
        queryReservationDto.setTenantId(tenantId);
        return this.reservationService.queryReservationCount(queryReservationDto);
    }

    @PostMapping(value={"/queryReservationCountExport"})
    @ApiOperation(value="\u7edf\u8ba1\u9884\u7ea6\u4eba\u6570\uff0c\u5c31\u8bca\u4eba\u6570", httpMethod="POST", notes="\u7edf\u8ba1\u9884\u7ea6\u4eba\u6570\uff0c\u5c31\u8bca\u4eba\u6570\u5bfc\u51fa")
    public void queryReservationCountExport(@RequestBody @Valid QueryReservationDto queryReservationDto, BindingResult bindingResult, HttpServletResponse response) throws ParseException {
        Integer tenantId = this.commonRequest.getTenant();
        queryReservationDto.setTenantId(tenantId);
        ResponseData listResponseData = this.reservationService.queryReservationCountExport(queryReservationDto);
        List data = (List)listResponseData.getData();
        String excelName = "\u95e8\u8bca\u62a5\u8868\u5bfc\u51fa";
        String sheetName = "\u666e\u901a";
        EasyExcelUtil.normalExport((HttpServletResponse)response, (String)excelName, (String)sheetName, (List)data, ExcelReservation.class);
    }

    @PostMapping(value={"/queryReservationCountByTime"})
    @ApiOperation(value="\u7edf\u8ba1\u9884\u7ea6\u4eba\u6570\uff0c\u5c31\u8bca\u4eba\u6570", httpMethod="POST", notes="\u6839\u636e\u65f6\u95f4\u533a\u95f4\u7edf\u8ba1\u9884\u7ea6\u4eba\u6570\uff0c\u5c31\u8bca\u4eba\u6570")
    public ResponseData<List<Map<String, Object>>> queryReservationCountByTime(@RequestBody @Valid QueryReservationDto queryReservationDto, BindingResult bindingResult) throws ParseException {
        if (bindingResult.hasErrors()) {
            return ResponseData.error((String)bindingResult.getFieldError().getDefaultMessage());
        }
        Integer tenantId = this.commonRequest.getTenant();
        queryReservationDto.setTenantId(tenantId);
        return this.reservationService.queryReservationCountByTime(queryReservationDto);
    }

    @PostMapping(value={"/queryReservationCountByDept"})
    @ApiOperation(value="\u6839\u636e\u90e8\u95e8\u5206\u7c7b\u67e5\u8be2\u9884\u7ea6\u4ee5\u53ca\u5c31\u8bca\u4eba\u6570", httpMethod="POST", notes="\u6839\u636e\u90e8\u95e8\u5206\u7c7b\u67e5\u8be2\u9884\u7ea6\u4ee5\u53ca\u5c31\u8bca\u4eba\u6570")
    public ResponseData<List<Map<String, Object>>> queryReservationCountByDept(@RequestBody @Valid QueryReservationDto queryReservationDto, BindingResult bindingResult) throws ParseException {
        if (bindingResult.hasErrors()) {
            return ResponseData.error((String)bindingResult.getFieldError().getDefaultMessage());
        }
        Integer tenantId = this.commonRequest.getTenant();
        queryReservationDto.setTenantId(tenantId);
        return this.reservationService.queryReservationCountByDept(queryReservationDto);
    }

    @PostMapping(value={"/queryReservationCountByReservationSource"})
    @ApiOperation(value="\u6839\u636e\u9884\u7ea6\u6765\u6e90\u7edf\u8ba1\u9884\u7ea6\u4eba\u6570", httpMethod="POST", notes="\u6839\u636e\u9884\u7ea6\u6765\u6e90\u7edf\u8ba1\u9884\u7ea6\u4eba\u6570")
    public ResponseData<List<Map<String, Object>>> queryReservationCountByReservationSource(@RequestBody @Valid QueryReservationDto queryReservationDto, BindingResult bindingResult) throws ParseException {
        if (bindingResult.hasErrors()) {
            return ResponseData.error((String)bindingResult.getFieldError().getDefaultMessage());
        }
        Integer tenantId = this.commonRequest.getTenant();
        queryReservationDto.setTenantId(tenantId);
        return this.reservationService.queryReservationCountByReservationSource(queryReservationDto);
    }

    @PostMapping(value={"/queryReservationList"})
    @ApiOperation(value="\u67e5\u8be2\u6302\u53f7\u5386\u53f2\u8bb0\u5f55", httpMethod="POST", notes="\u67e5\u8be2\u6302\u53f7\u5386\u53f2\u8bb0\u5f55")
    public ResponseData queryReservationList(@RequestBody ReservationDTO dto) {
        List list = this.reservationService.queryReservationList(dto);
        return ResponseData.success((Object)list);
    }
}

