/*
 * Decompiled with CFR 0.152.
 */
package com.byh.outpatient.web.rabbitListener;

import com.alibaba.fastjson.JSONObject;
import com.byh.outpatient.api.enums.ReservationStatusEnum;
import com.byh.outpatient.api.model.reservation.ReservationEntity;
import com.byh.outpatient.api.util.DateUtils;
import com.byh.outpatient.data.repository.ReservationMapper;
import com.byh.outpatient.web.mvc.utils.RabbitMqUtils;
import com.rabbitmq.client.Channel;
import java.io.Serializable;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.rabbit.annotation.RabbitHandler;
import org.springframework.amqp.rabbit.annotation.RabbitListener;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ReservationTimeoutListener {
    private static final Logger log = LoggerFactory.getLogger(ReservationTimeoutListener.class);
    @Autowired
    private ReservationMapper reservationMapper;
    @Autowired
    private RabbitTemplate rabbitTemplate;

    @RabbitHandler
    @RabbitListener(queues={"outpatient.delayed.resverationOvertime.queue"})
    public void reservationTimeout(Channel channel, Message message) throws Exception {
        String reservationId = new String(message.getBody());
        String messageId = message.getMessageProperties().getMessageId();
        log.info("\u3010\u5ef6\u65f6\u767b\u8bb0\u8d85\u65f6MQ\u3011 \u767b\u8bb0id\uff1a\u3010{}\u3011\u3002messageId \u3010{}\u3011", (Object)reservationId, (Object)messageId);
        try {
            ReservationEntity reservation = (ReservationEntity)this.reservationMapper.selectById((Serializable)new Integer(reservationId));
            log.info("\u67e5\u8be2\u9884\u7ea6\u8bb0\u5f55{}", (Object)JSONObject.toJSONString((Object)reservation));
            if (ReservationStatusEnum.RESERVATION.getValue().equals(reservation.getStatus())) {
                String scheduleTimeDetail = reservation.getScheduleTimeDetail();
                Date endDate = DateUtils.stringToFullDate((String)(reservation.getScheduleDate() + " " + reservation.getScheduleTimeDetail().substring(reservation.getScheduleTimeDetail().indexOf("-") + 1) + ":00"));
                long delyTime = DateUtils.differFrom((Date)DateUtils.getCurrentDate(), (Date)DateUtils.afterOneHourToNowDate((Date)endDate));
                if (delyTime < 5L) {
                    reservation.setStatus(ReservationStatusEnum.BREAK_PROMISE.getValue());
                    this.reservationMapper.updateById((Object)reservation);
                } else {
                    log.info("\u4fee\u6539\u9884\u7ea6\u65f6\u95f4\u540e\u66f4\u6539\u5ef6\u8fdf\u65f6\u95f4");
                    Date newEndDate = DateUtils.stringToFullDate((String)(reservation.getScheduleDate() + " " + reservation.getScheduleTimeDetail().substring(reservation.getScheduleTimeDetail().indexOf("-") + 1) + ":00"));
                    long newDelyTime = DateUtils.differFrom((Date)DateUtils.getCurrentDate(), (Date)DateUtils.afterOneHourToNowDate((Date)newEndDate));
                    RabbitMqUtils.sendReservationTimeout((RabbitTemplate)this.rabbitTemplate, (String)String.valueOf(reservation.getId()), (Long)newDelyTime);
                }
                log.info("\u66f4\u6539\u723d\u7ea6\u8bb0\u5f55");
            }
        }
        catch (Exception e) {
            log.error("\u6d88\u606f\u5904\u7406\u51fa\u73b0\u5f02\u5e38\uff1a{}", (Object)e.getMessage());
        }
    }
}

