/*
 * Decompiled with CFR 0.152.
 */
package com.byh.outpatient.web.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.byh.outpatient.api.dto.order.OutpatientDaySettlementDto;
import com.byh.outpatient.api.model.OutpatientDaySettlementEntity;
import com.byh.outpatient.api.util.ResponseData;
import com.byh.outpatient.api.vo.hsSettlement.TotalHsSettlmentRes;
import com.byh.outpatient.api.vo.order.FeeDetail;
import com.byh.outpatient.api.vo.order.OutpatientDaySettlementVo;
import com.byh.outpatient.api.vo.order.RegCountRes;
import com.byh.outpatient.api.vo.order.SelfSettlementRes;
import com.byh.outpatient.api.vo.order.TotalSettlementRes;
import com.byh.outpatient.data.repository.OutpatientDaySettlementMapper;
import com.byh.outpatient.web.service.OutpatientDaySettlementService;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class OutpatientDaySettlementServiceImpl
implements OutpatientDaySettlementService {
    @Autowired
    private OutpatientDaySettlementMapper mapper;

    public ResponseData saveOutpatientDaySettlement(OutpatientDaySettlementEntity entity) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        entity.setCheckoutTime(format.format(new Date()));
        this.mapper.insert((Object)entity);
        return ResponseData.success();
    }

    public ResponseData<PageInfo<OutpatientDaySettlementVo>> searchOutpatientDaySettlementList(OutpatientDaySettlementDto dto) {
        PageHelper.startPage((int)dto.getCurrent(), (int)dto.getSize());
        List outpatientDaySettlementEntities = this.mapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(dto.getNo() != null, OutpatientDaySettlementEntity::getNo, (Object)dto.getNo())).eq(dto.getCheckerId() != null, OutpatientDaySettlementEntity::getCheckerId, (Object)dto.getCheckerId())).eq(dto.getTenantId() != null, OutpatientDaySettlementEntity::getTenantId, (Object)dto.getTenantId()));
        ArrayList<OutpatientDaySettlementVo> outpatientDaySettlementVos = new ArrayList<OutpatientDaySettlementVo>();
        for (OutpatientDaySettlementEntity entity : outpatientDaySettlementEntities) {
            OutpatientDaySettlementVo vo = new OutpatientDaySettlementVo();
            vo.setNo(entity.getNo());
            vo.setCheckerId(entity.getCheckerId());
            vo.setCheckerName(entity.getCheckerName());
            vo.setStartTime(entity.getStartTime());
            vo.setCheckoutTime(entity.getEndTime());
            FeeDetail feeDetail = new FeeDetail();
            BeanUtils.copyProperties((Object)entity, (Object)feeDetail);
            if (entity.getGuaHao1() != null) {
                feeDetail.setGuaHao(entity.getGuaHao1());
            }
            if (entity.getJianYan1() != null) {
                feeDetail.setJianYan(entity.getJianYan1());
            }
            if (entity.getJianCha1() != null) {
                feeDetail.setJianCha(entity.getJianCha1());
            }
            vo.setFeeDetail(feeDetail);
            TotalHsSettlmentRes totalHsSettlmentRes = new TotalHsSettlmentRes();
            BeanUtils.copyProperties((Object)entity, (Object)totalHsSettlmentRes);
            vo.setTotalHsSettlmentRes(totalHsSettlmentRes);
            SelfSettlementRes selfSettlementRes = new SelfSettlementRes();
            BeanUtils.copyProperties((Object)entity, (Object)selfSettlementRes);
            vo.setSelfSettlementRes(selfSettlementRes);
            TotalSettlementRes totalSettlementRes = new TotalSettlementRes();
            BeanUtils.copyProperties((Object)entity, (Object)totalSettlementRes);
            vo.setTotalSettlementRes(totalSettlementRes);
            RegCountRes regCountRes = new RegCountRes();
            BeanUtils.copyProperties((Object)entity, (Object)regCountRes);
            if (entity.getRegOther() != null) {
                regCountRes.setOther(entity.getRegOther());
            }
            if (entity.getRegPayCost() != null) {
                regCountRes.setPayCost(entity.getRegPayCost());
            }
            if (entity.getRegPubCost() != null) {
                regCountRes.setPubCost(entity.getRegPubCost());
            }
            if (entity.getRegIndustrialInjuryCost() != null) {
                regCountRes.setIndustrialInjuryCost(entity.getRegIndustrialInjuryCost());
            }
            vo.setRegCountRes(regCountRes);
            outpatientDaySettlementVos.add(vo);
        }
        PageInfo outpatientDaySettlementVoPageInfo = new PageInfo(outpatientDaySettlementVos);
        return ResponseData.success((Object)outpatientDaySettlementVoPageInfo);
    }

    public ResponseData<OutpatientDaySettlementVo> searchOutpatientDaySettlementById(OutpatientDaySettlementEntity param) {
        OutpatientDaySettlementEntity entity = (OutpatientDaySettlementEntity)this.mapper.selectById((Serializable)param.getId());
        OutpatientDaySettlementVo vo = new OutpatientDaySettlementVo();
        if (entity != null) {
            vo.setNo(entity.getNo());
            vo.setCheckerId(entity.getCheckerId());
            vo.setCheckerName(entity.getCheckerName());
            vo.setStartTime(entity.getStartTime());
            vo.setCheckoutTime(entity.getEndTime());
            FeeDetail feeDetail = new FeeDetail();
            BeanUtils.copyProperties((Object)entity, (Object)feeDetail);
            if (entity.getGuaHao1() != null) {
                feeDetail.setGuaHao(entity.getGuaHao1());
            }
            if (entity.getJianYan1() != null) {
                feeDetail.setJianYan(entity.getJianYan1());
            }
            if (entity.getJianCha1() != null) {
                feeDetail.setJianCha(entity.getJianCha1());
            }
            vo.setFeeDetail(feeDetail);
            TotalHsSettlmentRes totalHsSettlmentRes = new TotalHsSettlmentRes();
            BeanUtils.copyProperties((Object)entity, (Object)totalHsSettlmentRes);
            vo.setTotalHsSettlmentRes(totalHsSettlmentRes);
            SelfSettlementRes selfSettlementRes = new SelfSettlementRes();
            BeanUtils.copyProperties((Object)entity, (Object)selfSettlementRes);
            vo.setSelfSettlementRes(selfSettlementRes);
            TotalSettlementRes totalSettlementRes = new TotalSettlementRes();
            BeanUtils.copyProperties((Object)entity, (Object)totalSettlementRes);
            vo.setTotalSettlementRes(totalSettlementRes);
            RegCountRes regCountRes = new RegCountRes();
            BeanUtils.copyProperties((Object)entity, (Object)regCountRes);
            if (entity.getRegOther() != null) {
                regCountRes.setOther(entity.getRegOther());
            }
            if (entity.getRegPayCost() != null) {
                regCountRes.setPayCost(entity.getRegPayCost());
            }
            if (entity.getRegPubCost() != null) {
                regCountRes.setPubCost(entity.getRegPubCost());
            }
            if (entity.getRegIndustrialInjuryCost() != null) {
                regCountRes.setIndustrialInjuryCost(entity.getRegIndustrialInjuryCost());
            }
            vo.setRegCountRes(regCountRes);
        }
        return ResponseData.success((Object)vo);
    }
}

