/*
 * Decompiled with CFR 0.152.
 */
package com.byh.outpatient.web.mvc.controller;

import cn.hutool.crypto.SecureUtil;
import cn.hutool.http.HttpRequest;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.byh.outpatient.api.dto.order.HsPayDto;
import com.byh.outpatient.api.dto.order.HsPreparePayDto;
import com.byh.outpatient.api.dto.order.OnlineHsPayDto;
import com.byh.outpatient.api.dto.pay.CancelPaymentDto;
import com.byh.outpatient.api.dto.pay.CheckItemStatusDto;
import com.byh.outpatient.api.dto.pay.FeeBillCreationDto;
import com.byh.outpatient.api.dto.pay.HsRefundDto;
import com.byh.outpatient.api.dto.pay.IcbcRefundDto;
import com.byh.outpatient.api.dto.pay.OnlineHsRefundDto;
import com.byh.outpatient.api.dto.pay.PayByICBC;
import com.byh.outpatient.api.dto.pay.PayDto;
import com.byh.outpatient.api.dto.pay.PayReFundByICBC;
import com.byh.outpatient.api.dto.pay.PayRefundDto;
import com.byh.outpatient.api.enums.PayStatusEnum;
import com.byh.outpatient.api.enums.PaymentRecordsStatusEnum;
import com.byh.outpatient.api.hsModel.request.MoveOrderInfoRequest;
import com.byh.outpatient.api.model.order.OutOrderPayment;
import com.byh.outpatient.api.util.BaseResponse;
import com.byh.outpatient.api.util.ResponseData;
import com.byh.outpatient.api.util.UUIDUtils;
import com.byh.outpatient.api.vo.order.PayRefundVo;
import com.byh.outpatient.api.vo.order.PayVo;
import com.byh.outpatient.api.vo.pay.FeeBillCreationVo;
import com.byh.outpatient.api.vo.pay.PayNotifyReqVO;
import com.byh.outpatient.api.vo.pay.RefundCallBackReqVo;
import com.byh.outpatient.data.repository.OutOrderPaymentMapper;
import com.byh.outpatient.web.aspect.UserOptLogger;
import com.byh.outpatient.web.feign.SysServiceFeign;
import com.byh.outpatient.web.mvc.config.NodeConfig;
import com.byh.outpatient.web.mvc.exception.RunDisplayException;
import com.byh.outpatient.web.mvc.utils.CommonRequest;
import com.byh.outpatient.web.service.OutInvoiceService;
import com.byh.outpatient.web.service.OutPayService;
import com.byh.outpatient.web.service.impl.PayOfflinePaymentImpl;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiOperation;
import io.swagger.v3.oas.annotations.Operation;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.HashMap;
import java.util.List;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/outPay"})
public class OutPayController {
    @Autowired
    private OutPayService outPayService;
    @Autowired
    private OutInvoiceService outInvoiceService;
    @Autowired
    private NodeConfig nodeConfig;
    @Autowired
    private CommonRequest commonRequest;
    private static Logger log = LoggerFactory.getLogger(OutPayController.class);
    @Autowired
    private SysServiceFeign sysServiceFeign;
    @Autowired
    private OutOrderPaymentMapper outOrderPaymentMapper;

    @ApiOperation(value="\u6821\u9a8c\u6240\u6709\u6536\u8d39\u7684\u9879\u76ee\u662f\u5426\u5b58\u5728\u672a\u542f\u7528\u7684\u72b6\u6001")
    @PostMapping(value={"/checkItemStatus"})
    public ResponseData checkItemStatus(@RequestBody List<CheckItemStatusDto> dtoList) {
        Integer tenantId = this.commonRequest.getTenant();
        return ResponseData.success((Object)this.outPayService.checkItemStatus(dtoList, tenantId));
    }

    @ApiModelProperty(value="\u6821\u9a8c\u6536\u8d39\u9879\u76ee\u662f\u5426\u901a\u8fc7\u533b\u4fdd\u5ba1\u6838")
    @PostMapping(value={"/checkMedicalInsuranceFlag"})
    public ResponseData checkMedicalInsuranceFlag(@RequestBody List<String> orderNos) {
        return ResponseData.success((Object)this.outPayService.checkMedicalInsuranceFlag(orderNos, this.commonRequest.getTenant()));
    }

    @PostMapping(value={"/v1/orderCharge"})
    @Operation(description="\u652f\u4ed8\u8ba2\u5355\u521b\u5efa")
    @ApiOperation(value="\u652f\u4ed8-\u652f\u4ed8\u8ba2\u5355\u521b\u5efa", httpMethod="POST", notes="\u652f\u4ed8-\u652f\u4ed8\u5355\u521b\u5efa")
    public ResponseData<FeeBillCreationVo> orderCharge(@RequestBody @Valid FeeBillCreationDto parameter, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return ResponseData.error((String)bindingResult.getFieldError().getDefaultMessage());
        }
        parameter.setTenantId(this.commonRequest.getTenant());
        parameter.setOperatorId(this.commonRequest.getUserId());
        parameter.setOperatorName(this.commonRequest.getUserName());
        return this.outPayService.orderCharge(parameter);
    }

    @ApiOperation(value="\u652f\u4ed8\u8ba2\u5355\uff08\u5de5\u884c\u626b\u7801\u652f\u4ed8\uff09")
    @PostMapping(value={"/orderPayByICBC"})
    @UserOptLogger(operation="\u5de5\u884c\u626b\u7801\u652f\u4ed8")
    public ResponseData orderPayByICBC(@RequestBody @Valid PayByICBC param) {
        param.setTenantId(this.commonRequest.getTenant());
        param.setUserId(this.commonRequest.getUserId());
        param.setUserName(this.commonRequest.getUserName());
        PayVo payVo = this.outPayService.orderPayByICBC(param);
        return ResponseData.success((Object)payVo);
    }

    @ApiOperation(value="\u5de5\u884c\u626b\u7801\u652f\u4ed8-\u9000\u6b3e")
    @PostMapping(value={"/payRefundByICBC"})
    @UserOptLogger(operation="\u5de5\u884c\u626b\u7801\u652f\u4ed8")
    public ResponseData payRefundByICBC(@RequestBody @Valid PayReFundByICBC param) {
        param.setTenantId(this.commonRequest.getTenant());
        param.setUserId(this.commonRequest.getUserId());
        param.setUserName(this.commonRequest.getUserName());
        PayVo payVo = this.outPayService.payRefundByICBC(param);
        try {
            this.outInvoiceService.batchCancel(param.getPayOrderNo(), param.getOrderNoList());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ResponseData.success((Object)payVo);
    }

    @ApiOperation(value="\u5de5\u884c\u626b\u7801\u652f\u4ed8-\u5168\u989d\u9000\u6b3e")
    @PostMapping(value={"/payFullRefundByICBC"})
    @UserOptLogger(operation="\u5de5\u884c\u626b\u7801\u652f\u4ed8")
    public ResponseData payFullRefundByICBC(@RequestBody IcbcRefundDto param) {
        param.setTenantId(this.commonRequest.getTenant());
        param.setUserId(this.commonRequest.getUserId());
        param.setUserName(this.commonRequest.getUserName());
        PayVo payVo = this.outPayService.payFullRefundByICBC(param);
        try {
            this.outInvoiceService.batchCancel(param.getOriOrderNo(), null);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ResponseData.success((Object)payVo);
    }

    @UserOptLogger(operation="\u53d6\u6d88\u652f\u4ed8")
    @PostMapping(value={"/v1/cancelPayment"})
    @Operation(description="\u53d6\u6d88\u652f\u4ed8")
    @ApiOperation(value="\u652f\u4ed8-\u53d6\u6d88\u652f\u4ed8", httpMethod="POST", notes="\u652f\u4ed8-\u53d6\u6d88\u652f\u4ed8")
    public ResponseData<String> cancelPayment(@RequestBody @Valid CancelPaymentDto parameter, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return ResponseData.error((String)bindingResult.getFieldError().getDefaultMessage());
        }
        parameter.setTenantId(this.commonRequest.getTenant());
        parameter.setOperatorId(this.commonRequest.getUserId());
        parameter.setOperatorName(this.commonRequest.getUserName());
        return this.outPayService.cancelPayment(parameter);
    }

    @UserOptLogger(operation="\u91cd\u65b0\u6536\u8d39")
    @PostMapping(value={"/v1/recharge"})
    @Operation(description="\u91cd\u65b0\u6536\u8d39")
    @ApiOperation(value="\u652f\u4ed8-\u91cd\u65b0\u6536\u8d39", httpMethod="POST", notes="\u652f\u4ed8-\u91cd\u65b0\u6536\u8d39")
    public ResponseData<String> recharge(@RequestBody @Valid CancelPaymentDto parameter, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return ResponseData.error((String)bindingResult.getFieldError().getDefaultMessage());
        }
        parameter.setTenantId(this.commonRequest.getTenant());
        parameter.setOperatorId(this.commonRequest.getUserId());
        parameter.setOperatorName(this.commonRequest.getUserName());
        return this.outPayService.recharge(parameter);
    }

    @PostMapping(value={"/v1/payment"})
    @Operation(description="H5\u652f\u4ed8")
    @ApiOperation(value="\u652f\u4ed8-H5\u652f\u4ed8", httpMethod="POST", notes="\u652f\u4ed8-H5\u652f\u4ed8")
    public ResponseData<PayVo> firstPayment(@RequestBody @Valid PayDto parameter, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return ResponseData.error((String)bindingResult.getFieldError().getDefaultMessage());
        }
        parameter.setTenantId(this.commonRequest.getTenant());
        parameter.setOperatorId(this.commonRequest.getUserId());
        parameter.setOperatorName(this.commonRequest.getUserName());
        return this.outPayService.firstPayment(parameter);
    }

    @PostMapping(value={"/v1/payRefund"})
    @Operation(description="\u652f\u4ed8\u9000\u6b3e")
    @ApiOperation(value="\u652f\u4ed8\u9000\u6b3e", httpMethod="POST", notes="\u652f\u4ed8\u9000\u6b3e")
    public ResponseData<PayRefundVo> firstPayRefund(@RequestBody @Valid PayRefundDto parameter, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return ResponseData.error((String)bindingResult.getFieldError().getDefaultMessage());
        }
        parameter.setTenantId(this.commonRequest.getTenant());
        parameter.setOperatorId(this.commonRequest.getUserId());
        parameter.setOperatorName(this.commonRequest.getUserName());
        ResponseData payRefundVoResponseData = this.outPayService.firstPayRefund(parameter);
        if (payRefundVoResponseData.isSuccess()) {
            try {
                this.outInvoiceService.batchCancel(parameter.getPayOrderNo(), parameter.getOrderNoList());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return payRefundVoResponseData;
    }

    @ApiOperation(value="\u652f\u4ed8\u56de\u8c03-\u4f70\u533b\u652f\u4ed8\u4e2d\u53f0", notes="\u652f\u4ed8\u56de\u8c03-\u4f70\u533b\u652f\u4ed8\u4e2d\u53f0")
    @PostMapping(value={"/v1/paymentCallback"})
    public BaseResponse<String> paymentCallback(@RequestBody JSONObject jsonObject, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return BaseResponse.error((String)bindingResult.getFieldError().getDefaultMessage());
        }
        try {
            log.info("======>>\u8fdb\u5165\u4e86\u652f\u4ed8\u56de\u8c03,\u56de\u8c03\u7684\u4fe1\u606f\u662f:{}", (Object)JSONObject.toJSONString((Object)jsonObject));
            PayNotifyReqVO payNotifyReqVO = (PayNotifyReqVO)JSON.toJavaObject((JSON)jsonObject, PayNotifyReqVO.class);
            log.info("======>>\u8fdb\u5165\u4e86\u652f\u4ed8\u56de\u8c03,\u4fe1\u606f\u662f:{}", (Object)JSONObject.toJSONString((Object)payNotifyReqVO));
            if (payNotifyReqVO == null) {
                return BaseResponse.error((String)PayStatusEnum.FAIL.getValue());
            }
            ResponseData stringResponseData = this.outPayService.paymentCallback(payNotifyReqVO);
            if (stringResponseData.isSuccess()) {
                return BaseResponse.success((Object)PayStatusEnum.SUCCESS.getValue());
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return BaseResponse.error((String)PayStatusEnum.FAIL.getValue());
    }

    @ApiOperation(value="\u9000\u6b3e\u56de\u8c03-\u4f70\u533b\u652f\u4ed8\u4e2d\u53f0", notes="\u652f\u4ed8\u56de\u8c03-\u4f70\u533b\u652f\u4ed8\u4e2d\u53f0")
    @PostMapping(value={"/v1/refundCallback"})
    public BaseResponse<String> refundCallback(@RequestBody JSONObject jsonObject, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return BaseResponse.error((String)bindingResult.getFieldError().getDefaultMessage());
        }
        try {
            log.info("======>>\u8fdb\u5165\u4e86\u9000\u6b3e\u56de\u8c03,\u56de\u8c03\u7684\u4fe1\u606f\u662f:{}", (Object)JSONObject.toJSONString((Object)jsonObject));
            RefundCallBackReqVo refundCallBackReqVo = (RefundCallBackReqVo)JSON.toJavaObject((JSON)jsonObject, RefundCallBackReqVo.class);
            log.info("======>>\u8fdb\u5165\u4e86\u9000\u6b3e\u56de\u8c03,\u4fe1\u606f\u662f:{}", (Object)JSONObject.toJSONString((Object)refundCallBackReqVo));
            if (refundCallBackReqVo == null) {
                return BaseResponse.error((String)PayStatusEnum.FAIL.getValue());
            }
            ResponseData stringResponseData = this.outPayService.refundCallback(refundCallBackReqVo);
            if (stringResponseData.isSuccess()) {
                return BaseResponse.success((Object)PayStatusEnum.SUCCESS.getValue());
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return BaseResponse.error((String)PayStatusEnum.FAIL.getValue());
    }

    @UserOptLogger(operation="\u533b\u4fdd\u9884\u7ed3\u7b97")
    @PostMapping(value={"/v1/hsPreparePayment"})
    @Operation(description="\u533b\u4fdd\u9884\u7ed3\u7b97")
    @ApiOperation(value="\u533b\u4fdd\u9884\u7ed3\u7b97", httpMethod="POST", notes="\u533b\u4fdd\u9884\u7ed3\u7b97")
    public ResponseData<?> hsPreparePayment(@RequestBody @Valid HsPreparePayDto hsPreparePayDto, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return ResponseData.error((String)bindingResult.getFieldError().getDefaultMessage());
        }
        hsPreparePayDto.setTenantId(this.commonRequest.getTenant());
        hsPreparePayDto.setOpter(String.valueOf(this.commonRequest.getUserId()));
        hsPreparePayDto.setOpter_name(this.commonRequest.getUserName());
        hsPreparePayDto.setOpter_type(this.nodeConfig.getOpterType());
        hsPreparePayDto.setSign_no(this.commonRequest.getSignNo());
        return this.outPayService.hsPreparePayment(hsPreparePayDto);
    }

    @PostMapping(value={"/v1/hsPayment"})
    @Operation(description="\u533b\u4fdd\u7ed3\u7b97")
    @ApiOperation(value="\u533b\u4fdd\u7ed3\u7b97", httpMethod="POST", notes="\u533b\u4fdd\u7ed3\u7b97")
    public ResponseData<String> hsPayment(@RequestBody @Valid HsPayDto hsPayDto, BindingResult bindingResult) {
        log.info("\u533b\u4fdd\u7ed3\u7b97{}\u5165\u53c2\uff1a{}", (Object)hsPayDto.getPayOrderNo(), (Object)JSONObject.toJSONString((Object)hsPayDto));
        if (bindingResult.hasErrors()) {
            return ResponseData.error((String)bindingResult.getFieldError().getDefaultMessage());
        }
        hsPayDto.setTenantId(this.commonRequest.getTenant());
        hsPayDto.setOpter(String.valueOf(this.commonRequest.getUserId()));
        hsPayDto.setOpter_name(this.commonRequest.getUserName());
        hsPayDto.setOpter_type(this.nodeConfig.getOpterType());
        hsPayDto.setSign_no(this.commonRequest.getSignNo());
        return this.outPayService.hsPayment(hsPayDto);
    }

    @PostMapping(value={"/v1/onlineHsPayment"})
    @Operation(description="\u7ebf\u4e0a\u533b\u4fdd\u7ed3\u7b97")
    @ApiOperation(value="\u7ebf\u4e0a\u533b\u4fdd\u7ed3\u7b97", httpMethod="POST", notes="\u533b\u4fdd\u7ed3\u7b97")
    public ResponseData onlineHsPayment(@RequestBody @Valid OnlineHsPayDto onlineHsPayDto, BindingResult bindingResult) {
        log.info("\u7ebf\u4e0a\u533b\u4fdd\u7ed3\u7b97\u5165\u53c2\uff1a", (Object)JSONObject.toJSONString((Object)onlineHsPayDto));
        if (bindingResult.hasErrors()) {
            return ResponseData.error((String)bindingResult.getFieldError().getDefaultMessage());
        }
        onlineHsPayDto.setTenantId(this.commonRequest.getTenant());
        onlineHsPayDto.setOpter(String.valueOf(this.commonRequest.getUserId()));
        onlineHsPayDto.setOpter_name(this.commonRequest.getUserName());
        onlineHsPayDto.setOpter_type(this.nodeConfig.getOpterType());
        onlineHsPayDto.setSign_no(this.commonRequest.getSignNo());
        return this.outPayService.onLineHsPay(onlineHsPayDto);
    }

    @PostMapping(value={"/v1/hsRefund"})
    @Operation(description="\u533b\u4fdd\u9000\u6b3e")
    @ApiOperation(value="\u533b\u4fdd\u9000\u6b3e", httpMethod="POST", notes="\u533b\u4fdd\u9000\u6b3e")
    public ResponseData<?> hsRefund(@RequestBody @Valid HsRefundDto hsRefundDto, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return ResponseData.error((String)bindingResult.getFieldError().getDefaultMessage());
        }
        hsRefundDto.setTenantId(this.commonRequest.getTenant());
        hsRefundDto.setOpter(this.commonRequest.getUserId().toString());
        hsRefundDto.setOpterName(this.commonRequest.getUserName());
        hsRefundDto.setOpterType(this.nodeConfig.getOpterType());
        hsRefundDto.setSign_no(this.commonRequest.getSignNo());
        ResponseData responseData = this.outPayService.hsRefund(hsRefundDto);
        if (responseData.isSuccess()) {
            QueryWrapper queryWrapper = new QueryWrapper();
            ((QueryWrapper)queryWrapper.eq((Object)"status", (Object)PaymentRecordsStatusEnum.STATUS_NORMAL.getValue())).eq((Object)"pay_order_no", (Object)hsRefundDto.getPayOrderNo());
            OutOrderPayment outOrderPayment = (OutOrderPayment)this.outOrderPaymentMapper.selectOne((Wrapper)queryWrapper);
            log.info("\u5f53\u524d\u8ba2\u5355\u652f\u4ed8\u8bb0\u5f55: {}", (Object)JSON.toJSONString((Object)outOrderPayment));
            this.refundSelf(outOrderPayment);
        }
        if (responseData.isSuccess()) {
            try {
                this.outInvoiceService.batchCancel(hsRefundDto.getPayOrderNo(), null);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return responseData;
    }

    @PostMapping(value={"/v1/ihosHsRefund"})
    @Operation(description="\u4e92\u533b\u533b\u4fdd\u9000\u6b3e")
    @ApiOperation(value="\u4e92\u533b\u533b\u4fdd\u9000\u6b3e", httpMethod="POST", notes="\u4e92\u533b\u533b\u4fdd\u9000\u6b3e")
    public ResponseData<?> ihosHsRefund(@RequestBody @Valid HsRefundDto hsRefundDto, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return ResponseData.error((String)bindingResult.getFieldError().getDefaultMessage());
        }
        hsRefundDto.setTenantId(this.commonRequest.getTenant());
        hsRefundDto.setOpter(this.commonRequest.getUserId().toString());
        hsRefundDto.setOpterName(this.commonRequest.getUserName());
        hsRefundDto.setOpterType(this.nodeConfig.getOpterType());
        hsRefundDto.setSign_no(this.commonRequest.getSignNo());
        ResponseData responseData = this.outPayService.hsRefund(hsRefundDto);
        if (responseData.isSuccess()) {
            try {
                this.outInvoiceService.batchCancel(hsRefundDto.getPayOrderNo(), null);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return responseData;
    }

    @PostMapping(value={"/v1/onlineHsRefund"})
    @Operation(description="\u7ebf\u4e0a\u533b\u4fdd\u9000\u6b3e")
    @ApiOperation(value="\u7ebf\u4e0a\u533b\u4fdd\u9000\u6b3e", httpMethod="POST", notes="\u7ebf\u4e0a\u533b\u4fdd\u9000\u6b3e")
    public ResponseData onlineHsRefund(@RequestBody @Valid OnlineHsRefundDto onlineHsRefundDto, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return ResponseData.error((String)bindingResult.getFieldError().getDefaultMessage());
        }
        onlineHsRefundDto.setTenantId(this.commonRequest.getTenant());
        onlineHsRefundDto.setOpter(this.commonRequest.getUserId().toString());
        onlineHsRefundDto.setOpterName(this.commonRequest.getUserName());
        onlineHsRefundDto.setOpterType(this.nodeConfig.getOpterType());
        onlineHsRefundDto.setSign_no(this.commonRequest.getSignNo());
        ResponseData responseData = this.outPayService.onlineHsRefund(onlineHsRefundDto);
        if (responseData.isSuccess()) {
            try {
                this.outInvoiceService.batchCancel(onlineHsRefundDto.getPayOrderNo(), null);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return responseData;
    }

    @PostMapping(value={"/v1/wisdomPay"})
    @Operation(description="\u667a\u6167\u5c31\u533b\u4fdd\u5b58\u8ba2\u5355\u6570\u636e")
    @ApiOperation(value="\u667a\u6167\u5c31\u533b\u4fdd\u5b58\u8ba2\u5355\u6570\u636e", httpMethod="POST", notes="\u667a\u6167\u5c31\u533b\u4fdd\u5b58\u8ba2\u5355\u6570\u636e")
    public ResponseData wisdomPay(@RequestBody @Valid HsPayDto hsPayDto, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return ResponseData.error((String)bindingResult.getFieldError().getDefaultMessage());
        }
        hsPayDto.setTenantId(this.commonRequest.getTenant());
        hsPayDto.setOpter(this.commonRequest.getUserId().toString());
        hsPayDto.setOpter_name(this.commonRequest.getUserName());
        hsPayDto.setOpter_type(this.nodeConfig.getOpterType());
        return this.outPayService.wisdomPay(hsPayDto);
    }

    @UserOptLogger(operation="\u667a\u6167\u5c31\u533b\u533b\u4fdd\u9884\u7ed3\u7b97")
    @PostMapping(value={"/v1/wisHsPreparePayment"})
    @Operation(description="\u667a\u6167\u5c31\u533b\u533b\u4fdd\u9884\u7ed3\u7b97")
    @ApiOperation(value="\u667a\u6167\u5c31\u533b\u533b\u4fdd\u9884\u7ed3\u7b97", httpMethod="POST", notes="\u667a\u6167\u5c31\u533b\u533b\u4fdd\u9884\u7ed3\u7b97")
    public ResponseData<?> wisHsPreparePayment(@RequestBody @Valid HsPreparePayDto hsPreparePayDto, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return ResponseData.error((String)bindingResult.getFieldError().getDefaultMessage());
        }
        hsPreparePayDto.setTenantId(this.commonRequest.getTenant());
        hsPreparePayDto.setOpter(String.valueOf(this.commonRequest.getUserId()));
        hsPreparePayDto.setOpter_name(this.commonRequest.getUserName());
        hsPreparePayDto.setOpter_type(this.nodeConfig.getOpterType());
        hsPreparePayDto.setSign_no(this.commonRequest.getSignNo());
        return this.outPayService.wisHsPreparePayment(hsPreparePayDto);
    }

    @UserOptLogger(operation="\u590d\u8bca\u5904\u65b9\u533b\u4fdd\u9884\u7ed3\u7b97")
    @PostMapping(value={"/v1/ihosHsPreparePayment"})
    @Operation(description="\u590d\u8bca\u5904\u65b9\u533b\u4fdd\u9884\u7ed3\u7b97")
    @ApiOperation(value="\u590d\u8bca\u5904\u65b9\u533b\u4fdd\u9884\u7ed3\u7b97", httpMethod="POST", notes="\u590d\u8bca\u5904\u65b9\u533b\u4fdd\u9884\u7ed3\u7b97")
    public ResponseData<?> ihosHsPreparePayment(@RequestBody @Valid HsPreparePayDto hsPreparePayDto, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return ResponseData.error((String)bindingResult.getFieldError().getDefaultMessage());
        }
        hsPreparePayDto.setTenantId(this.commonRequest.getTenant());
        hsPreparePayDto.setOpter(String.valueOf(this.commonRequest.getUserId()));
        hsPreparePayDto.setOpter_name(this.commonRequest.getUserName());
        hsPreparePayDto.setOpter_type(this.nodeConfig.getOpterType());
        hsPreparePayDto.setSign_no(this.commonRequest.getSignNo());
        return this.outPayService.ihosHsPreparePayment(hsPreparePayDto);
    }

    @GetMapping(value={"/test1"})
    public ResponseData test1() {
        ResponseData sysDoctorList = this.sysServiceFeign.doctorByDept(Integer.valueOf(25));
        log.info("\u81ea\u52a9\u673a\u6536\u8d39\u79d1\u5ba4: {}", (Object)JSONObject.toJSONString((Object)sysDoctorList));
        return sysDoctorList;
    }

    public void refundSelf(OutOrderPayment outOrderPayment) {
        List list;
        boolean exists;
        log.info("\u5373\u5c06\u5f00\u59cb\u81ea\u52a9\u673a\u9000\u8d39!!");
        if (BigDecimal.ZERO.compareTo(outOrderPayment.getOwnCost()) == 0) {
            log.info("\u81ea\u52a9\u673a\u9000\u8d39\u9662\u5185\u652f\u4ed8\u5355\u53f7{},\u5f53\u524d\u73b0\u91d1\u652f\u4ed8\u91d1\u989d\u7b49\u4e8e\u96f6", (Object)outOrderPayment.getPayOrderNo());
            return;
        }
        ResponseData sysDoctorList = this.sysServiceFeign.doctorByDept(Integer.valueOf(25));
        log.info("\u81ea\u52a9\u673a\u6536\u8d39\u79d1\u5ba4: {}", (Object)JSONObject.toJSONString((Object)sysDoctorList));
        if (sysDoctorList.getData() != null && !((List)sysDoctorList.getData()).isEmpty() && (exists = (list = (List)sysDoctorList.getData()).stream().anyMatch(item -> item.getJobNumber().equals(String.valueOf(outOrderPayment.getCheckerId()))))) {
            switch (outOrderPayment.getCheckerId()) {
                case 8001: {
                    this.selfRefundBy8001(outOrderPayment);
                    break;
                }
                case 7001: {
                    this.selfRefundBy7001(outOrderPayment);
                }
            }
        }
    }

    private void selfRefundBy7001(OutOrderPayment outOrderPayment) {
        String REFUND_URL = "http://171.34.133.170:9091/wxPay/refund";
        String API_KEY = "3F634C6B6BA3527EFDEAAF3506C4ADDC";
        JSONObject inParam = new JSONObject();
        inParam.put("key", (Object)"3F634C6B6BA3527EFDEAAF3506C4ADDC");
        inParam.put("outRefundNo", (Object)UUIDUtils.getRandom((int)5, (boolean)true));
        inParam.put("outTradeNo", (Object)outOrderPayment.getPaymentTransactionNo());
        BigDecimal fenFactor = new BigDecimal("100");
        Integer refundAmt = outOrderPayment.getOwnCost().setScale(2, RoundingMode.HALF_UP).multiply(fenFactor).intValue();
        inParam.put("totalFee", (Object)refundAmt);
        inParam.put("refundFee", (Object)refundAmt);
        String refundResponse = HttpRequest.post((String)"http://171.34.133.170:9091/wxPay/refund").contentType("application/json").body(inParam.toJSONString()).execute().body();
        log.info("\u5fae\u76df\u81ea\u52a9\u673a\u9000\u8d39\u9662\u5185\u652f\u4ed8\u5355\u53f7:{},\u53cd\u53c2\u62a5\u6587\uff1a {}", (Object)outOrderPayment.getPayOrderNo(), (Object)refundResponse);
        JSONObject refundResJson = JSONObject.parseObject((String)refundResponse);
        if (!refundResJson.getString("code").equals("200")) {
            throw new RunDisplayException(refundResJson.getString("message"));
        }
        JSONObject data = refundResJson.getJSONObject("data");
        if ("SUCCESS".equals(data.getString("result_code"))) {
            String refundId = data.getString("refund_id");
            OutOrderPayment refundPayment = new OutOrderPayment();
            refundPayment.setId(outOrderPayment.getId());
            refundPayment.setRefundTransactionNo(refundId);
            int updateCount = this.outOrderPaymentMapper.updateById((Object)refundPayment);
            log.info("\u81ea\u52a9\u673a\u9000\u8d39\u4fee\u6539\u652f\u4ed8\u8bb0\u5f55\uff1a {}", (Object)updateCount);
            return;
        }
        throw new RunDisplayException(data.getString("err_code_des"));
    }

    private void selfRefundBy8001(OutOrderPayment outOrderPayment) {
        String APP_SECRET = "497B3A0F3B6B4F61918F509B6C6AEBF4";
        String AUTH_URL = "http://171.34.133.170:11111//sys-auth/channel/oauth/token";
        String REFUND_URL = "http://171.34.133.170:11111//jdpay/core/refund";
        JSONObject authJsonObject = new JSONObject();
        authJsonObject.put("appKey", (Object)"1719566108352495");
        authJsonObject.put("appSecret", (Object)"497B3A0F3B6B4F61918F509B6C6AEBF4");
        log.info("\u81ea\u52a9\u673a\u9000\u8d39\u7edf\u4e00\u6388\u6743\u5165\u53c2\u62a5\u6587\uff1a {}", (Object)authJsonObject.toJSONString());
        String response = HttpRequest.post((String)"http://171.34.133.170:11111//sys-auth/channel/oauth/token").contentType("application/json").body(authJsonObject.toJSONString()).execute().body();
        log.info("\u81ea\u52a9\u673a\u9000\u8d39\u7edf\u4e00\u6388\u6743\u53cd\u53c2\u62a5\u6587\uff1a {}", (Object)response);
        JSONObject authResponse = JSONObject.parseObject((String)response);
        String accessToken = authResponse.getJSONObject("result").getString("accessToken");
        HashMap<String, Object> refundParam = new HashMap<String, Object>();
        refundParam.put("org_code", "64121");
        refundParam.put("mch_appid", "1719566108352495");
        refundParam.put("mch_order_id", UUIDUtils.getRandom((int)5, (boolean)true));
        refundParam.put("pay_out_trade_no", outOrderPayment.getPaymentTransactionNo());
        refundParam.put("refund_amt", outOrderPayment.getOwnCost().setScale(2, RoundingMode.HALF_UP));
        refundParam.put("refund_reason", "\u4ea4\u6613\u53d6\u6d88-\u9000\u6b3e");
        String signature = PayOfflinePaymentImpl.generateSignature(refundParam, (String)"497B3A0F3B6B4F61918F509B6C6AEBF4");
        refundParam.put("sign", SecureUtil.md5((String)(signature + "497B3A0F3B6B4F61918F509B6C6AEBF4")));
        refundParam.put("sign_type", "MD5");
        log.info("\u81ea\u52a9\u673a\u9000\u8d39,\u9662\u5185\u652f\u4ed8\u5355\u53f7:{},\u5165\u53c2\u62a5\u6587\uff1a {}", (Object)outOrderPayment.getPayOrderNo(), (Object)JSONObject.toJSONString(refundParam));
        String refundResponse = ((HttpRequest)HttpRequest.post((String)"http://171.34.133.170:11111//jdpay/core/refund").contentType("application/json").header("Authorization-Token", accessToken)).body(JSONObject.toJSONString(refundParam)).execute().body();
        log.info("\u81ea\u52a9\u673a\u9000\u8d39 \u9662\u5185\u652f\u4ed8\u5355\u53f7:{},\u53cd\u53c2\u62a5\u6587\uff1a {}", (Object)outOrderPayment.getPayOrderNo(), (Object)refundResponse);
        JSONObject refundResJson = JSONObject.parseObject((String)refundResponse);
        if (!refundResJson.getString("code").equals("200")) {
            throw new RunDisplayException(refundResJson.getString("message"));
        }
        String outTradeNo = refundResJson.getJSONObject("result").getString("out_trade_no");
        OutOrderPayment refundPayment = new OutOrderPayment();
        refundPayment.setId(outOrderPayment.getId());
        refundPayment.setRefundTransactionNo(outTradeNo);
        int updateCount = this.outOrderPaymentMapper.updateById((Object)refundPayment);
        log.info("\u81ea\u52a9\u673a\u9000\u8d39\u4fee\u6539\u652f\u4ed8\u8bb0\u5f55\uff1a {}", (Object)updateCount);
    }

    @UserOptLogger(operation="\u79fb\u52a8\u7aef\u533b\u4fdd\u9884\u652f\u4ed8")
    @PostMapping(value={"/moveHsPreparePayment"})
    @Operation(description="\u79fb\u52a8\u7aef\u533b\u4fdd\u9884\u652f\u4ed8")
    @ApiOperation(value="\u79fb\u52a8\u7aef\u533b\u4fdd\u9884\u652f\u4ed8", httpMethod="POST", notes="\u79fb\u52a8\u7aef\u533b\u4fdd\u9884\u652f\u4ed8")
    public ResponseData<?> moveHsPreparePayment(@RequestBody HsPreparePayDto hsPreparePayDto) {
        hsPreparePayDto.setTenantId(this.commonRequest.getTenant());
        hsPreparePayDto.setOpter("9001");
        hsPreparePayDto.setOpter_name("XHY");
        hsPreparePayDto.setOpter_type("3");
        hsPreparePayDto.setSign_no("999999");
        ResponseData responseData = this.outPayService.moveHsPreparePayment(hsPreparePayDto);
        if (!"200".equals(responseData.getCode())) {
            return ResponseData.error((String)responseData.getMsg());
        }
        return responseData;
    }

    @UserOptLogger(operation="\u79fb\u52a8\u7aef\u533b\u4fdd\u8ba2\u5355\u7ed3\u7b97\u7ed3\u679c\u67e5\u8be2")
    @PostMapping(value={"/moveOrderInfo"})
    @Operation(description="\u79fb\u52a8\u7aef\u533b\u4fdd\u8ba2\u5355\u7ed3\u7b97\u7ed3\u679c\u67e5\u8be2")
    @ApiOperation(value="\u79fb\u52a8\u7aef\u533b\u4fdd\u8ba2\u5355\u7ed3\u7b97\u7ed3\u679c\u67e5\u8be2", httpMethod="POST", notes="\u79fb\u52a8\u7aef\u533b\u4fdd\u8ba2\u5355\u7ed3\u7b97\u7ed3\u679c\u67e5\u8be2")
    public ResponseData<?> moveOrderInfo(@RequestBody MoveOrderInfoRequest moveOrderInfoRequest) {
        return this.outPayService.moveOrderInfo(moveOrderInfoRequest);
    }

    @PostMapping(value={"/payNotify"})
    @ApiOperation(value="\u652f\u4ed8\u56de\u8c03", httpMethod="POST", notes="\u652f\u4ed8\u56de\u8c03")
    public ResponseData<?> payNotify(@RequestBody MoveOrderInfoRequest moveOrderInfoRequest) {
        moveOrderInfoRequest.setTenantId(this.commonRequest.getTenant());
        moveOrderInfoRequest.setOpter("9001");
        moveOrderInfoRequest.setOpter_name("XHY");
        moveOrderInfoRequest.setOpter_type("3");
        return this.outPayService.payNotify(moveOrderInfoRequest);
    }

    @PostMapping(value={"/refundNotify"})
    @ApiOperation(value="\u9000\u6b3e\u56de\u8c03", httpMethod="POST", notes="\u9000\u6b3e\u56de\u8c03")
    public ResponseData<?> refundNotify(@RequestBody MoveOrderInfoRequest moveOrderInfoRequest) {
        moveOrderInfoRequest.setTenantId(this.commonRequest.getTenant());
        moveOrderInfoRequest.setOpter("9001");
        moveOrderInfoRequest.setOpter_name("XHY");
        moveOrderInfoRequest.setOpter_type("3");
        return this.outPayService.refundNotify(moveOrderInfoRequest);
    }
}

