/*
 * Decompiled with CFR 0.152.
 */
package com.byh.outpatient.web.mvc.controller;

import com.alibaba.fastjson.JSONObject;
import com.byh.outpatient.api.dto.medicalRecord.PatientInfoDto;
import com.byh.outpatient.api.dto.patient.CheckCardNoCorrectnessDto;
import com.byh.outpatient.api.dto.patient.ExportPatientDto;
import com.byh.outpatient.api.dto.patient.HsPatientInfoDto;
import com.byh.outpatient.api.dto.patient.PatientNameDto;
import com.byh.outpatient.api.dto.patient.QueryPatientDto;
import com.byh.outpatient.api.excel.PatientImportVo;
import com.byh.outpatient.api.excel.PatientListener;
import com.byh.outpatient.api.model.hsSettlement.HsSettlementInfoNewEntity;
import com.byh.outpatient.api.model.patient.PatientEntity;
import com.byh.outpatient.api.model.patient.PatientFamilyEntity;
import com.byh.outpatient.api.util.BeanUtil;
import com.byh.outpatient.api.util.EasyExcelUtil;
import com.byh.outpatient.api.util.PageResult;
import com.byh.outpatient.api.util.ResponseData;
import com.byh.outpatient.api.util.StringUtil;
import com.byh.outpatient.api.vo.patient.HsPatientInfoVo;
import com.byh.outpatient.web.aspect.UserOptLogger;
import com.byh.outpatient.web.mvc.utils.CommonRequest;
import com.byh.outpatient.web.service.PatientService;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/patient"})
public class PatientController {
    private static final Logger log = LoggerFactory.getLogger(PatientController.class);
    @Autowired
    private PatientService patientService;
    @Autowired
    private CommonRequest commonRequest;

    @ApiOperation(value="\u6821\u9a8c\u60a3\u8005\u8bc1\u4ef6\u53f7\u7801\u6b63\u786e\u6027")
    @PostMapping(value={"/checkCardNoCorrectness"})
    public ResponseData checkCardNoCorrectness(@RequestBody @Valid CheckCardNoCorrectnessDto dto) {
        return ResponseData.success((Object)this.patientService.checkCardNoCorrectness(dto));
    }

    @ApiOperation(value="\u60a3\u8005\u6863\u6848\u5bfc\u51fa")
    @PostMapping(value={"/exportPatientInfoList"})
    public void exportPatientInfoList(HttpServletResponse response, @RequestBody ExportPatientDto dto) {
        this.patientService.exportPatientInfoList(response, dto);
    }

    @ApiOperation(value="\u968f\u673a\u5bfc\u51fa200\u4f4d\u60a3\u8005\u7684\u6025\u8bca\u4fe1\u606f\u3001\u75c5\u5386\u6587\u6863\u3001\u5904\u65b9\u4fe1\u606f")
    @PostMapping(value={"/exportRandomPatientInfoList"})
    public void exportRandomPatientInfoList(HttpServletResponse response) {
        this.patientService.exportRandomPatientInfoList(response);
    }

    @PostMapping(value={"/HsSettlementInfoByPatient"})
    public ResponseData<PageInfo<HsSettlementInfoNewEntity>> HsSettlementInfoByPatient(@RequestBody PatientEntity patient) {
        Integer tenantId = this.commonRequest.getTenant();
        patient.setTenantId(tenantId);
        return this.patientService.HsSettlementInfoByPatient(patient);
    }

    @UserOptLogger(operation="\u63d2\u5165\u60a3\u8005")
    @PostMapping(value={"/insert"})
    @ApiOperation(value="\u63d2\u5165\u60a3\u8005\u4fe1\u606f", httpMethod="POST", notes="\u63d2\u5165\u60a3\u8005\u4fe1\u606f")
    public ResponseData insert(@RequestBody PatientEntity patient) {
        Integer tenantId = this.commonRequest.getTenant();
        patient.setTenantId(tenantId);
        return this.patientService.insert(patient);
    }

    @UserOptLogger(operation="\u63d2\u5165\u60a3\u8005\u8be6\u7ec6\u4fe1\u606f")
    @PostMapping(value={"/insertPatientDetail"})
    @ApiOperation(value="\u63d2\u5165\u60a3\u8005\u8be6\u7ec6\u4fe1\u606f", httpMethod="POST", notes="\u63d2\u5165\u60a3\u8005\u8be6\u7ec6\u4fe1\u606f")
    public ResponseData insertPatientDetail(@RequestBody PatientInfoDto patient) {
        Integer tenantId = this.commonRequest.getTenant();
        patient.setTenantId(tenantId);
        Integer userId = this.commonRequest.getUserId();
        String userName = this.commonRequest.getUserName();
        patient.setUserId(userId);
        patient.setUserName(userName);
        String name = patient.getName();
        String phone = patient.getPhone();
        String cardType = patient.getCardType();
        String cardNo = patient.getCardNo();
        String sex = patient.getSex();
        Integer age = patient.getAge();
        if (StringUtil.isBlank((String)name) || StringUtil.isBlank((String)phone) || StringUtil.isBlank((String)cardType) || StringUtil.isBlank((String)cardNo) || StringUtil.isBlank((String)sex) || age == null) {
            return ResponseData.error((String)"\u5fc5\u8981\u53c2\u6570\u4e3a\u7a7a");
        }
        return this.patientService.insertPatientDetail(patient);
    }

    @UserOptLogger(operation="\u6839\u636e\u95e8\u8bca\u53f7\u67e5\u8be2\u60a3\u8005\u6863\u6848")
    @PostMapping(value={"/queryPatientByOutpatientNo"})
    @ApiOperation(value="\u6839\u636e\u95e8\u8bca\u53f7\u67e5\u8be2\u60a3\u8005\u6863\u6848", httpMethod="GET", notes="\u6839\u636e\u95e8\u8bca\u53f7\u67e5\u8be2\u60a3\u8005\u6863\u6848")
    public ResponseData queryPatientByOutpatientNo(@RequestBody PatientEntity patient) {
        Integer tenantId = this.commonRequest.getTenant();
        patient.setTenantId(tenantId);
        return this.patientService.insert(patient);
    }

    @GetMapping(value={"/queryPatientByCardNo"})
    @ApiOperation(value="\u6839\u636e\u8bc1\u4ef6\u53f7\u67e5\u8be2\u60a3\u8005\u4fe1\u606f", httpMethod="GET", notes="\u6839\u636e\u8bc1\u4ef6\u53f7\u67e5\u8be2\u60a3\u8005\u4fe1\u606f")
    public ResponseData queryPatientByCardNo(@RequestParam(value="cardNo", required=true) String cardNo) {
        Integer tenantId = this.commonRequest.getTenant();
        log.info("\u67e5\u8be2\u60a3\u8005\u4fe1\u606ftenantId:{},cardNo:{}", (Object)tenantId, (Object)cardNo);
        return this.patientService.queryPatientByCardNo(cardNo, tenantId);
    }

    @UserOptLogger(operation="\u63d2\u5165\u60a3\u8005\u5bb6\u5ead\u4fe1\u606f")
    @PostMapping(value={"/insertPatientFamily"})
    @ApiOperation(value="\u63d2\u5165\u60a3\u8005\u5bb6\u5ead\u4fe1\u606f", httpMethod="POST", notes="\u63d2\u5165\u60a3\u8005\u5bb6\u5ead\u4fe1\u606f")
    public ResponseData insertPatientFamily(@RequestBody PatientFamilyEntity patientFamily) {
        Integer tenantId = this.commonRequest.getTenant();
        patientFamily.setTenantId(tenantId);
        return this.patientService.insertPatientFamily(patientFamily);
    }

    @UserOptLogger(operation="\u5220\u9664\u60a3\u8005\u4fe1\u606f")
    @GetMapping(value={"/deleteById"})
    @ApiOperation(value="\u5220\u9664\u60a3\u8005\u4fe1\u606f", httpMethod="GET", notes="\u5220\u9664\u60a3\u8005\u4fe1\u606f")
    public ResponseData deleteById(@RequestParam(value="id", required=true) Integer id) {
        return this.patientService.deleteById(id);
    }

    @UserOptLogger(operation="\u5220\u9664\u60a3\u8005\u5bb6\u5ead\u4fe1\u606f")
    @GetMapping(value={"/deletePatientFamilyById"})
    @ApiOperation(value="\u5220\u9664\u60a3\u8005\u5bb6\u5ead\u4fe1\u606f", httpMethod="GET", notes="\u5220\u9664\u60a3\u8005\u5bb6\u5ead\u4fe1\u606f")
    public ResponseData deletePatientFamilyById(@RequestParam(value="id", required=true) Integer id) {
        return this.patientService.deletePatientFamilyById(id);
    }

    @UserOptLogger(operation="\u66f4\u65b0\u60a3\u8005\u57fa\u7840\u4fe1\u606f")
    @PostMapping(value={"/updateById"})
    @ApiOperation(value="\u66f4\u65b0\u60a3\u8005\u57fa\u7840\u4fe1\u606f", httpMethod="POST", notes="\u66f4\u65b0\u60a3\u8005\u57fa\u7840\u4fe1\u606f")
    public ResponseData update(@RequestBody PatientEntity patient) {
        Integer tenantId = this.commonRequest.getTenant();
        patient.setTenantId(tenantId);
        return this.patientService.updateById(patient);
    }

    @UserOptLogger(operation="\u66f4\u65b0\u60a3\u8005\u5bb6\u5ead\u4fe1\u606f")
    @PostMapping(value={"/updatePatientFamilyById"})
    @ApiOperation(value="\u66f4\u65b0\u60a3\u8005\u5bb6\u5ead\u4fe1\u606f", httpMethod="POST", notes="\u66f4\u65b0\u60a3\u8005\u5bb6\u5ead\u4fe1\u606f")
    public ResponseData updatePatientFamilyById(@RequestBody PatientFamilyEntity patientFamily) {
        Integer tenantId = this.commonRequest.getTenant();
        patientFamily.setTenantId(tenantId);
        return this.patientService.updatePatientFamilyById(patientFamily);
    }

    @GetMapping(value={"/queryById"})
    @ApiOperation(value="\u6839\u636eid \u67e5\u8be2\u60a3\u8005\u4fe1\u606f", httpMethod="GET", notes="\u6839\u636eid \u67e5\u8be2\u60a3\u8005\u4fe1\u606f")
    public ResponseData<PatientEntity> queryById(@RequestParam(value="id", required=true) Integer id) {
        return this.patientService.queryById(id);
    }

    @UserOptLogger(operation="\u66f4\u65b0\u60a3\u8005\u5bb6\u5ead\u4fe1\u606f")
    @GetMapping(value={"/queryPatientFamilyById"})
    @ApiOperation(value="\u66f4\u65b0\u60a3\u8005\u5bb6\u5ead\u4fe1\u606f", httpMethod="GET", notes="\u66f4\u65b0\u60a3\u8005\u5bb6\u5ead\u4fe1\u606f")
    public ResponseData queryPatientFamilyById(int id) {
        return this.patientService.queryPatientFamilyById(Integer.valueOf(id));
    }

    @PostMapping(value={"/queryPatient"})
    @ApiOperation(value="\u67e5\u8be2", httpMethod="POST", notes="\u67e5\u8be2")
    public ResponseData<PageResult<PatientEntity>> queryPatient(@RequestBody @Valid QueryPatientDto queryPatientDto, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return ResponseData.error((String)bindingResult.getFieldError().getDefaultMessage());
        }
        Integer tenantId = this.commonRequest.getTenant();
        queryPatientDto.setTenantId(tenantId);
        Integer userId = this.commonRequest.getUserId();
        queryPatientDto.setUserId(userId);
        return this.patientService.queryPatient(queryPatientDto);
    }

    @PostMapping(value={"/queryPatientByName"})
    @ApiOperation(value="\u6839\u636e\u540d\u5b57\u6a21\u7cca\u67e5\u8be2", httpMethod="POST", notes="\u6839\u636e\u540d\u5b57\u6a21\u7cca\u67e5\u8be2")
    public ResponseData<PatientEntity> queryPatientByName(@RequestBody PatientNameDto patientNameDto) {
        Integer tenantId = this.commonRequest.getTenant();
        patientNameDto.setTenantId(tenantId);
        return this.patientService.queryPatientByName(patientNameDto);
    }

    @UserOptLogger(operation="\u652f\u4ed8\u65f6\u83b7\u53d6\u53c2\u4fdd\u4fe1\u606f")
    @PostMapping(value={"/queryPatientHsInfo"})
    @ApiOperation(value="\u652f\u4ed8\u65f6\u83b7\u53d6\u53c2\u4fdd\u4fe1\u606f", httpMethod="POST", notes="\u652f\u4ed8\u65f6\u83b7\u53d6\u53c2\u4fdd\u4fe1\u606f")
    public ResponseData<HsPatientInfoVo> queryPatientInfoByEcCode(@RequestBody HsPatientInfoDto hsPatientInfoDto) {
        log.info("\u652f\u4ed8\u65f6\u83b7\u53d6\u53c2\u4fdd\u4fe1\u606f\uff1a{}", (Object)JSONObject.toJSONString((Object)hsPatientInfoDto));
        hsPatientInfoDto.setTenantId(this.commonRequest.getTenant());
        hsPatientInfoDto.setOpter(this.commonRequest.getUserId());
        hsPatientInfoDto.setOpterName(this.commonRequest.getUserName());
        return this.patientService.queryPatientInfoByEcCode(hsPatientInfoDto);
    }

    @PostMapping(value={"/queryRegPatientHsInfo"})
    @ApiOperation(value="\u6302\u53f7\u65f6\u83b7\u53d6\u53c2\u4fdd\u4fe1\u606f", httpMethod="POST", notes="\u83b7\u53d6\u53c2\u4fdd\u4fe1\u606f")
    public ResponseData<HsPatientInfoVo> queryRegPatientHsInfo(@RequestBody HsPatientInfoDto hsPatientInfoDto) {
        log.info("\u6302\u53f7\u65f6\u83b7\u53d6\u53c2\u4fdd\u4fe1\u606f\uff1a{}", (Object)JSONObject.toJSONString((Object)hsPatientInfoDto));
        hsPatientInfoDto.setTenantId(this.commonRequest.getTenant());
        hsPatientInfoDto.setOpter(this.commonRequest.getUserId());
        hsPatientInfoDto.setOpterName(this.commonRequest.getUserName());
        return this.patientService.queryRegPatientHsInfo(hsPatientInfoDto);
    }

    @PostMapping(value={"/importPatientExcel"})
    @ApiOperation(value="\u5bfc\u5165\u60a3\u8005\u6863\u6848", httpMethod="GET", notes="\u5bfc\u5165\u60a3\u8005\u6863\u6848")
    public ResponseData importPatientExcel(@RequestParam(value="file") MultipartFile file) throws IOException {
        Integer tenant = this.commonRequest.getTenant();
        List importVos = EasyExcelUtil.importExcel((MultipartFile)file, (Object)new PatientImportVo(), (Object)new PatientListener());
        List patientList = BeanUtil.copyList((List)importVos, PatientEntity.class);
        patientList.forEach(item -> item.setTenantId(tenant));
        return this.patientService.insertImport(patientList);
    }

    @PostMapping(value={"/importPatient"})
    @ApiOperation(value="\u5bfc\u5165\u60a3\u8005\u6863\u6848", httpMethod="GET", notes="\u5bfc\u5165\u60a3\u8005\u6863\u6848")
    public ResponseData importPatient(@RequestBody List<PatientEntity> patientList) throws IOException {
        Integer tenant = this.commonRequest.getTenant();
        patientList.forEach(item -> {
            item.setTenantId(tenant);
            item.setCardType("01");
        });
        return this.patientService.insertImport(patientList);
    }
}

