/*
 * Decompiled with CFR 0.152.
 */
package com.byh.outpatient.web.mvc.controller;

import com.byh.outpatient.api.dto.FirstPaymentDto;
import com.byh.outpatient.api.excel.FirstPaymentExcel;
import com.byh.outpatient.api.util.BeanUtil;
import com.byh.outpatient.api.util.EasyExcelUtil;
import com.byh.outpatient.api.util.ResponseData;
import com.byh.outpatient.web.mvc.utils.CommonRequest;
import com.byh.outpatient.web.service.PatientService;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.ApiOperation;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/firstPayment"})
public class FirstPaymentController {
    private static final Logger log = LoggerFactory.getLogger(FirstPaymentController.class);
    @Autowired
    private PatientService patientService;
    @Autowired
    private CommonRequest commonRequest;

    @ApiOperation(value="\u60a3\u8005\u9996\u6b21\u8d2d\u836f\u8be6\u60c5")
    @PostMapping(value={"/queryFirstPayment"})
    public ResponseData<PageInfo<FirstPaymentDto>> queryFirstPayment(HttpServletResponse response, @RequestBody FirstPaymentDto dto) throws ParseException {
        Integer tenant = this.commonRequest.getTenant();
        dto.setTenantId(tenant);
        String endTime = dto.getEndTime();
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        Date parse = format.parse(endTime);
        Calendar instance = Calendar.getInstance();
        instance.setTime(parse);
        instance.add(5, 1);
        dto.setEndTime(format.format(instance.getTime()));
        return this.patientService.queryFirstPayment(dto);
    }

    @ApiOperation(value="\u5bfc\u51fa\u60a3\u8005\u9996\u6b21\u8d2d\u836f\u8be6\u60c5")
    @PostMapping(value={"/exportFirstPayment"})
    public void exportFirstPayment(HttpServletResponse response, @RequestBody FirstPaymentDto dto) throws ParseException {
        dto.setCurrent(Integer.valueOf(1));
        dto.setSize(Integer.valueOf(999999999));
        Integer tenant = this.commonRequest.getTenant();
        dto.setTenantId(tenant);
        String endTime = dto.getEndTime();
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        Date parse = format.parse(endTime);
        Calendar instance = Calendar.getInstance();
        instance.setTime(parse);
        instance.add(5, 1);
        dto.setEndTime(format.format(instance.getTime()));
        ResponseData pageInfoResponseData = this.patientService.queryFirstPaymentExport(dto);
        List list = ((PageInfo)pageInfoResponseData.getData()).getList();
        List firstPaymentExcels = BeanUtil.copyList((List)list, FirstPaymentExcel.class);
        String name = "";
        Integer isFirst = dto.getIsFirst();
        switch (isFirst) {
            case 0: {
                name = "\u8d2d\u836f\u8be6\u60c5";
                break;
            }
            case 1: {
                name = "\u9996\u8d2d\u8be6\u60c5";
                break;
            }
            case 2: {
                name = "\u590d\u8d2d\u8be6\u60c5";
            }
        }
        EasyExcelUtil.exportExcelMerge2((HttpServletResponse)response, (String)name, (String)name, (List)firstPaymentExcels, FirstPaymentExcel.class);
    }
}

