/*
 * Decompiled with CFR 0.152.
 */
package com.byh.outpatient.web.mvc.controller;

import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.byh.outpatient.api.dto.binding.DoctorTypeDto;
import com.byh.outpatient.api.dto.binding.OutDoctorTypeDTO;
import com.byh.outpatient.api.exception.BusinessException;
import com.byh.outpatient.api.model.binding.OutDoctorTypeEntity;
import com.byh.outpatient.api.util.ResponseData;
import com.byh.outpatient.web.aspect.UserOptLogger;
import com.byh.outpatient.web.mvc.utils.CommonRequest;
import com.byh.outpatient.web.service.OutDoctorTypeService;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/outDoctorType"})
public class OutDoctorTypeController {
    private static Logger logger = LoggerFactory.getLogger(OutDoctorTypeController.class);
    private final OutDoctorTypeService outDoctorTypeService;
    private final CommonRequest commonRequest;

    @ApiOperation(value="\u5206\u9875", httpMethod="GET", notes="\u5206\u9875")
    @GetMapping(value={"/pageList"})
    public ResponseData pageList(Page page, OutDoctorTypeDTO dto) {
        Integer tenantId = this.commonRequest.getTenant();
        dto.setTenantId(tenantId);
        return ResponseData.success((Object)this.outDoctorTypeService.pageList(page, dto));
    }

    @ApiOperation(value="\u5217\u8868", httpMethod="GET", notes="\u5217\u8868")
    @GetMapping(value={"/queryList"})
    public ResponseData queryList(DoctorTypeDto dto) {
        Integer tenantId = this.commonRequest.getTenant();
        dto.setTenantId(tenantId);
        return ResponseData.success((Object)this.outDoctorTypeService.queryList(dto));
    }

    @UserOptLogger(operation="\u533b\u751f\u7ed1\u5b9a\u95e8\u8bca\u7c7b\u578b\u8868\u3010\u81ea\u52a9\u673a\u4f7f\u7528\u3011")
    @PostMapping(value={"/saveUpdate"})
    @Transactional(rollbackFor={BusinessException.class})
    @ApiOperation(value="\u65b0\u589e\u6216\u4fee\u6539", httpMethod="POST", notes="\u65b0\u589e\u6216\u4fee\u6539")
    public ResponseData saveUpdates(@RequestBody OutDoctorTypeEntity entity) {
        Integer tenantId = this.commonRequest.getTenant();
        entity.setTenantId(tenantId);
        String id = entity.getId();
        if (StrUtil.isEmpty((CharSequence)id)) {
            this.outDoctorTypeService.save((Object)entity);
        } else {
            this.outDoctorTypeService.updateById((Object)entity);
        }
        return ResponseData.success();
    }

    @GetMapping(value={"/details"})
    @ApiOperation(value="\u8be6\u60c5", httpMethod="GET", notes="\u8be6\u60c5")
    public ResponseData details(OutDoctorTypeEntity entity) {
        Integer tenantId = this.commonRequest.getTenant();
        entity.setTenantId(tenantId);
        return ResponseData.success((Object)this.outDoctorTypeService.details(entity));
    }

    @UserOptLogger(operation="\u533b\u751f\u7ed1\u5b9a\u95e8\u8bca\u7c7b\u578b\u8868\u3010\u81ea\u52a9\u673a\u4f7f\u7528\u3011")
    @PostMapping(value={"/removeDoctorType"})
    @ApiOperation(value="\u6279\u91cf\u5220\u9664", httpMethod="POST", notes="\u6279\u91cf\u5220\u9664")
    public ResponseData removeDoctorType(@ApiParam(value="\u4e3b\u952e\u96c6\u5408", required=true) @RequestBody String[] ids) {
        return ResponseData.success((Object)this.outDoctorTypeService.removeDoctorType(ids));
    }

    public OutDoctorTypeController(OutDoctorTypeService outDoctorTypeService, CommonRequest commonRequest) {
        this.outDoctorTypeService = outDoctorTypeService;
        this.commonRequest = commonRequest;
    }
}

