/*
 * Decompiled with CFR 0.152.
 */
package com.byh.outpatient.web.service.impl;

import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.byh.outpatient.api.dto.history.OutpatientHistoryDto;
import com.byh.outpatient.api.model.history.OutpatientHistoryEntity;
import com.byh.outpatient.api.sdkModel.OrdSeeDoctorRecordEntity;
import com.byh.outpatient.data.repository.OutpatientHistoryMapper;
import com.byh.outpatient.web.mvc.utils.CommonRequest;
import com.byh.outpatient.web.service.OutpatientHistoryService;
import java.util.List;
import org.springframework.stereotype.Service;

@Service
public class OutpatientHistoryServiceImpl
extends ServiceImpl<OutpatientHistoryMapper, OutpatientHistoryEntity>
implements OutpatientHistoryService {
    private final CommonRequest commonRequest;

    public void timingInsertRecord(List<OrdSeeDoctorRecordEntity> list) {
        list.forEach(entity -> {
            OutpatientHistoryEntity history = new OutpatientHistoryEntity();
            history.setMedicalRecordNo(entity.getCardNo());
            history.setName(entity.getPatientName());
            history.setPhone(entity.getTel());
            history.setSexName(entity.getSexName());
            history.setAge(entity.getAge());
            history.setIdCard(entity.getIdenNo());
            history.setVisitDepartment(entity.getSeeDeptNm());
            history.setVisitPhysician(entity.getSeeDoctNm());
            history.setVisitTime(entity.getSeeDate());
            history.setSpendAmount(entity.getTotCost() == null ? "0" : String.valueOf(entity.getTotCost()));
            history.setDiagnosCodeOne(entity.getDiagCode1());
            history.setDiagnosNameOne(entity.getDiagName1());
            history.setDispose(entity.getTreatment());
            history.setStatusName("0".equals(entity.getStatus()) ? "\u6709\u6548" : "\u65e0\u6548");
            history.setPersonInsuranceCode(entity.getMcardNo());
            history.setCareer(entity.getProfName());
            history.setDiagnosCodeTwo(entity.getDiagCode2());
            history.setDiagnosNameTwo(entity.getDiagName2());
            history.setComplaints(entity.getHostTell());
            history.setPresentHistory(entity.getCurrentIllness());
            history.setPastHistory(entity.getAnamnesis());
            history.setAllergyHistory(entity.getAllergen());
            history.setPhysical(entity.getCheckBody());
            history.setMarriageHistory("1".equals(entity.getMarri()) ? "\u5df2\u5a5a" : "\u672a\u5a5a");
            history.setAddress(entity.getHomeAdd());
            history.setNarrator(entity.getTellOwnerName());
            history.setAllergy("1".equals(entity.getAllergenFlag()) ? "\u662f" : "\u5426");
            history.setRemarks(entity.getRemark());
            history.setTenantId(this.commonRequest.getTenant());
            ((OutpatientHistoryMapper)this.baseMapper).insert((Object)history);
        });
    }

    public IPage<OutpatientHistoryEntity> pageList(Page<OutpatientHistoryEntity> page, OutpatientHistoryDto dto) {
        LambdaQueryWrapper qw = Wrappers.lambdaQuery();
        if (StrUtil.isNotEmpty((CharSequence)dto.getSearch())) {
            qw.and(wrapper -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.like(OutpatientHistoryEntity::getName, (Object)dto.getSearch())).or()).like(OutpatientHistoryEntity::getPhone, (Object)dto.getSearch())).or()).like(OutpatientHistoryEntity::getIdCard, (Object)dto.getSearch());
            });
        }
        if (StrUtil.isNotEmpty((CharSequence)dto.getVisitPhysician())) {
            qw.and(wrapper -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)wrapper.like(OutpatientHistoryEntity::getVisitPhysician, (Object)dto.getVisitPhysician());
            });
        }
        qw.eq(OutpatientHistoryEntity::getTenantId, (Object)this.commonRequest.getTenant());
        qw.orderByDesc(OutpatientHistoryEntity::getVisitTime);
        IPage entityIPage = ((OutpatientHistoryMapper)this.baseMapper).selectPage(page, (Wrapper)qw);
        return entityIPage;
    }

    public OutpatientHistoryServiceImpl(CommonRequest commonRequest) {
        this.commonRequest = commonRequest;
    }
}

