/*
 * Decompiled with CFR 0.152.
 */
package com.byh.outpatient.web.mvc.controller;

import com.byh.outpatient.api.dto.order.CheckDiscountDto;
import com.byh.outpatient.api.dto.order.FeeManagemenDto;
import com.byh.outpatient.api.dto.order.PaymentOrderUpdateDTO;
import com.byh.outpatient.api.dto.order.QueryFeeDetailsDto;
import com.byh.outpatient.api.dto.order.QueryFeeDetailsListDto;
import com.byh.outpatient.api.dto.order.QueryOrderDto;
import com.byh.outpatient.api.dto.order.WriteOffDiscountDto;
import com.byh.outpatient.api.model.order.OutOrder;
import com.byh.outpatient.api.model.order.WisOutOrder;
import com.byh.outpatient.api.util.PageResult;
import com.byh.outpatient.api.util.ResponseData;
import com.byh.outpatient.api.vo.order.QueryFeeDetailsListVo;
import com.byh.outpatient.api.vo.order.QueryFeeDetailsVo;
import com.byh.outpatient.api.vo.order.QueryFeeManagementVo;
import com.byh.outpatient.api.vo.order.QueryFeeOrderPaidItemsVo;
import com.byh.outpatient.web.mvc.utils.CommonRequest;
import com.byh.outpatient.web.service.OutOrderService;
import io.swagger.annotations.ApiOperation;
import io.swagger.v3.oas.annotations.Operation;
import java.util.List;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/outOrder"})
public class OutOrderController {
    @Autowired
    private OutOrderService outOrderService;
    @Autowired
    private CommonRequest commonRequest;

    @ApiOperation(value="\u6839\u636e\u60a3\u8005\u7f16\u53f7\u67e5\u8be2\u60a3\u8005\u62e5\u6709\u591a\u5c11\u5f20\u4f18\u60e0\u5238")
    @PostMapping(value={"/selectDiscountNumByPatientId"})
    public ResponseData selectDiscountNumByPatientId(@RequestBody @Valid CheckDiscountDto dto) {
        return ResponseData.success((Object)this.outOrderService.selectDiscountNumByPatientId(dto));
    }

    @ApiOperation(value="\u6838\u9500\u60a3\u8005\u4f18\u60e0\u5238")
    @PostMapping(value={"/writeOffDiscount"})
    public ResponseData writeOffDiscount(@RequestBody @Valid WriteOffDiscountDto dto) {
        dto.setTenantId(this.commonRequest.getTenant());
        dto.setOperatorName(this.commonRequest.getUserName());
        this.outOrderService.writeOffDiscount(dto);
        return ResponseData.success((Object)"\u4f18\u60e0\u5238\u6838\u9500\u6210\u529f\uff01");
    }

    @ApiOperation(value="\u6839\u636e\u60a3\u8005\u7f16\u53f7\u67e5\u8be2\u60a3\u8005\u662f\u5426\u5b58\u5728\u5bf9\u5e94\u7684\u4f18\u60e0\u5238\u4fe1\u606f")
    @PostMapping(value={"/selectDiscountInfoByPatientId"})
    public ResponseData selectDiscountInfoByPatientId(@RequestBody @Valid CheckDiscountDto dto) {
        dto.setTenantId(this.commonRequest.getTenant());
        return ResponseData.success((Object)this.outOrderService.selectDiscountInfoByPatientId(dto));
    }

    @PostMapping(value={"/v1/feeManagement"})
    @Operation(description="\u6536\u8d39\u7ba1\u7406")
    @ApiOperation(value="\u6536\u8d39\u7ba1\u7406-\u67e5\u8be2", httpMethod="POST", notes="\u6536\u8d39\u7ba1\u7406-\u67e5\u8be2")
    public ResponseData<PageResult<QueryFeeManagementVo>> feeManagement(@RequestBody @Valid FeeManagemenDto parameter, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return ResponseData.error((String)bindingResult.getFieldError().getDefaultMessage());
        }
        parameter.setTenantId(this.commonRequest.getTenant());
        return this.outOrderService.feeManagement(parameter);
    }

    @PostMapping(value={"/v1/queryFeeDetails"})
    @Operation(description="\u95e8\u8bca\u53f7\u67e5\u8be2\u5f85\u6536\u8d39\u8be6\u60c5")
    @ApiOperation(value="\u95e8\u8bca\u53f7\u67e5\u8be2\u5f85\u6536\u8d39\u8be6\u60c5", httpMethod="POST", notes="\u95e8\u8bca\u53f7\u67e5\u8be2\u6536\u8d39\u8be6\u60c5")
    public ResponseData<QueryFeeDetailsVo> queryFeeDetails(@RequestBody @Valid QueryFeeDetailsDto parameter, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return ResponseData.error((String)bindingResult.getFieldError().getDefaultMessage());
        }
        parameter.setTenantId(this.commonRequest.getTenant());
        return this.outOrderService.queryFeeDetails(parameter);
    }

    @PostMapping(value={"/v1/wisQueryFeeDetailsByOrderNo"})
    @Operation(description="\u6839\u636eorderNo\u67e5\u8be2\u5f85\u6536\u8d39\u8be6\u60c5")
    @ApiOperation(value="\u6839\u636eorderNo\u67e5\u8be2\u5f85\u6536\u8d39\u8be6\u60c5", httpMethod="POST", notes="\u95e8\u8bca\u53f7\u67e5\u8be2\u6536\u8d39\u8be6\u60c5")
    public ResponseData<QueryFeeDetailsVo> wisQueryFeeDetailsByOrderNo(@RequestBody @Valid QueryFeeDetailsDto parameter, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return ResponseData.error((String)bindingResult.getFieldError().getDefaultMessage());
        }
        parameter.setTenantId(this.commonRequest.getTenant());
        return this.outOrderService.wisQueryFeeDetailsByOrderNo(parameter);
    }

    @PostMapping(value={"/v1/queryFeeDetailsByPatientId"})
    @Operation(description="\u95e8\u8bca\u53f7\u67e5\u8be2\u5f85\u6536\u8d39\u8be6\u60c5")
    @ApiOperation(value="\u95e8\u8bca\u53f7\u67e5\u8be2\u5f85\u6536\u8d39\u8be6\u60c5", httpMethod="POST", notes="\u95e8\u8bca\u53f7\u67e5\u8be2\u6536\u8d39\u8be6\u60c5")
    public ResponseData<QueryFeeDetailsVo> queryFeeDetailsByPatientId(@RequestBody @Valid QueryFeeDetailsDto parameter, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return ResponseData.error((String)bindingResult.getFieldError().getDefaultMessage());
        }
        parameter.setTenantId(this.commonRequest.getTenant());
        return this.outOrderService.queryFeeDetailsByPatientId(parameter);
    }

    @PostMapping(value={"/v1/queryFeePaidDetails"})
    @Operation(description="\u95e8\u8bca\u53f7\u67e5\u8be2\u5df2\u652f\u4ed8\u8be6\u60c5")
    @ApiOperation(value="\u95e8\u8bca\u53f7\u67e5\u8be2\u5df2\u652f\u4ed8\u8be6\u60c5", httpMethod="POST", notes="\u95e8\u8bca\u53f7\u67e5\u8be2\u5df2\u652f\u4ed8\u8be6\u60c5")
    public ResponseData<List<QueryFeeOrderPaidItemsVo>> queryFeePaidDetails(@RequestBody @Valid QueryFeeDetailsDto parameter, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return ResponseData.error((String)bindingResult.getFieldError().getDefaultMessage());
        }
        parameter.setTenantId(this.commonRequest.getTenant());
        return this.outOrderService.queryFeePaidDetails(parameter);
    }

    @PostMapping(value={"/v1/queryFeeDetailsByProjectID"})
    @Operation(description="\u6839\u636e\u8ba2\u5355id\u67e5\u8be2\u6536\u8d39\u9879\u76ee")
    @ApiOperation(value="\u6839\u636e\u8ba2\u5355id\u67e5\u8be2\u6536\u8d39\u9879\u76ee", httpMethod="POST", notes="\u6839\u636e\u8ba2\u5355id\u67e5\u8be2\u6536\u8d39\u9879\u76ee")
    public ResponseData<List<QueryFeeDetailsListVo>> queryFeeDetailsByProjectID(@RequestBody @Valid QueryFeeDetailsListDto parameter, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return ResponseData.error((String)bindingResult.getFieldError().getDefaultMessage());
        }
        parameter.setTenantId(this.commonRequest.getTenant());
        return this.outOrderService.queryFeeDetailsByProjectID(parameter);
    }

    @PostMapping(value={"/v1/queryByPresNoAndOutNo"})
    @Operation(description="\u6839\u636e\u5904\u65b9\u53f7\u548c\u95e8\u8bca\u53f7\u67e5\u8be2\u8ba2\u5355\u4fe1\u606f")
    @ApiOperation(value="\u6839\u636e\u5904\u65b9\u53f7\u548c\u95e8\u8bca\u53f7\u67e5\u8be2\u8ba2\u5355\u4fe1\u606f", httpMethod="POST", notes="\u6839\u636e\u5904\u65b9\u53f7\u548c\u95e8\u8bca\u53f7\u67e5\u8be2\u8ba2\u5355\u4fe1\u606f")
    public ResponseData<List<OutOrder>> queryByPresNoAndOutNo(@RequestBody @Valid QueryOrderDto parameter, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return ResponseData.error((String)bindingResult.getFieldError().getDefaultMessage());
        }
        parameter.setTenantId(this.commonRequest.getTenant());
        return this.outOrderService.queryByPresNoAndOutNo(parameter);
    }

    @PostMapping(value={"/v1/queryByMainIdAndOutNo"})
    @Operation(description="\u6839\u636e\u533b\u5631id\u548c\u95e8\u8bca\u53f7\u67e5\u8be2\u8ba2\u5355\u4fe1\u606f")
    @ApiOperation(value="\u6839\u636e\u533b\u5631id\u548c\u95e8\u8bca\u53f7\u67e5\u8be2\u8ba2\u5355\u4fe1\u606f", httpMethod="POST", notes="\u6839\u636e\u533b\u5631id\u548c\u95e8\u8bca\u53f7\u67e5\u8be2\u8ba2\u5355\u4fe1\u606f")
    public ResponseData<List<OutOrder>> queryByMainIdAndOutNo(@RequestBody @Valid QueryOrderDto parameter, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return ResponseData.error((String)bindingResult.getFieldError().getDefaultMessage());
        }
        parameter.setTenantId(this.commonRequest.getTenant());
        return this.outOrderService.queryByMainIdAndOutNo(parameter);
    }

    @GetMapping(value={"/v1/queryByWaitPayByPatientId"})
    @Operation(description="\u6839\u636e\u60a3\u8005id\u67e5\u5c31\u8bca\u8bb0\u5f55")
    @ApiOperation(value="\u6839\u636e\u60a3\u8005id\u67e5\u5c31\u8bca\u8bb0\u5f55", httpMethod="GET", notes="\u6839\u636e\u60a3\u8005id\u67e5\u5c31\u8bca\u8bb0\u5f55")
    public ResponseData<List<WisOutOrder>> queryByWaitPayByPatientId(@RequestParam(value="patientId", required=true) Integer patientId) {
        return this.outOrderService.queryByWaitPayByPatientId(patientId, this.commonRequest.getTenant());
    }

    @PostMapping(value={"/outOrder/queryExamineList"})
    @Operation(description="\u6839\u636e\u60a3\u8005id\u67e5\u68c0\u67e5/\u68c0\u9a8c\u5217\u8868")
    @ApiOperation(value="\u6839\u636e\u60a3\u8005id\u67e5\u5c31\u8bca\u8bb0\u5f55", httpMethod="GET", notes="\u6839\u636e\u60a3\u8005id\u67e5\u5c31\u8bca\u8bb0\u5f55")
    public ResponseData<List<WisOutOrder>> queryExamineList(@RequestParam(value="patientId", required=true) Integer patientId) {
        return this.outOrderService.queryByWaitPayByPatientId(patientId, this.commonRequest.getTenant());
    }

    @PostMapping(value={"/paymentOrderUpdate"})
    @Operation(description="\u5fae\u4fe1\u652f\u4ed8\u66f4\u65b0\u8ba2\u5355\u72b6\u6001")
    @ApiOperation(value="\u5fae\u4fe1\u652f\u4ed8\u66f4\u65b0\u8ba2\u5355\u72b6\u6001", httpMethod="POST", notes="\u5fae\u4fe1\u652f\u4ed8\u66f4\u65b0\u8ba2\u5355\u72b6\u6001")
    public ResponseData paymentOrderUpdate(@RequestBody PaymentOrderUpdateDTO dto) {
        return this.outOrderService.paymentOrderUpdate(dto);
    }

    @PostMapping(value={"/regOrderUpdate"})
    @Operation(description="\u5fae\u4fe1\u652f\u4ed8\u66f4\u65b0\u6302\u53f7\u8ba2\u5355\u72b6\u6001")
    @ApiOperation(value="\u5fae\u4fe1\u652f\u4ed8\u66f4\u65b0\u6302\u53f7\u8ba2\u5355\u72b6\u6001", httpMethod="POST", notes="\u5fae\u4fe1\u652f\u4ed8\u66f4\u65b0\u6302\u53f7\u8ba2\u5355\u72b6\u6001")
    public ResponseData regOrderUpdate(@RequestBody PaymentOrderUpdateDTO dto) {
        return this.outOrderService.regOrderUpdate(dto);
    }
}

