/*
 * Decompiled with CFR 0.152.
 */
package com.byh.outpatient.web.rocket;

import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.apache.rocketmq.client.producer.SendCallback;
import org.apache.rocketmq.client.producer.SendResult;
import org.apache.rocketmq.spring.core.RocketMQTemplate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.messaging.Message;
import org.springframework.messaging.support.MessageBuilder;
import org.springframework.stereotype.Component;

@Component
public class RocketMQProducer {
    private static final Logger logger = LoggerFactory.getLogger(RocketMQProducer.class);
    private static final String tag = "TAG1";
    @Autowired
    private RocketMQTemplate rocketMQTemplate;
    @Value(value="${rocketmq.environment.name}")
    private String environmentName;
    @Value(value="${rocketmq.environment.enabledIsolation:true}")
    private boolean enabledIsolation;

    @PostConstruct
    public void init() {
        logger.info("---RocketMq\u521d\u59cb\u5316---");
    }

    private Message<String> idempotence(String message, String key) {
        Message msg = MessageBuilder.withPayload((Object)message).setHeader("KEYS", (Object)key).build();
        return msg;
    }

    public void convertAndSend(String topic, String tag, String message, String key) {
        if (this.enabledIsolation) {
            topic = String.join((CharSequence)"_", topic, this.environmentName);
            logger.info("---\u7b80\u5355\u3010\u751f\u4ea7\u8005 \u73af\u5883\u5207\u6362\u3011---" + topic);
        }
        Message msg = this.idempotence(message, key);
        this.rocketMQTemplate.convertAndSend((Object)(topic + ":" + tag), (Object)msg);
    }

    public void sendOneWay(String topic, String tag, String message, String key) {
        if (this.enabledIsolation) {
            topic = String.join((CharSequence)"_", topic, this.environmentName);
            logger.info("---\u5355\u5411\u6d88\u606f\u3010\u751f\u4ea7\u8005 \u73af\u5883\u5207\u6362\u3011---{topic}" + topic);
        }
        Message msg = this.idempotence(message, key);
        this.rocketMQTemplate.sendOneWay(topic + ":" + tag, msg);
    }

    public void syncSend(String topic, String message, String key) {
        if (this.enabledIsolation) {
            topic = String.join((CharSequence)"_", topic, this.environmentName);
            logger.info("---\u540c\u6b65\u3010\u751f\u4ea7\u8005 \u73af\u5883\u5207\u6362\u3011---{topic}" + topic);
        }
        Message msg = this.idempotence(message, key);
        SendResult sendResult = this.rocketMQTemplate.syncSend(topic + ":" + tag, msg);
        logger.info("---\u53d1\u9001\u540c\u6b65\u6d88\u606f\u662f\u5426===---\n" + sendResult.getSendStatus());
    }

    public void asyncSend(String topic, String tag, String message, String key) {
        if (this.enabledIsolation) {
            topic = String.join((CharSequence)"_", topic, this.environmentName);
            logger.info("---\u5f02\u6b65\u3010\u751f\u4ea7\u8005 \u73af\u5883\u5207\u6362\u3011---{topic}" + topic);
        }
        Message msg = this.idempotence(message, key);
        this.rocketMQTemplate.asyncSend(topic + ":" + tag, msg, (SendCallback)new /* Unavailable Anonymous Inner Class!! */);
        logger.info("\u5f02\u6b65\u6d88\u606f\u5df2\u53d1\u9001\u5b8c\u6210");
    }

    public void asyncSendCallback(String topic, String tag, String message, SendCallback sendCallback, String key) {
        if (this.enabledIsolation) {
            topic = String.join((CharSequence)"_", topic, this.environmentName);
            logger.info("---\u5f02\u6b65\u56de\u8c03\u3010\u751f\u4ea7\u8005 \u73af\u5883\u5207\u6362\u3011---{topic}" + topic);
        }
        Message msg = this.idempotence(message, key);
        this.rocketMQTemplate.asyncSend(topic + ":" + tag, msg, sendCallback);
    }

    public void asyncSendCallbackTimeout(String topic, String tag, String message, SendCallback sendCallback, long timeout, String key) {
        if (this.enabledIsolation) {
            topic = String.join((CharSequence)"_", topic, this.environmentName);
            logger.info("---\u5f02\u6b65\u56de\u8c03\u8d85\u65f6\u3010\u751f\u4ea7\u8005 \u73af\u5883\u5207\u6362\u3011---{topic}" + topic);
        }
        Message msg = this.idempotence(message, key);
        this.rocketMQTemplate.asyncSend(topic + ":" + tag, msg, sendCallback, timeout);
    }

    public void asyncSendCallbackTimeoutLevel(String topic, String tag, String message, SendCallback sendCallback, long timeout, int delayLevel, String key) {
        if (this.enabledIsolation) {
            topic = String.join((CharSequence)"_", topic, this.environmentName);
            logger.info("---\u5f02\u6b65\u5ef6\u8fdf\u3010\u751f\u4ea7\u8005 \u73af\u5883\u5207\u6362\u3011---{topic}" + topic);
        }
        Message msg = this.idempotence(message, key);
        this.rocketMQTemplate.asyncSend(topic + ":" + tag, msg, sendCallback, timeout, delayLevel);
    }

    public void syncSendOrderly(String topic, String tag, String message, String key) {
        if (this.enabledIsolation) {
            topic = String.join((CharSequence)"_", topic, this.environmentName);
            logger.info("---\u540c\u6b65\u987a\u5e8f\u3010\u751f\u4ea7\u8005 \u73af\u5883\u5207\u6362\u3011---{topic}" + topic);
        }
        Message msg = this.idempotence(message, key);
        logger.info("\u53d1\u9001\u987a\u5e8f\u6d88\u606f\uff0ctopic:" + topic + ",hashKey:" + key);
        this.rocketMQTemplate.syncSendOrderly(topic + ":" + tag, msg, key);
    }

    public void syncSendOrderlyKeyCallback(String topic, String tag, String message, String key, SendCallback sendCallback) {
        if (this.enabledIsolation) {
            topic = String.join((CharSequence)"_", topic, this.environmentName);
            logger.info("---\u540c\u6b65\u987a\u5e8f\u56de\u8c03\u3010\u751f\u4ea7\u8005 \u73af\u5883\u5207\u6362\u3011" + topic);
        }
        Message msg = this.idempotence(message, key);
        logger.info("\u53d1\u9001\u987a\u5e8f\u6d88\u606f\uff0ctopic:" + topic + ",key:" + sendCallback);
        this.rocketMQTemplate.asyncSendOrderly(topic + ":" + tag, msg, key, sendCallback);
    }

    public void syncSendDelay(String topic, String tag, String message, Integer delayLevel, String key) {
        if (this.enabledIsolation) {
            topic = String.join((CharSequence)"_", topic, this.environmentName);
            logger.info("---\u540c\u6b65\u5ef6\u8fdf\u3010\u751f\u4ea7\u8005 \u73af\u5883\u5207\u6362\u3011---{topic}" + topic);
        }
        Message msg = this.idempotence(message, key);
        logger.info("\u53d1\u9001\u987a\u5e8f\u6d88\u606f\uff0ctopic:" + topic + ",delayLevel:" + delayLevel);
        this.rocketMQTemplate.syncSend(topic + ":" + tag, msg, 3000L, delayLevel.intValue());
    }

    public void syncSend(String topic, String tag, String message, String key) {
        if (this.enabledIsolation) {
            String topicY = String.join((CharSequence)"_", topic, this.environmentName);
            logger.info("---\u5e26TAG\u6d88\u606f\u3010\u751f\u4ea7\u8005 \u73af\u5883\u5207\u6362\u3011---{topic}" + topic);
        }
        Message msg = this.idempotence(message, key);
        this.rocketMQTemplate.convertAndSend((Object)(topic + ":" + tag), (Object)msg);
    }

    public void transactionSend(String topic, String message, String key) {
        if (this.enabledIsolation) {
            topic = String.join((CharSequence)"_", topic, this.environmentName);
            logger.info("---\u540c\u6b65\u987a\u5e8f\u606f\u3010\u751f\u4ea7\u8005 \u73af\u5883\u5207\u6362\u3011---{topic}" + topic);
        }
        Message msg = this.idempotence(message, key);
        this.rocketMQTemplate.sendMessageInTransaction(topic + ":" + tag, msg, (Object)key);
    }

    @PreDestroy
    public void destroy() {
        logger.info("---RocketMq\u52a9\u624b\u6ce8\u9500---");
    }

    static /* synthetic */ Logger access$000() {
        return logger;
    }
}

