/*
 * Decompiled with CFR 0.152.
 */
package com.byh.sdk.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.dynamic.datasource.annotation.DS;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.byh.sdk.entity.OutGroupHistoryMsgEntity;
import com.byh.sdk.entity.im.IMGenerateDto;
import com.byh.sdk.entity.im.IMSessionHistoryPatientVo;
import com.byh.sdk.service.IMGenerateService;
import com.byh.sdk.util.ResponseData;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.util.List;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/imGenerate"})
public class IMGenerateController {
    @Autowired
    private IMGenerateService imGenerateService;

    @PostMapping(value={"/generateUserId"})
    @ApiOperation(value="IM\u751f\u6210UserSig")
    public ResponseData generateUserId(@RequestBody @Valid IMGenerateDto dto) {
        return ResponseData.success((Object)this.imGenerateService.generateUserId(dto));
    }

    @GetMapping(value={"/getSessionList"})
    @ApiOperation(value="\u83b7\u53d6\u60a3\u8005\u5bf9\u8bdd\u5217\u8868")
    public ResponseData<List<IMSessionHistoryPatientVo>> getSessionList(String cardNo) throws IOException {
        return this.imGenerateService.getSessionList(cardNo);
    }

    @GetMapping(value={"/getMsgHistory"})
    @ApiOperation(value="\u83b7\u53d6\u60a3\u8005\u5bf9\u8bdd\u8be6\u60c5")
    public ResponseData getMsgHistory(Integer id) throws IOException {
        return this.imGenerateService.getMsgHistory(id);
    }

    @PostMapping(value={"/getGroupMsgHistory"})
    @ApiOperation(value="\u817e\u8baf\u4e91\u83b7\u53d6\u7fa4\u7ec4\u5bf9\u8bdd\u8be6\u60c5")
    public ResponseData getGroupMsgHistory(@RequestBody JSONObject jsonObject) throws IOException {
        jsonObject.put("ReqMsgNumber", (Object)20);
        String groupId = jsonObject.getString("GroupId");
        if (StringUtils.isBlank((CharSequence)groupId)) {
            jsonObject.put("GroupId", (Object)jsonObject.getString("groupId"));
        }
        return ResponseData.success((Object)this.imGenerateService.getGroupMsgHistory(jsonObject));
    }

    @PostMapping(value={"/queryByGroupId"})
    @ApiOperation(value="\u672c\u5730\u83b7\u53d6\u7fa4\u7ec4\u5bf9\u8bdd\u8be6\u60c5")
    @DS(value="mysql3")
    public ResponseData<OutGroupHistoryMsgEntity> queryByGroupId(@RequestBody OutGroupHistoryMsgEntity param) {
        return ResponseData.success((Object)this.imGenerateService.queryByGroupId(param));
    }

    @PostMapping(value={"/addOrUpdateHistory"})
    @ApiOperation(value="\u65b0\u589e\u66f4\u65b0\u5bf9\u8bdd\u6d88\u606f")
    @DS(value="mysql3")
    public ResponseData addOrUpdateHistory(@RequestBody OutGroupHistoryMsgEntity entity) {
        return ResponseData.success((Object)this.imGenerateService.addOrUpdateHistory(entity));
    }
}

