/*
 * Decompiled with CFR 0.152.
 */
package com.byh.sdk.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sourceforge.pinyin4j.PinyinHelper;
import net.sourceforge.pinyin4j.format.HanyuPinyinCaseType;
import net.sourceforge.pinyin4j.format.HanyuPinyinOutputFormat;
import net.sourceforge.pinyin4j.format.HanyuPinyinToneType;
import net.sourceforge.pinyin4j.format.exception.BadHanyuPinyinOutputFormatCombination;

public class StringPinYinUtil {
    public static String toFirstChar(String chinese) {
        chinese = chinese.replaceAll("[^\\u4E00-\\u9FA5]", "");
        char[] newChar = chinese.toCharArray();
        HanyuPinyinOutputFormat defaultFormat = new HanyuPinyinOutputFormat();
        defaultFormat.setCaseType(HanyuPinyinCaseType.LOWERCASE);
        defaultFormat.setToneType(HanyuPinyinToneType.WITHOUT_TONE);
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < newChar.length; ++i) {
            if (newChar[i] > '\u0080') {
                try {
                    stringBuilder.append(PinyinHelper.toHanyuPinyinStringArray((char)newChar[i], (HanyuPinyinOutputFormat)defaultFormat)[0].charAt(0));
                }
                catch (BadHanyuPinyinOutputFormatCombination e) {
                    e.printStackTrace();
                }
                continue;
            }
            stringBuilder.append(newChar[i]);
        }
        return stringBuilder.toString().toUpperCase();
    }

    public static String replaceBlank(String str) {
        String dest = "";
        if (str != null) {
            Pattern p = Pattern.compile("\\s*|\t|\r|\n");
            Matcher m = p.matcher(str);
            dest = m.replaceAll("");
        }
        return dest;
    }
}

