/*
 * Decompiled with CFR 0.152.
 */
package com.byh.sdk.controller.minio;

import cn.hutool.json.JSONObject;
import com.byh.sdk.config.minio.MinioConfig;
import com.byh.sdk.config.minio.MinioUtil;
import com.byh.sdk.util.ResponseData;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/minio"})
public class MinioController {
    private static final Logger log = LoggerFactory.getLogger(MinioController.class);
    @Autowired
    private MinioUtil minioUtil;
    @Autowired
    private MinioConfig prop;

    @GetMapping(value={"/bucketExists"})
    public ResponseData bucketExists(@RequestParam(value="bucketName") String bucketName) {
        Boolean aBoolean = this.minioUtil.bucketExists(bucketName);
        return ResponseData.success((Object)aBoolean);
    }

    @GetMapping(value={"/makeBucket"})
    public ResponseData makeBucket(String bucketName) {
        Boolean aBoolean = this.minioUtil.makeBucket(bucketName);
        return ResponseData.success((Object)aBoolean);
    }

    @GetMapping(value={"/removeBucket"})
    public ResponseData removeBucket(String bucketName) {
        Boolean aBoolean = this.minioUtil.removeBucket(bucketName);
        return ResponseData.success((Object)aBoolean);
    }

    @GetMapping(value={"/getAllBuckets"})
    public ResponseData getAllBuckets() {
        List allBuckets = this.minioUtil.getAllBuckets();
        return ResponseData.success((Object)allBuckets);
    }

    @PostMapping(value={"/uploadMinio"})
    public ResponseData uploadMinio(@RequestParam(value="file") MultipartFile file) {
        JSONObject jsonObject = this.minioUtil.upload(file);
        if (null != jsonObject) {
            return ResponseData.success((Object)jsonObject);
        }
        return ResponseData.error((String)"\u5931\u8d25");
    }

    @PostMapping(value={"/uploadMinios"})
    public ResponseData uploadMinios(@RequestParam(value="file", required=false) MultipartFile[] files) {
        JSONObject jsonObject = this.minioUtil.uploads(files);
        if (null != jsonObject) {
            return ResponseData.success((Object)jsonObject);
        }
        return ResponseData.error((String)"\u5931\u8d25");
    }

    @GetMapping(value={"/preview"})
    public ResponseData preview(@RequestParam(value="fileName") String fileName) {
        String preview = this.minioUtil.preview(fileName);
        return ResponseData.success((Object)preview);
    }

    @GetMapping(value={"/downloadMinio"})
    public ResponseData download(@RequestParam(value="fileName") String fileName, HttpServletResponse res) {
        this.minioUtil.download(fileName, res);
        return ResponseData.success();
    }

    @PostMapping(value={"/delete"})
    public ResponseData remove(String url) {
        String objName = url.substring(url.lastIndexOf(this.prop.getBucketName() + "/") + this.prop.getBucketName().length() + 1);
        this.minioUtil.remove(objName);
        return ResponseData.success((Object)objName);
    }
}

