/*
 * Decompiled with CFR 0.152.
 */
package com.byh.sdk.controller;

import com.baomidou.dynamic.datasource.annotation.DS;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.byh.sdk.entity.TestEntity;
import com.byh.sdk.entity.request.SysDrugEntity;
import com.byh.sdk.feign.sys.SysServiceFeign;
import com.byh.sdk.service.TestService;
import com.byh.sdk.util.CommonRequest;
import com.byh.sdk.util.ResponseData;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/test"})
public class TestController {
    private static final Logger logger = LoggerFactory.getLogger(TestController.class);
    private final TestService testService;
    private final SysServiceFeign sysServiceFeign;
    private final CommonRequest commonRequest;

    @RequestMapping(value={"/re/upload/data"})
    public ResponseData reUploadData(@RequestBody List<String> list) {
        this.testService.reUploadData(list);
        return ResponseData.success();
    }

    @RequestMapping(value={"/tt/mail"})
    @DS(value="mysql")
    @Scheduled(cron="0 0/30 * * * ? ")
    public void sendSinglePrescription() {
        this.testService.sendSinglePrescription();
    }

    @GetMapping(value={"/pageList"})
    @DS(value="mysql")
    public ResponseData<TestEntity> pageList() {
        List list = this.testService.list((Wrapper)Wrappers.lambdaQuery());
        logger.info("\u96c6\u5408" + list);
        return ResponseData.success((Object)list);
    }

    @GetMapping(value={"/pageListMysql2"})
    @DS(value="mysql2")
    public ResponseData<TestEntity> pageListMysql2() {
        List list = this.testService.list((Wrapper)Wrappers.lambdaQuery());
        logger.info("\u96c6\u5408" + list);
        return ResponseData.success((Object)list);
    }

    @GetMapping(value={"/list"})
    @DS(value="mysql")
    public ResponseData<TestEntity> list(TestEntity entity) {
        List list = this.testService.getList(entity);
        return ResponseData.success((Object)list);
    }

    @PostMapping(value={"/saveTest"})
    @DS(value="mysql")
    public ResponseData saveTest(@RequestBody TestEntity entity) {
        boolean b = this.testService.saveOrUpdate((Object)entity);
        logger.info("\u63d2\u5165\u6210\u529f" + b);
        return ResponseData.success((Object)b);
    }

    @PostMapping(value={"/listFeign"})
    @DS(value="mysql")
    public ResponseData<SysDrugEntity> listFeign(@RequestBody SysDrugEntity entity) {
        Integer tenantId = this.commonRequest.getTenant();
        ResponseData sysDrugEntityResponseData = this.sysServiceFeign.drugIdDetails(entity, tenantId);
        SysDrugEntity data = (SysDrugEntity)sysDrugEntityResponseData.getData();
        logger.info("\u67e5\u8be2" + data);
        return ResponseData.success((Object)data);
    }

    public static void main(String[] args) {
        Random random = new Random();
        HashSet<Integer> redBalls = new HashSet<Integer>();
        while (redBalls.size() < 6) {
            int number = random.nextInt(33) + 1;
            redBalls.add(number);
        }
        ArrayList sortedRedBalls = new ArrayList(redBalls);
        Collections.sort(sortedRedBalls);
        int blueBall = random.nextInt(16) + 1;
        HashMap<String, Serializable> result = new HashMap<String, Serializable>();
        result.put("redBalls", sortedRedBalls);
        result.put("blueBall", Integer.valueOf(blueBall));
        logger.info("\u7ea2\u8272\u7403 redBalls:" + sortedRedBalls);
        logger.info("\u84dd\u8272\u7403 blueBall:" + blueBall);
    }

    public TestController(TestService testService, SysServiceFeign sysServiceFeign, CommonRequest commonRequest) {
        this.testService = testService;
        this.sysServiceFeign = sysServiceFeign;
        this.commonRequest = commonRequest;
    }
}

