/*
 * Decompiled with CFR 0.152.
 */
package com.byh.sdk.controller.fastPrescription;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.byh.sdk.entity.admission.AdmissionPatientVo;
import com.byh.sdk.entity.admission.QuickTreatementDto;
import com.byh.sdk.entity.diagnostic.OutpatientInfomationDto;
import com.byh.sdk.entity.diagnostic.UpdateOutpatientMedicalRecords;
import com.byh.sdk.entity.drug.SysDictValueDTO;
import com.byh.sdk.entity.drug.SysDictValueVo;
import com.byh.sdk.entity.fastPrescription.HsPrescriptionUploadDto;
import com.byh.sdk.entity.request.SysDrugEntity;
import com.byh.sdk.entity.selfHelp.dto.SysDrugDto;
import com.byh.sdk.entity.system.SysDoctorImportExcel;
import com.byh.sdk.feign.sys.OutpatientServiceFeign;
import com.byh.sdk.feign.sys.SysServiceFeign;
import com.byh.sdk.util.ResponseData;
import io.swagger.annotations.ApiOperation;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import org.jsoup.internal.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/fastPrescription"})
public class FastPrescriptionController {
    private static final Logger log = LoggerFactory.getLogger(FastPrescriptionController.class);
    @Autowired
    OutpatientServiceFeign outpatientServiceFeign;
    @Autowired
    SysServiceFeign sysServiceFeign;

    @ApiOperation(value="\u6839\u636e\u5904\u65b9\u53f7\u67e5\u8be2\u5904\u65b9\u4fe1\u606f")
    @GetMapping(value={"/queryPrescriptionsByJSKFNo"})
    public ResponseData queryPrescriptionsByJSKFNo(String prescriptionNo) {
        return this.outpatientServiceFeign.queryPrescriptionsByJSKFNo(prescriptionNo);
    }

    @ApiOperation(value="\u6781\u901f\u5f00\u65b9\u95e8\u8bca\u6302\u53f7\uff08\u514d\u8d39\u53f7\uff09")
    @PostMapping(value={"/register"})
    public ResponseData quickTreatement(@RequestBody QuickTreatementDto quickTreatementDto) {
        try {
            log.info("\u6781\u901f\u5f00\u65b9\u95e8\u8bca\u6302\u53f7,\u5165\u53c2: {}", (Object)JSON.toJSONString((Object)quickTreatementDto));
            ResponseData responseData = this.outpatientServiceFeign.quickTreatement(quickTreatementDto, Integer.valueOf(1), Integer.valueOf(1), URLEncoder.encode("\u6781\u901f\u5f00\u65b9", StandardCharsets.UTF_8.toString()));
            log.info("\u6781\u901f\u5f00\u65b9\u95e8\u8bca\u6302\u53f7,\u51fa\u53c2: {}", (Object)JSON.toJSONString((Object)responseData.getData()));
            if (responseData.isSuccess()) {
                AdmissionPatientVo admissionPatientVo = (AdmissionPatientVo)JSON.parseObject((String)JSON.toJSONString((Object)responseData.getData()), AdmissionPatientVo.class);
                OutpatientInfomationDto outpatientInfomationDto = new OutpatientInfomationDto();
                outpatientInfomationDto.setOutpatientNo(admissionPatientVo.getOutpatientNo());
                ResponseData queryRes = this.outpatientServiceFeign.addOutMedicalRecord(outpatientInfomationDto, Integer.valueOf(1), Integer.valueOf(1), URLEncoder.encode("\u6781\u901f\u5f00\u65b9", StandardCharsets.UTF_8.toString()));
                if (!queryRes.isSuccess()) {
                    throw new RuntimeException("\u65b0\u589e\u75c5\u7a0b\u5931\u8d25\uff01");
                }
            }
            return responseData;
        }
        catch (Exception e) {
            String stackTrace = "";
            if (StringUtil.isBlank((String)e.getMessage())) {
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                e.printStackTrace(pw);
                stackTrace = sw.toString();
            } else {
                stackTrace = e.getMessage();
            }
            log.error("\u6781\u901f\u5f00\u65b9\u95e8\u8bca\u6302\u53f7\u9519\u8bef:{}", (Object)stackTrace);
            return ResponseData.error((String)stackTrace);
        }
    }

    @ApiOperation(value="\u6781\u901f\u5f00\u65b9\u6dfb\u52a0\u8bca\u65ad")
    @PostMapping(value={"/addDiags"})
    public ResponseData addDiags(@RequestBody UpdateOutpatientMedicalRecords dto) {
        try {
            log.info("\u6781\u901f\u5f00\u65b9\u6dfb\u52a0\u8bca\u65ad,\u5165\u53c2: {}", (Object)JSON.toJSONString((Object)dto));
            if (dto == null || StrUtil.isBlank((CharSequence)dto.getOutpatientNo())) {
                throw new RuntimeException("\u95e8\u8bca\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (dto.getDiagnosis() == null || dto.getDiagnosis().isEmpty()) {
                throw new RuntimeException("\u8bca\u65ad\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            ResponseData responseData = this.outpatientServiceFeign.addDiags(dto, Integer.valueOf(1), Integer.valueOf(1), URLEncoder.encode("\u6781\u901f\u5f00\u65b9", StandardCharsets.UTF_8.toString()));
            log.info("\u6781\u901f\u5f00\u65b9\u6dfb\u52a0\u8bca\u65ad,\u51fa\u53c2: {}", (Object)JSON.toJSONString((Object)responseData));
            return responseData;
        }
        catch (Exception e) {
            String stackTrace = "";
            if (StringUtil.isBlank((String)e.getMessage())) {
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                e.printStackTrace(pw);
                stackTrace = sw.toString();
            } else {
                stackTrace = e.getMessage();
            }
            log.error("\u6781\u901f\u5f00\u65b9\u6dfb\u52a0\u8bca\u65ad\u9519\u8bef:{}", (Object)stackTrace);
            return ResponseData.error((String)stackTrace);
        }
    }

    @ApiOperation(value="\u6781\u901f\u5f00\u65b9\u63a8\u9001")
    @PostMapping(value={"/push"})
    public ResponseData fastPrescription(@RequestBody HsPrescriptionUploadDto dto) {
        try {
            log.info("\u6781\u901f\u5f00\u65b9\u63a8\u9001,\u5165\u53c2: {}", (Object)JSON.toJSONString((Object)dto));
            ResponseData responseData = this.outpatientServiceFeign.uploadChk(dto, Integer.valueOf(1), Integer.valueOf(1), URLEncoder.encode("\u6781\u901f\u5f00\u65b9", StandardCharsets.UTF_8.toString()), "99999");
            log.info("\u6781\u901f\u5f00\u65b9\u63a8\u9001,\u51fa\u53c2: {}", (Object)JSON.toJSONString((Object)responseData));
            return responseData;
        }
        catch (Exception e) {
            String stackTrace = "";
            if (StringUtil.isBlank((String)e.getMessage())) {
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                e.printStackTrace(pw);
                stackTrace = sw.toString();
            } else {
                stackTrace = e.getMessage();
            }
            log.error("\u6781\u901f\u5f00\u65b9\u63a8\u9001\u9519\u8bef:{}", (Object)stackTrace);
            return ResponseData.error((String)stackTrace);
        }
    }

    @GetMapping(value={"/querySysDoctorInfo"})
    public ResponseData querySysDoctorInfo(@RequestParam(value="phone") String phone) {
        try {
            return this.sysServiceFeign.querySysDoctorInfo(phone);
        }
        catch (Exception e) {
            return ResponseData.error((String)e.getMessage());
        }
    }

    @PostMapping(value={"/importByJSFKDoctorExcel"})
    public ResponseData importByJSFKDoctorExcel(@RequestPart(value="file") MultipartFile file) {
        try {
            return this.sysServiceFeign.importByJSFKDoctorExcel(file);
        }
        catch (Exception e) {
            return ResponseData.error((String)e.getMessage());
        }
    }

    @PostMapping(value={"/importRapidDrug2"})
    public ResponseData importRapidDrug2(@RequestPart(value="file") MultipartFile file) {
        try {
            return this.sysServiceFeign.importRapidDrug2(file, Integer.valueOf(1));
        }
        catch (Exception e) {
            return ResponseData.error((String)e.getMessage());
        }
    }

    @PostMapping(value={"/importByJSFKDoctorByOne"})
    @ApiOperation(value="\u6781\u901f\u5f00\u65b9\u533b\u751f\u5feb\u901f\u5bfc\u5165\u5355\u4e2a", httpMethod="POST", notes="\u6781\u901f\u5f00\u65b9\u533b\u751f\u5feb\u901f\u5bfc\u5165\u5355\u4e2a")
    public ResponseData importByJSFKDoctorByOne(@RequestBody SysDoctorImportExcel dto) {
        try {
            return this.sysServiceFeign.importByJSFKDoctorByOne(dto);
        }
        catch (Exception e) {
            return ResponseData.error((String)e.getMessage());
        }
    }

    @PostMapping(value={"/saveUpdateByCustom"})
    @ApiOperation(value="\u65b0\u589e\u6216\u4fee\u6539\u6781\u901f\u5f00\u65b9\u836f\u54c1")
    public ResponseData saveUpdateByCustom(@RequestBody SysDrugEntity entity) {
        try {
            return this.sysServiceFeign.saveUpdateByCustom(entity, Integer.valueOf(1), Integer.valueOf(1), URLEncoder.encode("\u6781\u901f\u5f00\u65b9", StandardCharsets.UTF_8.toString()), "99999");
        }
        catch (Exception e) {
            return ResponseData.error((String)e.getMessage());
        }
    }

    @PostMapping(value={"/delDrugCustom"})
    @ApiOperation(value="\u5220\u9664\u6781\u901f\u5f00\u65b9\u836f\u54c1")
    public ResponseData delDrugCustom(@RequestBody SysDrugEntity entity) {
        try {
            return this.sysServiceFeign.delDrugCustom(entity, Integer.valueOf(1), Integer.valueOf(1), URLEncoder.encode("\u6781\u901f\u5f00\u65b9", StandardCharsets.UTF_8.toString()), "99999");
        }
        catch (Exception e) {
            return ResponseData.error((String)e.getMessage());
        }
    }

    @GetMapping(value={"/pageListByCustom"})
    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u6781\u901f\u5f00\u65b9\u836f\u54c1\u5217\u8868")
    public ResponseData pageListByCustom(SysDrugDto dto) {
        try {
            return this.sysServiceFeign.pageListByCustom(dto, Integer.valueOf(1));
        }
        catch (Exception e) {
            return ResponseData.error((String)e.getMessage());
        }
    }

    @PostMapping(value={"/sysDict/value/select"})
    @ApiOperation(value="\u5206\u9875\u67e5\u8be2his\u5b57\u5178\u9879")
    ResponseData<Page<SysDictValueVo>> sysDictValueById(@RequestBody SysDictValueDTO sysDictValueDTO) {
        try {
            if (ObjectUtil.isNull((Object)sysDictValueDTO.getCurrent()) || ObjectUtil.isNull((Object)sysDictValueDTO.getSize())) {
                sysDictValueDTO.setCurrent(1);
                sysDictValueDTO.setSize(-1);
            }
            return this.sysServiceFeign.sysDictValueById(sysDictValueDTO, Integer.valueOf(1));
        }
        catch (Exception e) {
            return ResponseData.error((String)e.getMessage());
        }
    }
}

