/*
 * Decompiled with CFR 0.152.
 */
package com.byh.sdk.controller.netHospital;

import com.alibaba.fastjson.JSONObject;
import com.byh.sdk.entity.admission.AdmissionEntity;
import com.byh.sdk.entity.card.RegisteredCardReqDTO;
import com.byh.sdk.entity.department.SysDepartmentDTO;
import com.byh.sdk.entity.diagnostic.DiagnosticReqDTO;
import com.byh.sdk.entity.diagnostic.OutpatientInfomationDto;
import com.byh.sdk.entity.drug.CheckObtainDrugDto;
import com.byh.sdk.entity.drug.OnlinePrescriptionCheckDto;
import com.byh.sdk.entity.drug.OutPrescriptionDto;
import com.byh.sdk.entity.drug.SysDictValueDTO;
import com.byh.sdk.entity.drug.SysDrugPharmacySimpleDto;
import com.byh.sdk.entity.netHospital.dto.DoctorDTO;
import com.byh.sdk.entity.netHospital.dto.DoctorOnlineDto;
import com.byh.sdk.entity.netHospital.dto.GytPatientNarrativeEntity;
import com.byh.sdk.entity.netHospital.dto.HealthPopDTO;
import com.byh.sdk.entity.netHospital.dto.HospitalDTO;
import com.byh.sdk.entity.netHospital.dto.InsertResevationDto;
import com.byh.sdk.entity.netHospital.dto.NetPrescriptionDto;
import com.byh.sdk.entity.netHospital.dto.PatientInfoDto;
import com.byh.sdk.entity.netHospital.dto.PrescriptionsDTO;
import com.byh.sdk.entity.netHospital.dto.QueryHistoricalPrescriptionListDto;
import com.byh.sdk.entity.netHospital.dto.QueryItemsDto;
import com.byh.sdk.entity.netHospital.dto.QueryOutIcdItemDto;
import com.byh.sdk.entity.netHospital.dto.QueryPatientMedicalDto;
import com.byh.sdk.entity.netHospital.dto.QueryScheduleRecordDto;
import com.byh.sdk.entity.netHospital.dto.QueryTreatmentItemDto;
import com.byh.sdk.entity.netHospital.dto.QuickTreatementDto;
import com.byh.sdk.entity.netHospital.dto.RatingDTO;
import com.byh.sdk.entity.netHospital.dto.ReservationDTO;
import com.byh.sdk.entity.netHospital.dto.SaveTreatmentItemsDto;
import com.byh.sdk.entity.netHospital.dto.SysHospitalDTO;
import com.byh.sdk.entity.netHospital.dto.WxPayDto;
import com.byh.sdk.entity.netHospital.dto.paymentOrderUpdateDTO;
import com.byh.sdk.entity.order.FeeBillCreationDto;
import com.byh.sdk.entity.order.QueryFeeDetailsDto;
import com.byh.sdk.entity.order.QueryFeeDetailsListDto;
import com.byh.sdk.entity.patient.PatientEntity;
import com.byh.sdk.entity.prescription.SavePrescriptionDto;
import com.byh.sdk.entity.selfHelp.dto.SysInvoiceDto;
import com.byh.sdk.entity.selfHelp.dto.SysTreatmentItemDto;
import com.byh.sdk.enums.SourceEnum;
import com.byh.sdk.feign.sys.OutpatientServiceFeign;
import com.byh.sdk.feign.sys.SysServiceFeign;
import com.byh.sdk.util.ResponseData;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.swagger.annotations.ApiOperation;
import io.swagger.v3.oas.annotations.Operation;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/netHospital"})
public class NetHospitalController {
    private static final Logger log = LoggerFactory.getLogger(NetHospitalController.class);
    @Autowired
    private SysServiceFeign sysServiceFeign;
    @Autowired
    private OutpatientServiceFeign outpatientServiceFeign;

    @ApiOperation(value="\u5b57\u5178")
    @PostMapping(value={"/getDict"})
    public ResponseData getDeptInfo(@RequestBody SysDictValueDTO dto) {
        ResponseData responseData = this.sysServiceFeign.sysDictValueById(dto, Integer.valueOf(1));
        return ResponseData.success((Object)responseData.getData());
    }

    @ApiOperation(value="\u3010\u4e92\u533b\u3011 \u533b\u9662\u4fe1\u606f\u521d\u59cb\u5316")
    @GetMapping(value={"/hospitalInfo"})
    public ResponseData getHospitalInfo(SysHospitalDTO dto) {
        dto.setTenantId(Integer.valueOf(1));
        return this.sysServiceFeign.getHospitalInfo(dto);
    }

    @ApiOperation(value="\u3010\u4e92\u533b\u3011 \u90e8\u95e8\u4fe1\u606f\u521d\u59cb\u5316")
    @GetMapping(value={"/getDept"})
    public ResponseData getDept(SysDepartmentDTO dto) {
        dto.setTenantId(Integer.valueOf(1));
        dto.setDepartmentType("0");
        return this.sysServiceFeign.getDept(dto);
    }

    @ApiOperation(value="\u3010\u8d63\u533b\u901a\u3011\u90e8\u95e8\u4fe1\u606f\u521d\u59cb\u5316")
    @GetMapping(value={"/deptInfo"})
    public ResponseData getDeptInfo(SysDepartmentDTO dto) {
        dto.setTenantId(Integer.valueOf(1));
        return this.sysServiceFeign.getDeptInfo(dto);
    }

    @ApiOperation(value="\u3010\u8d63\u533b\u901a\u3011 \u7b5b\u9009\u680f")
    @GetMapping(value={"/condition"})
    public ResponseData getCondition() {
        JSONObject jsonObject = new JSONObject();
        SysDictValueDTO dto = new SysDictValueDTO();
        dto.setTenantId(Integer.valueOf(1));
        dto.setType("hy_online");
        ResponseData responseData1 = this.sysServiceFeign.sysDictValueById(dto, Integer.valueOf(1));
        jsonObject.put("doctorOnline", responseData1.getData());
        dto.setType("hy_doctor_service");
        ResponseData responseData2 = this.sysServiceFeign.sysDictValueById(dto, Integer.valueOf(1));
        jsonObject.put("doctorService", responseData2.getData());
        dto.setType("hy_hospital_grade");
        ResponseData responseData3 = this.sysServiceFeign.sysDictValueById(dto, Integer.valueOf(1));
        jsonObject.put("hospitalGrade", responseData3.getData());
        dto.setType("sys_doctor_title");
        ResponseData responseData4 = this.sysServiceFeign.sysDictValueById(dto, Integer.valueOf(1));
        jsonObject.put("doctorTitle", responseData4.getData());
        return ResponseData.success((Object)jsonObject);
    }

    @ApiOperation(value="\u67e5\u8be2\u533b\u751f\u4fe1\u606f")
    @PostMapping(value={"/doctorInfo"})
    public ResponseData getDoctorInfo(@RequestBody DoctorDTO dto) {
        dto.setTenantId(Integer.valueOf(1));
        return this.sysServiceFeign.getNetDoctorInfo(dto);
    }

    @ApiOperation(value="\u67e5\u8be2\u6392\u73ed\u4fe1\u606f")
    @PostMapping(value={"/getNetScheduleInfo"})
    public ResponseData getNetScheduleInfo(@RequestBody QueryScheduleRecordDto dto) {
        dto.setTenantId(Integer.valueOf(1));
        return this.outpatientServiceFeign.getNetScheduleInfo(dto);
    }

    @ApiOperation(value="\u67e5\u8be2\u6392\u73ed\u8be6\u60c5\u4fe1\u606f", httpMethod="GET", notes="\u67e5\u8be2\u6392\u73ed\u8be6\u60c5\u4fe1\u606f")
    @GetMapping(value={"/queryRecordDetail"})
    public ResponseData queryRecordDetail(@RequestParam(value="scheduleCode", required=true) String scheduleCode, @RequestParam(value="reservationId", required=false) Integer reservationId) {
        return this.outpatientServiceFeign.queryRecordDetail(scheduleCode, reservationId);
    }

    @ApiOperation(value="\u9884\u7ea6")
    @PostMapping(value={"/reservation"})
    public ResponseData reservation(@RequestBody InsertResevationDto dto) {
        dto.setReservationSource("4");
        return this.outpatientServiceFeign.reservation(dto, Integer.valueOf(1));
    }

    @ApiOperation(value="\u53d6\u6d88\u9884\u7ea6")
    @PostMapping(value={"/cancelReservation"})
    public ResponseData cancelReservation(@RequestBody InsertResevationDto dto) {
        return this.outpatientServiceFeign.cancelReservation(dto);
    }

    @ApiOperation(value="\u6302\u53f7")
    @PostMapping(value={"/registration"})
    public ResponseData registration(@RequestBody QuickTreatementDto dto) {
        String deviceNo = dto.getDeviceNo();
        log.info("\u6302\u53f7\u63a5\u6536\u5230\u7684deviceNo===========\u300b{}", (Object)deviceNo);
        return this.outpatientServiceFeign.netOutpatientRegistration(dto);
    }

    @ApiOperation(value="\u53d6\u6d88\u6302\u53f7")
    @PostMapping(value={"/cancelRegistration"})
    public ResponseData netCancelRegistration(@RequestBody AdmissionEntity dto) {
        return this.outpatientServiceFeign.netCancelRegistration(dto);
    }

    @ApiOperation(value="\u67e5\u8be2\u6302\u53f7\u5217\u8868")
    @PostMapping(value={"/queryReservationList"})
    public ResponseData queryReservationList(@RequestBody ReservationDTO dto) {
        dto.setTenantId(Integer.valueOf(1));
        return this.outpatientServiceFeign.queryReservationList(dto);
    }

    @ApiOperation(value="\u6839\u636e\u8ba2\u5355\u53f7\u67e5\u8be2")
    @PostMapping(value={"/queryOrderInfo"})
    public ResponseData queryOrderInfo(@RequestBody QueryFeeDetailsListDto detailsListDto) {
        return this.outpatientServiceFeign.queryOrderInfo(detailsListDto, Integer.valueOf(1));
    }

    @ApiOperation(value="\u65b0\u589e\u60a3\u8005\u4e3b\u8ff0")
    @PostMapping(value={"/patientAddNarrative"})
    public ResponseData patientAddNarrative(@RequestBody GytPatientNarrativeEntity dto) {
        return this.outpatientServiceFeign.patientAddNarrative(dto);
    }

    @ApiOperation(value="\u6839\u636e\u5904\u65b9id\u67e5\u8be2\u5904\u65b9\u4fe1\u606f")
    @PostMapping(value={"/prescriptionById"})
    public ResponseData prescriptionById(@RequestBody OutpatientInfomationDto dto) {
        return this.outpatientServiceFeign.queryPrescriptionsByNo(dto, Integer.valueOf(1), Integer.valueOf(91), " \u8d63\u533b\u901a");
    }

    @ApiOperation(value="\u6211\u7684\u5904\u65b9")
    @PostMapping(value={"/queryPrescriptionsByPatientId"})
    public ResponseData queryPrescriptionsByPatientId(@RequestBody PatientInfoDto dto) {
        dto.setTenantId(Integer.valueOf(1));
        dto.setOperatorId(Integer.valueOf(91));
        dto.setOperatorName("\u8d63\u533b\u901a");
        return this.outpatientServiceFeign.queryPrescriptionsByPatientId(dto);
    }

    @ApiOperation(value="\u5065\u5eb7\u79d1\u666e")
    @PostMapping(value={"/healthPop"})
    public ResponseData getHealthPop(@RequestBody HealthPopDTO dto) {
        dto.setTenantId(Integer.valueOf(1));
        return this.sysServiceFeign.getHealthPop(dto);
    }

    @ApiOperation(value="\u65b0\u589e\u5c31\u8bca\u5361")
    @PostMapping(value={"/addPatientCard"})
    public ResponseData addPatientCard(@RequestBody RegisteredCardReqDTO dto) {
        return this.outpatientServiceFeign.patientInsert(dto, Integer.valueOf(1));
    }

    @ApiOperation(value="\u66f4\u65b0\u5c31\u8bca\u5361")
    @PostMapping(value={"/updatePatientCard"})
    public ResponseData updatePatientCard(@RequestBody PatientEntity patientEntity) {
        return this.outpatientServiceFeign.patientUpdateById(patientEntity, Integer.valueOf(1));
    }

    @ApiOperation(value="\u8bc4\u4ef7\u5217\u8868")
    @PostMapping(value={"/getRatingList"})
    public ResponseData getRatingList(@RequestBody RatingDTO dto) {
        return this.sysServiceFeign.getRatingList(dto);
    }

    @ApiOperation(value="\u65b0\u589e\u8bc4\u4ef7")
    @PostMapping(value={"/addRating"})
    public ResponseData addRating(@RequestBody RatingDTO dto) {
        return this.sysServiceFeign.addRating(dto);
    }

    @ApiOperation(value="\u95e8\u8bca\u53f7\u67e5\u8be2\u8bc4\u4ef7")
    @GetMapping(value={"/getRatingByOutPatientNo"})
    public ResponseData getRatingByOutPatientNo(@RequestParam(value="outpatientNo", required=true) String outpatientNo) {
        return this.sysServiceFeign.getRatingByOutPatientNo(outpatientNo);
    }

    @ApiOperation(value="\u67e5\u8be2\u6536\u8d39\u9879\u76ee")
    @PostMapping(value={"/queryChargeItem"})
    public ResponseData ChargeItem(@RequestBody QueryFeeDetailsDto dto) {
        return this.outpatientServiceFeign.ChargeItem(dto);
    }

    @ApiOperation(value="\u67e5\u8be2\u6536\u8d39\u9879\u76ee\u660e\u7ec6")
    @PostMapping(value={"/queryChargeItemDetails"})
    public ResponseData ChargeItemDetails(@RequestBody QueryFeeDetailsListDto dto) {
        return this.outpatientServiceFeign.ChargeItemDetails(dto);
    }

    @ApiOperation(value="\u652f\u4ed8\u8ba2\u5355\u521b\u5efa")
    @PostMapping(value={"/orderCharge"})
    public ResponseData orderAdd(@RequestBody FeeBillCreationDto dto) {
        return this.outpatientServiceFeign.orderAdd(dto);
    }

    @ApiOperation(value="\u6839\u636epatientId\u67e5\u8be2\u5f85\u6536\u8d39/\u6536\u8d39\u9879\u76ee")
    @PostMapping(value={"/queryItemInfo"})
    public ResponseData queryItemInfo(@RequestBody QueryFeeDetailsDto dto) {
        return this.outpatientServiceFeign.ItemInfo(dto);
    }

    @ApiOperation(value="\u5730\u533a\u521d\u59cb\u5316")
    @GetMapping(value={"/district"})
    public ResponseData QueryDistrict(String code) {
        return this.sysServiceFeign.QueryDistrict(code);
    }

    @ApiOperation(value="\u67e5\u8be2\u533b\u9662\u5217\u8868")
    @PostMapping(value={"/queryHospitalList"})
    public ResponseData queryHospitalList(@RequestBody HospitalDTO dto) {
        return this.sysServiceFeign.queryHospitalList(dto);
    }

    @ApiOperation(value="\u533b\u751f\u7aef-\u63a5\u8bca(\u6839\u636e\u95e8\u8bca\u53f7\u67e5\u8be2\u75c5\u7a0b\u4fe1\u606f\uff0c\u82e5\u672a\u67e5\u8be2\u5230\uff0c\u5219\u4ece\u6302\u53f7\u4fe1\u606f\u4e2d\u53d6\u6570\u636e\u8fdb\u884c\u75c5\u7a0b\u65b0\u589e)")
    @PostMapping(value={"/outpatientInformation"})
    public ResponseData OutpatientInformation(@RequestBody OutpatientInfomationDto outpatientInfomationDto) {
        return this.outpatientServiceFeign.queryOutpatientInformation(outpatientInfomationDto, Integer.valueOf(1), Integer.valueOf(1), "\u533b\u751f\u7aef");
    }

    @ApiOperation(value="\u67e5\u8be2\u60a3\u8005\u4e3b\u8ff0\u548c\u4e0a\u6b21\u8bca\u65ad")
    @GetMapping(value={"/queryNarrative"})
    public ResponseData queryNarrative(Integer patientId) {
        return this.outpatientServiceFeign.queryNarrative(patientId);
    }

    @ApiOperation(value="\u901a\u8fc7\u95e8\u8bca\u53f7\u67e5\u8be2\u60a3\u8005\u4e3b\u8ff0")
    @GetMapping(value={"/queryNarrativeByOutpatientNo"})
    public ResponseData queryNarrativeByOutpatientNo(String outpatientNo) {
        return this.outpatientServiceFeign.queryNarrativeByOutpatientNo(outpatientNo);
    }

    @ApiOperation(value="\u67e5\u8be2\u60a3\u8005\u5386\u53f2\u4e3b\u8ff0\u5217\u8868")
    @GetMapping(value={"/queryNarrativeList"})
    public ResponseData queryNarrativeList(Integer patientId) {
        return this.outpatientServiceFeign.queryNarrativeList(patientId);
    }

    @ApiOperation(value="\u67e5\u8be2\u5386\u53f2\u8bca\u65ad")
    @PostMapping(value={"/queryOutpatientMedicalRecords"})
    public ResponseData queryOutpatientMedicalRecords(@RequestBody OutpatientInfomationDto dto) {
        return this.outpatientServiceFeign.queryOutpatientMedicalRecords(dto, Integer.valueOf(1), Integer.valueOf(1), "\u533b\u751f\u7aef");
    }

    @ApiOperation(value="\u641c\u7d22\u8bca\u65ad")
    @PostMapping(value={"/queryIcd"})
    public ResponseData queryIcd(@RequestBody QueryOutIcdItemDto dto) {
        return this.outpatientServiceFeign.queryIcd(dto, Integer.valueOf(1));
    }

    @ApiOperation(value="\u66f4\u65b0\u95e8\u8bca\u75c5\u5386")
    @PostMapping(value={"/updateOutpatientMedicalRecords"})
    public ResponseData updateOutpatientMedicalRecords(@RequestBody DiagnosticReqDTO dto) {
        return this.outpatientServiceFeign.updateOutpatientMedicalRecords(dto, Integer.valueOf(1), Integer.valueOf(1), "\u533b\u751f\u7aef");
    }

    @ApiOperation(value="\u533b\u751f\u7aef-\u836f\u623f\u67e5\u8be2")
    @GetMapping(value={"/getStorageList"})
    public ResponseData getStorageList() {
        return this.sysServiceFeign.storageList(Integer.valueOf(1));
    }

    @ApiOperation(value="\u533b\u751f\u7aef-\u836f\u54c1\u67e5\u8be2")
    @GetMapping(value={"/drugSearch"})
    public ResponseData drugSearch(SysDrugPharmacySimpleDto dto) {
        return this.sysServiceFeign.pharmacyOutPageSearch(dto, Integer.valueOf(1));
    }

    @ApiOperation(value="\u533b\u751f\u7aef-\u836f\u54c1\u67e5\u8be2\uff08\u65b0\uff09")
    @GetMapping(value={"/drugSearchForPresc"})
    public ResponseData drugSearchForPresc(SysDrugPharmacySimpleDto dto) {
        log.info("\u67e5\u8be2\u836f\u54c1");
        return this.sysServiceFeign.drugSearchForPresc(dto, Integer.valueOf(1));
    }

    @ApiOperation(value="\u533b\u751f\u7aef-\u4fdd\u5b58/\u4fee\u6539\u5904\u65b9")
    @PostMapping(value={"/savePrescription"})
    public ResponseData savePrescription(@RequestBody SavePrescriptionDto dto) {
        return this.outpatientServiceFeign.savePrescription(dto, dto.getTenantId(), dto.getOperatorId(), dto.getOperatorName());
    }

    @ApiOperation(value="\u533b\u751f\u7aef-\u5220\u9664\u5904\u65b9")
    @PostMapping(value={"/deletePrescriptionsByNo"})
    public ResponseData deletePrescriptionsByNo(@RequestBody OutPrescriptionDto dto) {
        dto.setOperatorId(Integer.valueOf(36));
        dto.setOperatorName("\u5f90\u6377");
        return this.outpatientServiceFeign.deletePrescriptionsByNo(dto, Integer.valueOf(1), dto.getOperatorId(), dto.getOperatorName());
    }

    @ApiOperation(value="\u533b\u751f\u7aef-\u7ebf\u4e0a\u5904\u65b9\u5ba1\u6838\u5217\u8868")
    @GetMapping(value={"/onlinePrescriptionCheckList"})
    public ResponseData onlinePrescriptionCheckList() {
        return this.outpatientServiceFeign.queryPrescriptionCheckList();
    }

    @ApiOperation(value="\u533b\u751f\u7aef-\u7ebf\u4e0a\u5904\u65b9\u5ba1\u6838")
    @PostMapping(value={"/onlinePrescriptionCheck"})
    public ResponseData onlinePrescriptionCheck(@RequestBody OnlinePrescriptionCheckDto dto) {
        return this.outpatientServiceFeign.onlinePrescriptionCheck(dto);
    }

    @ApiOperation(value="\u6839\u636e\u95e8\u8bca\u53f7\uff0c\u67e5\u8be2\u5904\u65b9\u5217\u8868")
    @PostMapping(value={"/queryPrescriptions"})
    public ResponseData queryPrescriptions(@RequestBody OutpatientInfomationDto dto) {
        return this.outpatientServiceFeign.queryPrescriptions(dto, Integer.valueOf(1), Integer.valueOf(9001), "XHY");
    }

    @ApiOperation(value="\u533b\u751f\u7aef-\u67e5\u8be2\u5904\u65b9\u5217\u8868")
    @PostMapping(value={"/queryPrescriptionsList"})
    public ResponseData queryPrescriptionsList(@RequestBody PatientInfoDto dto) {
        Integer source = dto.getSource();
        if (source != null && source == 5) {
            return this.outpatientServiceFeign.queryPrescriptionsList2(dto, Integer.valueOf(1), dto.getOperatorId(), dto.getOperatorName());
        }
        return this.outpatientServiceFeign.queryPrescriptionsList(dto, Integer.valueOf(1), dto.getOperatorId(), dto.getOperatorName());
    }

    @ApiOperation(value="\u533b\u751f\u7aef-\u67e5\u8be2\u5904\u65b9\u5217\u8868")
    @PostMapping(value={"/queryPrescriptionsList2"})
    public ResponseData queryPrescriptionsList2(@RequestBody PatientInfoDto dto) {
        return this.outpatientServiceFeign.queryPrescriptionsList2(dto, Integer.valueOf(1), dto.getOperatorId(), dto.getOperatorName());
    }

    @ApiOperation(value="\u60a3\u8005\u8d44\u6599-\u5c31\u8bca\u75c5\u5386")
    @PostMapping(value={"/queryMedicalRecords"})
    public ResponseData queryMedicalRecords(@RequestBody QueryPatientMedicalDto dto) {
        return this.outpatientServiceFeign.queryMedicalRecords(dto, Integer.valueOf(1), Integer.valueOf(1), "\u533b\u751f\u7aef");
    }

    @ApiOperation(value="\u60a3\u8005\u8d44\u6599-\u68c0\u9a8c\u5217\u8868")
    @PostMapping(value={"/queryOutLisTreatmentItemList"})
    public ResponseData queryOutLisTreatmentItemList(@RequestBody QueryTreatmentItemDto dto) {
        return this.outpatientServiceFeign.queryOutLisTreatmentItemList(dto, Integer.valueOf(1), Integer.valueOf(1), "\u533b\u751f\u7aef");
    }

    @ApiOperation(value="\u533b\u751f\u7aef-\u5728\u7ebf\u72b6\u6001")
    @PostMapping(value={"/doctorOnline"})
    public ResponseData doctorOnline(@RequestBody DoctorOnlineDto dto) {
        dto.setTenantId(Integer.valueOf(1));
        return this.sysServiceFeign.doctorOnline(dto);
    }

    @ApiOperation(value="\u6839\u636e\u5904\u65b9\u53f7\u67e5\u8be2\u5904\u65b9\u4fe1\u606f")
    @GetMapping(value={"/selectPrescriptionDrugs"})
    public ResponseData doctorOnline(String prescriptionNo) {
        OutpatientInfomationDto dto = new OutpatientInfomationDto();
        dto.setPrescriptionNo(prescriptionNo);
        return this.outpatientServiceFeign.queryPrescriptionsByNo(dto, Integer.valueOf(1), Integer.valueOf(1), "\u533b\u751f\u7aef");
    }

    @ApiOperation(value="\u60a3\u8005\u7aef-\u5904\u65b9\u8be6\u60c5")
    @GetMapping(value={"/queryPrescriptionInfo"})
    public ResponseData queryPrescriptionInfo(String prescriptionNo) {
        return this.outpatientServiceFeign.queryPrescriptionInfo(prescriptionNo);
    }

    @ApiOperation(value="\u836f\u5e08\u5ba1\u6838\u5b8c\u6210\u66f4\u65b0\u5904\u65b9")
    @PostMapping(value={"/updatePrescription"})
    public ResponseData updatePrescription(@RequestBody NetPrescriptionDto dto) {
        return this.outpatientServiceFeign.updatePrescription(dto, Integer.valueOf(1), Integer.valueOf(1), "XHY");
    }

    @ApiOperation(value="\u95e8\u8bca\u53f7\u67e5\u8be2\u8bca\u65ad")
    @GetMapping(value={"/selectDiagnosisByOutpatientNo"})
    public ResponseData selectDiagnosisByOutpatientNo(String outpatientNo) {
        return this.outpatientServiceFeign.selectDiagnosisByOutpatientNo(outpatientNo);
    }

    @GetMapping(value={"/queryPatientByCardNo"})
    @ApiOperation(value="\u6839\u636e\u8bc1\u4ef6\u53f7\u67e5\u8be2\u60a3\u8005\u4fe1\u606f", httpMethod="GET", notes="\u6839\u636e\u8bc1\u4ef6\u53f7\u67e5\u8be2\u60a3\u8005\u4fe1\u606f")
    public ResponseData queryPatientByCardNo(@RequestParam(value="cardNo", required=true) String cardNo) {
        return this.outpatientServiceFeign.queryPatientByCardNo(cardNo, Integer.valueOf(1));
    }

    @PostMapping(value={"/patientInsert"})
    @ApiOperation(value="\u63d2\u5165\u60a3\u8005\u4fe1\u606f", httpMethod="POST", notes="\u63d2\u5165\u60a3\u8005\u4fe1\u606f")
    public ResponseData insert(@RequestBody RegisteredCardReqDTO patient) {
        return this.outpatientServiceFeign.patientInsert(patient, Integer.valueOf(1));
    }

    @GetMapping(value={"/queryPatientById"})
    @ApiOperation(value="\u6839\u636eid \u67e5\u8be2\u60a3\u8005\u4fe1\u606f", httpMethod="GET", notes="\u6839\u636eid \u67e5\u8be2\u60a3\u8005\u4fe1\u606f")
    public ResponseData<PatientEntity> queryPatientById(@RequestParam(value="id", required=true) Integer id) {
        return this.outpatientServiceFeign.queryPatientById(id);
    }

    @ApiOperation(value="\u521b\u5efa\u652f\u4ed8\u8ba2\u5355")
    @PostMapping(value={"/createPayOrder"})
    public ResponseData createPayOrder(@RequestBody WxPayDto dto) {
        FeeBillCreationDto feeBillCreationDto = new FeeBillCreationDto();
        ArrayList<String> orderNoList = new ArrayList<String>();
        orderNoList.add(dto.getOrderNo());
        feeBillCreationDto.setOrderNoList(orderNoList);
        feeBillCreationDto.setPayOrderName("\u5357\u660c\u4f17\u5eb7\u533b\u9662\u6709\u9650\u516c\u53f8");
        feeBillCreationDto.setSource(SourceEnum.NEW_ONLINE.getValue());
        feeBillCreationDto.setOperatorSource(SourceEnum.NEW_ONLINE.getValue());
        feeBillCreationDto.setAmount(dto.getAmount());
        feeBillCreationDto.setSettlementMethod(dto.getSettlementMethod());
        feeBillCreationDto.setOperatorId(Integer.valueOf(100));
        feeBillCreationDto.setOperatorName("\u4e92\u8054\u7f51\u533b\u9662");
        feeBillCreationDto.setTenantId(Integer.valueOf(1));
        feeBillCreationDto.setTotalAmount(dto.getAmount());
        feeBillCreationDto.setOutpatientNo(dto.getOutpatientNo());
        log.info("\u7f34\u8d39\u5165\u53c2======>" + JSONObject.toJSONString((Object)feeBillCreationDto));
        ResponseData orderCharge = this.outpatientServiceFeign.orderCharge(feeBillCreationDto, feeBillCreationDto.getTenantId(), Integer.valueOf(100), "\u4e92\u8054\u7f51\u533b\u9662");
        log.info("\u7f34\u8d39\u51fa\u53c2===>" + JSONObject.toJSONString((Object)orderCharge));
        JSONObject feeBillCreationVo = (JSONObject)JSONObject.parseObject((String)JSONObject.toJSONString((Object)orderCharge.getData()), JSONObject.class);
        return ResponseData.success((Object)feeBillCreationVo.getString("payOrderNo"));
    }

    @ApiOperation(value="\u751f\u6210\u5f00\u7968\u53c2\u6570")
    @PostMapping(value={"/createInvoiceParams"})
    public ResponseData createInvoiceParams(@RequestBody SysInvoiceDto dto) {
        return this.outpatientServiceFeign.createInvoiceParams(dto, dto.getTenantId(), "99999", Integer.valueOf(100), "\u516c\u4f17\u53f7");
    }

    @ApiOperation(value="\u66f4\u65b0\u53d1\u7968\u6570\u636e")
    @PostMapping(value={"/updateInvoice"})
    public ResponseData updateInvoice(@RequestBody SysInvoiceDto dto) {
        return this.outpatientServiceFeign.updateInvoice(dto, dto.getTenantId(), Integer.valueOf(100), "\u516c\u4f17\u53f7");
    }

    @ApiOperation(value="\u66f4\u65b0\u8ba2\u5355\u72b6\u6001")
    @PostMapping(value={"/paymentOrderUpdate"})
    public ResponseData paymentOrderUpdate(@RequestBody paymentOrderUpdateDTO dto) {
        return this.outpatientServiceFeign.paymentOrderUpdate(dto, Integer.valueOf(1), Integer.valueOf(9001), "XHY");
    }

    @ApiOperation(value="\u66f4\u65b0\u6302\u53f7\u8ba2\u5355\u72b6\u6001")
    @PostMapping(value={"/regOrderUpdate"})
    public ResponseData regOrderUpdate(@RequestBody paymentOrderUpdateDTO dto) {
        return this.outpatientServiceFeign.regOrderUpdate(dto, Integer.valueOf(1), Integer.valueOf(9001), "XHY");
    }

    @ApiOperation(value="\u533b\u751f\u7aef-\u67e5\u8be2\u5904\u65b9\u5217\u8868")
    @PostMapping(value={"/queryPrescriptionsByDoctorId"})
    public ResponseData queryPrescriptionsByDoctorId(@RequestBody PrescriptionsDTO dto) {
        return this.outpatientServiceFeign.queryPrescriptionsByDoctorId(dto, Integer.valueOf(1), Integer.valueOf(9001), "XHY");
    }

    @ApiOperation(value="\u533b\u751f\u7aef-\u67e5\u8be2\u6750\u6599\u5e93(\u7898\u4f0f\u5e3d)")
    @GetMapping(value={"/queryMaterial"})
    public ResponseData queryMaterial(SysTreatmentItemDto dto) {
        return this.sysServiceFeign.queryMaterial(dto, Integer.valueOf(1), Integer.valueOf(9001), "XHY");
    }

    @ApiOperation(value="\u95e8\u8bca\u53f7\u67e5\u8be2\u9879\u76ee\u5217\u8868")
    @PostMapping(value={"/queryItems"})
    public ResponseData queryItems(@RequestBody QueryItemsDto dto) {
        return this.outpatientServiceFeign.queryItems(dto, Integer.valueOf(1));
    }

    @ApiOperation(value="\u4fdd\u5b58\u6cbb\u7597\u9879\u76ee")
    @PostMapping(value={"/saveTreatmentItems"})
    public ResponseData saveTreatmentItems(@RequestBody SaveTreatmentItemsDto dto) {
        return this.outpatientServiceFeign.saveTreatmentItems(dto, Integer.valueOf(1), dto.getOperatorId(), dto.getOperatorName());
    }

    @PostMapping(value={"/voidItems"})
    @Operation(description="\u9879\u76eeid\u4f5c\u5e9f")
    @ApiOperation(value="\u9879\u76eeid\u4f5c\u5e9f", httpMethod="POST", notes="\u9879\u76eeid\u4f5c\u5e9f")
    public ResponseData voidItems(@RequestBody QueryItemsDto dto) {
        return this.outpatientServiceFeign.voidItems(dto, Integer.valueOf(1));
    }

    @PostMapping(value={"/queryItemsDetails"})
    @Operation(description="\u9879\u76eeid\u67e5\u8be2\u8be6\u60c5")
    @ApiOperation(value="\u9879\u76eeid\u67e5\u8be2\u8be6\u60c5", httpMethod="POST", notes="\u9879\u76eeid\u67e5\u8be2\u8be6\u60c5")
    public ResponseData queryItemsDetails(@RequestBody QueryItemsDto dto) {
        return this.outpatientServiceFeign.queryItemsDetails(dto, Integer.valueOf(1));
    }

    @PostMapping(value={"/queryDiagInfo"})
    @Operation(description="\u9879\u76eeid\u67e5\u8be2\u6162\u75c5")
    @ApiOperation(value="\u9879\u76eeid\u67e5\u8be2\u6162\u75c5", httpMethod="POST", notes="\u9879\u76eeid\u67e5\u8be2\u6162\u75c5")
    public ResponseData queryDiagInfo(@RequestBody QueryItemsDto dto) {
        return this.outpatientServiceFeign.queryDiagInfo(dto, Integer.valueOf(1));
    }

    @GetMapping(value={"/queryByOutpatientNo"})
    @Operation(description="\u95e8\u8bca\u53f7\u67e5\u8be2\u6302\u53f7\u8be6\u60c5")
    @ApiOperation(value="\u95e8\u8bca\u53f7\u67e5\u8be2\u6302\u53f7\u8be6\u60c5", httpMethod="GET", notes="\u95e8\u8bca\u53f7\u67e5\u8be2\u6302\u53f7\u8be6\u60c5")
    public ResponseData queryByOutpatientNo(String outpatientNo) {
        return this.outpatientServiceFeign.queryByOutpatientNo(outpatientNo, Integer.valueOf(1));
    }

    @PostMapping(value={"/queryHistoricalPrescriptionList"})
    @Operation(description="\u67e5\u8be2\u5386\u53f2\u5904\u65b9\u5217\u8868")
    @ApiOperation(value="\u67e5\u8be2\u5386\u53f2\u5904\u65b9\u5217\u8868", httpMethod="POST", notes="\u67e5\u8be2\u5386\u53f2\u5904\u65b9\u5217\u8868")
    public ResponseData queryHistoricalPrescriptionList(@RequestBody QueryHistoricalPrescriptionListDto dto) {
        return this.outpatientServiceFeign.queryHistoricalPrescriptionList(dto, Integer.valueOf(1), Integer.valueOf(9001), "XHY");
    }

    @PostMapping(value={"/checkObtainDrug"})
    @ApiOperation(value="\u6839\u636e\u60a3\u8005id\u6821\u9a8c\u5f00\u836f\u8bb0\u5f55", httpMethod="POST", notes="\u6839\u636e\u60a3\u8005id\u6821\u9a8c\u5f00\u836f\u8bb0\u5f55")
    public ResponseData checkObtainDrug(@RequestBody CheckObtainDrugDto param) {
        return this.outpatientServiceFeign.checkObtainDrug(param, Integer.valueOf(1), Integer.valueOf(9001), "XHY");
    }

    @PostMapping(value={"/queryItemInfoByOutpatientNo"})
    @ApiOperation(value="\u6839\u636e\u95e8\u8bca\u53f7\u67e5\u8be2\u8be6\u7ec6", httpMethod="POST", notes="\u6839\u636e\u95e8\u8bca\u53f7\u67e5\u8be2\u8be6\u7ec6")
    public ResponseData queryItemInfoByOutpatientNo(@RequestBody QueryFeeDetailsDto dto) {
        return this.outpatientServiceFeign.queryItemInfoByOutpatientNo(dto, Integer.valueOf(1), Integer.valueOf(9001), "XHY");
    }

    @ApiOperation(value="\u67e5\u8be2\u95e8\u8bca\u75c5\u5386")
    @GetMapping(value={"/queryOutpatientMedicalByOutpatientNo"})
    public ResponseData queryOutpatientMedicalByOutpatientNo(String outpatientNo) {
        return this.outpatientServiceFeign.queryOutpatientMedicalByOutpatientNo(outpatientNo);
    }

    @PostMapping(value={"/wxPayRefundNotify"})
    @ApiOperation(value="\u5fae\u4fe1\u652f\u4ed8\u9000\u6b3e\u56de\u8c03", httpMethod="POST", notes="\u5fae\u4fe1\u652f\u4ed8\u9000\u6b3e\u56de\u8c03")
    public ResponseData wxPayRefundNotify(@RequestBody JSONObject jsonObject) {
        return this.outpatientServiceFeign.wxPayRefundNotify(jsonObject, Integer.valueOf(1), Integer.valueOf(9001), "XHY");
    }

    @ApiOperation(value="\u67e5\u8be2\u662f\u5426\u9996\u8bca\u60a3\u8005")
    @GetMapping(value={"/queryFirstVisit"})
    public ResponseData queryFirstVisit(String patientId) {
        return this.outpatientServiceFeign.queryFirstVisit(patientId);
    }

    @ApiOperation(value="\u9662\u5185\u5927\u5c4f\u6570\u636e")
    @GetMapping(value={"/queryLargeScreenInfo"})
    public ResponseData queryLargeScreenInfo() {
        return this.outpatientServiceFeign.queryLargeScreenInfo();
    }

    @ApiOperation(value="\u66f4\u65b0\u63a5\u8bca\u72b6\u6001")
    @PostMapping(value={"/updateOutAdmission"})
    public ResponseData updateOutAdmission(@RequestBody JSONObject jsonObject) {
        return this.outpatientServiceFeign.updateOutAdmission(jsonObject, Integer.valueOf(1));
    }

    @ApiOperation(value="\u67e5\u8be2\u533b\u4fdd\u9650\u5236\u7528\u836f\u4fe1\u606f")
    @GetMapping(value={"/queryMedicalInsuranceDrugRemark"})
    public ResponseData queryMedicalInsuranceDrugRemark(String medicalInsuranceCode) {
        return this.sysServiceFeign.queryMedicalInsuranceDrugRemark(medicalInsuranceCode, Integer.valueOf(1));
    }

    @ApiOperation(value="\u6839\u636e\u95e8\u8bca\u53f7\u67e5\u8be2\u95e8\u8bca\u6253\u5370\u6570\u636e")
    @GetMapping(value={"/queryOutpatientPrintingData"})
    public ResponseData queryOutpatientPrintingData(String outpatientNo) {
        OutpatientInfomationDto parameter = new OutpatientInfomationDto();
        parameter.setOutpatientNo(outpatientNo);
        return this.outpatientServiceFeign.queryOutpatientPrintingData(parameter, Integer.valueOf(1), Integer.valueOf(9001), "XHY");
    }

    @PostMapping(value={"/addFlow"})
    @ApiOperation(value="\u65b0\u589e\u836f\u54c1\u7533\u8bf7\u6750\u6599", httpMethod="POST", notes="\u65b0\u589e\u836f\u54c1\u7533\u8bf7\u6750\u6599")
    public ResponseData addFlow(@RequestBody JSONObject jsonObject) {
        return this.outpatientServiceFeign.addFlow(jsonObject, Integer.valueOf(1));
    }

    @PostMapping(value={"/deleteFlow"})
    @ApiOperation(value="\u5220\u9664\u836f\u54c1\u7533\u8bf7\u6750\u6599", httpMethod="POST", notes="\u5220\u9664\u836f\u54c1\u7533\u8bf7\u6750\u6599")
    public ResponseData deleteFlow(@RequestBody JSONObject jsonObject) {
        return this.outpatientServiceFeign.deleteFlow(jsonObject, Integer.valueOf(1));
    }

    public static void main(String[] args) throws JsonProcessingException {
        SavePrescriptionDto dto = new SavePrescriptionDto();
        String js = JSONObject.toJSONString((Object)dto);
        System.out.println(js);
        ObjectMapper mapper = new ObjectMapper();
        mapper.setSerializationInclusion(JsonInclude.Include.ALWAYS);
        String js1 = mapper.writeValueAsString((Object)dto);
        System.out.println(js1);
    }
}

