/*
 * Decompiled with CFR 0.152.
 */
package com.byh.sdk.service.impl;

import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.byh.sdk.entity.bloodSugarResult.OutBloodSugarResultDetailEntity;
import com.byh.sdk.entity.bloodSugarResult.OutBloodSugarResultEntity;
import com.byh.sdk.entity.bloodSugarResult.OutBloodSugarResultVo;
import com.byh.sdk.entity.patient.PatientEntity;
import com.byh.sdk.entity.request.PatientResultDto;
import com.byh.sdk.enums.BloodSugarIndexEnum;
import com.byh.sdk.enums.DataTypeEnum;
import com.byh.sdk.enums.MedicalStatusEnum;
import com.byh.sdk.mapper.OutBloodSugarResultDetailMapper;
import com.byh.sdk.mapper.OutBloodSugarResultMapper;
import com.byh.sdk.mapper.PatientMapper;
import com.byh.sdk.service.OutBloodSugarResultService;
import com.byh.sdk.util.DateUtils;
import com.byh.sdk.util.ExceptionUtils;
import com.byh.sdk.util.StringPinYinUtil;
import com.byh.sdk.util.UUIDUtils;
import com.byh.sdk.util.exception.BusinessException;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class OutBloodSugarResultServiceImpl
extends ServiceImpl<OutBloodSugarResultMapper, OutBloodSugarResultEntity>
implements OutBloodSugarResultService {
    private Logger logger = LoggerFactory.getLogger(OutBloodSugarResultServiceImpl.class);
    @Resource
    private OutBloodSugarResultMapper outBloodSugarResultMapper;
    @Resource
    private OutBloodSugarResultDetailMapper outBloodSugarResultDetailMapper;
    @Resource
    private PatientMapper patientMapper;

    public List<OutBloodSugarResultVo> selectPatientResult(PatientResultDto dto) {
        List outBloodSugarResultVoList = this.outBloodSugarResultMapper.selectPatientResult(dto.getPatientId());
        if (!outBloodSugarResultVoList.isEmpty()) {
            List ids = outBloodSugarResultVoList.stream().map(OutBloodSugarResultVo::getId).distinct().collect(Collectors.toList());
            List detailList = this.outBloodSugarResultDetailMapper.selectList((Wrapper)Wrappers.lambdaQuery(OutBloodSugarResultDetailEntity.class).in(OutBloodSugarResultDetailEntity::getBloodSugarResultId, ids));
            for (OutBloodSugarResultDetailEntity detail : detailList) {
                String dataTypeLabel = Optional.ofNullable(DataTypeEnum.getEnumLabel((Integer)detail.getDataType())).map(DataTypeEnum::getLabel).orElse(null);
                detail.setDataTypeLabel(dataTypeLabel);
                String medicalStatusLabel = Optional.ofNullable(MedicalStatusEnum.getEnumLabel((Integer)detail.getMedicalStatus())).map(MedicalStatusEnum::getLabel).orElse(null);
                detail.setMedicalStatusLabel(medicalStatusLabel);
            }
            Map<String, List<OutBloodSugarResultDetailEntity>> detailMap = detailList.stream().collect(Collectors.groupingBy(OutBloodSugarResultDetailEntity::getBloodSugarResultId));
            for (OutBloodSugarResultVo vo : outBloodSugarResultVoList) {
                List details = Optional.ofNullable(detailMap.get(vo.getId())).orElse(new ArrayList());
                vo.setDetailList(details);
            }
        }
        return outBloodSugarResultVoList;
    }

    @Transactional(rollbackFor={BusinessException.class})
    public void deleteBloodSugarResult(Map<String, Object> map) {
        LinkedHashMap headMap = (LinkedHashMap)map.get("head");
        LinkedHashMap msgDataMap = (LinkedHashMap)map.get("msgdata");
        Integer resultId = this.getIntegerValue(msgDataMap, "resultId");
        OutBloodSugarResultEntity outBloodSugarResult = (OutBloodSugarResultEntity)this.outBloodSugarResultMapper.selectOne((Wrapper)Wrappers.lambdaQuery(OutBloodSugarResultEntity.class).eq(OutBloodSugarResultEntity::getResultId, (Object)resultId));
        if (outBloodSugarResult == null) {
            ExceptionUtils.createException((Logger)this.logger, (boolean)true, (String)"05", (String)"\u6570\u636e\u4e0d\u5b58\u5728");
        }
        this.outBloodSugarResultMapper.delete((Wrapper)Wrappers.lambdaQuery(OutBloodSugarResultEntity.class).eq(OutBloodSugarResultEntity::getId, (Object)outBloodSugarResult.getId()));
        this.outBloodSugarResultDetailMapper.delete((Wrapper)Wrappers.lambdaQuery(OutBloodSugarResultDetailEntity.class).eq(OutBloodSugarResultDetailEntity::getBloodSugarResultId, (Object)outBloodSugarResult.getId()));
    }

    @Transactional(rollbackFor={BusinessException.class})
    public void getBloodSugarResult(Map<String, Object> map) {
        OutBloodSugarResultEntity bloodSugarResult;
        LinkedHashMap headMap = (LinkedHashMap)map.get("head");
        LinkedHashMap msgDataMap = (LinkedHashMap)map.get("msgdata");
        Integer resultId = this.getIntegerValue(msgDataMap, "resultId");
        OutBloodSugarResultEntity dbBloodSugarResult = (OutBloodSugarResultEntity)this.outBloodSugarResultMapper.selectOne((Wrapper)Wrappers.lambdaQuery(OutBloodSugarResultEntity.class).eq(OutBloodSugarResultEntity::getResultId, (Object)resultId));
        if (dbBloodSugarResult != null) {
            ExceptionUtils.createException((Logger)this.logger, (boolean)true, (String)"01", (String)"\u91cd\u590d\u6570\u636e");
        }
        if (StrUtil.isNotEmpty((CharSequence)(bloodSugarResult = this.setOutBloodSugarResultEntity(msgDataMap)).getIdCard()) && bloodSugarResult.getIdCard().length() == 18) {
            PatientEntity patientEntity = (PatientEntity)this.patientMapper.selectOne((Wrapper)Wrappers.lambdaQuery(PatientEntity.class).eq(PatientEntity::getCardNo, (Object)bloodSugarResult.getIdCard()));
            if (patientEntity != null) {
                bloodSugarResult.setPatientId(patientEntity.getId());
            } else {
                try {
                    PatientEntity patient = new PatientEntity();
                    patient.setTenantId(Integer.valueOf(1));
                    patient.setName(bloodSugarResult.getName());
                    patient.setNamePinyin(StringPinYinUtil.toFirstChar((String)bloodSugarResult.getName()));
                    patient.setPhone(bloodSugarResult.getPhone());
                    patient.setCardType("1");
                    String idCard = bloodSugarResult.getIdCard();
                    patient.setCardNo(idCard);
                    String birthDayStr = idCard.substring(6, 14);
                    SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
                    Date birthDay = sdf.parse(birthDayStr);
                    Calendar now = Calendar.getInstance();
                    Calendar birth = Calendar.getInstance();
                    birth.setTime(birthDay);
                    int age = now.get(1) - birth.get(1);
                    if (now.get(2) < birth.get(2) || now.get(2) == birth.get(2) && now.get(5) < birth.get(5)) {
                        --age;
                    }
                    patient.setAge(Integer.valueOf(age));
                    patient.setBirthday(birthDayStr);
                    patient.setSex(String.valueOf(bloodSugarResult.getSex()));
                    String address = bloodSugarResult.getProvince() + bloodSugarResult.getCity() + bloodSugarResult.getCounty();
                    patient.setAddress(address);
                    String no = this.patientMapper.queryMaxMedicalNo(Integer.valueOf(1));
                    Integer endNo = StrUtil.isEmpty((CharSequence)no) ? Integer.valueOf(0) : Integer.valueOf(Integer.parseInt(no));
                    String currentDate = DateUtils.getCurrentDate((String)"yyMMdd");
                    Integer suffix = 1000001 + endNo;
                    patient.setMedicalRecordNo(currentDate + suffix);
                    this.patientMapper.insert((Object)patient);
                    bloodSugarResult.setPatientId(patient.getId());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        this.outBloodSugarResultMapper.insert((Object)bloodSugarResult);
        for (OutBloodSugarResultDetailEntity detailEntity : bloodSugarResult.getDetailList()) {
            this.outBloodSugarResultDetailMapper.insert((Object)detailEntity);
        }
    }

    private OutBloodSugarResultEntity setOutBloodSugarResultEntity(LinkedHashMap<String, String> msgDataMap) {
        OutBloodSugarResultEntity bloodSugarResult = new OutBloodSugarResultEntity();
        bloodSugarResult.setName(this.getString(msgDataMap, "name"));
        bloodSugarResult.setIdCard(this.getString(msgDataMap, "idCard"));
        bloodSugarResult.setSex(this.getIntegerValue(msgDataMap, "sex"));
        try {
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
            Date birthday = dateFormat.parse(msgDataMap.get("birthday"));
            bloodSugarResult.setBirthday(birthday);
            SimpleDateFormat dateTimeFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            Date createTime = dateTimeFormat.parse(msgDataMap.get("createTime"));
            bloodSugarResult.setCreateTime(createTime);
        }
        catch (Exception e) {
            ExceptionUtils.createException((Logger)this.logger, (boolean)true, (String)"500", (String)e.getMessage());
        }
        bloodSugarResult.setPhone(this.getString(msgDataMap, "phone"));
        bloodSugarResult.setBusinessLicense(this.getString(msgDataMap, "businessLicense"));
        bloodSugarResult.setCustomerCode(this.getString(msgDataMap, "customerCode"));
        bloodSugarResult.setCustomerName(this.getString(msgDataMap, "customerName"));
        bloodSugarResult.setProvince(this.getString(msgDataMap, "province"));
        bloodSugarResult.setProvinceCode(this.getIntegerValue(msgDataMap, "provinceCode"));
        bloodSugarResult.setCity(this.getString(msgDataMap, "city"));
        bloodSugarResult.setCityCode(this.getIntegerValue(msgDataMap, "cityCode"));
        bloodSugarResult.setCounty(this.getString(msgDataMap, "county"));
        bloodSugarResult.setCountyCode(this.getIntegerValue(msgDataMap, "countyCode"));
        bloodSugarResult.setChannelType(this.getIntegerValue(msgDataMap, "channelType"));
        bloodSugarResult.setResultId(this.getIntegerValue(msgDataMap, "resultId"));
        bloodSugarResult.setExtCode(this.getString(msgDataMap, "extCode"));
        bloodSugarResult.setSurveyorId(this.getIntegerValue(msgDataMap, "surveyorId"));
        bloodSugarResult.setSurveyorName(this.getString(msgDataMap, "surveyorName"));
        bloodSugarResult.setSurveyorPhone(this.getString(msgDataMap, "surveyorPhone"));
        bloodSugarResult.setUid(this.getString(msgDataMap, "uid"));
        bloodSugarResult.setUserId(this.getIntegerValue(msgDataMap, "userId"));
        bloodSugarResult.setLatitude(this.getDecimalValue(msgDataMap, "latitude"));
        bloodSugarResult.setLongitude(this.getDecimalValue(msgDataMap, "longitude"));
        bloodSugarResult.setQrCodeUrl(this.getString(msgDataMap, "qRCodeUrl"));
        String testTimeObject = msgDataMap.get("testTime");
        if (testTimeObject instanceof Long) {
            bloodSugarResult.setTestTime(new Date((Long)((Object)testTimeObject)));
        } else {
            bloodSugarResult.setTestTime(null);
        }
        bloodSugarResult.setId(UUIDUtils.getRandom((int)6, (boolean)true));
        ArrayList<OutBloodSugarResultDetailEntity> detailList = new ArrayList<OutBloodSugarResultDetailEntity>();
        String medicalResultIndexObject = msgDataMap.get("medicalResultIndexMap");
        if (medicalResultIndexObject instanceof LinkedHashMap) {
            LinkedHashMap indexMap = (LinkedHashMap)((Object)medicalResultIndexObject);
            for (Map.Entry entry : indexMap.entrySet()) {
                String indexName;
                String key = (String)entry.getKey();
                Object object = entry.getValue();
                if (!(object instanceof LinkedHashMap) || !StrUtil.isNotEmpty((CharSequence)(indexName = (String)Optional.ofNullable(BloodSugarIndexEnum.getEnumLabel((String)key)).map(BloodSugarIndexEnum::getLabel).orElse(null)))) continue;
                OutBloodSugarResultDetailEntity detailEntity = new OutBloodSugarResultDetailEntity();
                LinkedHashMap medicalResultIndexMap = (LinkedHashMap)object;
                detailEntity.setId(UUIDUtils.getRandom((int)6, (boolean)true));
                detailEntity.setBloodSugarResultId(bloodSugarResult.getId());
                detailEntity.setResult(this.getString(medicalResultIndexMap, "result"));
                detailEntity.setMedicalStatus(this.getIntegerValue(medicalResultIndexMap, "medicalStatus"));
                detailEntity.setMedicalUnits(this.getString(medicalResultIndexMap, "medicalUnits"));
                detailEntity.setDataType(this.getIntegerValue(medicalResultIndexMap, "dataType"));
                detailEntity.setMedicalReference(this.getString(medicalResultIndexMap, "medicalReference"));
                detailEntity.setIndexCode(key);
                detailEntity.setIndexName(indexName);
                detailList.add(detailEntity);
            }
            bloodSugarResult.setDetailList(detailList);
        }
        return bloodSugarResult;
    }

    private String getString(LinkedHashMap<String, String> msgDataMap, String field) {
        String object = msgDataMap.get(field);
        if (object instanceof String) {
            String result = object;
            return "".equals(result) ? null : result;
        }
        ExceptionUtils.createException((Logger)this.logger, (boolean)true, (String)"02", (String)(field + " \u5b57\u6bb5\u6570\u636e\u7c7b\u578b\u5f02\u5e38\uff0c\u5e94\u4e3a\uff1aString"));
        return null;
    }

    private Integer getIntegerValue(LinkedHashMap<String, String> msgDataMap, String field) {
        String object = msgDataMap.get(field);
        if (object instanceof Integer) {
            return (Integer)((Object)object);
        }
        ExceptionUtils.createException((Logger)this.logger, (boolean)true, (String)"02", (String)(field + " \u5b57\u6bb5\u6570\u636e\u7c7b\u578b\u5f02\u5e38\uff0c\u5e94\u4e3a\uff1aInteger"));
        return null;
    }

    private BigDecimal getDecimalValue(LinkedHashMap<String, String> msgDataMap, String field) {
        String object = msgDataMap.get(field);
        if (object instanceof Double) {
            Double objectDouble = (Double)((Object)object);
            return BigDecimal.valueOf(objectDouble);
        }
        ExceptionUtils.createException((Logger)this.logger, (boolean)true, (String)"02", (String)(field + " \u5b57\u6bb5\u6570\u636e\u7c7b\u578b\u5f02\u5e38\uff0c\u5e94\u4e3a\uff1aBigDecimal"));
        return BigDecimal.ZERO;
    }
}

