/*
 * Decompiled with CFR 0.152.
 */
package com.byh.sys.web.call_function;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.byh.sys.api.dto.drug.drugPharmacy.SysDrugPharmacyDto;
import com.byh.sys.api.dto.drug.drugPharmacy.SysDrugPharmacySaveDto;
import com.byh.sys.api.dto.drug.drugPharmacyCheck.SysDrugPharmacyCheckDto;
import com.byh.sys.api.dto.material.inventory.SysMaterialInventorySaveDto;
import com.byh.sys.api.dto.shelf.SysShelfDto;
import com.byh.sys.api.dto.shelf.SysShelfPharmacySaveDto;
import com.byh.sys.api.enums.SysDrugEnum;
import com.byh.sys.api.exception.BusinessException;
import com.byh.sys.api.model.drug.SysDrugEntity;
import com.byh.sys.api.model.drug.pharmacy.SysDrugPharmacyCheckPrescriptionEntity;
import com.byh.sys.api.model.drug.pharmacy.SysDrugPharmacyInEntity;
import com.byh.sys.api.model.drug.pharmacy.SysDrugPharmacyInPrescriptionEntity;
import com.byh.sys.api.model.drug.pharmacy.SysDrugPharmacyStorageEntity;
import com.byh.sys.api.model.material.SysMaterialEntity;
import com.byh.sys.api.model.material.SysMaterialInventoryInEntity;
import com.byh.sys.api.model.material.SysMaterialInventoryInPrescriptionEntity;
import com.byh.sys.api.model.shelf.SysDrugNumberRelationEntity;
import com.byh.sys.api.model.shelf.SysShelfEntity;
import com.byh.sys.api.model.shelf.SysShelfPharmacyBackLogEntity;
import com.byh.sys.api.model.shelf.SysShelfPharmacyEntity;
import com.byh.sys.api.util.BeanUtil;
import com.byh.sys.api.util.ExceptionUtils;
import com.byh.sys.api.util.UUIDUtils;
import com.byh.sys.api.vo.SysParamVo;
import com.byh.sys.api.vo.drug.SysDrugPharmacyVo;
import com.byh.sys.api.vo.material.SysMaterialInventoryVo;
import com.byh.sys.api.vo.shelf.SysShelfVo;
import com.byh.sys.data.repository.SysDrugMapper;
import com.byh.sys.data.repository.SysDrugNumberRelationMapper;
import com.byh.sys.data.repository.SysDrugPharmacyCheckMapper;
import com.byh.sys.data.repository.SysDrugPharmacyInPrescriptionMapper;
import com.byh.sys.data.repository.SysDrugPharmacyMapper;
import com.byh.sys.data.repository.SysDrugPharmacySimpleMapper;
import com.byh.sys.data.repository.SysDrugPharmacyStorageMapper;
import com.byh.sys.data.repository.SysMaterialInventoryInPrescriptionMapper;
import com.byh.sys.data.repository.SysMaterialInventoryMapper;
import com.byh.sys.data.repository.SysMaterialMapper;
import com.byh.sys.data.repository.SysParamMapper;
import com.byh.sys.data.repository.SysShelfMapper;
import com.byh.sys.data.repository.SysShelfPharmacyBackLogMapper;
import com.byh.sys.data.repository.SysShelfPharmacyMapper;
import com.byh.sys.web.call_function.ExtendServiceImpl;
import com.byh.sys.web.mvc.utils.CommonRequest;
import com.byh.sys.web.service.SysParamService;
import com.byh.sys.web.service.SysShelfService;
import com.byh.sys.web.service.impl.SysShelfServiceImpl;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ExtendServiceImpl {
    private static final Logger log = LoggerFactory.getLogger(ExtendServiceImpl.class);
    @Autowired
    private SysDrugPharmacyStorageMapper sysDrugPharmacyStorageMapper;
    @Autowired
    private SysParamMapper sysParamMapper;
    @Autowired
    private SysDrugPharmacyInPrescriptionMapper sysDrugPharmacyInPrescriptionMapper;
    @Autowired
    private SysShelfMapper sysShelfMapper;
    @Autowired
    private SysShelfPharmacyMapper sysShelfPharmacyMapper;
    @Autowired
    private SysDrugNumberRelationMapper sysDrugNumberRelationMapper;
    @Autowired
    private SysParamService sysParamService;
    @Autowired
    private SysDrugPharmacyMapper sysDrugPharmacyMapper;
    @Autowired
    private SysShelfService sysShelfService;
    @Autowired
    private SysDrugPharmacySimpleMapper sysDrugPharmacySimpleMapper;
    @Autowired
    private SysShelfServiceImpl sysShelfServiceImpl;
    @Autowired
    private SysShelfPharmacyBackLogMapper sysShelfPharmacyBackLogMapper;
    @Autowired
    private SysDrugMapper sysDrugMapper;
    @Autowired
    private SysMaterialMapper sysMaterialMapper;
    @Autowired
    private SysMaterialInventoryInPrescriptionMapper sysMaterialInventoryInPrescriptionMapper;
    @Autowired
    private SysMaterialInventoryMapper sysMaterialInventoryMapper;
    @Autowired
    private CommonRequest commonRequest;
    @Autowired
    private SysDrugPharmacyCheckMapper sysDrugPharmacyCheckMapper;

    public void checkShelf(SysDrugPharmacyInEntity entry) {
        SysDrugPharmacyStorageEntity storageEntity = (SysDrugPharmacyStorageEntity)this.sysDrugPharmacyStorageMapper.selectById((Serializable)((Object)entry.getWarehousingWarehouse()));
        if ("1".equals(storageEntity.getShelfCheck())) {
            ExceptionUtils.createException((Logger)log, (boolean)"0".equals(entry.getShelfUpdate()), (String)SysDrugEnum.SYS_DRUG_PHARMACY_CONFIRM_CHECK_SHELF_ERROR.getCode(), (String)SysDrugEnum.SYS_DRUG_PHARMACY_CONFIRM_CHECK_SHELF_ERROR.getName());
        }
    }

    public void inDrugPositionShelf(SysDrugPharmacyInEntity entry) {
        if (this.checkEnableShelf(entry.getTenantId(), entry.getWarehousingWarehouse(), "position_shelf")) {
            return;
        }
        List list = this.sysDrugPharmacyInPrescriptionMapper.selectList((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(SysDrugPharmacyInPrescriptionEntity::getDrugPharmacyInId, (Object)entry.getId())).eq(SysDrugPharmacyInPrescriptionEntity::getTenantId, (Object)entry.getTenantId()));
        for (SysDrugPharmacyInPrescriptionEntity n : list) {
            int quantity = n.getQuantity();
            ArrayList shelfPharmacyList = new ArrayList(5);
            CommonPharmacyEntity commonPharmacyEntity = (CommonPharmacyEntity)this.copyProperties((Object)entry, (Object)new CommonPharmacyEntity(this));
            CommonPrescriptionEntity commonPrescriptionEntity = (CommonPrescriptionEntity)this.copyProperties((Object)n, (Object)new CommonPrescriptionEntity(this));
            this.setPharmacyEntity(Integer.valueOf(quantity), commonPharmacyEntity, this.getDrugType(n.getDrugsName()), "1", shelfPharmacyList, commonPrescriptionEntity);
        }
    }

    public void inMaterialPositionShelf(SysMaterialInventoryInEntity entry) {
        List list = this.sysMaterialInventoryInPrescriptionMapper.selectList((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(SysMaterialInventoryInPrescriptionEntity::getMaterialInventoryInId, (Object)entry.getId())).eq(SysMaterialInventoryInPrescriptionEntity::getTenantId, (Object)entry.getTenantId()));
        for (SysMaterialInventoryInPrescriptionEntity n : list) {
            if (this.checkEnableShelf(entry.getTenantId(), n.getDrugsId(), "material_position_shelf")) continue;
            int quantity = n.getQuantity();
            ArrayList shelfPharmacyList = new ArrayList(5);
            CommonPharmacyEntity commonPharmacyEntity = (CommonPharmacyEntity)this.copyProperties((Object)entry, (Object)new CommonPharmacyEntity(this));
            CommonPrescriptionEntity commonPrescriptionEntity = (CommonPrescriptionEntity)this.copyProperties((Object)n, (Object)new CommonPrescriptionEntity(this));
            this.setPharmacyEntity(Integer.valueOf(quantity), commonPharmacyEntity, this.getDrugType(n.getDrugsName()), "2", shelfPharmacyList, commonPrescriptionEntity);
        }
    }

    public void drugCheckPositionShelf(Integer tenantId, String warehouse, List<SysDrugPharmacyCheckPrescriptionEntity> list) {
        if (this.checkEnableShelf(tenantId, warehouse, "position_shelf")) {
            return;
        }
        List ids = list.stream().map(SysDrugPharmacyCheckPrescriptionEntity::getDrugsId).collect(Collectors.toList());
        List drugList = this.sysDrugMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().in(SysDrugEntity::getId, ids)).eq(SysDrugEntity::getTenantId, (Object)tenantId)).eq(SysDrugEntity::getDelFlag, (Object)"0"));
        Map<String, List<SysDrugEntity>> drugMap = drugList.stream().collect(Collectors.groupingBy(SysDrugEntity::getId));
        ArrayList<SysShelfPharmacySaveDto> saveDtoList = new ArrayList<SysShelfPharmacySaveDto>();
        for (SysDrugPharmacyCheckPrescriptionEntity entry : list) {
            SysShelfPharmacySaveDto saveDto = (SysShelfPharmacySaveDto)BeanUtil.copy((Object)entry, SysShelfPharmacySaveDto.class);
            SysDrugEntity sysDrugEntity = drugMap.get(entry.getDrugsId()).get(0);
            SysDrugNumberRelationEntity relationEntity = (SysDrugNumberRelationEntity)this.sysDrugNumberRelationMapper.selectOne((Wrapper)Wrappers.lambdaQuery().eq(SysDrugNumberRelationEntity::getThirdCode, (Object)sysDrugEntity.getThirdCode()));
            saveDto.setSmallQuantity(entry.getPlNumber());
            saveDto.setId(UUIDUtils.getRandom((int)6, (boolean)true));
            ExceptionUtils.createException((Logger)log, (Math.abs(saveDto.getSmallQuantity()) % relationEntity.getNumber() > 0 ? 1 : 0) != 0, (String)"500", (String)("\u5165\u5e93\u4fdd\u5b58\u6821\u9a8c\u300a\u888b/\u4e2a -> \u4ef6\u300b\u3010" + Math.abs(saveDto.getSmallQuantity()) + "\u3011\u4e0d\u662f\u6574\u4ef6\u6570\u3010" + sysDrugEntity.getDrugsName() + " : " + sysDrugEntity.getThirdCode() + "\uff1b\u8f6c\u6362\u5173\u7cfb\uff1a" + relationEntity.getNumber() + "\u888b/\u4e2a1\u4ef6\u3011"));
            saveDto.setQuantity(Integer.valueOf(saveDto.getSmallQuantity() / relationEntity.getNumber()));
            saveDto.setWarehouse(warehouse);
            if (entry.getPlNumber() > 0) {
                saveDto.setInOutType("3");
            } else {
                saveDto.setInOutType("4");
            }
            SysShelfEntity sysShelfEntity = (SysShelfEntity)this.sysShelfMapper.selectOne((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(SysShelfEntity::getShelfNumber, (Object)entry.getShelfNumber())).eq(SysShelfEntity::getTenantId, (Object)tenantId));
            int quantity = sysShelfEntity.getCurrentQuantity() + saveDto.getQuantity();
            ExceptionUtils.createException((Logger)log, (quantity > sysShelfEntity.getUpperLimit() ? 1 : 0) != 0, (String)"500", (String)("\u76d8\u70b9\u6570\u91cf\u8d85\u9650\u989d\uff1b\u836f\u54c1\uff1a" + entry.getDrugsName() + "\uff1b\u76c8\u4e8f\u6570\u91cf\uff1a" + entry.getPlNumber() + "\uff1b\u5f53\u524d\u5e93\u5b58\u6570\uff1a" + sysShelfEntity.getCurrentQuantity() + "\uff1b\u4e0a\u9650\uff1a" + sysShelfEntity.getUpperLimit()));
            ExceptionUtils.createException((Logger)log, (quantity < 0 ? 1 : 0) != 0, (String)"500", (String)("\u76d8\u70b9\u6570\u91cf\u5c0f\u4e8e0\uff1b\u836f\u54c1\uff1a" + entry.getDrugsName() + "\uff1b\u76c8\u4e8f\u6570\u91cf\uff1a" + entry.getPlNumber() + "\uff1b\u5f53\u524d\u5e93\u5b58\u6570\uff1a" + sysShelfEntity.getCurrentQuantity() + "\uff1b\u4e0a\u9650\uff1a" + sysShelfEntity.getUpperLimit()));
            sysShelfEntity.setCurrentQuantity(Integer.valueOf(quantity));
            this.sysShelfMapper.updateById((Object)sysShelfEntity);
            saveDtoList.add(saveDto);
        }
        this.sysShelfPharmacyMapper.sysShelfPharmacySaveBatch(saveDtoList);
    }

    private void setPharmacyEntity(Integer quantity, CommonPharmacyEntity entry, String shelfType, String type, List<SysShelfPharmacySaveDto> shelfPharmacyList, CommonPrescriptionEntity n) {
        Integer relationNumber = this.checkRelation(n.getQuantity(), n.getTenantId(), n.getDrugsId(), type);
        quantity = quantity / relationNumber;
        List shelfList = this.sysShelfMapper.sysShelfSelect(entry.getTenantId(), shelfType, "1");
        for (SysShelfVo sysShelfVo : shelfList) {
            Integer currentQuantity = 0;
            SysShelfPharmacySaveDto saveDto = new SysShelfPharmacySaveDto();
            if (quantity <= 0) continue;
            saveDto.setShelfNumber(sysShelfVo.getShelfNumber());
            saveDto.setId(UUIDUtils.getRandom((int)6, (boolean)true));
            saveDto.setTenantId(entry.getTenantId());
            saveDto.setType(type);
            saveDto.setInOutType("1");
            saveDto.setInventoryId(entry.getId());
            saveDto.setBatchNumber(n.getBatchNumber());
            saveDto.setWarehouse(entry.getWarehousingWarehouse());
            saveDto.setDrugsId(n.getDrugsId());
            saveDto.setDrugsName(n.getDrugsName());
            saveDto.setPurchasePrice(n.getPurchasePrice());
            saveDto.setEffectiveTime(n.getEffectiveTime());
            saveDto.setCreateId(this.commonRequest.getUserId());
            if (quantity <= sysShelfVo.getActualInventory()) {
                saveDto.setSmallQuantity(Integer.valueOf(quantity * relationNumber));
                saveDto.setQuantity(quantity);
                currentQuantity = quantity;
                sysShelfVo.setCurrentQuantity(Integer.valueOf(sysShelfVo.getCurrentQuantity() + quantity));
                quantity = 0;
                shelfPharmacyList.add(saveDto);
            } else {
                quantity = quantity - sysShelfVo.getActualInventory();
                currentQuantity = sysShelfVo.getActualInventory();
                sysShelfVo.setCurrentQuantity(Integer.valueOf(sysShelfVo.getCurrentQuantity() + sysShelfVo.getActualInventory()));
                saveDto.setSmallQuantity(Integer.valueOf(sysShelfVo.getActualInventory() * relationNumber));
                saveDto.setQuantity(sysShelfVo.getActualInventory());
                shelfPharmacyList.add(saveDto);
            }
            ExceptionUtils.createException((Logger)log, (sysShelfVo.getCurrentQuantity() > sysShelfVo.getUpperLimit() ? 1 : 0) != 0, (String)"500", (String)("\u3010" + n.getDrugsName() + "\u3011\u8d27\u54c1\u5728\u8fdb\u884c\u3010" + sysShelfVo.getShelfNumber() + "\u8d27\u67b6\u53f7\u5165\u5e93\u8d27\u54c1\u65f6\u8d85\u51fa\u4e0a\u9650\u3011\u3010\u4e0a\u9650\uff1a" + sysShelfVo.getUpperLimit() + "\uff1b\u5f53\u524d:" + sysShelfVo.getCurrentQuantity() + "\uff1b\u5165\u5e93\uff1a" + currentQuantity + "\u3011"));
            SysShelfEntity shelfEntity = (SysShelfEntity)BeanUtil.copy((Object)sysShelfVo, SysShelfEntity.class);
            this.sysShelfMapper.updateById((Object)shelfEntity);
        }
        ExceptionUtils.createException((Logger)log, (quantity > 0 ? 1 : 0) != 0, (String)"500", (String)("\u8d27\u67b6\u53f7\u5269\u4f59\u7a7a\u95f4\u4e0d\u8db3\uff0c\u3010" + n.getDrugsName() + "\u3011\u8d27\u54c1\u5269\u4f59\u3010" + quantity + "\u4ef6\uff08" + quantity * relationNumber + "\u888b\uff09\u3011\u65e0\u6cd5\u5165\u5e93"));
        this.sysShelfPharmacyMapper.sysShelfPharmacySaveBatch(shelfPharmacyList);
    }

    public List<SysDrugPharmacyVo> getDrugBatchDetail(List<String> drugsIds, String outboundWarehouse, Integer tenantId) {
        if (this.checkEnableShelf(tenantId, outboundWarehouse, "position_shelf")) {
            List sysDrugPharmacyVos = this.sysDrugPharmacyMapper.sysDrugPharmacySelectByDrugsId(drugsIds, outboundWarehouse, tenantId);
            return sysDrugPharmacyVos;
        }
        List sysDrugPharmacyVos = this.sysDrugPharmacyMapper.sysDrugPharmacySelectByDrugsId2(drugsIds, outboundWarehouse, tenantId);
        return sysDrugPharmacyVos;
    }

    public List<SysMaterialInventoryVo> getMaterialBatchDetail(String drugsId, Integer tenantId) {
        ArrayList<String> drugsIds = new ArrayList<String>(1);
        drugsIds.add(drugsId);
        if (this.checkEnableShelf(tenantId, (String)drugsIds.get(0), "material_position_shelf")) {
            List list = this.sysMaterialInventoryMapper.sysMaterialInventorySelectByDrugsId(drugsIds, tenantId);
            return list;
        }
        List list = this.sysDrugPharmacyMapper.sysMaterialPharmacySelectByDrugsId2(drugsIds, tenantId);
        return list;
    }

    public void sysDrugShelfPharmacyOutSaveBatch(List<SysDrugPharmacySaveDto> saveDtoList, String warehouse, Integer tenantId) {
        if (this.checkEnableShelf(tenantId, warehouse, "position_shelf")) {
            return;
        }
        List list = BeanUtil.copyList(saveDtoList, SysShelfPharmacySaveDto.class);
        this.sysShelfPharmacyOutSaveBatch(list, tenantId, "1");
    }

    public void sysMaterialShelfPharmacyOutSaveBatch(List<SysMaterialInventorySaveDto> saveDtoList, Integer tenantId) {
        Map<String, List<SysMaterialInventorySaveDto>> drugsIdMap = saveDtoList.stream().collect(Collectors.groupingBy(SysMaterialInventorySaveDto::getDrugsId));
        for (Map.Entry<String, List<SysMaterialInventorySaveDto>> entry : drugsIdMap.entrySet()) {
            if (this.checkEnableShelf(tenantId, entry.getKey(), "material_position_shelf")) continue;
            List list = BeanUtil.copyList(entry.getValue(), SysShelfPharmacySaveDto.class);
            this.sysShelfPharmacyOutSaveBatch(list, tenantId, "2");
        }
    }

    private void sysShelfPharmacyOutSaveBatch(List<SysShelfPharmacySaveDto> list, Integer tenantId, String type) {
        for (SysShelfPharmacySaveDto n : list) {
            n.setType(type);
            n.setCreateId(this.commonRequest.getUserId());
            n.setSmallQuantity(n.getActualInventory());
            Integer relationNumber = this.checkRelation(n.getActualInventory(), n.getTenantId(), n.getDrugsId(), type);
            n.setQuantity(Integer.valueOf(n.getActualInventory() / relationNumber));
            List shelfList = this.sysShelfMapper.sysShelfSelect(tenantId, this.getDrugType(n.getDrugsName()), null);
            Map<String, List<SysShelfVo>> shelfMap = shelfList.stream().collect(Collectors.groupingBy(SysShelfVo::getShelfNumber));
            List<SysShelfVo> sysShelfVoList = shelfMap.get(n.getShelfNumber());
            ExceptionUtils.createException((Logger)log, (boolean)CollectionUtils.isEmpty(sysShelfVoList), (String)"500", (String)("\u3010sysShelfPharmacySaveBatch\u3011\u51fa\u5e93\u6263\u51cf\u8d27\u67b6\u8d27\u91cf\u672a\u5728sys_shelf\u8868\u67e5\u8be2\u5230" + n.getShelfNumber() + "\u8d27\u4f4d\u4fe1\u606f"));
            SysShelfVo vo = sysShelfVoList.get(0);
            ExceptionUtils.createException((Logger)log, (vo.getCurrentQuantity() + n.getQuantity() < 0 ? 1 : 0) != 0, (String)"500", (String)("\u66f4\u65b0\u68c0\u6d4b\u5230current_quantity\u5b57\u6bb5\u6570\u91cf\u5c0f\u4e8e0\uff1b\u3010\u8d27\u67b6\uff1a" + vo.getShelfNumber() + "\uff1b\u8d27\u67b6\u5269\u4f59\u6570\u91cf\uff1a" + vo.getCurrentQuantity() + "\uff1b\u51fa\u5e93\u6570\u91cf\uff1a" + Math.abs(n.getQuantity()) + "\u3011"));
            vo.setCurrentQuantity(Integer.valueOf(vo.getCurrentQuantity() + n.getQuantity()));
            this.sysShelfService.sysShelfUpdate((SysShelfEntity)BeanUtil.copy((Object)vo, SysShelfEntity.class));
        }
        this.sysShelfPharmacyMapper.sysShelfPharmacySaveBatch(list);
    }

    public IPage<SysDrugPharmacyVo> getDrugCheckSearch(Page page, SysDrugPharmacyCheckDto dto) {
        if (this.checkEnableShelf(dto.getTenantId(), dto.getWarehouse(), "position_shelf")) {
            IPage list = this.sysDrugPharmacyCheckMapper.sysDrugPharmacyCheckSearch(page, dto);
            return list;
        }
        IPage list = this.sysDrugPharmacyCheckMapper.sysDrugPharmacyCheckSearch2(page, dto);
        return list;
    }

    public IPage<SysDrugPharmacyVo> getDrugBackBatchDetail(Page page, SysDrugPharmacyDto dto, String drugRoomId) {
        if (this.checkEnableShelf(dto.getTenantId(), drugRoomId, "position_shelf")) {
            IPage list = this.sysDrugPharmacySimpleMapper.sysDrugPharmacyBatchDetail(page, dto, drugRoomId);
            return list;
        }
        IPage list = this.sysDrugPharmacySimpleMapper.sysDrugPharmacyBatchShelfDetail(page, dto, drugRoomId);
        return list;
    }

    public void sysDrugShelfBackDrug(String id, Integer tenantId, String warehouse) {
        if (this.checkEnableShelf(tenantId, warehouse, "position_shelf")) {
            return;
        }
        List sysShelfPharmacyList = this.sysShelfPharmacyMapper.selectList((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(SysShelfPharmacyEntity::getInventoryId, (Object)id)).eq(SysShelfPharmacyEntity::getTenantId, (Object)tenantId));
        ExceptionUtils.createException((Logger)log, (boolean)CollectionUtils.isEmpty((Collection)sysShelfPharmacyList), (String)"500", (String)("\u3010sysDrugShelfBackDrug\u3011\u836f\u623f\u9000\u836f\uff1b\u672a\u5728sys_shelf_pharmacy\u8868\u4e2d\u901a\u8fc7\u3010inventory_id\uff1a" + id + "\u3011\u67e5\u8be2\u51fa\u8d27\u67b6\u6279\u6b21\u4fe1\u606f"));
        this.sysShelfBack(sysShelfPharmacyList, tenantId);
    }

    public void sysMaterialShelfBackDrug(String id, Integer tenantId) {
        List sysShelfPharmacyList = this.sysShelfPharmacyMapper.selectList((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(SysShelfPharmacyEntity::getInventoryId, (Object)id)).eq(SysShelfPharmacyEntity::getTenantId, (Object)tenantId));
        ExceptionUtils.createException((Logger)log, (boolean)CollectionUtils.isEmpty((Collection)sysShelfPharmacyList), (String)"500", (String)("\u3010sysMaterialShelfBackDrug\u3011\u6750\u6599\u9000\u8d27\uff1b\u672a\u5728sys_shelf_pharmacy\u8868\u4e2d\u901a\u8fc7\u3010inventory_id\uff1a" + id + "\u3011\u67e5\u8be2\u51fa\u8d27\u67b6\u6279\u6b21\u4fe1\u606f"));
        this.sysShelfBack(sysShelfPharmacyList, tenantId);
    }

    private void sysShelfBack(List<SysShelfPharmacyEntity> sysShelfPharmacyList, Integer tenantId) {
        for (SysShelfPharmacyEntity n : sysShelfPharmacyList) {
            SysShelfDto dto = new SysShelfDto();
            dto.setTenantId(tenantId);
            dto.setType(this.getDrugType(n.getDrugsName()));
            dto.setShelfNumber(n.getShelfNumber());
            List shelfList = this.sysShelfMapper.sysShelfSelectByDto(dto);
            ExceptionUtils.createException((Logger)log, (boolean)CollectionUtils.isEmpty((Collection)shelfList), (String)"500", (String)("\u3010sysDrugPharmacyOutBackDrug\u3011\u836f\u623f\u9000\u836f\uff1b\u6ca1\u6709\u83b7\u53d6\u5230\u3010\u8d27\u4f4d\u53f7\uff1a" + n.getShelfNumber() + "\u3011"));
            SysShelfVo vo = (SysShelfVo)shelfList.get(0);
            int quantity = vo.getCurrentQuantity() + Math.abs(n.getQuantity());
            ExceptionUtils.createException((Logger)log, (quantity > vo.getUpperLimit() ? 1 : 0) != 0, (String)"500", (String)("\u3010sysDrugPharmacyOutBackDrug\u3011\u836f\u623f\u9000\u836f\u8d85\u51fa\u9650\u989d\uff1b\u3010\u4e0a\u9650\uff1a" + vo.getUpperLimit() + "\uff1b\u5f53\u524d\u5e93\u5b58\uff1a" + vo.getCurrentQuantity() + "\uff1b\u9000\u56de\u8d27\u54c1\uff1a" + Math.abs(n.getQuantity()) + "\u4ef6\u3011"));
            vo.setCurrentQuantity(Integer.valueOf(quantity));
            this.sysShelfServiceImpl.sysShelfUpdate((SysShelfEntity)BeanUtil.copy((Object)vo, SysShelfEntity.class));
        }
        List sysShelfPharmacyIds = sysShelfPharmacyList.stream().map(SysShelfPharmacyEntity::getId).collect(Collectors.toList());
        int b = this.sysShelfPharmacyBackLogMapper.sysShelfPharmacyBackDrugSaveBatch(BeanUtil.copyList(sysShelfPharmacyList, SysShelfPharmacyBackLogEntity.class));
        ExceptionUtils.createException((Logger)log, (int)b, (String)"500", (String)("\u3010sysDrugPharmacyOutBackDrug\u3011\u836f\u623f\u9000\u836f\u63d2\u5165\u5907\u4efd\u8868\u6570\u636e\u5f02\u5e38\uff0c\u5f02\u5e38id\u96c6\u5408\uff1a" + sysShelfPharmacyIds));
        int c = this.sysShelfPharmacyMapper.deleteBatchIds(sysShelfPharmacyIds);
        ExceptionUtils.createException((Logger)log, (int)c, (String)"500", (String)"\u3010sysDrugPharmacyOutBackDrug\u3011\u836f\u623f\u9000\u836f\uff0c\u5220\u9664sys_shelf_pharmacy\u8868\u4e2d\u7684\u51fa\u5e93\u6570\u636e\u51fa\u73b0\u5f02\u5e38\uff1b");
    }

    public void drugCheckDrugRelation(Integer quantity, Integer tenantId, String drugsId, String warehouse) {
        if (this.checkEnableShelf(tenantId, warehouse, "position_shelf")) {
            return;
        }
        this.checkRelation(quantity, tenantId, drugsId, "1");
    }

    public void materialCheckDrugRelation(Integer quantity, Integer tenantId, String drugsId) {
        if (this.checkEnableShelf(tenantId, drugsId, "material_position_shelf")) {
            return;
        }
        this.checkRelation(quantity, tenantId, drugsId, "2");
    }

    public Integer checkRelation(Integer quantity, Integer tenantId, String drugsId, String type) {
        String thirdCode = null;
        String drugsName = null;
        if ("1".equals(type)) {
            SysDrugEntity sysDrugEntity = (SysDrugEntity)this.sysDrugMapper.selectOne((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(SysDrugEntity::getId, (Object)drugsId)).eq(SysDrugEntity::getTenantId, (Object)tenantId));
            thirdCode = sysDrugEntity.getThirdCode();
            drugsName = sysDrugEntity.getDrugsName();
        } else if ("2".equals(type)) {
            SysMaterialEntity sysMaterialEntity = (SysMaterialEntity)this.sysMaterialMapper.selectOne((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(SysMaterialEntity::getId, (Object)drugsId)).eq(SysMaterialEntity::getTenantId, (Object)tenantId));
            thirdCode = sysMaterialEntity.getThirdCode();
            drugsName = sysMaterialEntity.getMaterialName();
        } else {
            ExceptionUtils.createException((Logger)log, (boolean)true, (String)"500", (String)("\u3010checkRelation\u3011\u6821\u9a8c\u8d27\u54c1\u300a \u888b/\u4e2a -> \u4ef6 \u300b\u7684\u5bf9\u5e94\u5173\u7cfb\u4f20\u5165\u53c2\u6570type\uff1a" + type + "\u7c7b\u578b\u4e0d\u5141\u8bb8"));
        }
        SysDrugNumberRelationEntity relation = (SysDrugNumberRelationEntity)this.sysDrugNumberRelationMapper.selectOne((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(SysDrugNumberRelationEntity::getTenantId, (Object)tenantId)).eq(SysDrugNumberRelationEntity::getThirdCode, (Object)thirdCode));
        ExceptionUtils.createException((Logger)log, (boolean)Objects.isNull(relation), (String)"500", (String)("\u3010" + drugsName + "\u3011\u8d27\u54c1\u6ca1\u6709\u300a\u888b/\u4e2a->\u4ef6\u300b\u7684\u8f6c\u6362\u5173\u7cfb"));
        ExceptionUtils.createException((Logger)log, (Math.abs(quantity) % relation.getNumber() > 0 ? 1 : 0) != 0, (String)"500", (String)("\u5165\u5e93\u4fdd\u5b58\u6821\u9a8c\u300a\u888b/\u4e2a -> \u4ef6\u300b\u3010" + Math.abs(quantity) + "\u3011\u4e0d\u662f\u6574\u4ef6\u6570\u3010" + drugsName + " : " + thirdCode + "\uff1b\u8f6c\u6362\u5173\u7cfb\uff1a" + relation.getNumber() + "\u888b/\u4e2a1\u4ef6\u3011"));
        return relation.getNumber();
    }

    private String getDrugType(String drugsName) {
        if (drugsName.contains("\u6c28\u57fa\u9178")) {
            return "2";
        }
        if (drugsName.contains("\u7898\u4f0f\u5e3d") && !drugsName.contains("\u5a01\u9ad8")) {
            return "3";
        }
        if (drugsName.contains("\u7898\u4f0f\u5e3d") && drugsName.contains("\u5a01\u9ad8")) {
            return "4";
        }
        return "1";
    }

    private boolean checkEnableShelf(Integer tenantId, String key, String paramName) {
        SysParamVo vo = this.sysParamMapper.selectByName(paramName, tenantId);
        JSONObject json = JSONObject.parseObject((String)vo.getValue());
        if (Objects.isNull(json)) {
            return Boolean.TRUE;
        }
        JSONObject warehouse = (JSONObject)json.get((Object)key);
        if (Objects.isNull(warehouse)) {
            return Boolean.TRUE;
        }
        if (1 != (Integer)warehouse.get((Object)"enable")) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    private <T> T copyProperties(Object object, T t) {
        try {
            BeanUtils.copyProperties((Object)object, t);
            return t;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BusinessException("500", "\u3010ExtendServiceImpl.copyProperties\u3011copy\u503c\u62a5\u9519\uff1a" + e.getMessage());
        }
    }
}

