/*
 * Decompiled with CFR 0.152.
 */
package com.byh.sys.web.mvc.controller;

import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.byh.sys.api.annotation.AntiRefresh;
import com.byh.sys.api.dto.SysLoginLogDto;
import com.byh.sys.api.exception.BusinessException;
import com.byh.sys.api.model.SysLoginLogEntity;
import com.byh.sys.api.util.ResponseData;
import com.byh.sys.web.mvc.utils.CommonRequest;
import com.byh.sys.web.service.SysLoginLogService;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"sysLoginLog"})
public class SysLoginLogController {
    private static final Logger log = LoggerFactory.getLogger(SysLoginLogController.class);
    private static Logger logger = LoggerFactory.getLogger(SysLoginLogController.class);
    private final SysLoginLogService sysLoginLogService;
    @Autowired
    private CommonRequest commonRequest;

    @ApiOperation(value="\u5217\u8868\u5206\u9875", httpMethod="GET", notes="\u5217\u8868\u5206\u9875")
    @GetMapping(value={"/pageList"})
    @AntiRefresh
    public ResponseData pageList(Page page, SysLoginLogDto dto) {
        dto.setTenantId(this.commonRequest.getTenant());
        return ResponseData.success((Object)this.sysLoginLogService.pageList(page, dto));
    }

    @ApiOperation(value="\u8be6\u60c5", httpMethod="GET", notes="\u8be6\u60c5")
    @GetMapping(value={"/getInfo"})
    @AntiRefresh
    public ResponseData getInfo(Integer loginLogId) {
        if (StrUtil.isEmpty((CharSequence)String.valueOf(loginLogId))) {
            throw new BusinessException("\u7cfb\u7edf\u767b\u5165\u65e5\u5fd7\u8868\u4e3b\u952eloginLogId\u4e0d\u80fd\u4e3a\u7a7a\uff01{id}" + loginLogId);
        }
        return ResponseData.success((Object)this.sysLoginLogService.getOne((Wrapper)Wrappers.lambdaQuery().eq(SysLoginLogEntity::getId, (Object)loginLogId)));
    }

    @PostMapping(value={"/removeSysLoginLog"})
    @ApiOperation(value="\u6279\u91cf\u5220\u9664", httpMethod="POST", notes="\u6279\u91cf\u5220\u9664")
    public ResponseData removeSysLoginLog(@ApiParam(value="\u4e3b\u952e\u96c6\u5408", required=true) @RequestBody Long[] ids) {
        return ResponseData.success((Object)this.sysLoginLogService.removeSysLoginLog(ids)).msg("\u5220\u9664\u6210\u529f");
    }

    public SysLoginLogController(SysLoginLogService sysLoginLogService) {
        this.sysLoginLogService = sysLoginLogService;
    }
}

