/*
 * Decompiled with CFR 0.152.
 */
package com.byh.sys.web.mvc.controller;

import com.byh.sys.api.dto.notice.SysNoticeDto;
import com.byh.sys.api.model.SysNoticeEntity;
import com.byh.sys.api.util.ResponseData;
import com.byh.sys.api.vo.SysNoticeVo;
import com.byh.sys.web.mvc.utils.CommonRequest;
import com.byh.sys.web.service.SysNoticeService;
import java.util.List;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/sysNotice"})
public class SysNoticeController {
    @Autowired
    private SysNoticeService sysNoticeService;
    @Autowired
    private CommonRequest commonRequest;

    @RequestMapping(value={"/save"})
    public ResponseData sysNoticeSave(@RequestBody @Valid SysNoticeEntity entity) {
        this.sysNoticeService.sysNoticeSave(entity);
        return ResponseData.success().save();
    }

    @GetMapping(value={"/select"})
    public ResponseData sysNoticeSelect(SysNoticeDto dto) {
        dto.setTenantId(this.commonRequest.getTenant());
        List list = this.sysNoticeService.sysNoticeSelect(dto);
        return ResponseData.success((Object)list);
    }

    @GetMapping(value={"/select/last"})
    public ResponseData sysNoticeSelectLast(SysNoticeDto dto) {
        dto.setTenantId(this.commonRequest.getTenant());
        SysNoticeVo vo = this.sysNoticeService.sysNoticeSelectLast(dto);
        return ResponseData.success((Object)vo);
    }

    @RequestMapping(value={"/update"})
    public ResponseData sysNoticeUpdate(@RequestBody @Valid SysNoticeEntity entity) {
        this.sysNoticeService.sysNoticeUpdate(entity);
        return ResponseData.success().update();
    }

    @RequestMapping(value={"/delete"})
    public ResponseData sysNoticeDelete(@RequestBody @Valid SysNoticeEntity entity) {
        this.sysNoticeService.sysNoticeDelete(entity);
        return ResponseData.success().delete();
    }
}

