/*
 * Decompiled with CFR 0.152.
 */
package com.byh.sys.web.mvc.controller.drug;

import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.byh.sys.api.annotation.AntiRefresh;
import com.byh.sys.api.annotation.UserOptLogger;
import com.byh.sys.api.dto.drug.SysDrugClassificationMiddleDto;
import com.byh.sys.api.exception.BusinessException;
import com.byh.sys.api.model.drug.SysDrugClassificationEntity;
import com.byh.sys.api.model.drug.SysDrugClassificationMiddleEntity;
import com.byh.sys.api.model.drug.SysDrugEntity;
import com.byh.sys.api.util.ResponseData;
import com.byh.sys.web.mvc.utils.CommonRequest;
import com.byh.sys.web.service.SysDrugClassificationMiddleService;
import com.byh.sys.web.service.SysDrugClassificationService;
import com.byh.sys.web.service.SysDrugService;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/drugClassification"})
public class SysDrugClassificationController {
    private static Logger logger = LoggerFactory.getLogger(SysDrugClassificationController.class);
    private final SysDrugClassificationService drugClassificationService;
    private final CommonRequest commonRequest;
    private final SysDrugClassificationMiddleService middleService;
    private final SysDrugService sysDrugService;

    @ApiOperation(value="\u836f\u54c1\u5206\u7c7b[\u6811\u5f62]", httpMethod="GET", notes="\u836f\u54c1\u5206\u7c7b[\u6811\u5f62]")
    @GetMapping(value={"/queryTree"})
    @AntiRefresh
    public ResponseData queryTree(SysDrugClassificationEntity entity) {
        entity.setTenantId(this.commonRequest.getTenant());
        return ResponseData.success((Object)this.drugClassificationService.queryTree(entity));
    }

    @UserOptLogger(operation="\u836f\u54c1\u5206\u7c7b\u7ba1\u7406\u6a21\u5757")
    @PostMapping(value={"/saveUpdate"})
    @ApiOperation(value="\u65b0\u589e\u6216\u4fee\u6539", httpMethod="POST", notes="\u65b0\u589e\u6216\u4fee\u6539")
    public ResponseData saveUpdates(@RequestBody SysDrugClassificationEntity entity) {
        entity.setTenantId(this.commonRequest.getTenant());
        entity.setCreateId(this.commonRequest.getUserId());
        entity.setCreateTime(new Date());
        entity.setUpdateId(this.commonRequest.getUserId());
        entity.setUpdateTime(new Date());
        if (StrUtil.isEmpty((CharSequence)entity.getParentId())) {
            throw new BusinessException("\u7236\u7ea7parentId\u4e0d\u80fd\u4e3a\u7a7a\uff01{parentId}" + entity.getParentId());
        }
        if (StrUtil.isEmpty((CharSequence)entity.getName())) {
            throw new BusinessException("\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01{name}\uff01" + entity.getName());
        }
        return ResponseData.success((Object)this.drugClassificationService.saveOrUpdate((Object)entity)).msg("\u4fdd\u5b58\u6216\u4fee\u6539\u6210\u529f");
    }

    @UserOptLogger(operation="\u836f\u54c1\u5206\u7c7b\u7ba1\u7406\u6a21\u5757")
    @PostMapping(value={"/removes"})
    @ApiOperation(value="\u6279\u91cf\u5220\u9664", httpMethod="POST", notes="\u6279\u91cf\u5220\u9664")
    public ResponseData removes(@ApiParam(value="\u4e3b\u952e\u96c6\u5408", required=true) @RequestBody Long[] ids) {
        return ResponseData.success((Object)this.drugClassificationService.removes(ids));
    }

    @ApiOperation(value="\u5217\u8868", httpMethod="GET", notes="\u5217\u8868")
    @GetMapping(value={"/classPage"})
    @AntiRefresh
    public ResponseData classPage(Page<SysDrugClassificationMiddleDto> page, SysDrugClassificationMiddleDto dto) {
        dto.setTenantId(this.commonRequest.getTenant());
        return ResponseData.success((Object)this.drugClassificationService.classPage(page, dto));
    }

    @UserOptLogger(operation="\u836f\u54c1\u5206\u7c7b\u4e0b\u65b0\u589e/\u7f16\u8f91\u836f\u54c1")
    @Transactional(rollbackFor={BusinessException.class})
    @PostMapping(value={"/saveUpdateClass"})
    @ApiOperation(value="\u836f\u54c1\u5206\u7c7b\u4e0b\u65b0\u589e\u6216\u4fee\u6539", httpMethod="POST", notes="\u836f\u54c1\u5206\u7c7b\u4e0b\u65b0\u589e/\u7f16\u8f91\u836f\u54c1")
    public ResponseData saveUpdateClass(@RequestBody List<SysDrugClassificationMiddleEntity> middleList) {
        if (StrUtil.isEmptyIfStr(middleList)) {
            throw new BusinessException("\u836f\u54c1\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a\uff01{name}\uff01" + middleList);
        }
        Integer classificationId = middleList.get(0).getClassificationId();
        middleList.forEach(a -> {
            a.setTenantId(this.commonRequest.getTenant());
            this.middleService.remove((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(SysDrugClassificationMiddleEntity::getClassificationId, (Object)classificationId)).eq(SysDrugClassificationMiddleEntity::getTenantId, (Object)this.commonRequest.getTenant())).eq(SysDrugClassificationMiddleEntity::getDrugId, (Object)a.getDrugId()));
            SysDrugEntity sysDrugEntity = new SysDrugEntity();
            sysDrugEntity.setClassificationId(a.getClassificationId());
            sysDrugEntity.setClassificationName(a.getClassificationName());
            this.sysDrugService.update((Object)sysDrugEntity, (Wrapper)((LambdaUpdateWrapper)Wrappers.lambdaUpdate().eq(SysDrugEntity::getId, (Object)a.getDrugId())).eq(SysDrugEntity::getTenantId, (Object)this.commonRequest.getTenant()));
        });
        this.middleService.saveBatch(middleList);
        return ResponseData.success().msg("\u4fdd\u5b58\u6216\u4fee\u6539\u6210\u529f");
    }

    @UserOptLogger(operation="\u6bcf\u4e2a\u836f\u54c1\u5206\u7c7b\u4e0b\u836f\u54c1")
    @PostMapping(value={"/removesMiddle"})
    @Transactional(rollbackFor={BusinessException.class})
    @ApiOperation(value="\u6279\u91cf\u5220\u9664", httpMethod="POST", notes="\u6279\u91cf\u5220\u9664")
    public ResponseData removesMiddle(@ApiParam(value="\u4e3b\u952e\u96c6\u5408", required=true) @RequestBody Long[] ids) {
        List list = this.middleService.list((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().in(SysDrugClassificationMiddleEntity::getId, (Object[])ids)).eq(SysDrugClassificationMiddleEntity::getTenantId, (Object)this.commonRequest.getTenant()));
        List collect = list.stream().map(SysDrugClassificationMiddleEntity::getDrugId).collect(Collectors.toList());
        SysDrugEntity sysDrugEntity = new SysDrugEntity();
        sysDrugEntity.setClassificationId(null);
        sysDrugEntity.setClassificationName("");
        sysDrugEntity.setTenantId(this.commonRequest.getTenant());
        this.sysDrugService.updateByClassification(sysDrugEntity, collect);
        this.middleService.remove((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().in(SysDrugClassificationMiddleEntity::getId, (Object[])ids)).eq(SysDrugClassificationMiddleEntity::getTenantId, (Object)this.commonRequest.getTenant()));
        return ResponseData.success().delete();
    }

    public SysDrugClassificationController(SysDrugClassificationService drugClassificationService, CommonRequest commonRequest, SysDrugClassificationMiddleService middleService, SysDrugService sysDrugService) {
        this.drugClassificationService = drugClassificationService;
        this.commonRequest = commonRequest;
        this.middleService = middleService;
        this.sysDrugService = sysDrugService;
    }
}

