/*
 * Decompiled with CFR 0.152.
 */
package com.byh.sys.web.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.byh.sys.api.dto.material.inventory.SysMaterialInventorySaveDto;
import com.byh.sys.api.dto.material.inventoryIn.SysMaterialInventoryInDto;
import com.byh.sys.api.dto.material.inventoryIn.SysMaterialInventoryInSaveDto;
import com.byh.sys.api.dto.material.inventoryIn.SysMaterialInventoryInUpdateDto;
import com.byh.sys.api.dto.material.inventoryInPrescrip.SysMaterialInventoryInPrescriptionSaveDto;
import com.byh.sys.api.dto.material.inventoryInPrescrip.SysMaterialInventoryInPrescriptionUpdateDto;
import com.byh.sys.api.dto.material.inventorySimple.SysMaterialInventorySimpleSaveDto;
import com.byh.sys.api.dto.material.inventoryStratEnd.SysMaterialInventoryQcQmSaveDto;
import com.byh.sys.api.enums.DictEnums;
import com.byh.sys.api.enums.SysMaterialInventoryEnum;
import com.byh.sys.api.exception.BusinessException;
import com.byh.sys.api.model.SysUserEntity;
import com.byh.sys.api.model.base.NoIdBaseEntity;
import com.byh.sys.api.model.material.SysMaterialEntity;
import com.byh.sys.api.model.material.SysMaterialInventoryInEntity;
import com.byh.sys.api.model.material.SysMaterialInventoryInPrescriptionEntity;
import com.byh.sys.api.model.material.SysMaterialInventoryQcQmEntity;
import com.byh.sys.api.model.material.SysMaterialInventorySimpleEntity;
import com.byh.sys.api.util.BeanUtil;
import com.byh.sys.api.util.DateUtils;
import com.byh.sys.api.util.ExceptionUtils;
import com.byh.sys.api.util.UUIDUtils;
import com.byh.sys.api.vo.material.SysMaterialInventoryInVo;
import com.byh.sys.data.repository.SysMaterialInventoryInMapper;
import com.byh.sys.data.repository.SysMaterialInventoryInPrescriptionMapper;
import com.byh.sys.data.repository.SysMaterialInventoryMapper;
import com.byh.sys.data.repository.SysMaterialInventoryQcQmMapper;
import com.byh.sys.data.repository.SysMaterialInventorySimpleMapper;
import com.byh.sys.data.repository.SysMaterialMapper;
import com.byh.sys.data.repository.SysUserMapper;
import com.byh.sys.web.call_function.ExtendServiceImpl;
import com.byh.sys.web.mvc.utils.CommonRequest;
import com.byh.sys.web.service.SysMaterialInventoryCheckService;
import com.byh.sys.web.service.SysMaterialInventoryInPrescriptionService;
import com.byh.sys.web.service.SysMaterialInventoryInService;
import com.byh.sys.web.service.SysMaterialInventoryQcQmService;
import com.byh.sys.web.service.SysMaterialInventorySimpleService;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SysMaterialInventoryInServiceImpl
implements SysMaterialInventoryInService {
    private static final Logger log = LoggerFactory.getLogger(SysMaterialInventoryInServiceImpl.class);
    @Resource
    private SysMaterialInventoryInMapper sysMaterialInventoryInMapper;
    @Autowired
    private SysMaterialInventoryInPrescriptionService sysMaterialInventoryInPrescriptionService;
    @Resource
    private SysMaterialInventoryInPrescriptionMapper sysMaterialInventoryInPrescriptionMapper;
    @Resource
    private SysMaterialInventoryMapper sysMaterialInventoryMapper;
    @Resource
    private SysMaterialInventorySimpleMapper sysMaterialInventorySimpleMapper;
    @Autowired
    private SysMaterialInventorySimpleService sysMaterialInventorySimpleService;
    @Resource
    private SysMaterialInventoryQcQmMapper sysMaterialInventoryQcQmMapper;
    @Resource
    private SysMaterialInventoryQcQmService sysMaterialInventoryQcQmService;
    @Resource
    private SysUserMapper sysUserMapper;
    @Autowired
    private CommonRequest commonRequest;
    @Resource
    private SysMaterialMapper sysMaterialMapper;
    @Autowired
    private SysMaterialInventoryCheckService sysMaterialInventoryCheckService;
    @Autowired
    private ExtendServiceImpl extendServiceImpl;

    @Transactional(rollbackFor={BusinessException.class})
    public void sysMaterialInventoryInSave(SysMaterialInventoryInSaveDto dto) {
        this.sysMaterialInventoryCheckService.sysMaterialInventoryCheckStatus();
        BigDecimal purchaseAmount = new BigDecimal(0);
        SysMaterialInventoryInEntity entity = (SysMaterialInventoryInEntity)BeanUtil.copy((Object)dto, SysMaterialInventoryInEntity.class);
        String materialInventoryInId = UUIDUtils.getRandom((int)6, (boolean)true);
        entity.setId(materialInventoryInId);
        entity.setAuditStatus(DictEnums.AUDIT_STATUS_WAIT.getCode());
        SysUserEntity userInfo = this.commonRequest.getUserInfo();
        if (null != userInfo) {
            entity.setWarehousingUse(userInfo.getUserName());
        }
        List prescripList = dto.getPrescripList();
        for (SysMaterialInventoryInPrescriptionSaveDto n : prescripList) {
            this.extendServiceImpl.materialCheckDrugRelation(n.getQuantity(), dto.getTenantId(), n.getDrugsId());
            n.setTenantId(dto.getTenantId());
            n.setMaterialInventoryInId(materialInventoryInId);
            n.setId(UUIDUtils.getRandom((int)6, (boolean)true));
            n.setPurchaseSalesDifference(n.getRetailPrice().subtract(n.getPurchasePrice()).toString());
            purchaseAmount = purchaseAmount.add(new BigDecimal(n.getQuantity()).multiply(n.getPurchasePrice()));
        }
        entity.setPurchaseAmount(purchaseAmount.toString());
        int a = this.sysMaterialInventoryInMapper.insert((Object)entity);
        ExceptionUtils.createException((Logger)log, (int)a, (String)SysMaterialInventoryEnum.SYS_MATERIAL_INVENTORY_INSERT_ERROR.getCode(), (String)SysMaterialInventoryEnum.SYS_MATERIAL_INVENTORY_INSERT_ERROR.getName());
        this.sysMaterialInventoryInPrescriptionService.sysMaterialInventoryInPrescriptionSaveBatch(prescripList);
    }

    public IPage<SysMaterialInventoryInVo> sysMaterialInventoryInSelect(Page page, SysMaterialInventoryInDto entity) {
        IPage list = this.sysMaterialInventoryInMapper.sysMaterialInventoryInSelect(page, entity);
        return list;
    }

    @Transactional(rollbackFor={BusinessException.class})
    public void sysMaterialInventoryInUpdate(SysMaterialInventoryInUpdateDto dto) {
        BigDecimal purchaseAmount = new BigDecimal(0);
        SysMaterialInventoryInEntity entity = (SysMaterialInventoryInEntity)BeanUtil.copy((Object)dto, SysMaterialInventoryInEntity.class);
        List list = dto.getPrescripList();
        if (!CollectionUtils.isEmpty((Collection)list)) {
            for (SysMaterialInventoryInPrescriptionUpdateDto n : list) {
                purchaseAmount = purchaseAmount.add(new BigDecimal(n.getQuantity()).multiply(n.getPurchasePrice()));
            }
            entity.setPurchaseAmount(purchaseAmount.toString());
            for (SysMaterialInventoryInPrescriptionUpdateDto n : list) {
                this.extendServiceImpl.materialCheckDrugRelation(n.getQuantity(), dto.getTenantId(), n.getDrugsId());
                n.setTenantId(dto.getTenantId());
                this.sysMaterialInventoryInPrescriptionService.sysMaterialInventoryInPrescriptionUpdate(n);
            }
        }
        int a = this.sysMaterialInventoryInMapper.update((Object)entity, (Wrapper)((LambdaUpdateWrapper)Wrappers.lambdaUpdate().eq(SysMaterialInventoryInEntity::getId, (Object)entity.getId())).eq(SysMaterialInventoryInEntity::getTenantId, (Object)entity.getTenantId()));
        ExceptionUtils.createException((Logger)log, (int)a, (String)SysMaterialInventoryEnum.SYS_MATERIAL_INVENTORY_UPDATE_ERROR.getCode(), (String)SysMaterialInventoryEnum.SYS_MATERIAL_INVENTORY_UPDATE_ERROR.getName());
    }

    public void sysMaterialInventoryInDelete(SysMaterialInventoryInDto entity) {
        int a = this.sysMaterialInventoryInMapper.sysMaterialInventoryInDelete(entity);
    }

    public List<SysMaterialInventoryInPrescriptionEntity> sysMaterialInventoryInDetail(String id) {
        List list = this.sysMaterialInventoryInPrescriptionMapper.selectList((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(SysMaterialInventoryInPrescriptionEntity::getMaterialInventoryInId, (Object)id)).eq(NoIdBaseEntity::getDelFlag, (Object)"0"));
        return list;
    }

    public void sysMaterialInventoryInCancel(String id) {
        SysMaterialInventoryInEntity entity = new SysMaterialInventoryInEntity();
        entity.setAuditStatus(DictEnums.AUDIT_STATUS_CANCEL.getCode());
        int a = this.sysMaterialInventoryInMapper.update((Object)entity, (Wrapper)Wrappers.lambdaUpdate().eq(SysMaterialInventoryInEntity::getId, (Object)id));
        ExceptionUtils.createException((Logger)log, (int)a, (String)SysMaterialInventoryEnum.SYS_MATERIAL_INVENTORY_UPDATE_ERROR.getCode(), (String)SysMaterialInventoryEnum.SYS_MATERIAL_INVENTORY_UPDATE_ERROR.getName());
    }

    @Transactional(rollbackFor={BusinessException.class})
    public void sysMaterialInventoryInConfirm(String id, Integer tenantId) {
        SysMaterialInventoryInEntity entry = (SysMaterialInventoryInEntity)this.sysMaterialInventoryInMapper.selectOne((Wrapper)Wrappers.lambdaUpdate().eq(SysMaterialInventoryInEntity::getId, (Object)id));
        ExceptionUtils.createException((Logger)log, (!DictEnums.AUDIT_STATUS_WAIT.getCode().equals(entry.getAuditStatus()) ? 1 : 0) != 0, (String)SysMaterialInventoryEnum.SYS_MATERIAL_INVENTORY_IN_STATUS_ALREADY_CONFIRM_ERROR.getCode(), (String)SysMaterialInventoryEnum.SYS_MATERIAL_INVENTORY_IN_STATUS_ALREADY_CONFIRM_ERROR.getName());
        this.extendServiceImpl.inMaterialPositionShelf(entry);
        SysMaterialInventoryInEntity entity = new SysMaterialInventoryInEntity();
        entity.setAuditStatus(DictEnums.AUDIT_STATUS_ALREADY.getCode());
        entity.setConfirmTime(new Date());
        SysUserEntity userInfo = this.commonRequest.getUserInfo();
        if (null != userInfo) {
            entity.setReviewedBy(userInfo.getUserName());
        }
        int a = this.sysMaterialInventoryInMapper.update((Object)entity, (Wrapper)Wrappers.lambdaUpdate().eq(SysMaterialInventoryInEntity::getId, (Object)id));
        ExceptionUtils.createException((Logger)log, (int)a, (String)SysMaterialInventoryEnum.SYS_MATERIAL_INVENTORY_UPDATE_ERROR.getCode(), (String)SysMaterialInventoryEnum.SYS_MATERIAL_INVENTORY_UPDATE_ERROR.getName());
        List saveDtoList = this.addInventory(id, tenantId, entry, entity.getConfirmTime());
    }

    public void addStartAndEnd(SysMaterialInventoryInEntity entry, List<SysMaterialInventorySaveDto> saveDtoList, Integer tenantId) {
        Date date = entry.getWarehousingTime();
        String year = DateUtils.dateFormat((Date)date, (String)"YYYY");
        String month = DateUtils.dateFormat((Date)date, (String)"MM");
        String day = DateUtils.dateFormat((Date)date, (String)"dd");
        for (SysMaterialInventorySaveDto saveDto : saveDtoList) {
            SysMaterialInventoryQcQmEntity qcQmEntity = (SysMaterialInventoryQcQmEntity)this.sysMaterialInventoryQcQmMapper.selectOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(SysMaterialInventoryQcQmEntity::getDrugId, (Object)saveDto.getDrugsId())).eq(SysMaterialInventoryQcQmEntity::getDrugYear, (Object)year)).eq(SysMaterialInventoryQcQmEntity::getDrugMonth, (Object)month)).eq(SysMaterialInventoryQcQmEntity::getDrugDay, (Object)day)).eq(SysMaterialInventoryQcQmEntity::getTenantId, (Object)tenantId));
            if (null != qcQmEntity) {
                qcQmEntity.setInNum(Integer.valueOf(qcQmEntity.getInNum() + saveDto.getActualInventory()));
                this.sysMaterialInventoryQcQmService.sysMaterialInventoryQcQmUpdateEntity(qcQmEntity);
                continue;
            }
            SysMaterialInventoryQcQmSaveDto qcQmSaveDto = new SysMaterialInventoryQcQmSaveDto();
            qcQmSaveDto.setId(UUIDUtils.getRandom((int)5, (boolean)true));
            qcQmSaveDto.setDrugYear(year);
            qcQmSaveDto.setDrugMonth(month);
            qcQmSaveDto.setDrugDay(day);
            qcQmSaveDto.setDrugId(saveDto.getDrugsId());
            qcQmSaveDto.setDrugName(saveDto.getDrugsName());
            qcQmSaveDto.setInNum(saveDto.getActualInventory());
            qcQmSaveDto.setTenantId(tenantId);
            this.sysMaterialInventoryQcQmService.sysMaterialInventoryQcQmSave(qcQmSaveDto);
        }
    }

    public List<SysMaterialInventorySaveDto> addInventory(String id, Integer tenantId, SysMaterialInventoryInEntity entry, Date confirmTime) {
        ArrayList<SysMaterialInventorySaveDto> saveDtoList = new ArrayList<SysMaterialInventorySaveDto>();
        List list = this.sysMaterialInventoryInPrescriptionMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(SysMaterialInventoryInPrescriptionEntity::getMaterialInventoryInId, (Object)id)).eq(SysMaterialInventoryInPrescriptionEntity::getTenantId, (Object)tenantId)).eq(NoIdBaseEntity::getDelFlag, (Object)Character.valueOf('0')));
        for (SysMaterialInventoryInPrescriptionEntity n : list) {
            this.selectAndCheckSimpleExist(n);
            SysMaterialInventorySaveDto saveDto = (SysMaterialInventorySaveDto)BeanUtil.copy((Object)n, SysMaterialInventorySaveDto.class);
            saveDto.setBatchNumber(n.getBatchNumber());
            saveDto.setId(UUIDUtils.getRandom((int)5, (boolean)true));
            saveDto.setInventoryId(n.getMaterialInventoryInId());
            saveDto.setActualInventory(n.getQuantity());
            saveDto.setPurchaseAmount(new BigDecimal(n.getQuantity()).multiply(n.getPurchasePrice()));
            saveDto.setRetailAmount(new BigDecimal(n.getQuantity()).multiply(n.getRetailPrice()));
            saveDto.setInOutType(DictEnums.IN_OUT_TYPE_IN.getCode());
            saveDto.setInOutMethod(entry.getWarehousingMethod());
            saveDto.setInOutTime(confirmTime);
            saveDto.setPurchasePrice(n.getPurchasePrice());
            saveDto.setRetailPrice(n.getRetailPrice());
            saveDtoList.add(saveDto);
        }
        this.sysMaterialInventoryMapper.sysMaterialInventorySaveBatch(saveDtoList);
        return saveDtoList;
    }

    private void selectAndCheckSimpleExist(SysMaterialInventoryInPrescriptionEntity n) {
        SysMaterialInventorySimpleEntity simpleMaterialEntity = (SysMaterialInventorySimpleEntity)this.sysMaterialInventorySimpleMapper.selectOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(SysMaterialInventorySimpleEntity::getDrugsId, (Object)n.getDrugsId())).eq(SysMaterialInventorySimpleEntity::getTenantId, (Object)n.getTenantId())).eq(NoIdBaseEntity::getDelFlag, (Object)"0"));
        if (null != simpleMaterialEntity) {
            simpleMaterialEntity.setActualInventory(Integer.valueOf(simpleMaterialEntity.getActualInventory() + n.getQuantity()));
            simpleMaterialEntity.setPurchaseAmount(simpleMaterialEntity.getPurchaseAmount().add(new BigDecimal(n.getQuantity()).multiply(n.getPurchasePrice())));
            this.sysMaterialInventorySimpleService.sysMaterialInventorySimpleUpdateEntity(simpleMaterialEntity);
        } else {
            SysMaterialInventorySimpleSaveDto simpleDto = (SysMaterialInventorySimpleSaveDto)BeanUtil.copy((Object)n, SysMaterialInventorySimpleSaveDto.class);
            simpleDto.setId(UUIDUtils.getRandom((int)5, (boolean)true));
            simpleDto.setActualInventory(n.getQuantity());
            simpleDto.setPurchaseAmount(new BigDecimal(n.getQuantity()).multiply(n.getPurchasePrice()));
            simpleDto.setRetailPriceAmount(new BigDecimal(n.getQuantity()).multiply(n.getRetailPrice()));
            simpleDto.setTenantId(n.getTenantId());
            SysMaterialEntity entity = (SysMaterialEntity)this.sysMaterialMapper.selectOne((Wrapper)Wrappers.lambdaQuery().eq(SysMaterialEntity::getId, (Object)simpleDto.getDrugsId()));
            if (null != entity) {
                simpleDto.setPinyin(entity.getMaterialPinyin());
            }
            this.sysMaterialInventorySimpleService.sysMaterialInventorySimpleSave(simpleDto);
        }
    }
}

