/*
 * Decompiled with CFR 0.152.
 */
package com.byh.sys.web.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.byh.sys.api.dto.material.inventory.SysMaterialInventorySaveDto;
import com.byh.sys.api.dto.material.inventoryOut.SysMaterialInventoryOutDto;
import com.byh.sys.api.dto.material.inventoryOut.SysMaterialInventoryOutSaveDto;
import com.byh.sys.api.dto.material.inventoryOut.SysMaterialInventoryOutUpdateDto;
import com.byh.sys.api.dto.material.inventoryOutPrescrip.SysMaterialInventoryOutPrescriptionSaveDto;
import com.byh.sys.api.dto.material.inventoryOutPrescrip.SysMaterialInventoryOutPrescriptionUpdateDto;
import com.byh.sys.api.dto.material.inventoryStratEnd.SysMaterialInventoryQcQmSaveDto;
import com.byh.sys.api.enums.DictEnums;
import com.byh.sys.api.enums.SysCommonEnum;
import com.byh.sys.api.enums.SysMaterialInventoryEnum;
import com.byh.sys.api.exception.BusinessException;
import com.byh.sys.api.model.SysUserEntity;
import com.byh.sys.api.model.base.NoIdBaseEntity;
import com.byh.sys.api.model.material.SysMaterialInventoryEntity;
import com.byh.sys.api.model.material.SysMaterialInventoryOutEntity;
import com.byh.sys.api.model.material.SysMaterialInventoryOutPrescriptionEntity;
import com.byh.sys.api.model.material.SysMaterialInventoryQcQmEntity;
import com.byh.sys.api.model.material.SysMaterialInventorySimpleEntity;
import com.byh.sys.api.util.BeanUtil;
import com.byh.sys.api.util.DateUtils;
import com.byh.sys.api.util.ExceptionUtils;
import com.byh.sys.api.util.StringUtils;
import com.byh.sys.api.util.UUIDUtils;
import com.byh.sys.api.vo.material.SysMaterialInventoryOutVo;
import com.byh.sys.api.vo.material.SysMaterialInventoryVo;
import com.byh.sys.data.repository.SysMaterialInventoryMapper;
import com.byh.sys.data.repository.SysMaterialInventoryOutMapper;
import com.byh.sys.data.repository.SysMaterialInventoryOutPrescriptionMapper;
import com.byh.sys.data.repository.SysMaterialInventoryQcQmMapper;
import com.byh.sys.data.repository.SysMaterialInventorySimpleMapper;
import com.byh.sys.data.repository.SysMaterialMapper;
import com.byh.sys.data.repository.SysTreatmentItemMapper;
import com.byh.sys.web.call_function.ExtendServiceImpl;
import com.byh.sys.web.mvc.utils.CommonRequest;
import com.byh.sys.web.service.SysMaterialInventoryCheckService;
import com.byh.sys.web.service.SysMaterialInventoryOutPrescriptionService;
import com.byh.sys.web.service.SysMaterialInventoryOutService;
import com.byh.sys.web.service.SysMaterialInventoryQcQmService;
import com.byh.sys.web.service.SysMaterialInventoryService;
import com.byh.sys.web.service.SysMaterialInventorySimpleService;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SysMaterialInventoryOutServiceImpl
implements SysMaterialInventoryOutService {
    private static final Logger log = LoggerFactory.getLogger(SysMaterialInventoryOutServiceImpl.class);
    @Autowired
    private CommonRequest commonRequest;
    @Resource
    private SysMaterialInventoryOutMapper sysMaterialInventoryOutMapper;
    @Resource
    private SysMaterialInventoryOutPrescriptionService sysMaterialInventoryOutPrescriptionService;
    @Resource
    private SysMaterialInventoryOutPrescriptionMapper sysMaterialInventoryOutPrescriptionMapper;
    @Resource
    private SysTreatmentItemMapper sysTreatmentItemMapper;
    @Resource
    private SysMaterialMapper sysMaterialMapper;
    @Resource
    private SysMaterialInventoryMapper sysMaterialInventoryMapper;
    @Resource
    private SysMaterialInventorySimpleMapper sysMaterialInventorySimpleMapper;
    @Autowired
    private SysMaterialInventorySimpleService sysMaterialInventorySimpleService;
    @Resource
    private SysMaterialInventoryQcQmMapper sysMaterialInventoryQcQmMapper;
    @Resource
    private SysMaterialInventoryQcQmService sysMaterialInventoryQcQmService;
    @Autowired
    private SysMaterialInventoryCheckService sysMaterialInventoryCheckService;
    @Autowired
    private ExtendServiceImpl extendServiceImpl;
    @Autowired
    private SysMaterialInventoryService sysMaterialInventoryService;

    @Transactional(rollbackFor={BusinessException.class})
    public SysMaterialInventoryOutEntity sysMaterialInventoryOutSave(SysMaterialInventoryOutSaveDto dto) {
        String outpatientNo = dto.getOutpatientNo();
        this.sysMaterialInventoryCheckService.sysMaterialInventoryCheckStatus();
        BigDecimal purchaseAmount = new BigDecimal(0);
        BigDecimal retailPrice = new BigDecimal(0);
        SysMaterialInventoryOutEntity entity = (SysMaterialInventoryOutEntity)BeanUtil.copy((Object)dto, SysMaterialInventoryOutEntity.class);
        String materialInventoryInId = UUIDUtils.getRandom((int)6, (boolean)true);
        entity.setId(materialInventoryInId);
        entity.setAuditStatus(DictEnums.AUDIT_STATUS_WAIT.getCode());
        List ids = dto.getPrescripList().stream().map(SysMaterialInventoryOutPrescriptionSaveDto::getDrugsId).collect(Collectors.toList());
        List materialList = this.sysMaterialInventorySimpleMapper.selectList((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().in(SysMaterialInventorySimpleEntity::getDrugsId, ids)).eq(SysMaterialInventorySimpleEntity::getTenantId, (Object)dto.getTenantId()));
        Map<String, List<SysMaterialInventorySimpleEntity>> map = materialList.stream().collect(Collectors.groupingBy(SysMaterialInventorySimpleEntity::getDrugsId));
        List prescripList = dto.getPrescripList();
        for (SysMaterialInventoryOutPrescriptionSaveDto n : prescripList) {
            this.extendServiceImpl.materialCheckDrugRelation(n.getQuantity(), dto.getTenantId(), n.getDrugsId());
            List<SysMaterialInventorySimpleEntity> l = map.get(n.getDrugsId());
            if (!CollectionUtils.isEmpty(l)) {
                SysMaterialInventorySimpleEntity entry = l.get(0);
                ExceptionUtils.createException((Logger)log, (entry.getActualInventory() < n.getQuantity() ? 1 : 0) != 0, (String)SysMaterialInventoryEnum.SYS_MATERIAL_INVENTORY_OUT_PRESCRIPTION_ERROR_01.getCode(), (String)("\u3010" + l.get(0).getDrugsName() + "\u3011\u51fa\u5e93\u6570\u91cf\u4e0d\u8db3\uff1a\u5e93\u5b58\u6570\u91cf\uff1a" + entry.getActualInventory() + ";\u51fa\u5e93\u6570\u91cf\uff1a" + n.getQuantity()));
            } else {
                ExceptionUtils.createException((Logger)log, (boolean)true, (String)SysMaterialInventoryEnum.SYS_MATERIAL_INVENTORY_OUT_PRESCRIPTION_ERROR_02.getCode(), (String)SysMaterialInventoryEnum.SYS_MATERIAL_INVENTORY_OUT_PRESCRIPTION_ERROR_02.getName());
            }
            n.setTenantId(dto.getTenantId());
            n.setMaterialInventoryOutId(materialInventoryInId);
            n.setId(UUIDUtils.getRandom((int)6, (boolean)true));
            retailPrice = retailPrice.add(new BigDecimal(n.getQuantity()).multiply(n.getRetailPrice()));
        }
        entity.setOutboundPurchaseAmount(purchaseAmount.toString());
        entity.setOutboundRetailAmount(retailPrice.toString());
        SysUserEntity userInfo = this.commonRequest.getUserInfo();
        if (null != userInfo) {
            entity.setOutboundUse(userInfo.getUserName());
        }
        int a = this.sysMaterialInventoryOutMapper.insert((Object)entity);
        ExceptionUtils.createException((Logger)log, (int)a, (String)SysMaterialInventoryEnum.SYS_MATERIAL_INVENTORY_OUT_INSERT_ERROR.getCode(), (String)SysMaterialInventoryEnum.SYS_MATERIAL_INVENTORY_OUT_INSERT_ERROR.getName());
        this.sysMaterialInventoryOutPrescriptionService.sysMaterialInventoryOutPrescriptionSaveBatch(prescripList);
        if (!StringUtils.isBlank((String)outpatientNo)) {
            this.sysMaterialInventoryOutConfirm(materialInventoryInId, dto.getTenantId());
        }
        return entity;
    }

    public IPage<SysMaterialInventoryOutVo> sysMaterialInventoryOutSelect(Page page, SysMaterialInventoryOutDto dto) {
        IPage list = this.sysMaterialInventoryOutMapper.sysMaterialInventoryOutSelect(page, dto);
        return list;
    }

    @Transactional(rollbackFor={BusinessException.class})
    public void sysMaterialInventoryOutUpdate(SysMaterialInventoryOutUpdateDto dto) {
        BigDecimal purchaseAmount = new BigDecimal(0);
        BigDecimal retailPrice = new BigDecimal(0);
        SysMaterialInventoryOutEntity entity = (SysMaterialInventoryOutEntity)BeanUtil.copy((Object)dto, SysMaterialInventoryOutEntity.class);
        List list = dto.getPrescripList();
        if (!CollectionUtils.isEmpty((Collection)list)) {
            for (SysMaterialInventoryOutPrescriptionUpdateDto n : dto.getPrescripList()) {
                purchaseAmount = purchaseAmount.add(new BigDecimal(n.getQuantity()).multiply(n.getPurchasePrice()));
                retailPrice = retailPrice.add(new BigDecimal(n.getQuantity()).multiply(n.getRetailPrice()));
            }
            entity.setOutboundPurchaseAmount(purchaseAmount.toString());
            entity.setOutboundRetailAmount(retailPrice.toString());
            for (SysMaterialInventoryOutPrescriptionUpdateDto n : list) {
                n.setTenantId(dto.getTenantId());
                this.sysMaterialInventoryOutPrescriptionService.sysMaterialInventoryOutPrescriptionUpdate(n);
            }
        }
        int a = this.sysMaterialInventoryOutMapper.update((Object)entity, (Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)Wrappers.lambdaUpdate().eq(NoIdBaseEntity::getDelFlag, (Object)"0")).eq(SysMaterialInventoryOutEntity::getTenantId, (Object)dto.getTenantId())).eq(SysMaterialInventoryOutEntity::getId, (Object)dto.getId()));
        ExceptionUtils.createException((Logger)log, (int)a, (String)SysMaterialInventoryEnum.SYS_MATERIAL_INVENTORY_OUT_UPDATE_ERROR.getCode(), (String)SysMaterialInventoryEnum.SYS_MATERIAL_INVENTORY_OUT_UPDATE_ERROR.getName());
    }

    public void sysMaterialInventoryOutDelete(String[] ids) {
        int a = this.sysMaterialInventoryOutMapper.sysMaterialInventoryOutDelete(ids);
        ExceptionUtils.createException((Logger)log, (int)a, (String)SysMaterialInventoryEnum.SYS_MATERIAL_INVENTORY_OUT_UPDATE_ERROR.getCode(), (String)SysMaterialInventoryEnum.SYS_MATERIAL_INVENTORY_OUT_UPDATE_ERROR.getName());
    }

    public List<SysMaterialInventoryOutPrescriptionEntity> sysMaterialInventoryOutDetail(String id) {
        List list = this.sysMaterialInventoryOutPrescriptionMapper.selectList((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(SysMaterialInventoryOutPrescriptionEntity::getMaterialInventoryOutId, (Object)id)).eq(NoIdBaseEntity::getDelFlag, (Object)"0"));
        return list;
    }

    public void sysMaterialInventoryOutCancel(String id) {
        SysMaterialInventoryOutEntity entity = new SysMaterialInventoryOutEntity();
        entity.setAuditStatus(DictEnums.AUDIT_STATUS_CANCEL.getCode());
        int a = this.sysMaterialInventoryOutMapper.update((Object)entity, (Wrapper)Wrappers.lambdaUpdate().eq(SysMaterialInventoryOutEntity::getId, (Object)id));
        ExceptionUtils.createException((Logger)log, (int)a, (String)SysMaterialInventoryEnum.SYS_MATERIAL_INVENTORY_OUT_UPDATE_ERROR.getCode(), (String)("\u3010\u51fa\u5e93\u5355\u53f7\uff1a" + id + "\u3011\u4f5c\u5e9f\u5f02\u5e38"));
    }

    @Transactional(rollbackFor={BusinessException.class})
    public void sysMaterialInventoryOutConfirm(String id, Integer tenantId) {
        SysMaterialInventoryOutEntity entry = (SysMaterialInventoryOutEntity)this.sysMaterialInventoryOutMapper.selectOne((Wrapper)Wrappers.lambdaUpdate().eq(SysMaterialInventoryOutEntity::getId, (Object)id));
        ExceptionUtils.createException((Logger)log, (!DictEnums.AUDIT_STATUS_WAIT.getCode().equals(entry.getAuditStatus()) ? 1 : 0) != 0, (String)SysMaterialInventoryEnum.SYS_MATERIAL_INVENTORY_OUT_STATUS_ALREADY_CONFIRM_ERROR.getCode(), (String)SysMaterialInventoryEnum.SYS_MATERIAL_INVENTORY_OUT_STATUS_ALREADY_CONFIRM_ERROR.getName());
        SysMaterialInventoryOutEntity entity = new SysMaterialInventoryOutEntity();
        entity.setAuditStatus(DictEnums.AUDIT_STATUS_ALREADY.getCode());
        entity.setConfirmTime(new Date());
        SysUserEntity userInfo = this.commonRequest.getUserInfo();
        if (null != userInfo) {
            entity.setCompositeUse(userInfo.getUserName());
        }
        int a = this.sysMaterialInventoryOutMapper.update((Object)entity, (Wrapper)Wrappers.lambdaUpdate().eq(SysMaterialInventoryOutEntity::getId, (Object)id));
        ExceptionUtils.createException((Logger)log, (int)a, (String)SysMaterialInventoryEnum.SYS_MATERIAL_INVENTORY_OUT_UPDATE_ERROR.getCode(), (String)SysMaterialInventoryEnum.SYS_MATERIAL_INVENTORY_OUT_UPDATE_ERROR.getName());
        List saveDtoList = this.addInventory(id, tenantId, entry, entity.getConfirmTime());
    }

    @Transactional(rollbackFor={BusinessException.class})
    public void sysMaterialInventoryBack(String id, Integer tenantId) {
        List sysMaterialInventoryList = this.sysMaterialInventoryMapper.selectList((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(SysMaterialInventoryEntity::getInventoryId, (Object)id)).eq(SysMaterialInventoryEntity::getTenantId, (Object)tenantId));
        for (SysMaterialInventoryEntity n : sysMaterialInventoryList) {
            List materialList = this.sysMaterialInventorySimpleMapper.selectList((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(SysMaterialInventorySimpleEntity::getDrugsId, (Object)n.getDrugsId())).eq(SysMaterialInventorySimpleEntity::getTenantId, (Object)tenantId));
            ExceptionUtils.createException((Logger)log, (materialList.size() > 1 ? 1 : 0) != 0, (String)"500", (String)("\u3010\u6750\u6599id\uff1a" + n.getDrugsId() + "\u3011\u67e5\u8be2\u7ed3\u679c\u4e0d\u552f\u4e00\uff0c\u51fa\u73b0" + materialList.size() + "\u6761\u6570\u636e"));
            SysMaterialInventorySimpleEntity material = (SysMaterialInventorySimpleEntity)materialList.get(0);
            material.setActualInventory(Integer.valueOf(material.getActualInventory() + Math.abs(n.getActualInventory())));
            material.setPurchaseAmount(material.getPurchaseAmount().add(n.getPurchasePrice().multiply(new BigDecimal(Math.abs(n.getActualInventory())))));
            this.sysMaterialInventorySimpleService.sysMaterialInventorySimpleUpdateEntity(material);
        }
        this.sysMaterialInventoryService.sysMaterialInventoryDeleteByInventoryId(id);
        SysMaterialInventoryOutEntity entity = new SysMaterialInventoryOutEntity();
        entity.setId(id);
        entity.setAuditStatus("3");
        this.sysMaterialInventoryOutCancel(id);
        this.extendServiceImpl.sysMaterialShelfBackDrug(id, tenantId);
    }

    public void addStartAndEnd(SysMaterialInventoryOutEntity entry, List<SysMaterialInventorySaveDto> saveDtoList, Integer tenantId) {
        Date date = entry.getOutboundTime();
        String year = DateUtils.dateFormat((Date)date, (String)"YYYY");
        String month = DateUtils.dateFormat((Date)date, (String)"MM");
        String day = DateUtils.dateFormat((Date)date, (String)"dd");
        for (SysMaterialInventorySaveDto saveDto : saveDtoList) {
            SysMaterialInventoryQcQmEntity qcQmEntity = (SysMaterialInventoryQcQmEntity)this.sysMaterialInventoryQcQmMapper.selectOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(SysMaterialInventoryQcQmEntity::getDrugId, (Object)saveDto.getDrugsId())).eq(SysMaterialInventoryQcQmEntity::getDrugYear, (Object)year)).eq(SysMaterialInventoryQcQmEntity::getDrugMonth, (Object)month)).eq(SysMaterialInventoryQcQmEntity::getDrugDay, (Object)day)).eq(SysMaterialInventoryQcQmEntity::getTenantId, (Object)tenantId));
            if (null != qcQmEntity) {
                qcQmEntity.setOutNum(Integer.valueOf(qcQmEntity.getOutNum() + saveDto.getActualInventory()));
                this.sysMaterialInventoryQcQmService.sysMaterialInventoryQcQmUpdateEntity(qcQmEntity);
                continue;
            }
            SysMaterialInventoryQcQmSaveDto qcQmSaveDto = new SysMaterialInventoryQcQmSaveDto();
            qcQmSaveDto.setId(UUIDUtils.getRandom((int)5, (boolean)true));
            qcQmSaveDto.setDrugYear(year);
            qcQmSaveDto.setDrugMonth(month);
            qcQmSaveDto.setDrugDay(day);
            qcQmSaveDto.setDrugId(saveDto.getDrugsId());
            qcQmSaveDto.setDrugName(saveDto.getDrugsName());
            qcQmSaveDto.setOutNum(saveDto.getActualInventory());
            qcQmSaveDto.setTenantId(tenantId);
            this.sysMaterialInventoryQcQmService.sysMaterialInventoryQcQmSave(qcQmSaveDto);
        }
    }

    public List<SysMaterialInventorySaveDto> addInventory(String id, Integer tenantId, SysMaterialInventoryOutEntity entry, Date confirmTime) {
        ArrayList<SysMaterialInventorySaveDto> saveDtoList = new ArrayList<SysMaterialInventorySaveDto>();
        List list = this.sysMaterialInventoryOutPrescriptionMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(SysMaterialInventoryOutPrescriptionEntity::getMaterialInventoryOutId, (Object)id)).eq(SysMaterialInventoryOutPrescriptionEntity::getTenantId, (Object)tenantId)).eq(NoIdBaseEntity::getDelFlag, (Object)Character.valueOf('0')));
        this.batchOut(list, entry, saveDtoList, confirmTime);
        this.sysMaterialInventoryMapper.sysMaterialInventorySaveBatch(saveDtoList);
        this.extendServiceImpl.sysMaterialShelfPharmacyOutSaveBatch(saveDtoList, tenantId);
        return saveDtoList;
    }

    private void batchOut(List<SysMaterialInventoryOutPrescriptionEntity> list, SysMaterialInventoryOutEntity entry, List<SysMaterialInventorySaveDto> saveDtoList, Date confirmTime) {
        for (SysMaterialInventoryOutPrescriptionEntity n : list) {
            List batch = this.extendServiceImpl.getMaterialBatchDetail(n.getDrugsId(), n.getTenantId());
            batch = batch.stream().filter(m -> m.getActualInventory() > 0).collect(Collectors.toList());
            BigDecimal purchasePriceAmount = new BigDecimal(0);
            Integer quantity = n.getQuantity();
            for (SysMaterialInventoryVo m2 : batch) {
                if (quantity <= 0) continue;
                SysMaterialInventorySaveDto saveDto = (SysMaterialInventorySaveDto)BeanUtil.copy((Object)n, SysMaterialInventorySaveDto.class);
                saveDto.setId(UUIDUtils.getRandom((int)5, (boolean)true));
                saveDto.setInventoryId(n.getMaterialInventoryOutId());
                saveDto.setInOutType(DictEnums.IN_OUT_TYPE_OUT.getCode());
                saveDto.setInOutMethod(entry.getOutboundMethod());
                saveDto.setBatchNumber(m2.getBatchNumber());
                saveDto.setInOutTime(confirmTime);
                saveDto.setShelfNumber(m2.getShelfNumber());
                if (m2.getActualInventory() <= quantity) {
                    saveDto.setActualInventory(Integer.valueOf(-m2.getActualInventory().intValue()));
                    saveDto.setPurchaseAmount(new BigDecimal(m2.getActualInventory()).multiply(m2.getPurchasePrice()));
                    saveDto.setRetailAmount(new BigDecimal(m2.getActualInventory()).multiply(n.getRetailPrice()));
                    saveDto.setEffectiveTime(m2.getEffectiveTime());
                    saveDto.setPurchasePrice(m2.getPurchasePrice());
                    purchasePriceAmount = purchasePriceAmount.add(saveDto.getPurchaseAmount());
                    quantity = quantity - m2.getActualInventory();
                    saveDtoList.add(saveDto);
                    continue;
                }
                saveDto.setActualInventory(Integer.valueOf(-quantity.intValue()));
                saveDto.setPurchaseAmount(new BigDecimal(quantity).multiply(m2.getPurchasePrice()));
                saveDto.setRetailAmount(new BigDecimal(m2.getActualInventory()).multiply(n.getRetailPrice()));
                saveDto.setEffectiveTime(m2.getEffectiveTime());
                saveDto.setPurchasePrice(m2.getPurchasePrice());
                purchasePriceAmount = purchasePriceAmount.add(saveDto.getPurchaseAmount());
                saveDtoList.add(saveDto);
                quantity = 0;
                break;
            }
            ExceptionUtils.createException((Logger)log, (quantity > 0 ? 1 : 0) != 0, (String)"500", (String)("\u3010\u6750\u6599\uff1a" + n.getDrugsName() + "\u3011\u51fa\u5e93\u6570\u91cf\u4e0d\u8db3\uff0c\u5269\u4f59\uff1a" + quantity + "\u65e0\u6cd5\u51fa\u5e93"));
            n.setPurchasePrice(purchasePriceAmount);
            this.selectAndCheckSimpleExist(n);
        }
    }

    private void selectAndCheckSimpleExist(SysMaterialInventoryOutPrescriptionEntity n) {
        SysMaterialInventorySimpleEntity simpleMaterialEntity = (SysMaterialInventorySimpleEntity)this.sysMaterialInventorySimpleMapper.selectOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(SysMaterialInventorySimpleEntity::getDrugsId, (Object)n.getDrugsId())).eq(SysMaterialInventorySimpleEntity::getTenantId, (Object)n.getTenantId())).eq(NoIdBaseEntity::getDelFlag, (Object)"0"));
        if (null != simpleMaterialEntity) {
            simpleMaterialEntity.setActualInventory(Integer.valueOf(simpleMaterialEntity.getActualInventory() - n.getQuantity()));
            simpleMaterialEntity.setPurchaseAmount(simpleMaterialEntity.getPurchaseAmount().subtract(n.getPurchasePrice()));
            this.commonRequest.checkNumber(n.getDrugsName() + SysCommonEnum.BACK_OR_LOSS_LT_ZERO_03.getCode(), SysCommonEnum.BACK_OR_LOSS_LT_ZERO_03.getName(), new Integer[]{simpleMaterialEntity.getActualInventory()});
            this.sysMaterialInventorySimpleService.sysMaterialInventorySimpleUpdateEntity(simpleMaterialEntity);
        } else {
            ExceptionUtils.createException((Logger)log, (boolean)Boolean.TRUE, (String)SysMaterialInventoryEnum.SYS_MATERIAL_SIMPLE_OUT_ERROR.getCode(), (String)SysMaterialInventoryEnum.SYS_MATERIAL_SIMPLE_OUT_ERROR.getName());
        }
    }
}

