/*
 * Decompiled with CFR 0.152.
 */
package com.byh.sys.web.service.impl;

import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.byh.sys.api.dto.SysEasyEntity;
import com.byh.sys.api.dto.sysParam.GetSysParamPageDto;
import com.byh.sys.api.enums.DelFlagEnum;
import com.byh.sys.api.exception.BusinessException;
import com.byh.sys.api.model.SysParamEntity;
import com.byh.sys.api.util.ExceptionUtils;
import com.byh.sys.api.util.UUIDUtils;
import com.byh.sys.api.vo.SysParamVo;
import com.byh.sys.data.repository.SysParamMapper;
import com.byh.sys.web.service.SysParamService;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SysParamServiceImpl
implements SysParamService {
    private static final Logger log = LoggerFactory.getLogger(SysParamServiceImpl.class);
    private Logger logger = LoggerFactory.getLogger(SysParamServiceImpl.class);
    @Resource
    private SysParamMapper sysParamMapper;

    public Page<SysParamEntity> selectPageList(GetSysParamPageDto dto) {
        Page page = new Page((long)dto.getCurrent().intValue(), (long)dto.getSize().intValue());
        List list = this.sysParamMapper.selectSysParamList(page, dto);
        page.setRecords(list);
        return page;
    }

    public void deleteSysParamByIds(String[] ids, Integer tenantId, Integer userId, String userName) {
        if (ids == null || ids.length == 0) {
            ExceptionUtils.createException((Logger)this.logger, (boolean)true, (String)"500", (String)"\u6279\u91cf\u5220\u9664\u53c2\u6570\u914d\u7f6e\u65f6\uff0c\u4f20\u9012\u7684\u4e3b\u952eID\u96c6\u5408\u4e0d\u53ef\u4e3a\u7a7a\uff01");
        }
        LambdaUpdateWrapper updateWrapper = Wrappers.lambdaUpdate();
        ((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)updateWrapper.in(SysParamEntity::getId, (Object[])ids)).set(SysParamEntity::getDelFlag, (Object)DelFlagEnum.IS_FLAG.getValue())).set(SysParamEntity::getUpdateId, (Object)userId)).set(SysParamEntity::getUpdateName, (Object)userName);
        this.sysParamMapper.update(null, (Wrapper)updateWrapper);
    }

    public void updateSysParam(SysParamEntity entity) {
        if (StrUtil.isEmpty((CharSequence)entity.getId())) {
            ExceptionUtils.createException((Logger)this.logger, (boolean)true, (String)"500", (String)"\u7f16\u8f91\u53c2\u6570\u914d\u7f6e\u65f6\uff0c\u4f20\u9012\u7684\u4e3b\u952eID\u4e0d\u53ef\u4e3a\u7a7a\uff01");
        }
        Integer tenantId = entity.getTenantId();
        String name = entity.getName();
        if (StrUtil.isNotEmpty((CharSequence)name)) {
            LambdaQueryWrapper paramQueryWrapper = Wrappers.lambdaQuery();
            ((LambdaQueryWrapper)((LambdaQueryWrapper)paramQueryWrapper.eq(tenantId != null, SysParamEntity::getTenantId, (Object)tenantId)).eq(SysParamEntity::getDelFlag, (Object)DelFlagEnum.NOT_FLAG.getValue())).eq(SysParamEntity::getName, (Object)name);
            SysParamEntity dbEntity = (SysParamEntity)this.sysParamMapper.selectOne((Wrapper)paramQueryWrapper);
            if (dbEntity != null && !dbEntity.getId().equals(entity.getId())) {
                ExceptionUtils.createException((Logger)this.logger, (boolean)true, (String)"500", (String)"\u7f16\u8f91\u53c2\u6570\u914d\u7f6e\u65f6\uff0c\u6839\u636e\u53c2\u6570\u540d\u67e5\u8be2\u5230\u53c2\u6570\u914d\u7f6e\u5df2\u5b58\u5728\uff01");
            }
        }
        this.sysParamMapper.updateById((Object)entity);
    }

    @Transactional(rollbackFor={BusinessException.class})
    public void insertSysParam(SysParamEntity entity) {
        this.checkField(entity);
        Integer tenantId = entity.getTenantId();
        LambdaQueryWrapper paramQueryWrapper = Wrappers.lambdaQuery();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)paramQueryWrapper.eq(tenantId != null, SysParamEntity::getTenantId, (Object)tenantId)).eq(SysParamEntity::getDelFlag, (Object)DelFlagEnum.NOT_FLAG.getValue())).eq(SysParamEntity::getName, (Object)entity.getName());
        List list = this.sysParamMapper.selectList((Wrapper)paramQueryWrapper);
        if (!list.isEmpty()) {
            ExceptionUtils.createException((Logger)this.logger, (boolean)true, (String)"500", (String)"\u65b0\u589e\u53c2\u6570\u914d\u7f6e\u65f6\uff0c\u5b58\u5728\u91cd\u590d\u53c2\u6570\u914d\u7f6e\u4fe1\u606f\uff01");
        }
        String id = UUIDUtils.getRandom((int)6, (boolean)true);
        entity.setId(id);
        this.sysParamMapper.insert((Object)entity);
    }

    private void checkField(SysParamEntity entity) {
        if (StrUtil.isEmpty((CharSequence)entity.getName())) {
            ExceptionUtils.createException((Logger)this.logger, (boolean)true, (String)"500", (String)"\u65b0\u589e\u53c2\u6570\u914d\u7f6e\u65f6\uff0c\u53c2\u6570\u540d\u4e0d\u53ef\u4e3a\u7a7a\uff01");
        }
        if (StrUtil.isEmpty((CharSequence)entity.getValue())) {
            ExceptionUtils.createException((Logger)this.logger, (boolean)true, (String)"500", (String)"\u65b0\u589e\u53c2\u6570\u914d\u7f6e\u65f6\uff0c\u53c2\u6570\u503c\u4e0d\u53ef\u4e3a\u7a7a\uff01");
        }
        if (StrUtil.isEmpty((CharSequence)entity.getType())) {
            ExceptionUtils.createException((Logger)this.logger, (boolean)true, (String)"500", (String)"\u65b0\u589e\u53c2\u6570\u914d\u7f6e\u65f6\uff0c\u53c2\u6570\u7c7b\u578b\u4e0d\u53ef\u4e3a\u7a7a\uff01");
        }
    }

    public void sysParamSave(SysParamEntity entity) {
        entity.setId(UUIDUtils.getRandom((int)6, (boolean)true));
        int a = this.sysParamMapper.insert((Object)entity);
    }

    public List<SysParamVo> sysParamSelect(SysParamEntity entity) {
        List list = this.sysParamMapper.sysParamSelect(entity);
        return list;
    }

    public void sysParamUpdate(SysParamEntity entity) {
        int a = this.sysParamMapper.update((Object)entity, (Wrapper)((LambdaUpdateWrapper)Wrappers.lambdaUpdate().eq(SysParamEntity::getId, (Object)entity.getId())).eq(SysParamEntity::getTenantId, (Object)entity.getTenantId()));
    }

    public void sysParamDelete(SysEasyEntity entity) {
        int a = this.sysParamMapper.sysParamDelete(entity.getIds());
    }

    public SysParamVo sysParamSelectByName(SysParamEntity entity) {
        SysParamVo vo = this.sysParamMapper.selectByName(entity.getName(), entity.getTenantId());
        return vo;
    }

    public String sysParamSelectByNameReturnValue(String name, Integer tenantId) {
        SysParamVo vo = this.sysParamMapper.selectByName(name, tenantId);
        ExceptionUtils.createException((Logger)log, (boolean)Objects.isNull(vo), (String)"500", (String)("\u6ca1\u6709\u627e\u5230\u3010\u540d\u4e3a\uff1a" + name + "\u3011\u7684\u914d\u7f6e\u6570\u636e"));
        return vo.getValue();
    }
}

