/*
 * Decompiled with CFR 0.152.
 */
package com.byh.sys.web.service.impl;

import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.byh.sys.api.dto.priceFloatSetting.SysPriceFloatSettingDetailDto;
import com.byh.sys.api.dto.priceFloatSetting.SysPriceFloatSettingDto;
import com.byh.sys.api.exception.BusinessException;
import com.byh.sys.api.model.priceFloatSetting.SysPriceFloatSettingDetailEntity;
import com.byh.sys.api.model.priceFloatSetting.SysPriceFloatSettingEntity;
import com.byh.sys.api.util.ExceptionUtils;
import com.byh.sys.api.vo.priceFloatSetting.SysPriceFloatSettingDetailVo;
import com.byh.sys.api.vo.priceFloatSetting.SysPriceFloatSettingVo;
import com.byh.sys.data.repository.SysPriceFloatSettingDetailMapper;
import com.byh.sys.data.repository.SysPriceFloatSettingMapper;
import com.byh.sys.web.service.SysPriceFloatSettingService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SysPriceFloatSettingServiceImpl
extends ServiceImpl<SysPriceFloatSettingMapper, SysPriceFloatSettingEntity>
implements SysPriceFloatSettingService {
    @Resource
    private SysPriceFloatSettingMapper sysPriceFloatSettingMapper;
    @Resource
    private SysPriceFloatSettingDetailMapper sysPriceFloatSettingDetailMapper;
    private Logger logger = LoggerFactory.getLogger(SysPriceFloatSettingServiceImpl.class);

    @Transactional(rollbackFor={BusinessException.class})
    public void insert(SysPriceFloatSettingDto dto) {
        SysPriceFloatSettingEntity dbEntity;
        LambdaQueryWrapper queryWrapper = Wrappers.lambdaQuery();
        queryWrapper.eq(SysPriceFloatSettingEntity::getTreatmentTypeCode, (Object)dto.getTreatmentTypeCode());
        if (StrUtil.isNotEmpty((CharSequence)dto.getTypeCode())) {
            queryWrapper.eq(SysPriceFloatSettingEntity::getTypeCode, (Object)dto.getTypeCode());
        }
        if ((dbEntity = (SysPriceFloatSettingEntity)this.sysPriceFloatSettingMapper.selectOne((Wrapper)queryWrapper)) != null) {
            throw new BusinessException("10002", "\u65b0\u589e\u4ef7\u683c\u6d6e\u52a8\u8bbe\u7f6e\u65f6\uff0c\u4ef7\u683c\u6d6e\u52a8\u8bbe\u7f6e\u5df2\u5b58\u5728\uff01");
        }
        SysPriceFloatSettingEntity entity = new SysPriceFloatSettingEntity();
        BeanUtils.copyProperties((Object)dto, (Object)entity);
        int insertCount = this.sysPriceFloatSettingMapper.insert((Object)entity);
        ExceptionUtils.createException((Logger)this.logger, (int)insertCount, (String)"10000", (String)"\u4ef7\u683c\u6d6e\u52a8\u8bbe\u7f6e\u65b0\u589e\u5931\u8d25\uff01");
        if (dto.getDetailList() != null && dto.getDetailList().size() > 0) {
            boolean flag = false;
            for (SysPriceFloatSettingDetailDto detailDto : dto.getDetailList()) {
                if (detailDto.getPriceUpper() == -1) {
                    flag = true;
                }
                this.insertDetail(entity.getId(), detailDto);
            }
            if (!flag) {
                throw new BusinessException("10001", "\u65b0\u589e\u4ef7\u683c\u6d6e\u52a8\u8bbe\u7f6e\u65f6\uff0c\u4ef7\u683c\u8bbe\u7f6e\u660e\u7ec6\u6700\u540e\u4e00\u6761\u5fc5\u987b\u4e3a\u4e0d\u9650\uff01");
            }
        }
    }

    @Transactional(rollbackFor={BusinessException.class})
    public void update(SysPriceFloatSettingDto dto) {
        if (dto.getId() == null || StrUtil.isEmpty((CharSequence)dto.getId().toString())) {
            throw new BusinessException("10000", "\u7f16\u8f91\u4ef7\u683c\u6d6e\u52a8\u8bbe\u7f6e\u65f6\uff0c\u4e3b\u952eID\u4e0d\u53ef\u4e3a\u7a7a\uff01");
        }
        SysPriceFloatSettingEntity entity = new SysPriceFloatSettingEntity();
        BeanUtils.copyProperties((Object)dto, (Object)entity);
        int updateCount = this.sysPriceFloatSettingMapper.updateById((Object)entity);
        ExceptionUtils.createException((Logger)this.logger, (int)updateCount, (String)"10001", (String)"\u4ef7\u683c\u6d6e\u52a8\u8bbe\u7f6e\u7f16\u8f91\u5931\u8d25\uff01");
        this.sysPriceFloatSettingDetailMapper.deleteByPriceFloatSettingId(entity.getId());
        if (dto.getDetailList() != null && dto.getDetailList().size() > 0) {
            boolean flag = false;
            for (SysPriceFloatSettingDetailDto detailDto : dto.getDetailList()) {
                this.insertDetail(entity.getId(), detailDto);
                if (detailDto.getPriceUpper() != -1) continue;
                flag = true;
            }
            if (!flag) {
                throw new BusinessException("10002", "\u7f16\u8f91\u4ef7\u683c\u6d6e\u52a8\u8bbe\u7f6e\u65f6\uff0c\u4ef7\u683c\u8bbe\u7f6e\u660e\u7ec6\u6700\u540e\u4e00\u6761\u5fc5\u987b\u4e3a\u4e0d\u9650\uff01");
            }
        }
    }

    @Transactional(rollbackFor={BusinessException.class})
    public void deleteList(Integer[] ids) {
        if (ArrayUtil.isEmpty((Object[])ids)) {
            throw new BusinessException("10000", "\u6279\u91cf\u5220\u9664\u4ef7\u683c\u6d6e\u52a8\u8bbe\u7f6e\u65f6\uff0c\u4e3b\u952eID\u4e0d\u53ef\u4e3a\u7a7a\uff01");
        }
        int deleteCount = this.sysPriceFloatSettingMapper.deleteByIds(ids);
        ExceptionUtils.createException((Logger)this.logger, (int)deleteCount, (String)"10001", (String)"\u6279\u91cf\u5220\u9664\u4ef7\u683c\u6d6e\u52a8\u8bbe\u7f6e\u5931\u8d25\uff01");
        int deleteDetailCount = this.sysPriceFloatSettingDetailMapper.deleteByPriceFloatSettingIds(ids);
        ExceptionUtils.createException((Logger)this.logger, (int)deleteDetailCount, (String)"10002", (String)"\u6279\u91cf\u5220\u9664\u4ef7\u683c\u6d6e\u52a8\u8bbe\u7f6e\u660e\u7ec6\u5931\u8d25\uff01");
    }

    public Page<SysPriceFloatSettingVo> selectPageList(SysPriceFloatSettingDto dto) {
        Page page = new Page((long)dto.getCurrent(), (long)dto.getSize());
        List list = this.sysPriceFloatSettingMapper.selectPageList(page, dto);
        if (list != null && list.size() > 0) {
            Integer[] ids = new Integer[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                ids[i] = ((SysPriceFloatSettingVo)list.get(i)).getId();
            }
            List detailVoList = this.sysPriceFloatSettingDetailMapper.selectListByPriceFloatSettingIds(ids);
            HashMap detailMap = new HashMap();
            for (SysPriceFloatSettingDetailVo detailVo : detailVoList) {
                List<SysPriceFloatSettingDetailVo> detailList = new ArrayList<SysPriceFloatSettingDetailVo>();
                Integer priceFloatSettingId = detailVo.getPriceFloatSettingId();
                if (detailMap.get(priceFloatSettingId) == null) {
                    detailList.add(detailVo);
                    detailMap.put(priceFloatSettingId, detailList);
                    continue;
                }
                detailList = (List)detailMap.get(priceFloatSettingId);
                detailList.add(detailVo);
                detailMap.put(priceFloatSettingId, detailList);
            }
            for (SysPriceFloatSettingVo vo : list) {
                if (detailMap.get(vo.getId()) == null) continue;
                vo.setDetailList((List)detailMap.get(vo.getId()));
            }
        }
        page.setRecords(list);
        return page;
    }

    private void insertDetail(Integer id, SysPriceFloatSettingDetailDto detailDto) {
        SysPriceFloatSettingDetailEntity detailEntity = new SysPriceFloatSettingDetailEntity();
        detailEntity.setPriceFloatSettingId(id);
        detailEntity.setPriceFloor(detailDto.getPriceFloor());
        detailEntity.setPriceUpper(detailDto.getPriceUpper());
        detailEntity.setUpperScale(detailDto.getUpperScale());
        int insertDetailCount = this.sysPriceFloatSettingDetailMapper.insert((Object)detailEntity);
        ExceptionUtils.createException((Logger)this.logger, (int)insertDetailCount, (String)"00000", (String)"\u65b0\u589e\u4ef7\u683c\u6d6e\u52a8\u660e\u7ec6\u8bbe\u7f6e\u5931\u8d25\uff01");
    }
}

