/*
 * Decompiled with CFR 0.152.
 */
package com.byh.sys.web.mvc.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.byh.sys.api.annotation.AntiRefresh;
import com.byh.sys.api.annotation.UserOptLogger;
import com.byh.sys.api.dto.hospital.SysHospitalDTO;
import com.byh.sys.api.dto.hospital.SysHospitalSaveDTO;
import com.byh.sys.api.dto.hospital.SysHospitalUpdateDTO;
import com.byh.sys.api.util.ResponseData;
import com.byh.sys.web.mvc.utils.CommonRequest;
import com.byh.sys.web.service.SysHospitalService;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/sysHospital"})
public class SysHospitalController {
    @Autowired
    private SysHospitalService sysHospitalService;
    @Autowired
    private CommonRequest commonRequest;

    @RequestMapping(value={"/save"})
    @ApiOperation(value="\u65b0\u589e\u533b\u9662\u4fe1\u606f")
    @UserOptLogger(operation="\u533b\u9662\u6a21\u5757")
    public ResponseData sysHospitalSave(@RequestBody @Valid SysHospitalSaveDTO dto) {
        dto.setTenantId(this.commonRequest.getTenant());
        this.sysHospitalService.sysHospitalSave(dto);
        return ResponseData.success().msg("\u4fdd\u5b58\u6210\u529f");
    }

    @GetMapping(value={"/select"})
    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u533b\u9662\u6570\u636e")
    @AntiRefresh
    public ResponseData sysHospitalSelect(Page page, SysHospitalDTO dto) {
        dto.setTenantId(this.commonRequest.getTenant());
        return ResponseData.success((Object)this.sysHospitalService.sysHospitalSelect(page, dto));
    }

    @GetMapping(value={"/select/noTenantId"})
    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u533b\u9662\u6570\u636e \u6ca1\u6709tenantId")
    @AntiRefresh
    public ResponseData sysHospitalSelectNoTenantId(Page page, SysHospitalDTO dto) {
        return ResponseData.success((Object)this.sysHospitalService.sysHospitalSelect(page, dto));
    }

    @RequestMapping(value={"/update"})
    @ApiOperation(value="\u66f4\u65b0\u533b\u9662\u4fe1\u606f")
    @UserOptLogger(operation="\u533b\u9662\u6a21\u5757")
    public ResponseData sysHospitalUpdate(@RequestBody @Valid SysHospitalUpdateDTO dto) {
        dto.setTenantId(this.commonRequest.getTenant());
        this.sysHospitalService.sysHospitalUpdate(dto);
        return ResponseData.success().msg("\u4fee\u6539\u6210\u529f");
    }

    @RequestMapping(value={"/delete"})
    @ApiOperation(value="\u6279\u91cf\u548c\u5355\u4e2a\u5220\u9664\u533b\u9662\u6570\u636e")
    @UserOptLogger(operation="\u533b\u9662\u6a21\u5757")
    public ResponseData sysHospitalDelete(@RequestBody Integer[] ids) {
        this.sysHospitalService.sysHospitalDelete(ids);
        return ResponseData.success().msg("\u5220\u9664\u6210\u529f");
    }

    @RequestMapping(value={"/get/bigTree"})
    @ApiOperation(value="\u83b7\u53d6\u533b\u9662->\u79d1\u5ba4->\u533b\u751f\u6811\u7ed3\u6784")
    @AntiRefresh
    public ResponseData getBigTree(@RequestBody SysHospitalDTO hosdto) {
        hosdto.setTenantId(this.commonRequest.getTenant());
        List bigTree = this.sysHospitalService.getBigTree(hosdto);
        return ResponseData.success((Object)bigTree);
    }

    @RequestMapping(value={"/delete/admin"})
    @ApiOperation(value="\u5220\u9664\u533b\u9662\u7ba1\u7406\u5458")
    public ResponseData deleteHospitalAdmin(@RequestBody Integer id) {
        this.sysHospitalService.deleteHospitalAdmin(id);
        return ResponseData.success().msg("\u7ba1\u7406\u5458\u5df2\u5220\u9664");
    }

    @GetMapping(value={"/get/admin"})
    @ApiOperation(value="\u83b7\u53d6\u533b\u9662\u7ba1\u7406\u5458")
    @AntiRefresh
    public ResponseData getHospitalAdmin(Page page, Integer id) {
        IPage list = this.sysHospitalService.getHospitalAdmin(page, id);
        return ResponseData.success((Object)list);
    }
}

