/*
 * Decompiled with CFR 0.152.
 */
package com.byh.sys.web.mvc.controller.drug;

import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.byh.sys.api.annotation.AntiRefresh;
import com.byh.sys.api.annotation.UserOptLogger;
import com.byh.sys.api.dto.SysEasyEntity;
import com.byh.sys.api.dto.drug.drugPharmacSimple.SysDrugPharmacySimpleDto;
import com.byh.sys.api.dto.drug.drugPharmacyOut.SysDrugPharmacyOutDto;
import com.byh.sys.api.dto.drug.drugPharmacyOut.SysDrugPharmacyOutSaveDto;
import com.byh.sys.api.dto.drug.drugPharmacyOut.SysDrugPharmacyOutUpdateDto;
import com.byh.sys.api.dto.drug.drugPharmacyOut.SysDrugPharmacyOutUpdateStatusDto;
import com.byh.sys.api.model.drug.pharmacy.SysDrugPharmacyOutEntity;
import com.byh.sys.api.util.ResponseData;
import com.byh.sys.api.util.StringUtils;
import com.byh.sys.api.vo.drug.SysDrugPharmacyOutVo;
import com.byh.sys.web.mvc.utils.CommonRequest;
import com.byh.sys.web.service.SysDrugPharmacyOutService;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/sysDrug/pharmacyOut"})
public class SysDrugPharmacyOutController {
    private static final Logger log = LoggerFactory.getLogger(SysDrugPharmacyOutController.class);
    @Autowired
    private SysDrugPharmacyOutService sysDrugPharmacyOutService;
    @Autowired
    private CommonRequest commonRequest;

    @ApiOperation(value="\u5f00\u7acb\u5904\u65b9\u65f6\uff0c\u67e5\u8be2\u836f\u54c1\u5e93\u5b58\u5217\u8868\u4fe1\u606f")
    @GetMapping(value={"/searchForPresc"})
    public ResponseData searchForPresc(Page page, SysDrugPharmacySimpleDto dto) {
        dto.setTenantId(this.commonRequest.getTenant());
        if (StrUtil.isEmpty((CharSequence)dto.getWarehouse())) {
            dto.setWarehouse(this.commonRequest.getDrugRoomId());
        }
        return ResponseData.success((Object)this.sysDrugPharmacyOutService.searchForPresc(page, dto));
    }

    @RequestMapping(value={"/save"})
    @UserOptLogger(operation="\u836f\u623f\u51fa\u5e93\u6a21\u5757")
    @ApiOperation(value="\u836f\u623f\u51fa\u5e93-\u65b0\u589e")
    public ResponseData sysDrugPharmacyOutSave(@RequestBody @Valid SysDrugPharmacyOutSaveDto dto) {
        dto.setTenantId(this.commonRequest.getTenant());
        if (StringUtils.isBlank((String)dto.getOutboundWarehouse())) {
            dto.setOutboundWarehouse(this.commonRequest.getDrugRoomId());
        }
        SysDrugPharmacyOutEntity entity = this.sysDrugPharmacyOutService.sysDrugPharmacyOutSave(dto);
        return ResponseData.success((Object)entity).save();
    }

    @GetMapping(value={"/select"})
    @ApiOperation(value="\u836f\u623f\u51fa\u5e93-\u5206\u9875\u67e5\u8be2")
    @AntiRefresh
    public ResponseData sysDrugPharmacyOutSelect(Page page, SysDrugPharmacyOutDto dto) {
        dto.setTenantId(this.commonRequest.getTenant());
        if (StringUtils.isBlank((String)dto.getOutboundWarehouse())) {
            dto.setOutboundWarehouse(this.commonRequest.getDrugRoomId());
        }
        IPage list = this.sysDrugPharmacyOutService.sysDrugPharmacyOutSelect(page, dto);
        return ResponseData.success((Object)list);
    }

    @RequestMapping(value={"/select/byPrescriptionId"})
    @ApiOperation(value="\u836f\u623f\u51fa\u5e93-\u5206\u9875\u67e5\u8be2")
    public ResponseData sysDrugPharmacyOutSelectByPrescriptionId(@RequestBody SysEasyEntity dto) {
        dto.setTenantId(this.commonRequest.getTenant());
        SysDrugPharmacyOutVo vo = this.sysDrugPharmacyOutService.sysDrugPharmacyOutSelectById(dto);
        return ResponseData.success((Object)vo);
    }

    @RequestMapping(value={"/update"})
    @UserOptLogger(operation="\u836f\u623f\u51fa\u5e93\u6a21\u5757")
    @ApiOperation(value="\u836f\u623f\u51fa\u5e93-\u66f4\u65b0")
    public ResponseData sysDrugPharmacyOutUpdate(@RequestBody @Valid SysDrugPharmacyOutUpdateDto dto) {
        dto.setTenantId(this.commonRequest.getTenant());
        if (StringUtils.isBlank((String)dto.getOutboundWarehouse())) {
            dto.setOutboundWarehouse(this.commonRequest.getDrugRoomId());
        }
        this.sysDrugPharmacyOutService.sysDrugPharmacyOutUpdate(dto);
        return ResponseData.success().update();
    }

    @RequestMapping(value={"/update/status"})
    @UserOptLogger(operation="\u66f4\u65b0\u836f\u623f\u72b6\u6001")
    @ApiOperation(value="\u836f\u623f\u51fa\u5e93-\u66f4\u65b0\u836f\u623f\u72b6\u6001")
    public ResponseData sysDrugPharmacyOutUpdateStatus(@RequestBody @Valid SysDrugPharmacyOutUpdateStatusDto dto) {
        dto.setTenantId(this.commonRequest.getTenant());
        if (StringUtils.isBlank((String)dto.getOutboundWarehouse())) {
            dto.setOutboundWarehouse(this.commonRequest.getDrugRoomId());
        }
        this.sysDrugPharmacyOutService.sysDrugPharmacyOutUpdateStatus(dto);
        return ResponseData.success().update();
    }

    @RequestMapping(value={"/confirm"})
    @UserOptLogger(operation="\u836f\u623f\u53d1\u836f\u64cd\u4f5c")
    @ApiOperation(value="\u786e\u8ba4\u5f53\u524d\u51fa\u5e93\u72b6\u6001")
    public ResponseData sysDrugPharmacyOutConfirm(@RequestBody SysEasyEntity entity) {
        log.info("========== \u5f00\u59cb\u53d1\u836f\uff1a\u51fa\u5e93\u5355\u53f7\uff1a{}-\u65b9\u6cd5\u6765\u6e90-{}", (Object)entity.getId(), (Object)entity.getMethodType());
        return this.sysDrugPharmacyOutService.sysDrugPharmacyOutConfirm(entity, this.commonRequest.getTenant());
    }

    @RequestMapping(value={"/back"})
    @UserOptLogger(operation="\u836f\u623f\u9000\u836f\u64cd\u4f5c")
    @ApiOperation(value="\u836f\u623f\u9000\u836f")
    public ResponseData sysDrugPharmacyOutBackDrug(@RequestBody SysEasyEntity entity) {
        this.sysDrugPharmacyOutService.sysDrugPharmacyOutBackDrug(entity.getId(), this.commonRequest.getTenant(), entity);
        return ResponseData.success().msg("\u836f\u54c1\u5df2\u9000\u56de");
    }

    @RequestMapping(value={"/delete"})
    @ApiOperation(value="\u836f\u623f\u51fa\u5e93-\u5220\u9664")
    public ResponseData sysDrugPharmacyOutDelete(@RequestBody String[] ids) {
        this.sysDrugPharmacyOutService.sysDrugPharmacyOutDelete(ids);
        return ResponseData.success().delete();
    }

    @RequestMapping(value={"/delete/byPrescriptionId"})
    @ApiOperation(value="\u836f\u623f\u51fa\u5e93-\u5220\u9664")
    @UserOptLogger(operation="\u836f\u623f\u51fa\u5e93\u6839\u636e\u5904\u65b9\u5220\u9664\u51fa\u5e93\u5355")
    public ResponseData sysDrugPharmacyOutDeleteByPrescriptionId(@RequestBody SysEasyEntity entity) {
        entity.setTenantId(this.commonRequest.getTenant());
        if (StringUtils.isBlank((String)entity.getWarehouse())) {
            entity.setWarehouse(this.commonRequest.getDrugRoomId());
        }
        this.sysDrugPharmacyOutService.sysDrugPharmacyOutDeleteByPrescriptionId(entity);
        return ResponseData.success();
    }

    @GetMapping(value={"/search"})
    @ApiOperation(value="\u836f\u623f\u51fa\u5e93-\u5217\u8868\u67e5\u8be2")
    public ResponseData sysDrugPharmacyOutSearch(Page page, SysDrugPharmacySimpleDto dto) {
        dto.setTenantId(this.commonRequest.getTenant());
        if (StringUtils.isBlank((String)dto.getWarehouse())) {
            dto.setWarehouse(this.commonRequest.getDrugRoomId());
        }
        IPage list = this.sysDrugPharmacyOutService.sysDrugPharmacyOutSearch(page, dto);
        return ResponseData.success((Object)list);
    }

    @PostMapping(value={"/withoutSearch"})
    @ApiOperation(value="\u5916\u90e8\u8c03\u7528\u67e5\u8be2\u836f\u54c1\u5e93\u5b58\u5217\u8868\u4fe1\u606f")
    @AntiRefresh
    public ResponseData withoutSearch(@RequestBody SysDrugPharmacySimpleDto dto) {
        Page page = new Page();
        page.setSize((long)dto.getSize());
        page.setCurrent((long)dto.getSize());
        IPage list = this.sysDrugPharmacyOutService.sysDrugPharmacyOutSearch(page, dto);
        return ResponseData.success((Object)list);
    }

    @PostMapping(value={"/sdkSearch"})
    @ApiOperation(value="\u836f\u623f\u51fa\u5e93-\u5217\u8868\u67e5\u8be2-\u65e0\u5206\u9875")
    @AntiRefresh(time=1, number=10)
    public ResponseData sysDrugPharmacyOutList(@RequestBody SysDrugPharmacySimpleDto dto) {
        dto.setTenantId(this.commonRequest.getTenant());
        if (StringUtils.isBlank((String)dto.getWarehouse())) {
            dto.setWarehouse(this.commonRequest.getDrugRoomId());
        }
        List list = this.sysDrugPharmacyOutService.sysDrugPharmacyOutList(dto);
        return ResponseData.success((Object)list);
    }

    @PostMapping(value={"/sdkPageSearch"})
    @ApiOperation(value="\u836f\u623f\u51fa\u5e93-\u5217\u8868\u67e5\u8be2-\u5206\u9875")
    @AntiRefresh(time=1, number=10)
    public ResponseData sysDrugPharmacyOutPageList(@RequestBody SysDrugPharmacySimpleDto dto) {
        dto.setTenantId(this.commonRequest.getTenant());
        if (StringUtils.isBlank((String)dto.getWarehouse())) {
            dto.setWarehouse(this.commonRequest.getDrugRoomId());
        }
        Page page = new Page();
        page.setSize((long)dto.getSize());
        page.setCurrent((long)dto.getSize());
        IPage list = this.sysDrugPharmacyOutService.sysDrugPharmacyOutPageList(page, dto);
        return ResponseData.success((Object)list);
    }

    @PostMapping(value={"/numberSearch"})
    @ApiOperation(value="\u901a\u8fc7\u836f\u54c1id,\u8ba2\u5355id\u67e5\u8be2\u6279\u53f7\uff0c\u8d27\u67b6\u53f7")
    @AntiRefresh(time=1, number=10)
    public ResponseData sysDrugNumberSearch(@RequestBody SysDrugPharmacySimpleDto dto) {
        dto.setTenantId(this.commonRequest.getTenant());
        List list = this.sysDrugPharmacyOutService.numberSearch(dto);
        return ResponseData.success((Object)list);
    }

    @RequestMapping(value={"/search/byIds"})
    @ApiOperation(value="\u4ed3\u5e93\u6279\u6b21\u8be6\u60c5")
    public ResponseData sysDrugPharmacyOutSearchByIds(@RequestBody SysEasyEntity entity) {
        entity.setTenantId(this.commonRequest.getTenant());
        if (StringUtils.isBlank((String)entity.getWarehouse())) {
            entity.setWarehouse(this.commonRequest.getDrugRoomId());
        }
        List list = this.sysDrugPharmacyOutService.sysDrugPharmacyOutSearchByIds(entity);
        return ResponseData.success((Object)list);
    }

    @GetMapping(value={"/export"})
    @ApiOperation(value="\u5bfc\u51faExcel", httpMethod="GET", notes="\u5bfc\u51faExcel")
    public void sysDrugPharmacyOutExport(HttpServletResponse response, Page page, SysDrugPharmacyOutDto dto) {
        dto.setTenantId(this.commonRequest.getTenant());
        if (StringUtils.isBlank((String)dto.getOutboundWarehouse())) {
            dto.setOutboundWarehouse(this.commonRequest.getDrugRoomId());
        }
        this.sysDrugPharmacyOutService.sysDrugPharmacyOutExport(response, page, dto);
    }
}

