/*
 * Decompiled with CFR 0.152.
 */
package com.byh.sys.web.mvc.controller.netHospital;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.byh.sys.api.dto.department.SysDepartmentDTO;
import com.byh.sys.api.dto.hospital.SysHospitalDTO;
import com.byh.sys.api.dto.netHospital.DoctorDTO;
import com.byh.sys.api.dto.netHospital.HealthPopDTO;
import com.byh.sys.api.dto.netHospital.HospitalDTO;
import com.byh.sys.api.dto.netHospital.RatingDTO;
import com.byh.sys.api.model.department.SysDepartmentEntity;
import com.byh.sys.api.model.netHospital.SysDepartmentRefEntity;
import com.byh.sys.api.model.netHospital.SysDoctorUserRatingEntity;
import com.byh.sys.api.util.ResponseData;
import com.byh.sys.web.service.SysDepartmentRefService;
import com.byh.sys.web.service.SysDepartmentService;
import com.byh.sys.web.service.SysDistrictService;
import com.byh.sys.web.service.SysDoctorService;
import com.byh.sys.web.service.SysDoctorUserRatingService;
import com.byh.sys.web.service.SysHealthPopService;
import com.byh.sys.web.service.SysHospitalListService;
import com.byh.sys.web.service.SysHospitalService;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/netHospital"})
public class NetHospitalController {
    private final SysHospitalService sysHospitalService;
    private final SysDepartmentService sysDepartmentService;
    private final SysDepartmentRefService sysDepartmentRefService;
    private final SysDoctorService sysDoctorService;
    private final SysHealthPopService healthPopService;
    private final SysDoctorUserRatingService sysDoctorUserRatingService;
    private final SysDistrictService sysDistrictService;
    private final SysHospitalListService sysHospitalListService;

    @ApiOperation(value="\u4e92\u8054\u7f51\u533b\u9662\u5c0f\u7a0b\u5e8f \u3010\u83b7\u53d6\u533b\u9662\u4fe1\u606f\u3011")
    @GetMapping(value={"/hospitalInfo"})
    public ResponseData getHospitalInfo(SysHospitalDTO dto) {
        Page page = new Page();
        page.setSize(-1L);
        return ResponseData.success((Object)this.sysHospitalService.sysHospitalSelect(page, dto));
    }

    @ApiOperation(value=" \u4e92\u533b \u3010\u83b7\u53d6\u90e8\u95e8\u4fe1\u606f\u3011")
    @GetMapping(value={"/getDept"})
    public ResponseData getDeptInfo(SysDepartmentDTO dto) {
        return ResponseData.success((Object)this.sysDepartmentService.sysDepartmentSelect(dto));
    }

    @ApiOperation(value=" \u8d63\u533b\u901a \u3010\u83b7\u53d6\u90e8\u95e8\u4fe1\u606f\u3011")
    @GetMapping(value={"/deptInfo"})
    public ResponseData deptInfo(SysDepartmentRefEntity entity) {
        List list = this.sysDepartmentRefService.selectDeptInfo(entity);
        return ResponseData.success((Object)list);
    }

    @ApiOperation(value="\u4e92\u8054\u7f51\u533b\u9662\u5c0f\u7a0b\u5e8f \u3010\u83b7\u53d6\u533b\u751f\u4fe1\u606f\u3011")
    @PostMapping(value={"/doctorInfo"})
    public ResponseData getDoctorInfo(@RequestBody DoctorDTO dto) {
        SysDepartmentEntity entity;
        Page page = new Page();
        page.setCurrent(dto.getCurrent() < 1L ? 1L : dto.getCurrent());
        page.setSize(dto.getSize() < 1L ? -1L : dto.getSize());
        Integer refId = dto.getDepartmentId();
        if (refId != null && "gyt".equals(dto.getSource()) && (entity = this.sysDepartmentService.selectDepartmentByRefId(refId)) != null) {
            dto.setDepartmentId(entity.getId());
        }
        IPage iPage = this.sysDoctorService.netHospitalPageList(page, dto);
        List records = iPage.getRecords();
        return ResponseData.success((Object)records);
    }

    @ApiOperation(value="\u5065\u5eb7\u79d1\u666e")
    @PostMapping(value={"/getHealthPop"})
    public ResponseData getHealthPop(@RequestBody HealthPopDTO dto) {
        Page page = new Page();
        page.setCurrent(dto.getCurrent() < 1L ? 1L : dto.getCurrent());
        page.setSize(dto.getSize() < 1L ? -1L : dto.getSize());
        IPage iPage = this.healthPopService.pageList(page, dto);
        List records = iPage.getRecords();
        return ResponseData.success((Object)records);
    }

    @ApiOperation(value="\u8bc4\u4ef7\u5217\u8868")
    @PostMapping(value={"/getRatingList"})
    public ResponseData getRatingList(@RequestBody RatingDTO dto) {
        Page page = new Page();
        page.setCurrent(dto.getCurrent() < 1L ? 1L : dto.getCurrent());
        page.setSize(dto.getSize() < 1L ? -1L : dto.getSize());
        IPage iPage = this.sysDoctorUserRatingService.pageList(page, dto);
        List records = iPage.getRecords();
        return ResponseData.success((Object)records);
    }

    @ApiOperation(value="\u65b0\u589e\u8bc4\u4ef7")
    @PostMapping(value={"/addRating"})
    public ResponseData addRating(@RequestBody RatingDTO dto) {
        SysDoctorUserRatingEntity ratingEntity = (SysDoctorUserRatingEntity)this.sysDoctorUserRatingService.getOne((Wrapper)Wrappers.lambdaQuery().eq(SysDoctorUserRatingEntity::getOutpatientNo, (Object)dto.getOutpatientNo()));
        if (ratingEntity != null) {
            return ResponseData.error((String)"\u6b64\u6b21\u590d\u8bca\u5df2\u8bc4\u4ef7!");
        }
        this.sysDoctorUserRatingService.addRating(dto);
        return ResponseData.success();
    }

    @ApiOperation(value="\u95e8\u8bca\u53f7\u67e5\u8be2\u8bc4\u4ef7")
    @GetMapping(value={"/getRatingByOutPatientNo"})
    public ResponseData getRatingByOutPatientNo(String outpatientNo) {
        SysDoctorUserRatingEntity ratingEntity = (SysDoctorUserRatingEntity)this.sysDoctorUserRatingService.getOne((Wrapper)Wrappers.lambdaQuery().eq(SysDoctorUserRatingEntity::getOutpatientNo, (Object)outpatientNo));
        return ResponseData.success((Object)ratingEntity);
    }

    @ApiOperation(value="\u5730\u533a\u521d\u59cb\u5316")
    @GetMapping(value={"/queryDistrict"})
    public ResponseData queryDistrict(String code) {
        return ResponseData.success((Object)this.sysDistrictService.queryDistrict(code));
    }

    @ApiOperation(value="\u67e5\u8be2\u533b\u9662\u5217\u8868")
    @PostMapping(value={"/queryHospitalList"})
    public ResponseData queryHospitalList(@RequestBody HospitalDTO dto) {
        return ResponseData.success((Object)this.sysHospitalListService.queryHospitalList(dto));
    }

    public NetHospitalController(SysHospitalService sysHospitalService, SysDepartmentService sysDepartmentService, SysDepartmentRefService sysDepartmentRefService, SysDoctorService sysDoctorService, SysHealthPopService healthPopService, SysDoctorUserRatingService sysDoctorUserRatingService, SysDistrictService sysDistrictService, SysHospitalListService sysHospitalListService) {
        this.sysHospitalService = sysHospitalService;
        this.sysDepartmentService = sysDepartmentService;
        this.sysDepartmentRefService = sysDepartmentRefService;
        this.sysDoctorService = sysDoctorService;
        this.healthPopService = healthPopService;
        this.sysDoctorUserRatingService = sysDoctorUserRatingService;
        this.sysDistrictService = sysDistrictService;
        this.sysHospitalListService = sysHospitalListService;
    }
}

