/*
 * Decompiled with CFR 0.152.
 */
package com.byh.sys.web.service.impl;

import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.byh.sys.api.dto.DoctorOnlineDto;
import com.byh.sys.api.dto.OutQueryReadyVisitDto;
import com.byh.sys.api.dto.SysDoctorDto;
import com.byh.sys.api.dto.netHospital.DoctorDTO;
import com.byh.sys.api.dto.netHospital.DoctorVo;
import com.byh.sys.api.enums.DelFlagEnum;
import com.byh.sys.api.enums.StatusEnum;
import com.byh.sys.api.exception.BusinessException;
import com.byh.sys.api.model.SysDoctorEntity;
import com.byh.sys.api.model.department.SysDepartmentEntity;
import com.byh.sys.api.model.ward.SysDoctorWardEntity;
import com.byh.sys.api.model.ward.SysWardEntity;
import com.byh.sys.api.util.ExceptionUtils;
import com.byh.sys.api.util.ResponseData;
import com.byh.sys.api.vo.QueryReadyVisitVo;
import com.byh.sys.api.vo.SysDoctorIdVo;
import com.byh.sys.api.vo.SysDoctorVo;
import com.byh.sys.data.repository.SysDepartmentMapper;
import com.byh.sys.data.repository.SysDictMapper;
import com.byh.sys.data.repository.SysDoctorMapper;
import com.byh.sys.data.repository.SysDoctorWardMapper;
import com.byh.sys.data.repository.SysWardMapper;
import com.byh.sys.web.fegin.OutServiceFeign;
import com.byh.sys.web.service.SysDepartmentService;
import com.byh.sys.web.service.SysDoctorService;
import com.byh.sys.web.service.SysRoleService;
import com.byh.sys.web.service.SysUserRoleService;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

@Service
public class SysDoctorServiceImpl
extends ServiceImpl<SysDoctorMapper, SysDoctorEntity>
implements SysDoctorService {
    private Logger logger = LoggerFactory.getLogger(SysDoctorServiceImpl.class);
    private final SysDictMapper sysDictMapper;
    private static final String dictDuties = "sys_doctor_duties";
    private static final String doctorTitle = "sys_doctor_title";
    private final SysDepartmentService sysDepartmentService;
    private final SysRoleService sysRoleService;
    private final SysUserRoleService sysUserRoleService;
    @Resource
    private SysDoctorWardMapper sysDoctorWardMapper;
    @Resource
    private SysWardMapper sysWardMapper;
    @Autowired
    private OutServiceFeign outServiceFeign;
    @Resource
    private SysDepartmentMapper sysDepartmentMapper;
    @Autowired
    private SysDoctorMapper doctorMapper;

    @Transactional(rollbackFor={BusinessException.class})
    public void updateVisitDeptPositionById(SysDoctorDto dto) {
        int updateCount;
        Integer doctorId = dto.getId();
        String visitDeptPosition = dto.getVisitDeptPosition();
        if (doctorId == null) {
            ExceptionUtils.createException((Logger)this.logger, (boolean)true, (String)"500", (String)"\u7f16\u8f91\u533b\u751f\u63a5\u8bca\u4f4d\u7f6e\u65f6\uff0c\u533b\u751f\u7f16\u53f7\u4e0d\u53ef\u4e3a\u7a7a\uff01");
        }
        if ((updateCount = this.doctorMapper.update(null, (Wrapper)((LambdaUpdateWrapper)Wrappers.lambdaUpdate().set(SysDoctorEntity::getVisitDeptPosition, (Object)(StrUtil.isNotEmpty((CharSequence)visitDeptPosition) ? visitDeptPosition : null))).eq(SysDoctorEntity::getId, (Object)doctorId))) <= 0) {
            ExceptionUtils.createException((Logger)this.logger, (boolean)true, (String)"500", (String)"\u6570\u636e\u4e0d\u5b58\u5728\uff0c\u66f4\u65b0\u5931\u8d25\uff01");
        }
        if (updateCount > 1) {
            ExceptionUtils.createException((Logger)this.logger, (boolean)true, (String)"500", (String)"\u5355\u6b21\u53ea\u80fd\u66f4\u65b0\u4e00\u4f4d\u533b\u751f\u7684\u63a5\u8bca\u4f4d\u7f6e\uff0c\u66f4\u65b0\u5931\u8d25\uff01");
        }
    }

    public List<SysDoctorEntity> selectListByCondition(SysDoctorDto dto) {
        SysDepartmentEntity department = this.sysDepartmentMapper.selectListByCondition(dto);
        if (department == null) {
            return Collections.emptyList();
        }
        return ((SysDoctorMapper)this.baseMapper).selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(SysDoctorEntity.class).eq(dto.getTenantId() != null, SysDoctorEntity::getTenantId, (Object)dto.getTenantId())).eq(department.getId() != null, SysDoctorEntity::getDepartmentId, (Object)department.getId())).eq(SysDoctorEntity::getStatus, (Object)"0")).eq(SysDoctorEntity::getDelFlag, (Object)DelFlagEnum.NOT_FLAG.getValue()));
    }

    public IPage<SysDoctorVo> pageList(Page<SysDoctorVo> page, SysDoctorDto sysDoctorDto) {
        IPage pages;
        List records;
        List<Integer> longs = new ArrayList<Integer>();
        String departmentId = sysDoctorDto.getDepartmentId();
        if (StrUtil.isNotEmpty((CharSequence)departmentId)) {
            if (StrUtil.isNotEmpty((CharSequence)sysDoctorDto.getType())) {
                Integer i = Integer.valueOf(departmentId);
                longs.add(i);
            } else {
                longs = this.sysDepartmentService.sysDepartmentGetAllIds(Integer.valueOf(departmentId));
            }
        }
        if ((records = (pages = ((SysDoctorMapper)this.baseMapper).pageList(page, sysDoctorDto, longs)).getRecords()).size() > 0) {
            records.forEach(a -> {
                String roleId = a.getRoleId();
                if (StrUtil.isEmpty((CharSequence)roleId)) {
                    a.setRoleIds(new String[0]);
                } else {
                    String[] myArray = new String[]{roleId};
                    a.setRoleIds(myArray);
                }
            });
        }
        if (StrUtil.isNotEmpty((CharSequence)sysDoctorDto.getDataCenter())) {
            return pages;
        }
        List doctorIds = page.getRecords().stream().map(SysDoctorEntity::getId).distinct().collect(Collectors.toList());
        if (!doctorIds.isEmpty()) {
            LocalDate currentDate = LocalDate.now();
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
            String todayStr = currentDate.format(formatter);
            OutQueryReadyVisitDto queryReadyVisitDto = new OutQueryReadyVisitDto();
            queryReadyVisitDto.setDoctorIds(doctorIds);
            queryReadyVisitDto.setStartDate(todayStr);
            queryReadyVisitDto.setEndDate(todayStr);
            List queryReadyVisitVos = this.outServiceFeign.selectReadyVisitList(queryReadyVisitDto);
            if (!queryReadyVisitVos.isEmpty()) {
                Map<Integer, Long> countMap = queryReadyVisitVos.stream().collect(Collectors.groupingBy(QueryReadyVisitVo::getDoctorId, Collectors.counting()));
                for (SysDoctorVo record : page.getRecords()) {
                    Long count = countMap.getOrDefault(record.getId(), 0L);
                    record.setReadyVisitCount(Integer.valueOf(count.intValue()));
                }
            }
            LambdaQueryWrapper doctorWardQuery = Wrappers.lambdaQuery();
            ((LambdaQueryWrapper)((LambdaQueryWrapper)doctorWardQuery.eq(sysDoctorDto.getTenantId() != null, SysDoctorWardEntity::getTenantId, (Object)sysDoctorDto.getTenantId())).eq(SysDoctorWardEntity::getDelFlag, (Object)DelFlagEnum.NOT_FLAG.getValue())).in(SysDoctorWardEntity::getDoctorId, doctorIds);
            List doctorWardList = this.sysDoctorWardMapper.selectList((Wrapper)doctorWardQuery);
            if (!doctorWardList.isEmpty()) {
                List<SysDoctorWardEntity> relations;
                List wardIds = doctorWardList.stream().map(SysDoctorWardEntity::getWardId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
                Map<Integer, List<SysDoctorWardEntity>> relationMap = doctorWardList.stream().collect(Collectors.groupingBy(SysDoctorWardEntity::getDoctorId));
                LambdaQueryWrapper wardQuery = Wrappers.lambdaQuery();
                ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wardQuery.eq(sysDoctorDto.getTenantId() != null, SysWardEntity::getTenantId, (Object)sysDoctorDto.getTenantId())).eq(SysWardEntity::getDelFlag, (Object)DelFlagEnum.NOT_FLAG.getValue())).eq(SysWardEntity::getEnableStatus, (Object)StatusEnum.ENABLED.getValue())).in(SysWardEntity::getId, wardIds);
                List wardList = this.sysWardMapper.selectList((Wrapper)wardQuery);
                Map wardMap = wardList.stream().collect(Collectors.toMap(SysWardEntity::getId, Function.identity()));
                for (Map.Entry<Integer, List<SysDoctorWardEntity>> entry : relationMap.entrySet()) {
                    relations = entry.getValue();
                    if (relations.isEmpty()) continue;
                    for (SysDoctorWardEntity relation : relations) {
                        SysWardEntity ward = (SysWardEntity)wardMap.get(relation.getWardId());
                        if (ward == null) continue;
                        relation.setWard(ward);
                    }
                }
                for (SysDoctorVo record : page.getRecords()) {
                    relations = relationMap.get(record.getId());
                    if (relations == null || relations.isEmpty()) continue;
                    List wards = relations.stream().map(SysDoctorWardEntity::getWard).filter(Objects::nonNull).collect(Collectors.toList());
                    record.setWardList(wards);
                }
            }
        }
        return pages;
    }

    public List<SysDoctorEntity> pageList(SysDoctorDto sysDoctorDto) {
        Integer tenantId = sysDoctorDto.getTenantId();
        List list = this.doctorMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(SysDoctorEntity::getTenantId, (Object)1)).eq(SysDoctorEntity::getDuties, (Object)"0")).eq(SysDoctorEntity::getDelFlag, (Object)"0")).isNotNull(SysDoctorEntity::getAvatar)).notIn(SysDoctorEntity::getAvatar, new Object[]{""}));
        return list;
    }

    public List<SysDoctorEntity> doctorQueryByWatch() {
        List list = this.doctorMapper.doctorQueryByWatch();
        return list;
    }

    public Boolean removeSysDoctor(Long[] ids) {
        if (ObjectUtils.isEmpty((Object[])ids)) {
            throw new BusinessException("\u533b\u751f\u6279\u91cf\u5220\u9664\u4e0d\u80fd\u4e3a\u7a7a\uff01{ids}\uff01" + ids);
        }
        return ((SysDoctorMapper)this.baseMapper).removeSysDoctor(ids);
    }

    public SysDoctorIdVo doctorById(SysDoctorDto dto) {
        Integer id = dto.getId();
        if (ObjectUtils.isEmpty((Object)id)) {
            throw new BusinessException("\u533b\u751f\u4e3b\u952eid\u4e0d\u80fd\u4e3a\u7a7a\uff01{id}\uff01" + id);
        }
        return ((SysDoctorMapper)this.baseMapper).doctorById(dto);
    }

    public List<SysDoctorIdVo> doctor() {
        return ((SysDoctorMapper)this.baseMapper).doctor();
    }

    public List<SysDoctorIdVo> doctorByDept(Integer deptId) {
        return ((SysDoctorMapper)this.baseMapper).doctorByDept(deptId);
    }

    public IPage<DoctorVo> netHospitalPageList(Page<DoctorDTO> page, DoctorDTO dto) {
        return ((SysDoctorMapper)this.baseMapper).netHospitalPageList(page, dto);
    }

    public ResponseData doctorOnline(DoctorOnlineDto dto) {
        SysDoctorEntity sd = new SysDoctorEntity();
        sd.setId(dto.getDoctorId());
        sd.setTenantId(dto.getTenantId());
        sd.setOnline(dto.getOnline());
        return ResponseData.success((Object)((SysDoctorMapper)this.baseMapper).updateById((Object)sd));
    }

    public SysDoctorServiceImpl(SysDictMapper sysDictMapper, SysDepartmentService sysDepartmentService, SysRoleService sysRoleService, SysUserRoleService sysUserRoleService) {
        this.sysDictMapper = sysDictMapper;
        this.sysDepartmentService = sysDepartmentService;
        this.sysRoleService = sysRoleService;
        this.sysUserRoleService = sysUserRoleService;
    }
}

