/*
 * Decompiled with CFR 0.152.
 */
package com.byh.sys.web.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.byh.sys.api.dto.SysEasyEntity;
import com.byh.sys.api.dto.drug.drugPharmacPrescip.SysDrugPharmacyInPrescriptionSaveDto;
import com.byh.sys.api.dto.drug.drugPharmacPrescip.SysDrugPharmacyInPrescriptionUpdateDto;
import com.byh.sys.api.dto.drug.drugPharmacPrescip.SysDrugPharmacyInPrescriptionUpdateShelfNumberDto;
import com.byh.sys.api.dto.drug.drugPharmacQcQm.SysDrugPharmacyQcQmSaveDto;
import com.byh.sys.api.dto.drug.drugPharmacSimple.SysDrugPharmacySimpleSaveDto;
import com.byh.sys.api.dto.drug.drugPharmacy.SysDrugPharmacySaveDto;
import com.byh.sys.api.dto.drug.drugPharmacyIn.SysDrugPharmacyInDto;
import com.byh.sys.api.dto.drug.drugPharmacyIn.SysDrugPharmacyInExcel;
import com.byh.sys.api.dto.drug.drugPharmacyIn.SysDrugPharmacyInSaveDto;
import com.byh.sys.api.dto.drug.drugPharmacyIn.SysDrugPharmacyInUpdateDto;
import com.byh.sys.api.dto.drug.drugPharmacyIn.SysDrugPharmacyInUpdateShelfNumberDto;
import com.byh.sys.api.dto.drug.drugPharmacyIn.SysDrugPharmacyInUpdateStatusDto;
import com.byh.sys.api.enums.DictEnums;
import com.byh.sys.api.enums.SysDrugEnum;
import com.byh.sys.api.enums.SysMaterialInventoryEnum;
import com.byh.sys.api.exception.BusinessException;
import com.byh.sys.api.model.SysUserEntity;
import com.byh.sys.api.model.drug.SysDrugEntity;
import com.byh.sys.api.model.drug.SysDrugInventoryOutTempEntity;
import com.byh.sys.api.model.drug.inventory.SysDrugAccessEntity;
import com.byh.sys.api.model.drug.inventory.SysDrugBatchEntity;
import com.byh.sys.api.model.drug.inventory.SysDrugInventoryEntity;
import com.byh.sys.api.model.drug.inventory.SysDrugInventoryOutEntity;
import com.byh.sys.api.model.drug.inventory.SysDrugInventoryOutPrescriptionEntity;
import com.byh.sys.api.model.drug.inventory.SysDrugQcQmEntity;
import com.byh.sys.api.model.drug.inventory.SysDrugSubstanceEntity;
import com.byh.sys.api.model.drug.pharmacy.SysDrugPharmacyInEntity;
import com.byh.sys.api.model.drug.pharmacy.SysDrugPharmacyInPrescriptionEntity;
import com.byh.sys.api.model.drug.pharmacy.SysDrugPharmacyQcQmEntity;
import com.byh.sys.api.model.drug.pharmacy.SysDrugPharmacySimpleEntity;
import com.byh.sys.api.util.BeanUtil;
import com.byh.sys.api.util.DateUtils;
import com.byh.sys.api.util.EasyExcelUtil;
import com.byh.sys.api.util.ExceptionUtils;
import com.byh.sys.api.util.UUIDUtils;
import com.byh.sys.api.vo.drug.SysDrugPharmacyInPrescriptionVo;
import com.byh.sys.api.vo.drug.SysDrugPharmacyInVo;
import com.byh.sys.data.repository.SysDrugAccessMapper;
import com.byh.sys.data.repository.SysDrugBatchMapper;
import com.byh.sys.data.repository.SysDrugInventoryMapper;
import com.byh.sys.data.repository.SysDrugInventoryOutMapper;
import com.byh.sys.data.repository.SysDrugInventoryOutPrescriptionMapper;
import com.byh.sys.data.repository.SysDrugInventoryOutTempMapper;
import com.byh.sys.data.repository.SysDrugMapper;
import com.byh.sys.data.repository.SysDrugPharmacyInMapper;
import com.byh.sys.data.repository.SysDrugPharmacyInPrescriptionMapper;
import com.byh.sys.data.repository.SysDrugPharmacyMapper;
import com.byh.sys.data.repository.SysDrugPharmacyQcQmMapper;
import com.byh.sys.data.repository.SysDrugPharmacySimpleMapper;
import com.byh.sys.data.repository.SysDrugPharmacyStorageMapper;
import com.byh.sys.data.repository.SysDrugQcQmMapper;
import com.byh.sys.data.repository.SysDrugSubstanceMapper;
import com.byh.sys.web.call_function.ExtendServiceImpl;
import com.byh.sys.web.mvc.utils.CommonRequest;
import com.byh.sys.web.service.SysDrugPharmacyCheckService;
import com.byh.sys.web.service.SysDrugPharmacyInPrescriptionService;
import com.byh.sys.web.service.SysDrugPharmacyInService;
import com.byh.sys.web.service.SysDrugPharmacyQcQmService;
import com.byh.sys.web.service.SysDrugPharmacySimpleService;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SysDrugPharmacyInServiceImpl
implements SysDrugPharmacyInService {
    private static final Logger log = LoggerFactory.getLogger(SysDrugPharmacyInServiceImpl.class);
    @Resource
    private SysDrugPharmacyInMapper sysDrugPharmacyInMapper;
    @Resource
    private SysDrugPharmacyInPrescriptionService sysDrugPharmacyInPrescriptionService;
    @Resource
    private SysDrugInventoryOutTempMapper sysDrugInventoryOutTempMapper;
    @Resource
    private SysDrugInventoryMapper sysDrugInventoryMapper;
    @Autowired
    private CommonRequest commonRequest;
    @Resource
    private SysDrugAccessMapper sysDrugAccessMapper;
    @Resource
    private SysDrugPharmacyInPrescriptionMapper sysDrugPharmacyInPrescriptionMapper;
    @Resource
    private SysDrugPharmacyQcQmMapper sysDrugPharmacyQcQmMapper;
    @Resource
    private SysDrugPharmacyMapper sysDrugPharmacyMapper;
    @Autowired
    private SysDrugPharmacyQcQmService sysDrugPharmacyQcQmService;
    @Resource
    private SysDrugPharmacySimpleMapper sysDrugPharmacySimpleMapper;
    @Autowired
    private SysDrugPharmacySimpleService sysDrugPharmacySimpleService;
    @Autowired
    private SysDrugPharmacyCheckService sysDrugPharmacyCheckService;
    @Autowired
    private SysDrugInventoryOutPrescriptionMapper sysDrugInventoryOutPrescriptionMapper;
    @Autowired
    private SysDrugBatchMapper sysDrugBatchMapper;
    @Autowired
    private SysDrugInventoryOutMapper sysDrugInventoryOutMapper;
    @Autowired
    private SysDrugQcQmMapper sysDrugQcQmMapper;
    @Autowired
    private SysDrugSubstanceMapper sysDrugSubstanceMapper;
    @Autowired
    private SysDrugPharmacyStorageMapper sysDrugPharmacyStorageMapper;
    @Autowired
    private SysDrugMapper sysDrugMapper;
    @Autowired
    private ExtendServiceImpl extendServiceImpl;

    @Transactional(rollbackFor={BusinessException.class})
    public void sysDrugPharmacyInSave(SysDrugPharmacyInSaveDto dto) {
        this.sysDrugPharmacyCheckService.sysDrugPharmacyCheckStatus(dto.getWarehousingWarehouse());
        List inList = this.sysDrugPharmacyInMapper.selectList((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(SysDrugPharmacyInEntity::getDrugInventoryOutId, (Object)dto.getDrugInventoryOutId())).eq(SysDrugPharmacyInEntity::getAuditStatus, (Object)DictEnums.AUDIT_STATUS_WAIT.getCode()));
        ExceptionUtils.createException((Logger)log, (!CollectionUtils.isEmpty((Collection)inList) ? 1 : 0) != 0, (String)SysDrugEnum.SYS_DRUG_PHARMACY_IN_ALREADY_ERROR.getCode(), (String)SysDrugEnum.SYS_DRUG_PHARMACY_IN_ALREADY_ERROR.getName());
        BigDecimal purchaseAmount = new BigDecimal(0);
        BigDecimal retailAmount = new BigDecimal(0);
        SysDrugPharmacyInEntity entity = (SysDrugPharmacyInEntity)BeanUtil.copy((Object)dto, SysDrugPharmacyInEntity.class);
        String parentId = UUIDUtils.getRandom((int)6, (boolean)true);
        entity.setId(parentId);
        entity.setAuditStatus(DictEnums.AUDIT_STATUS_WAIT.getCode());
        SysUserEntity userInfo = this.commonRequest.getUserInfo();
        if (null != userInfo) {
            entity.setWarehousingUse(userInfo.getUserName());
        }
        List list = dto.getList();
        for (SysDrugPharmacyInPrescriptionSaveDto n : list) {
            this.extendServiceImpl.drugCheckDrugRelation(n.getQuantity(), n.getTenantId(), n.getDrugsId(), dto.getWarehousingWarehouse());
            n.setTenantId(dto.getTenantId());
            n.setDrugPharmacyInId(parentId);
            n.setId(UUIDUtils.getRandom((int)6, (boolean)true));
            n.setPurchaseSalesDifference(n.getRetailPrice().subtract(n.getPurchasePrice()));
            purchaseAmount = purchaseAmount.add(new BigDecimal(n.getQuantity()).multiply(n.getPurchasePrice()));
            retailAmount = retailAmount.add(new BigDecimal(n.getQuantity()).multiply(n.getRetailPrice()));
        }
        entity.setPurchaseAmount(purchaseAmount);
        entity.setRetailAmount(retailAmount);
        int a = this.sysDrugPharmacyInMapper.insert((Object)entity);
        ExceptionUtils.createException((Logger)log, (int)a, (String)SysDrugEnum.SYS_DRUG_PHARMACY_IN_INSERT_ERROR.getCode(), (String)SysDrugEnum.SYS_DRUG_PHARMACY_IN_INSERT_ERROR.getName());
        this.sysDrugPharmacyInPrescriptionService.sysDrugPharmacyInPrescriptionSaveBatch(list);
    }

    public IPage<SysDrugPharmacyInVo> sysDrugPharmacyInSelect(Page page, SysDrugPharmacyInDto dto) {
        IPage list = this.sysDrugPharmacyInMapper.sysDrugPharmacyInSelect(page, dto);
        return list;
    }

    public void sysDrugPharmacyInUpdate(SysDrugPharmacyInUpdateDto dto) {
        BigDecimal purchaseAmount = new BigDecimal(0);
        SysDrugPharmacyInEntity entity = (SysDrugPharmacyInEntity)BeanUtil.copy((Object)dto, SysDrugPharmacyInEntity.class);
        List list = dto.getList();
        if (!CollectionUtils.isEmpty((Collection)list)) {
            for (SysDrugPharmacyInPrescriptionUpdateDto n : list) {
                purchaseAmount = purchaseAmount.add(new BigDecimal(n.getQuantity()).multiply(n.getPurchasePrice()));
            }
            entity.setPurchaseAmount(purchaseAmount);
            for (SysDrugPharmacyInPrescriptionUpdateDto n : list) {
                this.extendServiceImpl.drugCheckDrugRelation(n.getQuantity(), n.getTenantId(), n.getDrugsId(), dto.getWarehousingWarehouse());
                n.setTenantId(dto.getTenantId());
                this.sysDrugPharmacyInPrescriptionService.sysDrugPharmacyInPrescriptionUpdate(n);
            }
        }
        int a = this.sysDrugPharmacyInMapper.update((Object)entity, (Wrapper)((LambdaUpdateWrapper)Wrappers.lambdaUpdate().eq(SysDrugPharmacyInEntity::getId, (Object)entity.getId())).eq(SysDrugPharmacyInEntity::getTenantId, (Object)entity.getTenantId()));
        ExceptionUtils.createException((Logger)log, (int)a, (String)SysMaterialInventoryEnum.SYS_MATERIAL_INVENTORY_UPDATE_ERROR.getCode(), (String)SysMaterialInventoryEnum.SYS_MATERIAL_INVENTORY_UPDATE_ERROR.getName());
    }

    public void sysDrugPharmacyInDelete(String[] ids) {
        int a = this.sysDrugPharmacyInMapper.sysDrugPharmacyInDelete(ids);
        ExceptionUtils.createException((Logger)log, (int)a, (String)SysDrugEnum.SYS_DRUG_PHARMACY_IN_DELETE_ERROR.getCode(), (String)SysDrugEnum.SYS_DRUG_PHARMACY_IN_DELETE_ERROR.getName());
    }

    public List<SysDrugPharmacyInPrescriptionVo> sysDrugPharmacyInDetail(String id, Integer tenantId) {
        List list = this.sysDrugPharmacyInPrescriptionMapper.selectList((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(SysDrugPharmacyInPrescriptionEntity::getDrugPharmacyInId, (Object)id)).eq(SysDrugPharmacyInPrescriptionEntity::getTenantId, (Object)tenantId));
        List vo = BeanUtil.copyList((List)list, SysDrugPharmacyInPrescriptionVo.class);
        for (SysDrugPharmacyInPrescriptionVo n : vo) {
            n.setRetailPriceCount(n.getRetailPrice().multiply(new BigDecimal(n.getQuantity())));
        }
        return vo;
    }

    public void sysDrugPharmacyInUpdateStatus(SysDrugPharmacyInUpdateStatusDto dto) {
        SysDrugPharmacyInEntity entity = (SysDrugPharmacyInEntity)BeanUtil.copy((Object)dto, SysDrugPharmacyInEntity.class);
        entity.setConfirmTime(new Date());
        SysUserEntity userInfo = this.commonRequest.getUserInfo();
        if (null != userInfo) {
            entity.setReviewedBy(userInfo.getUserName());
            entity.setUpdateId(userInfo.getId());
        }
        int a = this.sysDrugPharmacyInMapper.update((Object)entity, (Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(SysDrugPharmacyInEntity::getId, (Object)entity.getId())).eq(SysDrugPharmacyInEntity::getTenantId, (Object)entity.getTenantId()));
        ExceptionUtils.createException((Logger)log, (int)a, (String)SysMaterialInventoryEnum.SYS_MATERIAL_INVENTORY_UPDATE_ERROR.getCode(), (String)SysMaterialInventoryEnum.SYS_MATERIAL_INVENTORY_UPDATE_ERROR.getName());
    }

    @Transactional(rollbackFor={BusinessException.class})
    public void sysDrugPharmacyInUpdateShelfNumber(SysDrugPharmacyInUpdateShelfNumberDto dto) {
        SysDrugPharmacyInEntity entity = (SysDrugPharmacyInEntity)BeanUtil.copy((Object)dto, SysDrugPharmacyInEntity.class);
        List l = dto.getList().stream().filter(n -> null == n.getShelfNumber() || "".equals(n.getShelfNumber())).collect(Collectors.toList());
        ExceptionUtils.createException((Logger)log, (!CollectionUtils.isEmpty(l) ? 1 : 0) != 0, (String)SysDrugEnum.SYS_DRUG_PHARMACY_UPDATE_SHELF_NUMBER_ERROR.getCode(), (String)SysDrugEnum.SYS_DRUG_PHARMACY_UPDATE_SHELF_NUMBER_ERROR.getName());
        entity.setShelfUpdate("1");
        int a = this.sysDrugPharmacyInMapper.update((Object)entity, (Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(SysDrugPharmacyInEntity::getId, (Object)entity.getId())).eq(SysDrugPharmacyInEntity::getTenantId, (Object)this.commonRequest.getTenant()));
        ExceptionUtils.createException((Logger)log, (int)a, (String)SysDrugEnum.SYS_DRUG_PHARMACY_UPDATE_ERROR.getCode(), (String)SysDrugEnum.SYS_DRUG_PHARMACY_UPDATE_ERROR.getName());
        for (SysDrugPharmacyInPrescriptionUpdateShelfNumberDto n2 : dto.getList()) {
            SysDrugPharmacyInPrescriptionEntity e = (SysDrugPharmacyInPrescriptionEntity)BeanUtil.copy((Object)n2, SysDrugPharmacyInPrescriptionEntity.class);
            int b = this.sysDrugPharmacyInPrescriptionMapper.updateById((Object)e);
            ExceptionUtils.createException((Logger)log, (int)b, (String)SysDrugEnum.SYS_DRUG_PHARMACY_IN_PRESCRIPTION_UPDATE_SHELF_NUMBER_ERROR.getCode(), (String)SysDrugEnum.SYS_DRUG_PHARMACY_IN_PRESCRIPTION_UPDATE_SHELF_NUMBER_ERROR.getName());
        }
    }

    @Transactional(rollbackFor={BusinessException.class})
    public void sysDrugPharmacyInBack(SysEasyEntity entity, Integer tenantId) {
        SysDrugInventoryOutEntity sysDrugInventoryOutEntity = (SysDrugInventoryOutEntity)this.sysDrugInventoryOutMapper.selectOne((Wrapper)Wrappers.lambdaQuery().eq(SysDrugInventoryOutEntity::getId, (Object)entity.getId()));
        ExceptionUtils.createException((Logger)log, (null == sysDrugInventoryOutEntity ? 1 : 0) != 0, (String)SysDrugEnum.SYS_DRUG_PHARMACY_IN_BACK_NOT_FIND_ERROR.getCode(), (String)SysDrugEnum.SYS_DRUG_PHARMACY_IN_BACK_NOT_FIND_ERROR.getName());
        List list = this.sysDrugInventoryOutPrescriptionMapper.selectList((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(SysDrugInventoryOutPrescriptionEntity::getDrugInventoryOutId, (Object)entity.getId())).eq(SysDrugInventoryOutPrescriptionEntity::getTenantId, (Object)tenantId));
        this.backDrugForeach(list, tenantId, entity, DateUtils.dateFormat((Date)sysDrugInventoryOutEntity.getConfirmTime(), (String)"yyyy-MM-dd"));
        int c = this.sysDrugInventoryOutMapper.delete((Wrapper)Wrappers.lambdaQuery().eq(SysDrugInventoryOutEntity::getId, (Object)entity.getId()));
        ExceptionUtils.createException((Logger)log, (int)c, (String)SysDrugEnum.SYS_DRUG_PHARMACY_IN_BACK_ERROR.getCode(), (String)SysDrugEnum.SYS_DRUG_PHARMACY_IN_BACK_ERROR.getName());
        int d = this.sysDrugInventoryOutPrescriptionMapper.delete((Wrapper)Wrappers.lambdaQuery().eq(SysDrugInventoryOutPrescriptionEntity::getDrugInventoryOutId, (Object)entity.getId()));
        ExceptionUtils.createException((Logger)log, (int)d, (String)SysDrugEnum.SYS_DRUG_PHARMACY_IN_BACK_ERROR.getCode(), (String)SysDrugEnum.SYS_DRUG_PHARMACY_IN_BACK_ERROR.getName());
        int e = this.sysDrugInventoryOutTempMapper.delete((Wrapper)Wrappers.lambdaQuery().eq(SysDrugInventoryOutTempEntity::getDrugInventoryOutId, (Object)entity.getId()));
        ExceptionUtils.createException((Logger)log, (int)e, (String)SysDrugEnum.SYS_DRUG_OUT_TEMP_DELETE_ERROR.getCode(), (String)SysDrugEnum.SYS_DRUG_OUT_TEMP_DELETE_ERROR.getName());
    }

    public void backDrugForeach(List<SysDrugInventoryOutPrescriptionEntity> list, Integer tenantId, SysEasyEntity entity, String confirmDate) {
        ArrayList accessList = new ArrayList();
        for (SysDrugInventoryOutPrescriptionEntity n : list) {
            SysDrugInventoryEntity drugInventory = new SysDrugInventoryEntity();
            SysDrugBatchEntity drugBatch = new SysDrugBatchEntity();
            BigDecimal purchasePriceAmount = new BigDecimal(n.getDrugNum()).multiply(n.getPurchasePrice());
            BigDecimal retailPriceAmount = new BigDecimal(n.getDrugNum()).multiply(n.getRetailPrice());
            SysDrugInventoryEntity sysDrugInventoryEntity = (SysDrugInventoryEntity)this.sysDrugInventoryMapper.selectOne((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(SysDrugInventoryEntity::getDrugId, (Object)n.getDrugId())).eq(SysDrugInventoryEntity::getTenantId, (Object)tenantId));
            ExceptionUtils.createException((Logger)log, (null == sysDrugInventoryEntity ? 1 : 0) != 0, (String)SysDrugEnum.SYS_DRUG_PHARMACY_IN_BACK_NOT_FIND_ERROR.getCode(), (String)SysDrugEnum.SYS_DRUG_PHARMACY_IN_BACK_NOT_FIND_ERROR.getName());
            SysDrugBatchEntity sysDrugBatchEntity = (SysDrugBatchEntity)this.sysDrugBatchMapper.selectOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(SysDrugBatchEntity::getDrugId, (Object)n.getDrugId())).eq(SysDrugBatchEntity::getBatchNumber, (Object)n.getBatchNumber())).eq(SysDrugBatchEntity::getPurchasePrice, (Object)n.getPurchasePrice())).eq(SysDrugBatchEntity::getEffectiveTime, (Object)n.getEffectiveTime())).eq(SysDrugBatchEntity::getDrugInventoryInId, (Object)n.getDrugInventoryInId()));
            ExceptionUtils.createException((Logger)log, (null == sysDrugBatchEntity ? 1 : 0) != 0, (String)SysDrugEnum.SYS_DRUG_PHARMACY_IN_BACK_NOT_FIND_ERROR.getCode(), (String)SysDrugEnum.SYS_DRUG_PHARMACY_IN_BACK_NOT_FIND_ERROR.getName());
            drugInventory.setPurchaseAmount(sysDrugInventoryEntity.getPurchaseAmount().add(purchasePriceAmount));
            drugInventory.setRetailAmount(sysDrugInventoryEntity.getRetailAmount().add(retailPriceAmount));
            drugInventory.setActualInventory(Integer.valueOf(sysDrugInventoryEntity.getActualInventory() + n.getDrugNum()));
            drugInventory.setDrugId(n.getDrugId());
            int a = this.sysDrugInventoryMapper.update((Object)drugInventory, (Wrapper)Wrappers.lambdaUpdate().eq(SysDrugInventoryEntity::getDrugId, (Object)n.getDrugId()));
            ExceptionUtils.createException((Logger)log, (int)a, (String)SysDrugEnum.SYS_DRUG_PHARMACY_IN_BACK_ERROR.getCode(), (String)"\u836f\u623f\u5165\u5e93\u9000\u56de\u67e5\u8be2\u5e93\u5b58\u3010sys_drug_inventory\u3011\u8868\u6570\u636e\u66f4\u65b0\u5931\u8d25");
            drugBatch.setPurchaseAmount(sysDrugBatchEntity.getPurchaseAmount().add(purchasePriceAmount));
            drugBatch.setRetailAmount(sysDrugBatchEntity.getRetailAmount().add(retailPriceAmount));
            drugBatch.setBookInventory(Integer.valueOf(sysDrugBatchEntity.getBookInventory() + n.getDrugNum()));
            drugBatch.setDrugId(n.getDrugId());
            int b = this.sysDrugBatchMapper.update((Object)drugBatch, (Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)Wrappers.lambdaUpdate().eq(SysDrugBatchEntity::getDrugId, (Object)n.getDrugId())).eq(SysDrugBatchEntity::getBatchNumber, (Object)n.getBatchNumber())).eq(SysDrugBatchEntity::getPurchasePrice, (Object)n.getPurchasePrice())).eq(SysDrugBatchEntity::getEffectiveTime, (Object)n.getEffectiveTime())).eq(SysDrugBatchEntity::getDrugInventoryInId, (Object)n.getDrugInventoryInId()));
            ExceptionUtils.createException((Logger)log, (int)b, (String)SysDrugEnum.SYS_DRUG_PHARMACY_IN_BACK_ERROR.getCode(), (String)"\u836f\u623f\u5165\u5e93\u9000\u56de\u67e5\u8be2\u5e93\u5b58\u3010sys_drug_batch\u3011\u8868\u6570\u636e\u66f4\u65b0\u5931\u8d25");
            SysDrugQcQmEntity sysDrugQcQmEntity = (SysDrugQcQmEntity)this.sysDrugQcQmMapper.selectOne((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(SysDrugQcQmEntity::getDrugId, (Object)n.getDrugId())).eq(SysDrugQcQmEntity::getOutTime, (Object)confirmDate));
            sysDrugQcQmEntity.setOutNum(Integer.valueOf(sysDrugQcQmEntity.getOutNum() - n.getDrugNum()));
            int k = this.sysDrugQcQmMapper.updateById((Object)sysDrugQcQmEntity);
            ExceptionUtils.createException((Logger)log, (int)k, (String)SysDrugEnum.SYS_DRUG_PHARMACY_IN_BACK_ERROR.getCode(), (String)"\u836f\u623f\u5165\u5e93\u9000\u56de\u67e5\u8be2\u5e93\u5b58\u3010sys_drug_qc_qm\u3011\u8868\u6570\u636e\u66f4\u65b0\u5931\u8d25");
            this.backInsertAccess(entity, n, accessList);
        }
        int i = this.sysDrugSubstanceMapper.delete((Wrapper)Wrappers.lambdaQuery().eq(SysDrugSubstanceEntity::getOddNumbers, (Object)entity.getId()));
        ExceptionUtils.createException((Logger)log, (int)i, (String)SysDrugEnum.SYS_DRUG_PHARMACY_IN_BACK_ERROR.getCode(), (String)(entity.getId() + "-\u836f\u623f\u5165\u5e93\u9000\u56de\u67e5\u8be2\u5e93\u5b58\u3010sys_drug_substance\u8868\u6570\u636e\u3011\u672a\u627e\u5230"));
        int a = this.sysDrugAccessMapper.insertBatch(accessList);
        ExceptionUtils.createException((Logger)log, (int)a, (String)SysDrugEnum.SYS_DRUG_ACCESS_INSERT_ERROR.getCode(), (String)SysDrugEnum.SYS_DRUG_ACCESS_INSERT_ERROR.getName());
    }

    private void backInsertAccess(SysEasyEntity esEntry, SysDrugInventoryOutPrescriptionEntity n, List<SysDrugAccessEntity> accessList) {
        SysDrugAccessEntity entity = (SysDrugAccessEntity)BeanUtil.copy((Object)n, SysDrugAccessEntity.class);
        entity.setId(UUIDUtils.getRandom((int)6, (boolean)true));
        entity.setWayType(esEntry.getInOutType());
        entity.setWayName(esEntry.getInOutName());
        entity.setWayNom(n.getDrugInventoryOutId());
        entity.setNumber(n.getDrugNum());
        entity.setWayTime(new Date());
        entity.setTenantId(this.commonRequest.getTenant());
        entity.setDrugId(n.getDrugId());
        entity.setDrugName(n.getDrugName());
        accessList.add(entity);
    }

    public void sysDrugPharmacyInExport(HttpServletResponse response, Page page, SysDrugPharmacyInDto dto) {
        IPage list = this.sysDrugPharmacyInMapper.sysDrugPharmacyInSelect(page, dto);
        List excels = BeanUtil.copyList((List)list.getRecords(), SysDrugPharmacyInExcel.class);
        for (SysDrugPharmacyInExcel n : excels) {
            if (DictEnums.AUDIT_STATUS_WAIT.getCode().equals(n.getAuditStatus())) {
                n.setAuditStatus(DictEnums.AUDIT_STATUS_WAIT.getMsg());
                continue;
            }
            if (DictEnums.AUDIT_STATUS_ALREADY.getCode().equals(n.getAuditStatus())) {
                n.setAuditStatus(DictEnums.AUDIT_STATUS_ALREADY.getMsg());
                continue;
            }
            if (!DictEnums.AUDIT_STATUS_CANCEL.getCode().equals(n.getAuditStatus())) continue;
            n.setAuditStatus(DictEnums.AUDIT_STATUS_CANCEL.getMsg());
        }
        String excelName = "\u836f\u623f\u5165\u5e93\u5bfc\u51fa";
        String sheetName = "\u836f\u623f\u5165\u5e93";
        try {
            EasyExcelUtil.exportExcel((HttpServletResponse)response, (String)excelName, (String)sheetName, (List)excels, (Object)new SysDrugPharmacyInExcel());
        }
        catch (Exception e) {
            e.printStackTrace();
            ExceptionUtils.createException((Logger)log, (boolean)true, (String)SysDrugEnum.SYS_DRUG_PHARMACY_IN_EXPORT_ERROR.getCode(), (String)SysDrugEnum.SYS_DRUG_PHARMACY_IN_EXPORT_ERROR.getName());
        }
    }

    @Transactional(rollbackFor={BusinessException.class})
    public void sysDrugPharmacyInConfirm(String id, Integer tenantId) {
        SysDrugPharmacyInEntity entry = (SysDrugPharmacyInEntity)this.sysDrugPharmacyInMapper.selectOne((Wrapper)Wrappers.lambdaQuery().eq(SysDrugPharmacyInEntity::getId, (Object)id));
        this.extendServiceImpl.checkShelf(entry);
        ExceptionUtils.createException((Logger)log, (!DictEnums.AUDIT_STATUS_WAIT.getCode().equals(entry.getAuditStatus()) ? 1 : 0) != 0, (String)SysDrugEnum.SYS_DRUG_PHARMACY_IN_STATUS_ALREADY_CONFIRM_ERROR.getCode(), (String)SysDrugEnum.SYS_DRUG_PHARMACY_IN_STATUS_ALREADY_CONFIRM_ERROR.getName());
        this.extendServiceImpl.inDrugPositionShelf(entry);
        SysDrugPharmacyInEntity entity = new SysDrugPharmacyInEntity();
        entity.setAuditStatus(DictEnums.AUDIT_STATUS_ALREADY.getCode());
        entity.setConfirmTime(new Date());
        SysUserEntity userInfo = this.commonRequest.getUserInfo();
        if (null != userInfo) {
            entity.setReviewedBy(userInfo.getUserName());
        }
        int a = this.sysDrugPharmacyInMapper.update((Object)entity, (Wrapper)Wrappers.lambdaUpdate().eq(SysDrugPharmacyInEntity::getId, (Object)id));
        ExceptionUtils.createException((Logger)log, (int)a, (String)SysDrugEnum.SYS_DRUG_PHARMACY_IN_UPDATE_ERROR.getCode(), (String)SysDrugEnum.SYS_DRUG_PHARMACY_IN_UPDATE_ERROR.getName());
        List saveDtoList = this.addInventory(id, tenantId, entry, entity.getConfirmTime());
        this.addStartAndEnd(entry, saveDtoList, tenantId);
    }

    public List<SysDrugPharmacySaveDto> addInventory(String id, Integer tenantId, SysDrugPharmacyInEntity entry, Date confirmTime) {
        ArrayList<SysDrugPharmacySaveDto> saveDtoList = new ArrayList<SysDrugPharmacySaveDto>();
        List list = this.sysDrugPharmacyInPrescriptionMapper.selectList((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(SysDrugPharmacyInPrescriptionEntity::getDrugPharmacyInId, (Object)id)).eq(SysDrugPharmacyInPrescriptionEntity::getTenantId, (Object)tenantId));
        List ids = list.stream().map(SysDrugPharmacyInPrescriptionEntity::getDrugsId).collect(Collectors.toList());
        List drugList = this.sysDrugMapper.selectList((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().in(SysDrugEntity::getId, ids)).eq(SysDrugEntity::getTenantId, (Object)entry.getTenantId()));
        Map<String, List<SysDrugEntity>> drugsListMap = drugList.stream().collect(Collectors.groupingBy(SysDrugEntity::getId));
        for (SysDrugPharmacyInPrescriptionEntity n : list) {
            this.selectAndCheckSimpleExist(n, entry);
            SysDrugPharmacySaveDto saveDto = (SysDrugPharmacySaveDto)BeanUtil.copy((Object)n, SysDrugPharmacySaveDto.class);
            saveDto.setBatchNumber(n.getBatchNumber());
            saveDto.setId(UUIDUtils.getRandom((int)5, (boolean)true));
            saveDto.setInventoryId(n.getDrugPharmacyInId());
            saveDto.setActualInventory(n.getQuantity());
            saveDto.setPurchaseAmount(new BigDecimal(n.getQuantity()).multiply(n.getPurchasePrice()));
            saveDto.setRetailAmount(new BigDecimal(n.getQuantity()).multiply(n.getRetailPrice()));
            saveDto.setInOutType(DictEnums.IN_OUT_TYPE_IN.getCode());
            saveDto.setInOutMethod(entry.getWarehousingMethod());
            saveDto.setInOutTime(confirmTime);
            saveDto.setWarehouse(entry.getWarehousingWarehouse());
            saveDto.setPurchasePrice(n.getPurchasePrice());
            saveDto.setRetailPrice(n.getRetailPrice());
            saveDto.setShelfNumber(n.getShelfNumber());
            if (!CollectionUtils.isEmpty((Collection)drugsListMap.get(n.getDrugsId()))) {
                saveDto.setThirdCode(drugsListMap.get(n.getDrugsId()).get(0).getThirdCode());
                saveDto.setInternalCode(drugsListMap.get(n.getDrugsId()).get(0).getInternalCode().toString());
            }
            saveDtoList.add(saveDto);
        }
        this.sysDrugPharmacyMapper.sysDrugPharmacySaveBatch(saveDtoList);
        this.sysDrugInventoryOutTempMapper.deleteById((Serializable)((Object)entry.getTempId()));
        return saveDtoList;
    }

    public void addStartAndEnd(SysDrugPharmacyInEntity entry, List<SysDrugPharmacySaveDto> saveDtoList, Integer tenantId) {
        Date date = entry.getWarehousingTime();
        String year = DateUtils.dateFormat((Date)date, (String)"YYYY");
        String month = DateUtils.dateFormat((Date)date, (String)"MM");
        String day = DateUtils.dateFormat((Date)date, (String)"dd");
        for (SysDrugPharmacySaveDto saveDto : saveDtoList) {
            SysDrugPharmacyQcQmEntity qcQmEntity = (SysDrugPharmacyQcQmEntity)this.sysDrugPharmacyQcQmMapper.selectOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(SysDrugPharmacyQcQmEntity::getWarehouse, (Object)entry.getWarehousingWarehouse())).eq(SysDrugPharmacyQcQmEntity::getDrugId, (Object)saveDto.getDrugsId())).eq(SysDrugPharmacyQcQmEntity::getDrugYear, (Object)year)).eq(SysDrugPharmacyQcQmEntity::getDrugMonth, (Object)month)).eq(SysDrugPharmacyQcQmEntity::getDrugDay, (Object)day)).eq(SysDrugPharmacyQcQmEntity::getTenantId, (Object)tenantId));
            if (null != qcQmEntity) {
                qcQmEntity.setInNum(Integer.valueOf(qcQmEntity.getInNum() + saveDto.getActualInventory()));
                this.sysDrugPharmacyQcQmService.sysDrugPharmacyQcQmUpdateEntity(qcQmEntity);
                continue;
            }
            SysDrugPharmacyQcQmSaveDto qcQmSaveDto = new SysDrugPharmacyQcQmSaveDto();
            qcQmSaveDto.setWarehouse(entry.getWarehousingWarehouse());
            qcQmSaveDto.setId(UUIDUtils.getRandom((int)5, (boolean)true));
            qcQmSaveDto.setDrugYear(year);
            qcQmSaveDto.setDrugMonth(month);
            qcQmSaveDto.setDrugDay(day);
            qcQmSaveDto.setDrugId(saveDto.getDrugsId());
            qcQmSaveDto.setDrugName(saveDto.getDrugsName());
            qcQmSaveDto.setInNum(saveDto.getActualInventory());
            qcQmSaveDto.setTenantId(tenantId);
            this.sysDrugPharmacyQcQmService.sysDrugPharmacyQcQmSave(qcQmSaveDto);
        }
    }

    private void selectAndCheckSimpleExist(SysDrugPharmacyInPrescriptionEntity n, SysDrugPharmacyInEntity entry) {
        SysDrugPharmacySimpleEntity simpleDrugEntity = (SysDrugPharmacySimpleEntity)this.sysDrugPharmacySimpleMapper.selectOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(SysDrugPharmacySimpleEntity::getDrugsId, (Object)n.getDrugsId())).eq(SysDrugPharmacySimpleEntity::getTenantId, (Object)n.getTenantId())).eq(SysDrugPharmacySimpleEntity::getDelFlag, (Object)"0")).eq(SysDrugPharmacySimpleEntity::getWarehouse, (Object)entry.getWarehousingWarehouse()));
        if (null != simpleDrugEntity) {
            simpleDrugEntity.setActualInventory(Integer.valueOf(simpleDrugEntity.getActualInventory() + n.getQuantity()));
            simpleDrugEntity.setPurchaseAmount(simpleDrugEntity.getPurchaseAmount().add(new BigDecimal(n.getQuantity()).multiply(n.getPurchasePrice())));
            this.sysDrugPharmacySimpleService.sysDrugPharmacySimpleUpdateEntity(simpleDrugEntity);
        } else {
            SysDrugPharmacySimpleSaveDto simpleDto = (SysDrugPharmacySimpleSaveDto)BeanUtil.copy((Object)n, SysDrugPharmacySimpleSaveDto.class);
            simpleDto.setId(UUIDUtils.getRandom((int)5, (boolean)true));
            simpleDto.setActualInventory(n.getQuantity());
            simpleDto.setPurchaseAmount(new BigDecimal(n.getQuantity()).multiply(n.getPurchasePrice()));
            simpleDto.setRetailPriceAmount(new BigDecimal(n.getQuantity()).multiply(n.getRetailPrice()));
            simpleDto.setTenantId(n.getTenantId());
            simpleDto.setUnit(n.getUnit());
            simpleDto.setDrugsType(n.getDrugsType());
            simpleDto.setWarehouse(entry.getWarehousingWarehouse());
            this.sysDrugPharmacySimpleService.sysDrugPharmacySimpleSave(simpleDto);
        }
    }
}

