/*
 * Decompiled with CFR 0.152.
 */
package com.byh.sys.web.service.impl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.byh.sys.api.dto.OutPrescriptionDto;
import com.byh.sys.api.dto.SysEasyEntity;
import com.byh.sys.api.dto.outRelation.SysDrugPharmacyOutRelationDto;
import com.byh.sys.api.dto.outRelation.SysDrugPharmacyOutRelationExcel;
import com.byh.sys.api.dto.outRelation.SysDrugPharmacyOutRelationSaveDto;
import com.byh.sys.api.enums.SysDrugEnum;
import com.byh.sys.api.exception.BusinessException;
import com.byh.sys.api.util.BeanUtil;
import com.byh.sys.api.util.EasyExcelUtil;
import com.byh.sys.api.util.ExceptionUtils;
import com.byh.sys.api.util.ResponseData;
import com.byh.sys.api.util.StringUtils;
import com.byh.sys.api.util.UUIDUtils;
import com.byh.sys.api.vo.drug.SysDrugPharmacyOutRelationVo;
import com.byh.sys.data.repository.SysDrugMapper;
import com.byh.sys.data.repository.SysDrugPharmacyOutRelationMapper;
import com.byh.sys.web.fegin.OutServiceFeign;
import com.byh.sys.web.mvc.utils.CommonRequest;
import com.byh.sys.web.service.SysDrugPharmacyOutRelationService;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SysDrugPharmacyOutRelationServiceImpl
implements SysDrugPharmacyOutRelationService {
    private static final Logger log = LoggerFactory.getLogger(SysDrugPharmacyOutRelationServiceImpl.class);
    @Resource
    private SysDrugPharmacyOutRelationMapper sysDrugPharmacyOutRelationMapper;
    @Autowired
    private CommonRequest commonRequest;
    @Resource
    private SysDrugMapper sysDrugMapper;
    @Resource
    private OutServiceFeign outServiceFeign;

    @Transactional(rollbackFor={BusinessException.class})
    public List<SysDrugPharmacyOutRelationVo> sysDrugPharmacyOutRelationSave(List<SysDrugPharmacyOutRelationSaveDto> dto) {
        StringBuilder builder = new StringBuilder();
        List drugsIds = dto.stream().map(SysDrugPharmacyOutRelationSaveDto::getDrugsId).collect(Collectors.toList());
        Page page = new Page(1L, -1L);
        SysDrugPharmacyOutRelationDto req = new SysDrugPharmacyOutRelationDto();
        req.setDrugsIds(drugsIds);
        req.setWarehouse(this.commonRequest.getDrugRoomId());
        req.setTenantId(this.commonRequest.getTenant());
        IPage checkList = this.sysDrugPharmacyOutRelationMapper.sysDrugPharmacyOutRelationSelect(page, req);
        if (!CollectionUtils.isEmpty((Collection)checkList.getRecords())) {
            List collects = checkList.getRecords().stream().map(SysDrugPharmacyOutRelationVo::getDrugsName).collect(Collectors.toList());
            for (String s : collects) {
                builder.append("\u3010").append(s).append("\u3011");
            }
            return checkList.getRecords();
        }
        for (SysDrugPharmacyOutRelationSaveDto n : dto) {
            n.setTenantId(this.commonRequest.getTenant());
            n.setId(UUIDUtils.getRandom((int)5, (boolean)true));
            if (!StringUtils.isBlank((String)n.getWarehouse())) continue;
            n.setWarehouse(this.commonRequest.getDrugRoomId());
        }
        int a = this.sysDrugPharmacyOutRelationMapper.sysDrugPharmacyOutRelationSaveBatch(dto);
        ExceptionUtils.createException((Logger)log, (int)a, (String)SysDrugEnum.SYS_DRUG_PHARMACY_OUT_RELATION_INSERT_ERROR.getCode(), (String)SysDrugEnum.SYS_DRUG_PHARMACY_OUT_RELATION_INSERT_ERROR.getName());
        return null;
    }

    public IPage<SysDrugPharmacyOutRelationVo> sysDrugPharmacyOutRelationSelect(Page page, SysDrugPharmacyOutRelationDto dto) {
        IPage list = this.sysDrugPharmacyOutRelationMapper.sysDrugPharmacyOutRelationSelect(page, dto);
        return list;
    }

    @Transactional(rollbackFor={BusinessException.class})
    public void sysDrugPharmacyOutRelationDelete(SysEasyEntity entity) {
        Integer tenant = this.commonRequest.getTenant();
        int a = this.sysDrugPharmacyOutRelationMapper.sysDrugPharmacyOutRelationDelete(tenant, entity.getIds(), entity.getWarehouse());
        ExceptionUtils.createException((Logger)log, (int)a, (String)SysDrugEnum.SYS_DRUG_PHARMACY_OUT_RELATION_DELETE_ERROR.getCode(), (String)SysDrugEnum.SYS_DRUG_PHARMACY_OUT_RELATION_DELETE_ERROR.getName());
    }

    public void sysDrugPharmacyOutRelationExport(HttpServletResponse response, Page page, SysDrugPharmacyOutRelationDto dto) {
        IPage list = this.sysDrugPharmacyOutRelationSelect(page, dto);
        List excels = BeanUtil.copyList((List)list.getRecords(), SysDrugPharmacyOutRelationExcel.class);
        String excelName = "\u865a\u62df\u836f\u623f\u5bfc\u51fa\u660e\u7ec6";
        String sheetName = "\u865a\u62df\u836f\u623f\u5bfc\u51fa\u660e\u7ec6";
        try {
            EasyExcelUtil.exportExcel((HttpServletResponse)response, (String)excelName, (String)sheetName, (List)excels, (Object)new SysDrugPharmacyOutRelationExcel());
        }
        catch (Exception e) {
            e.printStackTrace();
            ExceptionUtils.createException((Logger)log, (boolean)true, (String)SysDrugEnum.SYS_DRUG_PHARMACY_SIMPLE_EXPORT_ERROR.getCode(), (String)SysDrugEnum.SYS_DRUG_PHARMACY_SIMPLE_EXPORT_ERROR.getName());
        }
    }

    public ResponseData prescriptionOrderSelect(SysDrugPharmacyOutRelationDto dto) {
        OutPrescriptionDto param = new OutPrescriptionDto();
        param.setTenantId(dto.getTenantId());
        param.setPrescriptionClassifyType(Integer.valueOf(3));
        param.setSize(dto.getSize());
        param.setCurrent(dto.getCurrent());
        return this.outServiceFeign.queryPrescriptionSelect(param);
    }
}

