/*
 * Decompiled with CFR 0.152.
 */
package com.chdu.ai.controller;

import com.chdu.ai.model.BaseResponse;
import com.chdu.ai.model.MedicalDoc;
import com.chdu.ai.model.MedicalDocRequest;
import com.chdu.ai.model.QueryRequest;
import com.chdu.ai.service.MedicalDocSearchService;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/assist"})
public class AssistantController {
    private static final Logger log = LoggerFactory.getLogger(AssistantController.class);
    @Autowired
    private MedicalDocSearchService medicalDocSearchService;

    @PostMapping(value={"/searchMedicalDocs"})
    public BaseResponse<List<MedicalDoc>> searchMedicalDocs(@RequestBody QueryRequest request) {
        log.info("\u6536\u5230\u641c\u7d22\u8bf7\u6c42: query={}", (Object)request.getQuery());
        List result = this.medicalDocSearchService.searchMedicalDocs(request.getQuery());
        log.info("\u641c\u7d22\u8fd4\u56de {} \u6761\u7ed3\u679c", (Object)result.size());
        return BaseResponse.success((Object)result);
    }

    @PostMapping(value={"/addMedicalDoc"})
    public BaseResponse<String> addMedicalDoc(@RequestBody MedicalDocRequest request) {
        log.info("\u6536\u5230\u6dfb\u52a0\u533b\u5b66\u6587\u6863\u8bf7\u6c42: title={}, content={}", (Object)request.getTitle(), (Object)request.getContent());
        try {
            this.medicalDocSearchService.saveMedicalDoc(request.getTitle(), request.getContent());
            log.info("\u533b\u5b66\u6587\u6863\u6dfb\u52a0\u6210\u529f: {}", (Object)request.getTitle());
            return BaseResponse.success((Object)"\u533b\u5b66\u6587\u6863\u5df2\u6dfb\u52a0");
        }
        catch (Exception e) {
            log.error("\u6dfb\u52a0\u533b\u5b66\u6587\u6863\u5931\u8d25: {}", (Object)e.getMessage(), (Object)e);
            return BaseResponse.error((String)"500", (String)("\u6dfb\u52a0\u5931\u8d25: " + e.getMessage()));
        }
    }
}

