/*
 * Decompiled with CFR 0.152.
 */
package com.chdu.ai.handler;

import com.chdu.ai.model.ChatMessage;
import com.chdu.ai.model.CozeChatRequest;
import com.chdu.ai.service.ChatService;
import com.chdu.ai.service.CozeSearchService;
import com.chdu.ai.util.ContentProcessor;
import com.chdu.ai.util.NumericIdGenerator;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;
import org.springframework.web.socket.CloseStatus;
import org.springframework.web.socket.PingMessage;
import org.springframework.web.socket.TextMessage;
import org.springframework.web.socket.WebSocketMessage;
import org.springframework.web.socket.WebSocketSession;
import org.springframework.web.socket.handler.TextWebSocketHandler;

@Component
public class ChatWebSocketHandler
extends TextWebSocketHandler {
    private static final Logger logger = LoggerFactory.getLogger(ChatWebSocketHandler.class);
    private final ChatService chatService;
    private final CozeSearchService cozeSearchService;
    private static ConcurrentHashMap<String, WebSocketSession> sessions = new ConcurrentHashMap();
    private final ObjectMapper objectMapper = new ObjectMapper();

    public ChatWebSocketHandler(ChatService chatService, CozeSearchService cozeSearchService) {
        this.chatService = chatService;
        this.cozeSearchService = cozeSearchService;
    }

    public void afterConnectionEstablished(WebSocketSession session) throws Exception {
        String userId = this.getQueryParam(session, "userId");
        if (userId == null || userId.trim().isEmpty()) {
            userId = session.getId();
        }
        session.getAttributes().put("userId", userId);
        sessions.put(userId, session);
        logger.info("WebSocket \u8fde\u63a5\u5df2\u5efa\u7acb: userId={}, sessionId={}", (Object)userId, (Object)session.getId());
        List offlineMessages = this.chatService.getOfflineMessages(userId);
        if (offlineMessages != null && !offlineMessages.isEmpty()) {
            for (ChatMessage msg : offlineMessages) {
                session.sendMessage((WebSocketMessage)new TextMessage((CharSequence)this.objectMapper.writeValueAsString((Object)msg)));
                logger.info("\u53d1\u9001\u79bb\u7ebf\u6d88\u606f: {}", (Object)msg);
            }
            List messageIds = offlineMessages.stream().map(ChatMessage::getId).collect(Collectors.toList());
            this.chatService.markMessagesAsDelivered(messageIds);
            logger.info("\u5df2\u66f4\u65b0 {} \u6761\u6d88\u606f\u72b6\u6001\u4e3a\u5df2\u53d1\u9001", (Object)messageIds.size());
        }
    }

    protected void handleTextMessage(WebSocketSession session, TextMessage message) throws Exception {
        String payload = (String)message.getPayload();
        logger.info("\u6536\u5230 WebSocket \u6d88\u606f: {}", (Object)payload);
        try {
            String currentUserId = session.getAttributes().get("userId").toString();
            ChatMessage chatMessage = (ChatMessage)this.objectMapper.readValue(payload, ChatMessage.class);
            logger.info("\u6210\u529f\u89e3\u6790\u6d88\u606f: {}", (Object)chatMessage);
            chatMessage.setFromUser(currentUserId);
            if (chatMessage.getConversionId() == null || chatMessage.getConversionId().trim().isEmpty()) {
                chatMessage.setConversionId(NumericIdGenerator.generate4NumericId());
            }
            if ("auto".equalsIgnoreCase(chatMessage.getMsgType())) {
                chatMessage.setDelivered(1);
                this.chatService.saveMessage(chatMessage);
                CozeChatRequest cozeRequest = new CozeChatRequest();
                cozeRequest.setBotId(chatMessage.getToUser());
                cozeRequest.setUserId(currentUserId);
                cozeRequest.setStream(true);
                cozeRequest.setAutoSaveHistory(true);
                cozeRequest.setRole("user");
                cozeRequest.setConversationId(chatMessage.getConversionId());
                String messageContent = chatMessage.getMessage();
                try {
                    List messageParts = (List)this.objectMapper.readValue(messageContent, (JavaType)this.objectMapper.getTypeFactory().constructCollectionType(List.class, Map.class));
                    ContentProcessor.ProcessedContent processed = ContentProcessor.process((List)messageParts);
                    cozeRequest.setContent(processed.getContent());
                    cozeRequest.setContentType(processed.getContentType());
                }
                catch (Exception e) {
                    cozeRequest.setContent(messageContent);
                    cozeRequest.setContentType("text");
                }
                this.cozeSearchService.chatWithCoze(cozeRequest, session);
                return;
            }
            String targetUser = chatMessage.getToUser();
            WebSocketSession targetSession = (WebSocketSession)sessions.get(targetUser);
            if (targetSession != null && targetSession.isOpen()) {
                chatMessage.setDelivered(1);
                ChatMessage savedMessage = this.chatService.saveMessage(chatMessage);
                targetSession.sendMessage((WebSocketMessage)new TextMessage((CharSequence)this.objectMapper.writeValueAsString((Object)savedMessage)));
            } else {
                chatMessage.setDelivered(0);
                this.chatService.saveMessage(chatMessage);
                logger.info("\u7528\u6237 {} \u4e0d\u5728\u7ebf\uff0c\u5b58\u50a8\u79bb\u7ebf\u6d88\u606f", (Object)targetUser);
            }
        }
        catch (Exception e) {
            logger.error("\u5904\u7406 WebSocket \u6d88\u606f\u65f6\u53d1\u751f\u5f02\u5e38", (Throwable)e);
            session.sendMessage((WebSocketMessage)new TextMessage((CharSequence)"\u5904\u7406\u6d88\u606f\u65f6\u53d1\u751f\u9519\u8bef\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\u3002"));
        }
    }

    public void handleTransportError(WebSocketSession session, Throwable exception) throws Exception {
        logger.error("WebSocket \u4f20\u8f93\u9519\u8bef: {}", (Object)exception.getMessage());
    }

    public void afterConnectionClosed(WebSocketSession session, CloseStatus status) throws Exception {
        String userId;
        String string = userId = session.getAttributes().get("userId") != null ? session.getAttributes().get("userId").toString() : null;
        if (userId != null) {
            sessions.remove(userId);
            logger.info("WebSocket \u8fde\u63a5\u5173\u95ed: userId={}, sessionId={}, status={}", new Object[]{userId, session.getId(), status});
        }
    }

    private String getQueryParam(WebSocketSession session, String paramName) {
        try {
            String query = session.getUri().getQuery();
            if (query != null) {
                String[] params;
                for (String param : params = query.split("&")) {
                    String[] keyValue = param.split("=");
                    if (keyValue.length != 2 || !paramName.equals(keyValue[0])) continue;
                    return keyValue[1];
                }
            }
        }
        catch (Exception e) {
            logger.error("\u89e3\u6790\u67e5\u8be2\u53c2\u6570\u5931\u8d25", (Throwable)e);
        }
        return null;
    }

    @Scheduled(fixedRate=30000L)
    public void sendPingMessages() {
        for (WebSocketSession session : sessions.values()) {
            if (!session.isOpen()) continue;
            try {
                session.sendMessage((WebSocketMessage)new PingMessage());
            }
            catch (Exception e) {
                logger.error("\u53d1\u9001\u5fc3\u8df3 Ping \u6d88\u606f\u5931\u8d25: sessionId={}", (Object)session.getId(), (Object)e);
            }
        }
    }
}

