/*
 * Decompiled with CFR 0.152.
 */
package com.chdu.ai.wecom.service;

import com.chdu.ai.model.BaseResponse;
import com.chdu.ai.model.ChatMessage;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.HashMap;
import java.util.List;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;

@Service
public class WeComService {
    private static final String CORP_ID = "wwe009ab79fcbebe4d";
    private static final String SECRET = "QwK7JmmTOrqHpHo3IvWAtolO24nJ2Zu38XUupN0gyjU";
    private static final String CUSTOMER_CONTACT_SECRET = "QcJGDnYgMBFflwn1YfUJxBYHzHjadjhZpOOU8iw8eOg";
    private static final String MESSAGE_URL = "https://qyapi.weixin.qq.com/cgi-bin/kf/send_msg?access_token=";
    private static final String TOKEN_URL = "https://qyapi.weixin.qq.com/cgi-bin/gettoken?corpid=wwe009ab79fcbebe4d&corpsecret=QcJGDnYgMBFflwn1YfUJxBYHzHjadjhZpOOU8iw8eOg";
    private static final String LIST_CONTACTS_URL = "https://qyapi.weixin.qq.com/cgi-bin/externalcontact/list?access_token=%s&userid=%s";
    private final RestTemplate restTemplate = new RestTemplate();
    private final ObjectMapper objectMapper = new ObjectMapper();

    public String getAccessToken() {
        try {
            String response = (String)this.restTemplate.getForObject(TOKEN_URL, String.class, new Object[0]);
            JsonNode jsonNode = this.objectMapper.readTree(response);
            if (jsonNode.get("errcode").asInt() == 0) {
                return jsonNode.get("access_token").asText();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public BaseResponse<String> sendMessageToWeCom(ChatMessage message) {
        String accessToken = this.getAccessToken();
        if (accessToken == null) {
            return BaseResponse.error((String)"500", (String)"\u83b7\u53d6 AccessToken \u5931\u8d25");
        }
        HashMap<String, Object> payload = new HashMap<String, Object>();
        payload.put("touser", message.getToUser());
        payload.put("open_kfid", "wkvLghVgAAuaKYnjUapy3shJz8q7BXTA");
        payload.put("msgtype", "text");
        HashMap<String, String> text = new HashMap<String, String>();
        text.put("content", message.getMessage());
        payload.put("text", text);
        try {
            String response = (String)this.restTemplate.postForObject(MESSAGE_URL + accessToken, payload, String.class, new Object[0]);
            JsonNode jsonNode = this.objectMapper.readTree(response);
            if (jsonNode.get("errcode").asInt() == 0) {
                return BaseResponse.success((Object)"Message sent successfully");
            }
            return BaseResponse.error((String)jsonNode.get("errcode").toString(), (String)jsonNode.get("errmsg").asText());
        }
        catch (Exception e) {
            e.printStackTrace();
            return BaseResponse.error((String)"500", (String)"\u53d1\u9001\u6d88\u606f\u5931\u8d25");
        }
    }

    public BaseResponse<List<String>> getExternalContacts(String userId) {
        String accessToken = this.getAccessToken();
        if (accessToken == null) {
            return BaseResponse.error((String)"500", (String)"\u83b7\u53d6 AccessToken \u5931\u8d25");
        }
        try {
            String apiUrl = String.format(LIST_CONTACTS_URL, accessToken, userId);
            String response = (String)this.restTemplate.getForObject(apiUrl, String.class, new Object[0]);
            JsonNode jsonNode = this.objectMapper.readTree(response);
            if (jsonNode.get("errcode").asInt() == 0) {
                List externalUserIds = (List)this.objectMapper.convertValue((Object)jsonNode.get("external_userid"), List.class);
                return BaseResponse.success((Object)externalUserIds);
            }
            return BaseResponse.error((String)jsonNode.get("errcode").toString(), (String)jsonNode.get("errmsg").asText());
        }
        catch (Exception e) {
            e.printStackTrace();
            return BaseResponse.error((String)"500", (String)"\u83b7\u53d6\u5916\u90e8\u8054\u7cfb\u4eba\u5931\u8d25");
        }
    }
}

