/*
 * Decompiled with CFR 0.152.
 */
package com.chdu.ai.config;

import co.elastic.clients.elasticsearch.ElasticsearchClient;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.jackson.JacksonJsonpMapper;
import co.elastic.clients.transport.ElasticsearchTransport;
import co.elastic.clients.transport.rest_client.RestClientTransport;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.client.RestClientBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class ElasticsearchConfig {
    private static final Logger log = LoggerFactory.getLogger(ElasticsearchConfig.class);
    @Value(value="${spring.elasticsearch.uris}")
    private String elasticsearchUri;
    @Value(value="${spring.elasticsearch.username}")
    private String username;
    @Value(value="${spring.elasticsearch.password}")
    private String password;
    @Value(value="${spring.elasticsearch.connection-timeout:5000}")
    private int connectionTimeout;
    @Value(value="${spring.elasticsearch.socket-timeout:60000}")
    private int socketTimeout;

    @Bean
    public ElasticsearchClient elasticsearchClient() {
        try {
            if (this.elasticsearchUri == null || this.elasticsearchUri.trim().isEmpty()) {
                throw new IllegalArgumentException("Elasticsearch URI \u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5 spring.elasticsearch.uris \u914d\u7f6e");
            }
            log.info("\u521d\u59cb\u5316 Elasticsearch \u5ba2\u6237\u7aef\uff0c\u8fde\u63a5\u5730\u5740: {}", (Object)this.elasticsearchUri);
            BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
            credentialsProvider.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(this.username, this.password));
            RestClientBuilder builder = RestClient.builder((HttpHost[])new HttpHost[]{HttpHost.create((String)this.elasticsearchUri)}).setHttpClientConfigCallback(httpClientBuilder -> httpClientBuilder.setDefaultCredentialsProvider((CredentialsProvider)credentialsProvider)).setRequestConfigCallback(requestConfigBuilder -> requestConfigBuilder.setConnectTimeout(this.connectionTimeout).setSocketTimeout(this.socketTimeout));
            RestClient restClient = builder.build();
            RestClientTransport transport = new RestClientTransport(restClient, (JsonpMapper)new JacksonJsonpMapper());
            ElasticsearchClient client = new ElasticsearchClient((ElasticsearchTransport)transport);
            log.info("Elasticsearch \u5ba2\u6237\u7aef\u521d\u59cb\u5316\u5b8c\u6210");
            return client;
        }
        catch (Exception e) {
            log.error("Elasticsearch \u521d\u59cb\u5316\u5931\u8d25", (Throwable)e);
            throw new RuntimeException("Elasticsearch \u8fde\u63a5\u5931\u8d25", e);
        }
    }
}

