/*
 * Decompiled with CFR 0.152.
 */
package com.chdu.ai.controller;

import com.chdu.ai.model.BaseResponse;
import com.chdu.ai.model.Tenant;
import com.chdu.ai.service.TenantService;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/tenant"})
public class TenantController {
    @Autowired
    private TenantService tenantService;

    @PostMapping(value={"/getById"})
    public BaseResponse<Tenant> getTenantById(@RequestBody Tenant tenant) {
        Tenant result = this.tenantService.getTenantById(tenant.getId());
        return result != null ? BaseResponse.success((Object)result) : BaseResponse.error((String)"404", (String)"Tenant not found");
    }

    @PostMapping(value={"/getAll"})
    public BaseResponse<List<Tenant>> getAllTenants() {
        List tenants = this.tenantService.getAllTenants();
        return BaseResponse.success((Object)tenants);
    }

    @PostMapping(value={"/create"})
    public BaseResponse<String> createTenant(@RequestBody Tenant tenant) {
        this.tenantService.createTenant(tenant);
        return BaseResponse.success((Object)"Tenant created successfully");
    }

    @PostMapping(value={"/update"})
    public BaseResponse<String> updateTenant(@RequestBody Tenant tenant) {
        this.tenantService.updateTenant(tenant);
        return BaseResponse.success((Object)"Tenant updated successfully");
    }

    @PostMapping(value={"/delete"})
    public BaseResponse<String> deleteTenant(@RequestBody Tenant tenant) {
        this.tenantService.deleteTenant(tenant.getId());
        return BaseResponse.success((Object)"Tenant logically deleted");
    }
}

